/////////////////////////////////////////////////////////////////////////
// Colour change script 3.0

//
//
// Edit the list below to match the names of the prims to be coloured
//
//
list menuParts=["shell", "collar", "trim", "latch", "lock", "hinge"];


integer debugMode=FALSE;
integer touchDelay;

vector blue=<0.0,0.0,1.0>;
vector darkblue=<0.0,0.0,0.545>;
vector lightblue=<0.678,0.847,0.902>;
vector green=<0.0,1.0,0.0>;
vector darkgreen=<0.0,0.392,0.0>;
vector lightgreen=<0.564,0.933,0.547>;
vector black=<0.0,0.0,0.0>;
vector darkblack=<0.0,0.0,0.0>;
vector lightblack=<0.501,0.501,0.501>;
vector pink=<0.933,0.416,0.655>;
vector darkpink=<1.0,0.078,0.576>;
vector lightpink=<1.0,0.714,0.757>;
vector red=<1.0,0.0,0.0>;
vector darkred=<0.545,0.0,0.0>;
vector lightred=<1.0,0.416,0.416>;
vector purple=<0.58,0.0,0.827>;
vector darkpurple=<0.5,0.0,0.5>;
vector lightpurple=<0.933,0.0,0.933>;
vector white=<1.0,1.0,1.0>;
vector darkwhite=<0.439,0.502,0.565>;
vector lightwhite=<0.752,0.752,0.752>;
vector yellow=<1.0,1.0,0.0>;
vector darkyellow=<1.0,0.843,0.0>;
vector lightyellow=<1.0,1.0,0.878>;
vector orange=<1.0,0.647,0.0>;
vector darkorange=<1.0,0.549,0.0>;
vector lightorange=<1.0,0.925,0.545>;
string linkDescription;
integer menuChannel;
vector vectColour;
string selectedPartName;
list menuColour=[" - ", " - ", "back", "blue", "green", "black", "pink", "red", "purple", "white", "yellow", "orange"];
list menuShades=[" - ", " - ", "back", "light", "normal", "dark"];
integer listenHandleMenu;
integer menuExpireTime;
string menuMessage;
string menuLevel;
string selectedColourName;
//Function to change colour of parts
colourPart(string partName, string colour)
{
    integer i=1;
    if (colour=="blue") vectColour=blue;
    if (colour=="lightblue") vectColour=lightblue;
    if (colour=="darkblue") vectColour=darkblue;
    if (colour=="green") vectColour=green;
    if (colour=="lightgreen") vectColour=lightgreen;
    if (colour=="darkgreen") vectColour=darkgreen;
    if (colour=="black") vectColour=black;
    if (colour=="lightblack") vectColour=lightblack;
    if (colour=="darkblack") vectColour=darkblack;
    if (colour=="pink") vectColour=pink;
    if (colour=="lightpink") vectColour=lightpink;
    if (colour=="darkpink") vectColour=darkpink;
    if (colour=="red") vectColour=red;
    if (colour=="lightred") vectColour=lightred;
    if (colour=="darkred") vectColour=darkred;
    if (colour=="purple") vectColour=purple;
    if (colour=="lightpurple") vectColour=lightpurple;
    if (colour=="darkpurple") vectColour=darkpurple;
    if (colour=="white") vectColour=white;
    if (colour=="lightwhite") vectColour=lightwhite;
    if (colour=="darkwhite") vectColour=darkwhite;
    if (colour=="yellow") vectColour=yellow;
    if (colour=="lightyellow") vectColour=lightyellow;
    if (colour=="darkyellow") vectColour=darkyellow;
    if (colour=="orange") vectColour=orange;
    if (colour=="lightorange") vectColour=lightorange;
    if (colour=="darkorange") vectColour=darkorange;
     while (i <= llGetNumberOfPrims()) 
     {
        linkDescription=(string)llGetLinkPrimitiveParams(i,[PRIM_DESC]);
        if (linkDescription==partName)
        {
            llSetLinkColor(i,vectColour,ALL_SIDES);
        }
        ++i;
     }
    
}
//Function to display colour shades menu
displayShadesMenu (key ID)
{
        menuLevel="shades";
        llListenRemove(listenHandleMenu);
        menuChannel = (integer)(llFrand(-1000000000.0) - 1000000000.0);
        llDialog(ID, menuMessage, menuShades, menuChannel);
        listenHandleMenu = llListen( menuChannel, "", ID, "");
        menuExpireTime=llGetUnixTime() + 60;
}
//Function to display colour menu
displayColourMenu (key ID)
{
        menuLevel="colour";
        llListenRemove(listenHandleMenu);
        menuChannel = (integer)(llFrand(-1000000000.0) - 1000000000.0);
        llDialog(ID, menuMessage, menuColour, menuChannel);
        listenHandleMenu = llListen( menuChannel, "", ID, "");
        menuExpireTime=llGetUnixTime() + 60;
}
//Function to display belt parts menu for colouring
displayPartsMenu (key ID)
{
        menuLevel="main";
        llListenRemove(listenHandleMenu);
        menuChannel = (integer)(llFrand(-1000000000.0) - 1000000000.0);
        llDialog(ID, menuMessage, menuParts, menuChannel);
        listenHandleMenu = llListen( menuChannel, "", ID, "");
        menuExpireTime=llGetUnixTime() + 60;
}

default
{
    state_entry()
    {
        llSetTimerEvent (10.0);
    }
    link_message(integer sender_number, integer number, string message, key id)
    {
        if (number==5566 && message=="MENU") displayPartsMenu(id);
    }   
    listen(integer channel, string name, key id, string message)
    {
        llListenRemove(listenHandleMenu);
        if (menuLevel=="main")
        {
            selectedPartName=message;
            displayColourMenu(id);
            return;
        }
        if (menuLevel=="colour")
        {
            if (message != "back")
            {
                selectedColourName=message;
                displayShadesMenu(id);
            }
            else displayPartsMenu(id);
            return;
        }
        if (menuLevel=="shades")
        {
            if (message != "back")
            {
                if (message != "normal") selectedColourName = message + selectedColourName;
                if (debugMode==TRUE) llWhisper (0, selectedPartName + " " + selectedColourName);
                colourPart(selectedPartName, selectedColourName);
                displayPartsMenu(id);
            }
            else displayColourMenu(id);
            return;
        }    
    }
        
    



    timer()
    {
        if (llGetUnixTime() >= menuExpireTime) llListenRemove(listenHandleMenu);
    }
}