 

// :CREATED: 9-8-2014
// :REV: 1.2, adapted on 10/22/2017
// Addapted for Cinderella bby Ferd Frederix
// Copyright CC-BY=NC-SA
// :DESCRIPTION: 
// Vehicle code for the Conderella Pumpkin

// :CODE:

integer PRODUCTION = TRUE;     // set to true and it will poof when you step off. Use it in a Rezzer to get it back.
integer debug = FALSE;         // set to TRUE or FALSE for debug chat on various actions
 
// OpenSim & Bulletsim
       
// avatar control animations
string AvatarSit = "unisex-sit";
string AvatarRide = "HoldHarness";
string AvatarStand  = "M-Stand-01";
string AvatarWalk  = "M-Walk-01";

// NPC animations
string NPCStand = "HorseStand1";
string NPCWalk = "HorseWalk";
string NPCRun = "RamGallop";

string whatsplayingHorse1 = "";      // the currently playing NPC automation
string whatsplayingHorse2 = "";      // the currently playing NPC automation
string whatsplayingHorse3 = "";      // the currently playing NPC automation
string whatsplayingHorse4 = "";      // the currently playing NPC automation
string whatsplayingFootman = "";      // the currently playing NPC automation
string whatsplayingDriver = "";      // the currently playing NPC automation

integer Private = 0;    // Change to 1 to prevent others riding.
float  gallop= 1.0;
integer isSeated = FALSE;
vector Destination; // place for a NPC to go.

key Agent;

float forward_power = 8; //Power used to go forward (1 to 30)
float reverse_power = -6; //Power ued to go reverse (-1 to -30)
float turning_ratio = 3; //How sharply the vehicle turns. Less is more sharply. (.1 to 10)

integer turncount; 

integer DUST_ON = 8;
integer DUST_OFF = 9;
// 9, feetsieson
// 8, feetsiesoff

float Speed; 
integer NPCisRunning;
string last_animation; // the last animation played on the owner
integer once;


DEBUG(string str)
{
    if (debug)
        llOwnerSay(llGetScriptName()+":" +  str);                    // Send the owner debug info so you can chase NPCS
}


RemoveAllNPC() {
    DEBUG("Remove All NPC");
    osNpcRemove(NPCKeyHorse1);
    osNpcRemove(NPCKeyHorse1);
    llSleep(0.1);
    osNpcRemove(NPCKeyHorse2);
    osNpcRemove(NPCKeyHorse2);
    llSleep(0.1);
    osNpcRemove(NPCKeyHorse3);
    osNpcRemove(NPCKeyHorse3);
    llSleep(0.1);
    osNpcRemove(NPCKeyHorse4);
    osNpcRemove(NPCKeyHorse4);
    llSleep(0.1);
    osNpcRemove(NPCKeyFootman);
     osNpcRemove(NPCKeyFootman);
    llSleep(0.1);
    osNpcRemove(NPCKeyDriver);
    osNpcRemove(NPCKeyDriver);
    llSleep(0.1);
}

SetMaterial()
{
    llSetPrimitiveParams([PRIM_MATERIAL, PRIM_MATERIAL_GLASS]);
    llMessageLinked(LINK_ALL_OTHERS, 0, "SetMat", NULL_KEY);    // Tell daughter pims on ground to be glass
}

// pipeline for animations for the owner
AvatarAnimate(string animation)
{
    if (animation != last_animation) {
        //llOwnerSay(animation);
        llStopAnimation(last_animation);
        llStartAnimation(animation);
        last_animation = animation;
    }
}

// and for the NPC
NPCHorse1Play(string what)
{
    if (whatsplayingHorse1 != what) {
        DEBUG("Playing Horse1 animation " + what + ", stopping " + whatsplayingHorse1);
        
        osNpcStopAnimation(NPCKeyHorse1, whatsplayingHorse1);
        osNpcPlayAnimation(NPCKeyHorse1, what);
        
        whatsplayingHorse1 = what;
    }       
}

NPCHorse2Play(string what)
{
    if (whatsplayingHorse2 != what) {
        DEBUG("Playing Horse2 animation " + what + ", stopping " + whatsplayingHorse2);
        
        osNpcStopAnimation(NPCKeyHorse2, whatsplayingHorse2);
        osNpcPlayAnimation(NPCKeyHorse2, what);
        
        whatsplayingHorse2 = what;
    }       
}

NPCHorse3Play(string what)
{
    if (whatsplayingHorse3 != what) {
        DEBUG("Playing Horse3 animation " + what + ", stopping " + whatsplayingHorse3);
        
        osNpcStopAnimation(NPCKeyHorse3, whatsplayingHorse3);
        osNpcPlayAnimation(NPCKeyHorse3, what);
        
        whatsplayingHorse3 = what;
    }       
}


NPCHorse4Play(string what)
{
    if (whatsplayingHorse4 != what) {
        DEBUG("Playing Horse4 animation " + what + ", stopping " + whatsplayingHorse4);
        
        osNpcStopAnimation(NPCKeyHorse4, whatsplayingHorse4);
        osNpcPlayAnimation(NPCKeyHorse4, what);
        
        whatsplayingHorse4 = what;
    }       
}


// footman
NPCPlayFootman(string what)
{
    if (whatsplayingFootman != what) {
        DEBUG("Playing Foorman animation " + what + ", stopping " + whatsplayingFootman);
        
        osNpcStopAnimation(NPCKeyFootman, whatsplayingFootman);
        osNpcPlayAnimation(NPCKeyFootman, what);
        
        whatsplayingFootman = what;
    }       
}


NPCPlayDriver(string what)
{
    if (whatsplayingDriver != what) {
        DEBUG("Playing Driver animation " + what + ", stopping " + whatsplayingDriver);
        
        osNpcStopAnimation(NPCKeyDriver, whatsplayingDriver);
        osNpcPlayAnimation(NPCKeyDriver, what);
        
        whatsplayingDriver = what;
    }       
}

// Play a sound
Whinny1()
{
    llTriggerSound("whinny1",1.0);
}

// Play a sound
Whinny2()
{
    llTriggerSound("whinny2",1.0);
}
// Play a sound
Whinny3()
{
    llTriggerSound("whinny3",1.0);
}


setVehicle()
{
    //car
    llSetVehicleType(VEHICLE_TYPE_CAR);
    llSetVehicleFloatParam(VEHICLE_ANGULAR_DEFLECTION_EFFICIENCY, 0.2);
    llSetVehicleFloatParam(VEHICLE_LINEAR_DEFLECTION_EFFICIENCY, 0.80);
    llSetVehicleFloatParam(VEHICLE_ANGULAR_DEFLECTION_TIMESCALE, 0.50);
    llSetVehicleFloatParam(VEHICLE_LINEAR_DEFLECTION_TIMESCALE, 0.10);
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_TIMESCALE, 1.0);
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_DECAY_TIMESCALE, 0.1);
    llSetVehicleFloatParam(VEHICLE_ANGULAR_MOTOR_TIMESCALE, 0.1);
    llSetVehicleFloatParam(VEHICLE_ANGULAR_MOTOR_DECAY_TIMESCALE, 0.1);
    llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <10.0, 2.0, 1000.0>);
    llSetVehicleVectorParam(VEHICLE_ANGULAR_FRICTION_TIMESCALE, <0.1, 0.1, 0.1>);
    llSetVehicleFloatParam(VEHICLE_VERTICAL_ATTRACTION_EFFICIENCY, 0.1);
    llSetVehicleFloatParam(VEHICLE_VERTICAL_ATTRACTION_TIMESCALE, 5.0);
}

Init()
{
    llSetStatus(STATUS_PHYSICS, FALSE);
    llSetStatus(STATUS_PHANTOM,FALSE);
    vector rotv = llRot2Euler(llGetRot());
    rotation rot = llEuler2Rot(<0,0,rotv.z>);

    llSetRot(rot);
    
    llSetVehicleType(VEHICLE_TYPE_NONE);
    NPCisRunning = FALSE;
}


key NPCKeyHorse1;    // key of npc
key NPCKeyHorse2;
key NPCKeyHorse3;
key NPCKeyHorse4;
key NPCKeyFootman;
key NPCKeyDriver;
key kSitHorse1;  // key of seat
key kSitHorse2;
key kSitHorse3;
key kSitHorse4;
key kSitFootman;
key kSitDriver;

StartNPCHorse1() {
    NPCKeyHorse1 = osNpcCreate("Bert", "", llGetPos(), "HorseAppearance", OS_NPC_SENSE_AS_AGENT);    // no OS_NPC_SENSE_AS_AGENT allowed due to llSensor Use

    osNpcSit(NPCKeyHorse1, kSitHorse1, OS_NPC_SIT_NOW);     
    DEBUG("Horse1 Created");
    whatsplayingHorse1 = "sit";
    NPCHorse1Play(NPCStand); 
}

StartNPCHorse2() {
    NPCKeyHorse2 = osNpcCreate("Luke", "", llGetPos(), "HorseAppearance", OS_NPC_SENSE_AS_AGENT);    // no OS_NPC_SENSE_AS_AGENT allowed due to llSensor Use
 
    osNpcSit(NPCKeyHorse2,kSitHorse2, OS_NPC_SIT_NOW);  
    DEBUG("Horse2 Created");
    whatsplayingHorse2 = "sit";
    NPCHorse2Play(NPCStand);
}
 
StartNPCHorse3() {
    NPCKeyHorse3 = osNpcCreate("Jaq", "", llGetPos(), "HorseAppearance", OS_NPC_SENSE_AS_AGENT);    // no OS_NPC_SENSE_AS_AGENT allowed due to llSensor Use
    
    osNpcSit(NPCKeyHorse3,kSitHorse3, OS_NPC_SIT_NOW);  
    DEBUG("Horse3 Created");
    whatsplayingHorse3 = "sit";
    NPCHorse3Play(NPCStand);
}

StartNPCHorse4() {
    NPCKeyHorse4 = osNpcCreate("Gus", "", llGetPos(), "HorseAppearance", OS_NPC_SENSE_AS_AGENT);    // no OS_NPC_SENSE_AS_AGENT allowed due to llSensor Use
     
    osNpcSit(NPCKeyHorse4,kSitHorse4, OS_NPC_SIT_NOW);  
    DEBUG("Horse4 Created");
    whatsplayingHorse4 = "sit";
    NPCHorse4Play(NPCStand);
}


StartNPCFootman() {
    NPCKeyFootman = osNpcCreate("Footman", "", llGetPos()+<0,5,0>, "AppearanceFootman", OS_NPC_SENSE_AS_AGENT);    // no OS_NPC_SENSE_AS_AGENT allowed due to llSensor Use
     
    osNpcSit(NPCKeyFootman,kSitFootman, OS_NPC_SIT_NOW);  
    DEBUG("Footman Created");
    whatsplayingFootman = "sit";
    NPCPlayFootman("M-Stand-01");
}


StartNPCDriver() {
    NPCKeyDriver = osNpcCreate("Driver", "", llGetPos()+<0,6,0>, "AppearanceDriver", OS_NPC_SENSE_AS_AGENT);    // no OS_NPC_SENSE_AS_AGENT allowed due to llSensor Use
     
    osNpcSit(NPCKeyDriver,kSitDriver, OS_NPC_SIT_NOW);  
    DEBUG("Driver Created");
    whatsplayingDriver = "sit";
    NPCPlayDriver("drive forward");
}


init_followCam(){
    
    llSetCameraParams([
                       CAMERA_ACTIVE, 1,                     // 0=INACTIVE  1=ACTIVE
                       CAMERA_BEHINDNESS_ANGLE, 45.0,         // (0 to 180) DEGREES
                       CAMERA_BEHINDNESS_LAG, 1.0,           // (0 to 3) SECONDS
                       CAMERA_DISTANCE, 4.0,                 // ( 0.5 to 10) METERS
                       CAMERA_PITCH, 20.0,                    // (-45 to 80) DEGREES
                       CAMERA_POSITION_LOCKED, FALSE,        // (TRUE or FALSE)
                       CAMERA_POSITION_LAG, 0.01,             // (0 to 3) SECONDS
                       CAMERA_POSITION_THRESHOLD, 2.0,       // (0 to 4) METERS
                       CAMERA_FOCUS_LOCKED, FALSE,           // (TRUE or FALSE)
                       CAMERA_FOCUS_LAG, 0.01 ,               // (0 to 3) SECONDS
                       CAMERA_FOCUS_THRESHOLD, 0.01,          // (0 to 4) METERS
                       CAMERA_FOCUS_OFFSET, <-1.0,0.0,2.0>   // <-10,-10,-10> to <10,10,10> METERS
                      ]);
}

key  GetLinkKeyNum(string name)
{
    integer prims = llGetNumberOfPrims();
    integer i;
    for (i = 1; i <= prims; i++) {
        string n = llGetLinkName(i);
        if (n == name)
            return llGetLinkKey(i);    
    }
    llOwnerSay("Cannot find the prim named " + name);
    return NULL_KEY;
}

Run() {
    //DEBUG("Avatar Seated");
    last_animation = "sit";
    
     
    llWhisper(0,"Use arrow keys to steer.  PG Up to gallop, Pg Down to walk");
    
    setVehicle();
    
    llSetStatus(STATUS_PHYSICS, TRUE);
    llSleep(.1);
    NPCisRunning = TRUE;
    
    //DEBUG("Starting platform");
    llRequestPermissions(Agent, PERMISSION_TRIGGER_ANIMATION | PERMISSION_CONTROL_CAMERA| PERMISSION_TAKE_CONTROLS);
}


ResetScript() {
    RemoveAllNPC();
    llResetScript();
}

Unsit() {
    DEBUG("Stopping");
    llMessageLinked(LINK_SET,0,"dustoff","");
    llMessageLinked(LINK_SET,0,"feetsiesoff","");
    
    if (NPCisRunning) {
        Init(); // shut off physics
        
        RemoveAllNPC();

        NPCisRunning = FALSE;
        llReleaseControls();
          
        llSetTimerEvent(0.0);
        
        llMessageLinked(LINK_SET,100,"Invisible",""); 
    }
    if (PRODUCTION) {
        llDie();
    }    
    ResetScript();
}           
            
default
{
    state_entry()
    {
        
        Init();
        llCollisionSound("",0);
        
        SetMaterial();
        
        integer i = llGetNumberOfPrims();
        while (i-- > 1) {
            llSetLinkPrimitiveParamsFast(i, [PRIM_PHYSICS_SHAPE_TYPE, PRIM_PHYSICS_SHAPE_NONE]);
        }
        llSetLinkPrimitiveParamsFast(1, [PRIM_PHYSICS_SHAPE_TYPE, PRIM_PHYSICS_SHAPE_PRIM]);    

        llSitTarget(ZERO_VECTOR, ZERO_ROTATION); 

        RemoveAllNPC();

        NPCisRunning = FALSE;
        
        // Link these as Horse 1, Horse 2, 3, 4 , Rider, Base
        kSitHorse1 = GetLinkKeyNum("Horse1");
        kSitHorse2 = GetLinkKeyNum("Horse2");    
        kSitHorse3 = GetLinkKeyNum("Horse3");  
        kSitHorse4 = GetLinkKeyNum("Horse4");
        kSitFootman = GetLinkKeyNum("Footman");
        kSitDriver = GetLinkKeyNum("Driver");
    }
    
    on_rez(integer rn)
    {
        llResetScript();
    }


    link_message(integer sender_number, integer number, string message, key id)
    {
        DEBUG(" Main script heard:" + message + " with key " + (string) id);
        
        if (message == "horses" )
        {
            state Horses;     
            
        } else if (message == "Seated") {
            isSeated = TRUE;
            Agent = id;
            state Horses;    
        } else if (message == "Unseated")    {
           Unsit();
        } else if (message == "reset") {
            ResetScript();
        }
    }
}



state Horses {

    state_entry() {
        DEBUG("State Horses");
        StartNPCHorse1();
        Whinny1();            
        StartNPCHorse2();
        Whinny2();            
        StartNPCHorse3();
        Whinny1();     
        StartNPCHorse4();
        Whinny2(); 
        NPCisRunning = TRUE; 
        
        llMessageLinked(LINK_SET,1,"OPEN","");
        
        llMessageLinked(LINK_SET,101,"Visible","");
        if (isSeated)
            state Driver;
    }
    
    link_message(integer sender_number, integer number, string message, key id)
    {
        if (message == "Driver")
        {
            state Driver;
            
        } else if (message == "Seated") {
            isSeated = TRUE;
            Agent = id;
            state Driver;
        } else if (message == "Unseated")    {
           Unsit();
        } else if (message == "reset") {
            ResetScript();
        } 
    }
   
}


state Driver {

    state_entry() {
        DEBUG("State Driver");
        StartNPCDriver();
        if (isSeated)
            state Footman;
    }
    
    link_message(integer sender_number, integer number, string message, key id)
    {
        
        if (message == "FootMan")
        {
            state Footman;
        } else if (message == "Seated") {
            isSeated = TRUE;
            Agent = id;
            state Footman;
        } else if (message == "Unseated")    {
           Unsit();
        }  else if (message == "reset") {
            ResetScript();
        }
    }
    
}
 
state Footman {

    state_entry() {
        DEBUG("State Footman");
        StartNPCFootman(); 
        if (isSeated)
            state  DoorClose; 
    }
    
    link_message(integer sender_number, integer number, string message, key id)
    {
        if (message == "DoorClose")
        {
            state DoorClose;
        } else if (message == "Seated") {
            isSeated = TRUE;
            Agent = id;
            state DoorClose;
        }  else if (message == "Unseated")    {
           Unsit();
        } else if (message == "reset") {
            ResetScript();
        }
    }
    
}


state DoorClose  {
     
    state_entry() {
        DEBUG("State Doorclose");
        
        llMessageLinked(LINK_SET,1,"CLOSE","");
        
         if (isSeated)
            state  Running; 
    }
    link_message(integer sender_number, integer number, string message, key id)
    {
        if (message == "DoorClosed")
        {
            state Running;
        }  else if (message == "Seated") {
            isSeated = TRUE;
            Agent = id;
            state Running;
        }  else if (message == "Unseated")    {
           Unsit();
        }  else if (message == "reset") {
            ResetScript();
        }
    }  
    
}

state Running {
    
    state_entry()
    {
        DEBUG("State Running");
        if (isSeated)
            Run();
    }
    
    link_message(integer sender_number, integer number, string message, key id)
    {
        if (message == "Seated")
        {
            Agent = id;
            Run();
            
        } else if (message == "Unseated")    {
           Unsit();
        } else if (message == "reset") {
            ResetScript();
        }
    }
    
    
    run_time_permissions(integer perm)
    {
        if (perm & PERMISSION_CONTROL_CAMERA)
        {
           // DEBUG("Init Camera");
            init_followCam();
        }

        if (perm & PERMISSION_TAKE_CONTROLS)
        {            
            //DEBUG("Taking Controls");
            llSetTimerEvent(0.2);
            
            llTakeControls(CONTROL_FWD | CONTROL_BACK | CONTROL_DOWN | CONTROL_UP | CONTROL_RIGHT |
                CONTROL_LEFT | CONTROL_ROT_RIGHT | CONTROL_ROT_LEFT, TRUE, FALSE);
        }

        if (perm & PERMISSION_TRIGGER_ANIMATION)
        {
            //DEBUG("Seating Avatar");
            llStopAnimation("sit");
            AvatarAnimate(AvatarSit);
        }
    }
    
    
    control(key id, integer level, integer edge)
    {
        integer reverse=1;
        vector angular_motor;
        
        //get current speed
        vector vel = llGetVel();
        Speed = llVecMag(vel);
        //DEBUG((string)Speed);

        //car controls
        if(level & CONTROL_FWD)
        {
            llMessageLinked(LINK_SET,0,"fwd","");
            llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <10.0, 2.0, 1000.0>);
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <forward_power * gallop,0,0>);
            reverse=1;
        }
        if(level & CONTROL_BACK)
        {
            llMessageLinked(LINK_SET,0,"rev","");
            llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <10.0, 2.0, 1000.0>);
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <reverse_power,0,0>);
            reverse = -1;
        }

        if(level & (CONTROL_RIGHT|CONTROL_ROT_RIGHT))
        {
            angular_motor.z -= Speed / turning_ratio * reverse;
            turncount = 10;
        }
        
        if(level & (CONTROL_LEFT|CONTROL_ROT_LEFT))
        {
            angular_motor.z += Speed / turning_ratio * reverse;
            
            turncount = 10;
        }
        
        if(level & (CONTROL_UP))
        {
            if (gallop == 1.0)
                Whinny2();
                
            gallop = 2.0;
            
        }
        
        if(level & (CONTROL_DOWN))
        {
             if (gallop == 2.0)
                Whinny3();
           
            gallop = 1.0;
        }
        
        llSetVehicleVectorParam(VEHICLE_ANGULAR_MOTOR_DIRECTION, angular_motor);
        if(turncount > 0)
        {
            turncount--;
        } 
          
        
    } //end control        

    timer(){
          
        if(NPCisRunning){
            vector vel = llGetVel();

            Speed = llVecMag(vel);
            //DEBUG("vecMag Speed " + (string)Speed);            

            if(Speed > 0.2)
            {
                //AvatarAnimate(AvatarRide);
                if (gallop == 1)
                    llLoopSound("horse_walk1",1.0);
                else
                    llLoopSound("horse_gallop",1.0);
           
                if (!once++)  {
                
                    llMessageLinked(LINK_SET, 9, "feetsieson","");
                    llMessageLinked(LINK_SET, 9, "duston","");
                    llMessageLinked(LINK_SET,0,"spin","");                    
                }

                if (gallop == 1.0) {
                    NPCHorse1Play(NPCWalk);
                    NPCHorse2Play(NPCWalk);
                    NPCHorse3Play(NPCWalk);
                    NPCHorse4Play(NPCWalk);
                } else {
                    NPCHorse1Play(NPCRun); 
                    NPCHorse2Play(NPCRun); 
                    NPCHorse3Play(NPCRun); 
                    NPCHorse4Play(NPCRun); 
                }
                    
                llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <1.0, 2.0, 1000.0>);
                llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <0,0,0>);
            }
            else {     
            
                if (once) {           
                    NPCHorse1Play(NPCStand);
                    NPCHorse2Play(NPCStand);
                    NPCHorse3Play(NPCStand);
                    NPCHorse4Play(NPCStand);                
                    
                    once = 0;
                    llStopSound();
                    llMessageLinked(LINK_SET,0,"stop","");
                    llMessageLinked(LINK_SET, 8, "feetsiesoff","");
                    llMessageLinked(LINK_SET, 8, "dustoff","");
                }
            } 
            llSetTimerEvent(0.3);          // If restarted timer() appears to keep working  
        } else {
           //DEBUG("Timer = OFF");
            llSetTimerEvent(0.0);
        }
    }
    
} //end running

 