//=========================================================================
// Gag script 1.5.2
//
//Revision history:
//
// 1.3.1    Changed MUTE behaviour to re-direct chat to random channel so no indication
//          is given to others that the wearer is even trying to speak
// 1.4.1    Added re-direct to Channel 1 when loose or medium
// 1.4.2    Fixed not resetting when TPing very short distances
// 1.4.3    Found I had not fixed reset issue in both states
//          Also tried to clean up chat redirections 
// 1.4.4    Added reset function for script issues
// 1.4.5    Changed gag output to whisper
// 1.4.6    Replaced references to llKey2Name with osKey2Name and fixed gagged speech name
// 1.5.2    Changed to say "Elizabeth rofanui mumbles: " as the message from the gag
//          Removed reference to osKey2Name as this does not always work on all sims due to security
//
//

integer listen_handle_monitor;
string msg_rec;
integer gagLevel;
integer gagChannel;
string nameWearer;
string objectName;


// ==================
// MUFFLE CHANNEL

// Send a gagged-speech version of a message to the open channel.
integer mumble(string mes, integer severity)
{
    // Iterate through the speech, mushing up the wearer's diction.
    integer i;
    string sub = "";
    string rep = "";
    for (i = 0; i < llStringLength(mes); i++)
    {
        sub = llGetSubString(mes, i, i);
        rep = "";

        if (severity == 0)
        {
            if (sub == "l")
                rep = "w";
            else
                if (sub == "L")
                    rep = "W";
            else
                if (sub == "s")
                    rep = "f";
            else
                if (sub == "S")
                    rep = "F";
            else
                if (sub == "t" || sub == "c" || sub == "k")
                    rep = "g";
            else
                if (sub == "T" || sub == "C" || sub =="K")
                    rep = "G";
        }
        else
            if (severity == 1)
            {
                if (sub == "r" || sub == "l" || sub == "q" || sub == "j" || sub == "d")
                    rep = "w";
                else
                    if (sub == "R" || sub == "L" || sub == "Q" || sub == "J" || sub == "D")
                        rep = "W";
                else
                    if (sub == "s")
                        rep = "f";
                else
                    if (sub == "S")
                        rep = "F";
                else
                    if (sub == "b" || sub == "t" || sub == "c" || sub == "k")
                        rep = "g";
                else
                    if (sub == "B" || sub == "T" || sub =="C" || sub == "K")
                        rep = "G";
            }
        else
            if (severity == 2)
            {
                if (sub == "r" || sub == "l" || sub == "q" || sub == "j" || sub == "d")
                    rep = "w";
                else
                    if (sub == "R" || sub == "L" || sub == "Q" || sub == "J" || sub == "D")
                        rep = "W";
                else
                    if (sub == "s")
                        rep = "f";
                else
                    if (sub == "S")
                        rep = "F";
                else
                    if (sub == "n")
                        rep = "m";
                    if (sub == "N")
                        rep = "m";        
                
                else
                    if (sub == "b" | sub == "t" | sub == "h" | sub == "d" | sub == "c" | sub == "k" | sub == "v" | sub == "e")
                        rep = "m";
                else
                    if (sub == "B" | sub == "T" | sub == "H" | sub == "D" | sub == "C" | sub == "K" | sub == "V" | sub == "E")
                        rep = "M";
            }
        else
        {
            llOwnerSay("Tried to use an unsupported muffle algorithm called '" + (string)severity + "'.");
        }

        // Replace character if necessary.
        if (rep != "")
        {
            mes = llDeleteSubString(mes, i, i);
            mes = llInsertString(mes, i, rep);
        }
    }

    // Broadcast the muffled speech on the chat channel.

    llSetObjectName(nameWearer + " mumbles");
    llSay(0, mes);
    llSetObjectName(objectName);

    return TRUE;
}

default
{
    state_entry()
    {
        gagChannel=(integer)(llFrand(1000000000.0));
        nameWearer=llKey2Name(llGetOwner());
        objectName=llGetObjectName();
        llOwnerSay("@clear=redirchat"); //Clean up any old chat redirections
    }
    link_message(integer sender_num, integer num, string str, key id)
    {
        //llOwnerSay(str);
        if (num==9977 && str=="LOOSE")
        {
            gagLevel=0;
            state gag_on;
        }
        else if (num==9977 && str=="MEDIUM")
        {
            gagLevel=1;
            state gag_on;
        }
        else if (num==9977 && str=="TIGHT")
        {
            gagLevel=2;
            state gag_on;
        }
        if (num==9977 && str=="MUTE")
        {
            gagLevel=0;
            state mute_on;
        }
        else if (num==9977 && str=="NONE")
        {
            state gag_off;
        }
        else if (num==9977 && str=="RESET")
        {
            llOwnerSay("Gag  got reset message");
            llResetScript();
        }
    }
    on_rez (integer start_param)
    {
        llResetScript();
    }
    changed (integer iChange)
    {
        if (iChange & CHANGED_REGION)
        {
            llResetScript();
        }
    }
}


state gag_off
{
    state_entry ()
    {
        llOwnerSay("@redirchat:" + (string)gagChannel + "=rem");
        llOwnerSay("@sendchat=y");
        nameWearer=llKey2Name(llGetOwner());
        objectName=llGetObjectName();
    }
    link_message(integer sender_num, integer num, string str, key id)
    {
        //llOwnerSay(str);
        if (num==9977 && str=="LOOSE")
        {
            gagLevel=0;
            state gag_on;
        }
        else if (num==9977 && str=="MEDIUM")
        {
            gagLevel=1;
            state gag_on;
        }
        else if (num==9977 && str=="TIGHT")
        {
            gagLevel=2;
            state gag_on;
        }
        if (num==9977 && str=="MUTE")
        {
            gagLevel=0;
            state mute_on;
        }
        else if (num==9977 && str=="NONE")
        {
            state gag_off;
        }
        else if (num==9977 && str=="RESET")
        {
            llOwnerSay("Gag got reset message");
            llResetScript();
        }
    }
    on_rez (integer start_param)
    {
        llResetScript();
    }
    changed (integer iChange)
    {
        if (iChange & CHANGED_REGION)
        {
            llResetScript();
        }
    }

}



state gag_on
{
    state_entry ()
    {
        llOwnerSay("@redirchat:" + (string)gagChannel + "=add");
        llOwnerSay("@sendchat=n");
        listen_handle_monitor=llListen(gagChannel,"", "", "");
        nameWearer=llKey2Name(llGetOwner());
        objectName=llGetObjectName();
    }
    link_message(integer sender_num, integer num, string str, key id)
    {
        //llOwnerSay(str);
        if (num==9977 && str=="LOOSE")
        {
            gagLevel=0;
            state gag_on;
        }
        else if (num==9977 && str=="MEDIUM")
        {
            gagLevel=1;
            state gag_on;
        }
        else if (num==9977 && str=="TIGHT")
        {
            gagLevel=2;
            state gag_on;
        }
        if (num==9977 && str=="MUTE")
        {
            gagLevel=0;
            state mute_on;
        }
        else if (num==9977 && str=="NONE")
        {
            state gag_off;
        }
         else if (num==9977 && str=="RESET")
        {
            llOwnerSay("gag got reset message");
            llResetScript();
        }
    }
    state_exit()
    {
        llListenRemove(gagChannel);
        llOwnerSay("@redirchat:" + (string)gagChannel + "=add");
    }

    listen(integer channel, string name, key id, string message)
    {
        msg_rec=message;
        mumble (msg_rec,gagLevel);
        if (gagLevel==0 || gagLevel==1)
        {
            llSetObjectName(nameWearer);
            llSay(1, msg_rec);
            llSetObjectName(objectName);
        }
    }

    attach (key id)
    {
        if (id) //if id is valid we have been attached
        {
            //re-issue necessary commands etc here
            gagChannel= (integer)(llFrand(1000000000.0));
            llOwnerSay("@redirchat:" + (string)gagChannel + "=add");
            llOwnerSay("@sendchat=n");
            listen_handle_monitor=llListen(gagChannel,"", "", "");
            nameWearer=llKey2Name(llGetOwner());
            objectName=llGetObjectName();
        }
        else
        {
            //item detached
            llListenRemove(gagChannel); //Cleanup listener
            llOwnerSay("@redirchat:" + (string)gagChannel + "=rem");
        }
    }
     on_rez (integer start_param)
    {
        llResetScript();
    }
    changed (integer iChange)
    {
        if (iChange & CHANGED_REGION)
        {
            llResetScript();
        }
    }

}

state mute_on
{
    state_entry ()
    {
        llOwnerSay("@redirchat:" + (string)gagChannel + "=rem");
        //llOwnerSay("@sendchat=n");
        //If the wearer is mute we re-direct chat but don't set-up listener
        //This way there is no indication that they are even speaking
        gagChannel=(integer)(llFrand(1000000000.0));
        llOwnerSay("@redirchat:" + (string)gagChannel + "=add");
        llOwnerSay("@sendchat=n");
        nameWearer=llKey2Name(llGetOwner());
        objectName=llGetObjectName();
    }
    link_message(integer sender_num, integer num, string str, key id)
    {
        
        //llOwnerSay(str);
        if (num==9977 && str=="LOOSE")
        {
            gagLevel=0;
            state gag_on;
        }
        else if (num==9977 && str=="MEDIUM")
        {
            gagLevel=1;
            state gag_on;
        }
        else if (num==9977 && str=="TIGHT")
        {
            gagLevel=2;
            state gag_on;
        }
        if (num==9977 && str=="MUTE")
        {
            gagLevel=0;
            state mute_on;
        }
        else if (num==9977 && str=="NONE")
        {
            state gag_off;
        }
         else if (num==9977 && str=="RESET")
        {
            llOwnerSay("gag got reset message");
            llResetScript();
        }
    }


    attach (key id)
    {
        if (id) //if id is valid we have been attached
        {
            //re-issue necessary commands etc here
            gagChannel=(integer)(llFrand(1000000000.0));
            llOwnerSay("@redirchat:" + (string)gagChannel + "=add");
            llOwnerSay("@sendchat=n");
            //llOwnerSay("@sendchat=n");
            nameWearer=llKey2Name(llGetOwner());
            objectName=llGetObjectName();
        }
        else
        {
            //item detached
            llOwnerSay ("@sendchat=y");
            llOwnerSay("@redirchat:" + (string)gagChannel + "=rem");
        }
    }
     on_rez (integer start_param)
    {
        llResetScript();
    }
    changed (integer iChange)
    {
        if (iChange & CHANGED_REGION)
        {
            llResetScript();
        }
    }

}
