vector offset = < 2, 0, 1.25>;  
vector pos;
vector vecNewPos;

key gKyOID;
key gKySensedObject;
key gKyOrb;

float fltDistApart;

list lstObjectNameList;
list lstObjectKeyList;

string strDisplayString;
string strObjectPos;
string strButtonResponse;

integer gIntAttached;
integer gListener;
integer gListener2;
integer intSearchState;
integer gIntTimedCount;
integer gIntSearchIndex;
integer gIntRegionMax;


fnWarpPos(vector pos)
{
    list rules;
    integer num = llCeil(llVecDist(llGetPos(),pos)/10);
    while(num--)rules=(rules=[])+rules+[PRIM_POSITION,pos];
    llSetPrimitiveParams(rules);
}


fnBeamParticles(key gKySensedObject)
{
        llParticleSystem([ PSYS_PART_FLAGS, 0 | PSYS_PART_EMISSIVE_MASK | 
         PSYS_PART_INTERP_COLOR_MASK | PSYS_PART_INTERP_SCALE_MASK | 
         PSYS_PART_FOLLOW_SRC_MASK | PSYS_PART_FOLLOW_VELOCITY_MASK |PSYS_PART_TARGET_POS_MASK ,
         PSYS_SRC_PATTERN,PSYS_SRC_PATTERN_EXPLODE,
         PSYS_PART_MAX_AGE, 1.0,
         PSYS_PART_START_COLOR,<1,0,0>,
         PSYS_PART_END_COLOR,<1,0,0>,
         PSYS_PART_START_SCALE,<0.1, 0.4, 0.1>,
         PSYS_PART_END_SCALE,<0.1, 0.2, 0.1>,
         PSYS_PART_START_GLOW, 0.3,
         PSYS_SRC_BURST_RATE,0.01,
         PSYS_SRC_ACCEL,<0.0, 0.0, 0.0>,
         PSYS_SRC_BURST_PART_COUNT,1,
         PSYS_SRC_BURST_RADIUS,0.03,
         PSYS_SRC_BURST_SPEED_MIN,0.10,
         PSYS_SRC_BURST_SPEED_MAX,0.50,
         PSYS_SRC_TARGET_KEY,gKySensedObject,
         PSYS_SRC_INNERANGLE,1.55,
         PSYS_SRC_OUTERANGLE,1.54,
         PSYS_SRC_OMEGA,<0.0, 0.0, 5.0>,
         PSYS_SRC_MAX_AGE,0.00,
         PSYS_PART_START_ALPHA,0.50,
         PSYS_PART_END_ALPHA,0.10
         ]);   
}

updateParticles()
{
    key gKySensor;
    llParticleSystem([  PSYS_PART_MAX_AGE,2,
                        PSYS_PART_FLAGS,PSYS_PART_EMISSIVE_MASK|PSYS_PART_INTERP_SCALE_MASK|PSYS_PART_TARGET_POS_MASK ,
                        PSYS_SRC_TARGET_KEY,gKyOrb,
                        PSYS_PART_START_COLOR,<1,0,0> ,
                        PSYS_PART_END_COLOR, <1,0,0>,
                        PSYS_PART_START_SCALE,<.125,.125,FALSE>,
                        PSYS_PART_END_SCALE,<.01,.01,FALSE>, 
                        PSYS_SRC_PATTERN, PSYS_SRC_PATTERN_EXPLODE,
                        PSYS_SRC_BURST_RATE,.02,
                        PSYS_SRC_ACCEL, <0,0,0>,
                        PSYS_SRC_BURST_PART_COUNT,1,
                        PSYS_SRC_BURST_RADIUS,.0,
                        PSYS_SRC_BURST_SPEED_MIN,.25,
                        PSYS_SRC_BURST_SPEED_MAX,.25,                       
                        PSYS_SRC_ANGLE_BEGIN,(float).5*PI,
                        PSYS_SRC_ANGLE_END,(float).5*PI,                       
                        PSYS_SRC_OMEGA, <0,0,1.0>,
                        PSYS_SRC_MAX_AGE, 0,
                        PSYS_SRC_TEXTURE, "smoke1",
                        PSYS_PART_START_ALPHA, 1,
                        PSYS_PART_END_ALPHA, 1
                            ]);
}
 
default
{
    on_rez(integer parm)
    {
        llResetScript();
    }
    state_entry()
    {
       // llSetPrimitiveParams([PRIM_TYPE,PRIM_TYPE_SPHERE,PRIM_SIZE,<0.2,0.2,0.2>,PRIM_PHYSICS,1,PRIM_FULLBRIGHT,1,PRIM_POINT_LIGHT,1,<1,0,0>,1,10,5,PRIM_GLOW,0.3,PRIM_TEXTURE,0,"CLOUDS",<1,1,1>,<1,1,1>,0.0]);
        gIntRegionMax = (integer)llGetObjectDesc();
        updateParticles();
        llSetStatus(STATUS_PHYSICS, TRUE);
        llSleep(0.1);
        llSetTimerEvent(0.5);
        gKyOID=llGetOwner();
        gKyOrb = llGetKey();
    }
     attach(key id)
    {
        if (id)     // is a valid key and not NULL_KEY
        {
            llSay(0, "I have been attached!");
            llSetTimerEvent(0);
            gIntAttached =1;
        }
        else
        {
            llSay(0, "I have been detached!");
            llSetTimerEvent(0.5);
            gIntAttached =0;
        }
    }
    touch_start(integer c)
    {
        llListenRemove(gListener);
        llListenRemove(gListener2);
        gListener = llListen(-99, "", gKyOID, "");
        llDialog(gKyOID, "\nPlease select Scan Type:", ["Active", "Passive", "Scripted","Legacy", "Display","Select", "Beam Off" ,"Reset"] , -99);
        llSensor("", "", intSearchState, 30, PI);
        //CAN BE ACTIVE,PASSIVE,SCRIPTED,AGENT
    }
    
    listen(integer chan, string name, key id, string msg)
    {
        lstObjectNameList = llList2List(lstObjectNameList,0,11);
        if (chan == -101)
        {
            llSetObjectDesc((integer)msg);
        }
        if (chan == -99)
        {
            if (msg == "Reset")
            {
                llResetScript();
            
            }
            if (msg == "Active")
            {
                intSearchState=2;
                llSensor("", "", intSearchState, 30, PI);
            }
            if (msg == "Passive")
            {
                intSearchState=4;
                 llSensor("", "", intSearchState, 30, PI);
            }
            if (msg == "Legacy")
            {
                intSearchState=1;
                 llSensor("", "", intSearchState, 30, PI);
            }
            if (msg == "Display")
            {
                intSearchState =10;
                 llSensor("", "", intSearchState, 30, PI);
            }
            if (msg == "Scripted")
            {   
                intSearchState =8;
                 llSensor("", "", intSearchState, 30, PI);
            }
            if (msg == "Select")
            {
                
            llDialog(gKyOID, "\nPlease select Object:", lstObjectNameList , -98);
            gListener2 = llListen(-98, "", gKyOID, "");
            }
            if (msg == "Beam Off")
            {
                updateParticles();
            
            }
        } 
        if (chan == -98)
        {
  //         llOwnerSay(msg);
           
            integer intQ;
            for (intQ=0;intQ<11;intQ++)
            {
                string strMyString = llList2String(lstObjectNameList,intQ);
                string strMyString2 = llGetSubString(strMyString,0,11);
                msg = llGetSubString(msg,0,11);
                
                llOwnerSay(msg + "  " + strMyString2);
                if (strMyString2 == msg)
                {
                    gIntSearchIndex = intQ;
                }
            }
            //gIntSearchIndex = llListFindList(lstObjectNameList,msg);
            llOwnerSay(gIntSearchIndex);
           // llOwnerSay(llDumpList2String(lstObjectNameList,""));
            gKySensedObject = llList2Key(lstObjectKeyList,gIntSearchIndex);  
            fnBeamParticles(gKySensedObject);             
        }
     }
    sensor(integer number_detected)
    {
        strDisplayString = "";
        lstObjectNameList = [];
        lstObjectKeyList = [];
        integer intObjectNumber;
        for (intObjectNumber = 0; intObjectNumber < number_detected; intObjectNumber++)
        {
            string  strObjectName = llDetectedName(intObjectNumber);
            key     gKySensedObject  = llDetectedKey(intObjectNumber);
            if (intObjectNumber< 12)
            {
                if (llListFindList(lstObjectNameList, [strObjectName]) == -1)
                {
                    lstObjectNameList =(lstObjectNameList=[])+lstObjectNameList+[strObjectName]; 
                    lstObjectKeyList = (lstObjectKeyList=[])+lstObjectKeyList+[gKySensedObject];
                    // llOwnerSay(strObjectName);
               
                    list lstObjectNow = llGetObjectDetails(gKySensedObject, OBJECT_POS);
                    vector vecObjectNow = llList2Vector (lstObjectNow,0);
                    integer intVecX = (integer)vecObjectNow.x;
                    integer intVecY = (integer)vecObjectNow.y;
                    integer intVecZ = (integer)vecObjectNow.z;
                    string strObjPosVec = "<"+(string)intVecX+" "+(string)intVecY+ " " + (string)intVecZ+">";
                    strObjectPos = strObjPosVec;
                    strDisplayString = strDisplayString +strObjectName + " \n";
                    strObjectPos = "";
                 //lstObjectNameList = [];   
                 //lstObjectKeyList = [];
                 }
            }
        }
        llSetText(strDisplayString,<1,1,1>,1.0);
        //strDisplayString = "";
        //lstObjectNameList = [];
    }
    changed(integer c)
    {
        if (c & CHANGED_OWNER)
        {
            llResetScript();
        }
    }
    
    timer()
    {
      //  gIntTimedCount++;
      //  if (gIntTimedCount == 1)
       // {
       //     lstObjectNameList=[];
       //     lstObjectKeyList=[];
       //     strDisplayString="";
       //     gIntTimedCount = 0;
       // }
       if (llGetAttached()==0){
        if (llGetAgentSize(gKyOID) == ZERO_VECTOR)
        {
            pos = <128,128,25>;
            llMoveToTarget(pos,0.4);
        }
        else
        {
    
            
                list det = llGetObjectDetails(gKyOID,[OBJECT_POS,OBJECT_ROT]);
                pos   = llList2Vector(det,0);
                vecNewPos = llGetPos();
                fltDistApart =llVecDist(pos,vecNewPos);
                if (fltDistApart > 8)
                { 
                    llSetText((string)fltDistApart, <1,1,1>,1.0);
                    pos += <2,0,1>;
                    fnWarpPos(pos);
                    llSleep(1.5);
                    llSetText("",<0.1,0.1,0.1>,0.1);            
                }
                rotation rot = (rotation)llList2String(det,1);
                vector worldOffset = offset;
                vector avOffset = offset * rot;
                pos += avOffset;
                if (pos.x < 0 ) { pos.x =1; }
                if (pos.x > gIntRegionMax ) { pos.x = gIntRegionMax;}
                if (pos.y < 0 ) { pos.y = 1;}
                if (pos.y > gIntRegionMax ) { pos.y = gIntRegionMax; }
                {
                    llMoveToTarget(pos,0.4);
                }
            }
        } 
    }
} 