//=========================================================================
// Leasher Script (DP) 1.2.0 
//
//Revision history:
//
// 1.1      Added link messages to recive updates for DP commands
// 1.1.1    Added missing re-leash command
// 1.1.2    Added link messages to update control script with leash status
// 1.2.0    Used llTakeControls to make leash work properly
//
//
//

integer debugMode=FALSE;
string msg;
integer channel_dialog;
key toucherID;
key selectedAVKey;
key keyHolder=NULL_KEY;
list nearbyAV;
list nearbyAVKey;
integer listen_id;
integer leashMessageID=9922;
integer leashParticlesID=9911;
string leashPosition="FRONT RING";



float DELAY = 0.5;   // Seconds between blinks; lower for more lag
float RANGE = 5.0;   // Meters away that we stop walking towards
float TAU = 0.5;     // Make smaller for more rushed following

key target = NULL_KEY;
string part_texture = "Steel chain";
integer toggle = 0;
list msg_lst = [];

// Avatar Follower script, by Dale Innis
// Do with this what you will, no rights reserved
// See https://wiki.secondlife.com/wiki/AvatarFollower for instructions and notes

float LIMIT = 60.0;   // Approximate limit (lower bound) of llMoveToTarget

integer lh = 0;
integer tid = 0;
string targetName = "";
key targetKey = NULL_KEY;
integer announced = FALSE;

leashParticlesON()
{
    llMessageLinked(LINK_SET, leashParticlesID, leashPosition, selectedAVKey);
}

leashParticlesOff()
{
    llMessageLinked(LINK_SET, leashParticlesID, "OFF", selectedAVKey);
    toggle = 0;
}
stopFollowing()
{
    llTargetRemove(tid);
    llStopMoveToTarget();
    llSetTimerEvent(0.0);
    // llOwnerSay("No longer following.");
    llOwnerSay("@tplm=y,tploc=y,tplure_sec=y,sittp=y,accepttp:" + (string)keyHolder + "=rem,tplure:" + (string)keyHolder + "=rem");
    leashParticlesOff();
}
startFollowingKey(key id)
{
    targetKey = id;
    //llOwnerSay("Now following "+targetName);
    target=targetKey;
    leashParticlesON();
    keepFollowing();
    llSetTimerEvent(DELAY);
}
keepFollowing()
{
    llTargetRemove(tid);
    llStopMoveToTarget();
    list answer = llGetObjectDetails(targetKey,[OBJECT_POS]);
    if (llGetListLength(answer)==0)
    {
        if (!announced) llOwnerSay(targetName+" seems to be out of range.  Waiting for return...");
        announced = TRUE;
    }
    else
    {
        announced = FALSE;
        vector targetPos = llList2Vector(answer,0);
        float dist = llVecDist(targetPos,llGetPos());
        if (dist>RANGE)
        {
            tid = llTarget(targetPos,RANGE);
            if (dist>LIMIT)
            {
                targetPos = llGetPos() + LIMIT * llVecNorm( targetPos - llGetPos() ) ;
            }
            llMoveToTarget(targetPos,TAU);
            llRequestPermissions(llGetOwner(), PERMISSION_TAKE_CONTROLS);
            llTakeControls(
                            CONTROL_FWD |
                            CONTROL_BACK |
                            CONTROL_LEFT |
                            CONTROL_RIGHT |
                            CONTROL_ROT_LEFT |
                            CONTROL_ROT_RIGHT |
                            CONTROL_UP |
                            CONTROL_DOWN |
                            CONTROL_LBUTTON |
                            CONTROL_ML_LBUTTON |
                            0, TRUE, FALSE);
            llSleep(0.5);
            llReleaseControls();


             
        }
        else
        {
            llReleaseControls();
        }
    }
}


default
{
    state_entry()
    {
        stopFollowing();
        llRequestPermissions(llGetOwner(), PERMISSION_TAKE_CONTROLS);
    }
    run_time_permissions (integer iPerm)
    {
    }
    link_message(integer sender_number, integer number, string message, key id)
    {
        if (number==leashMessageID)
        {
            toucherID=id;
            if (message=="OBJECT") state chooseObject;
            else if (message=="PERSON") state chooseAV;
            else if (message=="UNLEASH")
            {
                stopFollowing();
                state default;
            }
            else if (message=="FRONT RING") leashPosition="FRONT RING";
            else if (message=="BACK RING") leashPosition="BACK RING";
            else if (message=="KEYHOLDER") keyHolder=id;
            else if (message=="LEASH_TARGET") selectedAVKey=id;
            else if (message=="RELEASH")
            {
                if (debugMode==TRUE) llOwnerSay("Received Re-Leash command - changing state");
                state leashed;
            }
            else RANGE=(integer)message;
        }

    }
on_rez(integer start_param)
{
    llResetScript();
}
changed(integer iChange)
{
    if (iChange & CHANGED_REGION)
    {
        llResetScript();
    }
}


}
state chooseAV
{
    state_entry()
    {
        msg = "Please select person to leash to";
        channel_dialog = ( -1 * (integer)("0x"+llGetSubString((string)llGetKey(),-5,-1)) );
        llSensor("", NULL_KEY, AGENT, 20, PI); // scan for agents/avatars within 20 metres
    }
    sensor(integer total_number) // total_number is the number of avatars detected.
    {
        nearbyAV = [];
        nearbyAVKey = [];

        if (total_number > 12) // can't display more than 12 items in a dialogue
        {
            total_number = 12;
        }
        integer i;
        for (i = 0; i < total_number; i++)
        {
            nearbyAV = nearbyAV + llGetSubString(llDetectedName(i), 0, 23);
            nearbyAVKey= nearbyAVKey + llDetectedKey(i);
        }
        llDialog(toucherID, msg,nearbyAV, channel_dialog);
        listen_id = llListen( channel_dialog, "", toucherID, "");
        llSetTimerEvent(30); //HERE WE SET A TIME LIMIT
    }
    no_sensor()
    {
        llOwnerSay("No Avatars found");
        state default;
    }
    listen(integer channel, string name, key id, string choice)
    {
        integer avIndex;
        llListenRemove(listen_id); //HERE WE ARE BEING RESPONSIBLE
        avIndex = llListFindList (nearbyAV, [choice]);
        selectedAVKey = llList2Key(nearbyAVKey, avIndex);
        llSetTimerEvent(0.0);
        state lookForLeashHandle;
    }

    timer()

    {
        //TIME’S UP!
        llListenRemove(listen_id);
        llSetTimerEvent(0.0); //Stop the timer from being called repeatedly
        state default;
    }


}
state chooseObject
{
    state_entry()
    {
        msg = "Please select object to leash to";
        channel_dialog = ( -1 * (integer)("0x"+llGetSubString((string)llGetKey(),-5,-1)) );
        llSensor("", NULL_KEY, SCRIPTED, 20, PI); // scan for agents/avatars within 20 metres
    }
    sensor(integer total_number) // total_number is the number of avatars detected.
    {
        nearbyAV = [];
        nearbyAVKey = [];

        if (total_number > 12) // can't display more than 12 items in a dialogue
        {
            total_number = 12;
        }
        integer i;
        for (i = 0; i < total_number; i++)
        {
            nearbyAV = nearbyAV + llGetSubString(llDetectedName(i), 0, 23);
            nearbyAVKey= nearbyAVKey + llDetectedKey(i);
        }
        llDialog(toucherID, msg,nearbyAV, channel_dialog);
        listen_id = llListen( channel_dialog, "", toucherID, "");
        llSetTimerEvent(30); //HERE WE SET A TIME LIMIT
    }
    no_sensor()
    {
        llOwnerSay("No Objects found");
        state default;
    }
    listen(integer channel, string name, key id, string choice)
    {
        integer avIndex;
        llListenRemove(listen_id); //HERE WE ARE BEING RESPONSIBLE
        avIndex = llListFindList (nearbyAV, [choice]);
        selectedAVKey = llList2Key(nearbyAVKey, avIndex);
        //llOwnerSay ("Object selected: " + choice + " with a key of: " + (string)selectedAVKey);
        llMessageLinked(LINK_THIS, 47, choice, selectedAVKey);
        llSetTimerEvent(0.0);
        state leashed;
    }

    timer()

    {
        //TIME’S UP!
        llListenRemove(listen_id);
        llSetTimerEvent(0.0); //Stop the timer from being called repeatedly
        state default;
    }
}
state lookForLeashHandle
{
    state_entry()
    {
        // Lets see if they have a leash handle we know about
        llSay(-8888, (string)selectedAVKey + "handle");
        listen_id=llListen(-8888, "", NULL_KEY, "");
        llSetTimerEvent(2);
    }
    listen(integer channel, string name, key id, string message)
    {
        llListenRemove(listen_id);
        llSetTimerEvent(0);
        if (message==((string)selectedAVKey + "handle ok"))
        {
            selectedAVKey=id;
        }
        state leashed;
    }
    timer()
    {
        state leashed;
    }
}
state leashed
{
    state_entry()
    {
       if (RANGE <= 2.0) RANGE=2.0;
         llOwnerSay("@tplm=n,tploc=n,tplure_sec=n,sittp=n,tplure:" + (string)keyHolder + "=add,accepttp:" + (string)keyHolder + "=add");;
    startFollowingKey(selectedAVKey);
    llMessageLinked(LINK_ROOT, leashMessageID, "LEASH_ACTIVE", selectedAVKey);
    }
    attach(key attached)
    {
        if (attached)
        {
            llOwnerSay("@tplm=n,tploc=n,tplure_sec=n,sittp=n,tplure:" + (string)keyHolder + "=add,accepttp:" + (string)keyHolder + "=add");
            llMessageLinked(LINK_SET, leashParticlesID, leashPosition, selectedAVKey);
        }
    }
    //    touch_start (integer n)
    //    {
    //    if (llDetectedKey(0) != llGetOwner())
    //    {
    //        stopFollowing();
    //        state default;
    //    }
    //    }
    timer()
    {
        keepFollowing();
    }
    at_target(integer tnum,vector tpos,vector ourpos)
    {
        llTargetRemove(tnum);
        llStopMoveToTarget();
    }
    link_message(integer sender_number, integer number, string message, key id)
    {
        if (number==leashMessageID)
        {
            toucherID=id;
            if (message=="OBJECT") state chooseObject;
            else if (message=="PERSON") state chooseAV;
            else if (message=="UNLEASH")
            {
                stopFollowing();
                state default;
            }
            else if (message=="FRONT RING")
            {
                leashPosition="FRONT RING";
                llMessageLinked(LINK_SET, leashParticlesID, leashPosition, selectedAVKey);

            }
            else if (message=="BACK RING")
            {
                leashPosition="BACK RING";
                llMessageLinked(LINK_SET, leashParticlesID, leashPosition, selectedAVKey);

            }
        else if (message=="KEYHOLDER") keyHolder=id;
        else if (message=="LEASH_TARGET") selectedAVKey=id;
            else if (message=="RELEASH")
            {
                if (debugMode==TRUE) llOwnerSay("Received Re-Leash command - allready in leashed state - attempting re-leash");
                state releash;
            }
            else if ((integer)message >= 2.0) RANGE=(integer)message;
        }
        return;

}
on_rez(integer start_param)
{
    llResetScript();
}
changed(integer iChange)
{
    if (iChange & CHANGED_REGION)
    {
        llResetScript();
    }
}

}
state releash
{
    state_entry()
    {
        state leashed;
    }
}
