//OpenCollar - appearance - 3.333
//handle appearance menu
//handle skAving position on detach, and restoring it on httpdb_response

string g_sSubMenu = "Appearance";
string g_sParentMenu = "Main";

list g_lMenuIDs;//3-strided list of kAvkey, g_kDialogID, menusName
integer g_iMenuStride = 3;

string POSMENU = "Position";
string ROTMENU = "Rotation";

list g_lLocalButtons = ["Position","Rotation"]; //[POSMENU, ROTMENU];
list g_lButtons;
float g_fSmallNudge=0.0005;
float g_fMediumNudge=0.005;
float g_fLargeNudge=0.05;
float g_fNudge=0.005; // g_fMediumNudge;
float g_fRotNudge;

//MESSAGE MAP
integer COMMAND_NOAUTH = 0;
integer COMMAND_OWNER = 500;
integer COMMAND_SECOWNER = 501;
integer COMMAND_GROUP = 502;
integer COMMAND_WEARER = 503;
integer COMMAND_EVERYONE = 504;
//integer CHAT = 505;//deprecated
integer COMMAND_OBJECT = 506;
integer COMMAND_RLV_RELAY = 507;

//integer SEND_IM = 1000; deprecated.  each script should send its own IMs now.  This is to reduce even the tiny bt of lag caused by hkAving IM slkAve scripts
integer POPUP_HELP = 1001;

integer HTTPDB_SAVE = 2000;//scripts send messages on this channel to have settings saved to httpdb
                            //sStr must be in form of "sToken=sValue"
integer HTTPDB_REQUEST = 2001;//when startup, scripts send requests for settings on this channel
integer HTTPDB_RESPONSE = 2002;//the httpdb script will send responses on this channel
integer HTTPDB_DELETE = 2003;//delete sToken from DB
integer HTTPDB_EMPTY = 2004;//sent by httpdb script when a sToken has no sValue in the db

integer MENUNAME_REQUEST = 3000;
integer MENUNAME_RESPONSE = 3001;
integer SUBMENU = 3002;
integer MENUNAME_REMOVE = 3003;

integer RLV_CMD = 6000;
integer RLV_REFRESH = 6001;//RLV plugins should reinstate their g_lRestrictions upon receiving this message.
integer RLV_CLEAR = 6002;//RLV plugins should clear their resStriction lists upon receiving this message.

integer ANIM_START = 7000;//send this with the sName of an sAnim in the string part of the sMessage to play the sAnim
integer ANIM_STOP = 7001;//send this with the sName of an sAnim in the string part of the sMessage to stop the sAnim
integer CPLANIM_PERMREQUEST = 7002;//kID should be kAv's key, sStr should be sCmd sName "hug", "kiss", etc
integer CPLANIM_PERMRESPONSE = 7003;//sStr should be "1" for got perms or "0" for not.  kID should be kAv's key
integer CPLANIM_START = 7004;//sStr should be valkID sAnim sName.  kID should be kAv
integer CPLANIM_STOP = 7005;//sStr should be valkID sAnim sName.  kID should be kAv

integer DIALOG = -9000;
integer DIALOG_RESPONSE = -9001;
integer DIALOG_TIMEOUT = -9002;

//string UPMENU = "↑";//when your menu hears this, give the parent menu
string UPMENU = "^";

key g_kWearer;
integer g_iRemenu;

key ShortKey()
{//just pick 8 random hex digits and pad the rest with 0.  Good enough for dialog uniqueness.
    string sChars = "0123456789abcdef";
    integer iLength = 16;
    string sOut;
    integer n;
    for (n = 0; n < 8; n++)
    {
        integer iIndex = (integer)llFrand(16);//yes this is correct; an integer cast rounds towards 0.  See the llFrand wiki entry.
        sOut += llGetSubString(sChars, iIndex, iIndex);
    }
     
    return (key)(sOut + "-0000-0000-0000-000000000000");
}

key Dialog(key kRCPT, string sPrompt, list lChoices, list lUtilityButtons, integer iPage)
{
    key kID = ShortKey();
    llMessageLinked(LINK_SET, DIALOG, (string)kRCPT + "|" + sPrompt + "|" + (string)iPage + "|" + llDumpList2String(lChoices, "`") + "|" + llDumpList2String(lUtilityButtons, "`"), kID);
    return kID;
}

Notify(key kID, string sMsg, integer iAlsoNotifyWearer) {
    if (kID == g_kWearer) {
        llOwnerSay(sMsg);
    } else {
        llInstantMessage(kID,sMsg);
        if (iAlsoNotifyWearer) {
            llOwnerSay(sMsg);
        }
    }    
}

Debug(string sStr)
{
    //llOwnerSay(llGetScriptName() + ": " + sStr);
}

ForceUpdate()
{
    //workaround for https://jira.secondlife.com/browse/VWR-1168
    llSetText(".", <1,1,1>, 1.0);
    llSetText("", <1,1,1>, 1.0);
}

AdjustPos(vector vDelta)
{
    if (llGetAttached())
    {
        llSetPos(llGetLocalPos() + vDelta);
        ForceUpdate();
    }
}

AdjustRot(vector vDelta)
{
    if (llGetAttached())
    {
        llSetLocalRot(llGetLocalRot() * llEuler2Rot(vDelta));
        ForceUpdate();
    }
}

RotMenu(key kAv)
{
    string sPrompt = "Adjust the collar rotation.";
    list lMyButtons = ["tilt up", "right", "tilt left", "tilt down", "left", "tilt right"];// ria iChange
    key kMenuID = Dialog(kAv, sPrompt, lMyButtons, [UPMENU], 0);
    integer iMenuIndex = llListFindList(g_lMenuIDs, [kAv]);
    list lAddMe = [kAv, kMenuID, ROTMENU];
    if (iMenuIndex == -1)
    {
        g_lMenuIDs += lAddMe;
    }
    else
    {
        g_lMenuIDs = llListReplaceList(g_lMenuIDs, lAddMe, iMenuIndex, iMenuIndex + g_iMenuStride - 1);
    }
}

PosMenu(key kAv)
{
    string sPrompt = "Adjust the collar position:\nChoose the size of the nudge (S/M/L), and move the collar in one of the three directions (X/Y/Z).\nCurrent nudge size is: ";
    list lMyButtons = ["left", "up", "forward", "right", "down", "backward"];// ria iChange
    if (g_fNudge!=g_fSmallNudge) lMyButtons+=["Nudge: S"];
    else sPrompt += "Small.";
    if (g_fNudge!=g_fMediumNudge) lMyButtons+=["Nudge: M"];
    else sPrompt += "Medium.";
    if (g_fNudge!=g_fLargeNudge) lMyButtons+=["Nudge: L"];
    else sPrompt += "Large.";
    
    key kMenuID = Dialog(kAv, sPrompt, lMyButtons, [UPMENU], 0);
    integer iMenuIndex = llListFindList(g_lMenuIDs, [kAv]);
    list lAddMe = [kAv, kMenuID, POSMENU];
    if (iMenuIndex == -1)
    {
        g_lMenuIDs += lAddMe;
    }
    else
    {
        g_lMenuIDs = llListReplaceList(g_lMenuIDs, lAddMe, iMenuIndex, iMenuIndex + g_iMenuStride - 1);    
    }
}

DoMenu(key kAv)
{
    string sPrompt = "Which aspect of the appearance would you like to modify?\n";

    list lMyButtons = llListSort(g_lLocalButtons + g_lButtons, 1, TRUE);
    
    key kMenuID = Dialog(kAv, sPrompt, lMyButtons, [UPMENU], 0);
    integer iMenuIndex = llListFindList(g_lMenuIDs, [kAv]);
    list lAddMe = [kAv, kMenuID, g_sSubMenu];
    if (iMenuIndex == -1)
    {
        g_lMenuIDs += lAddMe;
    }
    else
    {
        g_lMenuIDs = llListReplaceList(g_lMenuIDs, lAddMe, iMenuIndex, iMenuIndex + g_iMenuStride - 1);    
    }    
}

string GetDBPrefix()
{//get db prefix from list in object desc
    return llList2String(llParseString2List(llGetObjectDesc(), ["~"], []), 2);
}

default
{
    state_entry()
    {
        g_kWearer = llGetOwner();       
        g_fRotNudge = PI / 32.0;//have to do this here since we can't divkIDe in a global var declaration   
    }
    
    on_rez(integer iParam)
    {
        llResetScript();
    }

    link_message(integer iSender, integer iNum, string sStr, key kID)
    {
        if (iNum == SUBMENU && sStr == g_sSubMenu)
        {
            //someone asked for our menu
            //give this plugin's menu to kID
            g_iRemenu = TRUE;
            llMessageLinked(LINK_THIS, COMMAND_NOAUTH, "appearance",kID);
        }
        else if (iNum == MENUNAME_REQUEST && sStr == g_sParentMenu)
        {
            
            llMessageLinked(LINK_THIS, MENUNAME_RESPONSE, g_sParentMenu + "|" + g_sSubMenu, NULL_KEY);
        }
        else if (iNum == MENUNAME_RESPONSE)
        {
            list lParts = llParseString2List(sStr, ["|"], []);
            if (llList2String(lParts, 0) == g_sSubMenu)
            {//someone wants to stick something in our menu
                string button = llList2String(lParts, 1);
                if (llListFindList(g_lButtons, [button]) == -1)
                {
                    g_lButtons = llListSort(g_lButtons + [button], 1, TRUE);
                }
            }
        }
        else if (iNum >= COMMAND_OWNER && iNum <= COMMAND_WEARER)
        {
            list lParams = llParseString2List(sStr, [" "], []);
            string sCommand = llToLower(llList2String(lParams, 0));
            string sValue = llToLower(llList2String(lParams, 1));
            if (sStr == "refreshmenu")
            {
                g_lButtons = [];
                llMessageLinked(LINK_SET, MENUNAME_REQUEST, g_sSubMenu, NULL_KEY);
            }
            else if (sStr == "appearance")
            {
                if (kID!=g_kWearer && iNum!=COMMAND_OWNER)
                {
                    Notify(kID,"You are not allowed to change the collar appearance.", FALSE);
                    if (g_iRemenu) llMessageLinked(LINK_THIS, SUBMENU, g_sParentMenu, kID);
                }
                else DoMenu(kID);
                g_iRemenu=FALSE;
            }
            else if (sStr == "rotation")
            {
                if (kID!=g_kWearer && iNum!=COMMAND_OWNER)
                {
                    Notify(kID,"You are not allowed to change the collar rotation.", FALSE);
                }
                else RotMenu(kID);
             }
            else if (sStr == "position")
            {
                if (kID!=g_kWearer && iNum!=COMMAND_OWNER)
                {
                    Notify(kID,"You are not allowed to change the collar position.", FALSE);
                }
                else PosMenu(kID);
            }
        }
        else if (iNum == DIALOG_RESPONSE)
        {
            integer iMenuIndex = llListFindList(g_lMenuIDs, [kID]);
            if (iMenuIndex != -1)
            {
                //got a menu response meant for us.  pull sOut sValues
                list lMenuParams = llParseString2List(sStr, ["|"], []);
                key kAv = (key)llList2String(lMenuParams, 0);          
                string sMessage = llList2String(lMenuParams, 1);                                         
                integer iPage = (integer)llList2String(lMenuParams, 2);
                string sMenuType = llList2String(g_lMenuIDs, iMenuIndex + 1);
                //remove sStrkIDe from g_lMenuIDs
                //we have to subtract from the iIndex because the dialog kID comes in the mkIDdle of the sStrkIDe
                g_lMenuIDs = llDeleteSubList(g_lMenuIDs, iMenuIndex - 1, iMenuIndex - 2 + g_iMenuStride);                  
                if (sMenuType == g_sSubMenu)
                {
                    if (sMessage == UPMENU)
                    {
                        //give kID the parent menu
                        llMessageLinked(LINK_THIS, SUBMENU, g_sParentMenu, kAv);
                    }
                    else if (~llListFindList(g_lLocalButtons, [sMessage]))
                    {
                        //we got a response for something we handle locally
                        if (sMessage == POSMENU)
                        {
                            PosMenu(kAv);
                        }
                        else if (sMessage == ROTMENU)
                        {
                            RotMenu(kAv);
                        }
                    }
                    else if (~llListFindList(g_lButtons, [sMessage]))
                    {
                        //we got a g_sSubMenu selection
                        llMessageLinked(LINK_THIS, SUBMENU, sMessage, kAv);
                    }                                
                }
                else if (sMenuType == POSMENU)
                {
                    if (sMessage == UPMENU)
                    {
                        DoMenu(kAv);
                        return;
                    }
                    else if (llGetAttached())
                    {
                        if (sMessage == "left")
                        {
                            AdjustPos(<g_fNudge, 0, 0>);
                        }
                        else if (sMessage == "up")
                        {
                            AdjustPos(<0, g_fNudge, 0>);                
                        }
                        else if (sMessage == "forward")
                        {
                            AdjustPos(<0, 0, g_fNudge>);                
                        }            
                        else if (sMessage == "right")
                        {
                            AdjustPos(<-g_fNudge, 0, 0>);                
                        }            
                        else if (sMessage == "down")
                        {
                            AdjustPos(<0, -g_fNudge, 0>);                    
                        }            
                        else if (sMessage == "backward")
                        {
                            AdjustPos(<0, 0, -g_fNudge>);                
                        }                            
                        else if (sMessage == "Nudge: S")
                        {
                            g_fNudge=g_fSmallNudge;
                        }
                        else if (sMessage == "Nudge: M")
                        {
                            g_fNudge=g_fMediumNudge;                
                        }
                        else if (sMessage == "Nudge: L")
                        {
                            g_fNudge=g_fLargeNudge;                
                        }
                    }
                    else
                    {
                        Notify(kAv, "Sorry, position can only be adjusted while worn",FALSE);
                    }
                    PosMenu(kAv);                    
                }
                else if (sMenuType == ROTMENU)
                {
                    if (sMessage == UPMENU)
                    {
                        DoMenu(kAv);
                        return;
                    }
                    else if (llGetAttached())
                    {
                        if (sMessage == "tilt up")
                        {
                            AdjustRot(<g_fRotNudge, 0, 0>);
                        }
                        else if (sMessage == "right")
                        {
                            AdjustRot(<0, g_fRotNudge, 0>);                
                        }
                        else if (sMessage == "tilt left")
                        {
                            AdjustRot(<0, 0, g_fRotNudge>);                
                        }            
                        else if (sMessage == "tilt down")
                        {
                            AdjustRot(<-g_fRotNudge, 0, 0>);                
                        }            
                        else if (sMessage == "left")
                        {
                            AdjustRot(<0, -g_fRotNudge, 0>);                    
                        }            
                        else if (sMessage == "tilt right")
                        {
                            AdjustRot(<0, 0, -g_fRotNudge>);                
                        }                        
                    }
                    else
                    {
                        Notify(kAv, "Sorry, position can only be adjusted while worn", FALSE);
                    }
                    RotMenu(kAv);                     
                }
            }            
        }
        else if (iNum == DIALOG_TIMEOUT)
        {
            integer iMenuIndex = llListFindList(g_lMenuIDs, [kID]);
            if (iMenuIndex != -1)
            {
                //remove sStrkIDe from g_lMenuIDs
                //we have to subtract from the iIndex because the dialog kID comes in the mkIDdle of the sStrkIDe
                g_lMenuIDs = llDeleteSubList(g_lMenuIDs, iMenuIndex - 1, iMenuIndex - 2 + g_iMenuStride);                          
            }            
        }
    } 
}
