/////////////////////////////////////////////////////////////////////////
// Colour change script 1.0
//
//
// Edit the list below to match the names of the prims to be coloured
//
//
list menuParts=["Rings", "Part A", "Part B"];



vector blue=<0.0,0.0,1.0>;
vector green=<0.0,1.0,0.0>;
vector black=<0.0,0.0,0.0>;
vector pink=<1.0,0.714,0.757>;
vector red=<1.0,0.0,0.0>;
vector purple=<0.5,0.0,0.5>;
vector white=<1.0,1.0,1.0>;
vector yellow=<1.0,1.0,0.0>;
vector orange=<1.0,0.647,0.0>;
string linkDescription;
integer menuChannel;
vector vectColour;
string selectedPartName;
list menuColour=[" - ", " - ", "back", "blue", "green", "black", "pink", "red", "purple", "white", "yellow", "orange"];
integer listenHandleMenu;
integer menuExpireTime;
string menuMessage;
string menuLevel;
//Function to change colour of parts
colourPart(string partName, string colour)
{
    integer i=1;
    if (colour=="blue") vectColour=blue;
    if (colour=="green") vectColour=green;
    if (colour=="black") vectColour=black;
    if (colour=="pink") vectColour=pink;
    if (colour=="red") vectColour=red;
    if (colour=="purple") vectColour=purple;
    if (colour=="white") vectColour=white;
    if (colour=="yellow") vectColour=yellow;
    if (colour=="orange") vectColour=orange;
     while (i <= llGetNumberOfPrims()) 
     {
        linkDescription=(string)llGetLinkPrimitiveParams(i,[PRIM_DESC]);
        if (linkDescription==partName)
        {
            llSetLinkColor(i,vectColour,ALL_SIDES);
        }
        ++i;
     }
    
}
//Function to display colour menu
displayColourMenu (key ID)
{
        menuLevel="colour";
        llListenRemove(listenHandleMenu);
        menuChannel = (integer)(llFrand(-1000000000.0) - 1000000000.0);
        llDialog(ID, menuMessage, menuColour, menuChannel);
        listenHandleMenu = llListen( menuChannel, "", ID, "");
        menuExpireTime=llGetUnixTime() + 60;
}
//Function to display belt parts menu for colouring
displayPartsMenu (key ID)
{
    if (ID==llGetOwner())
    {
        menuLevel="main";
        llListenRemove(listenHandleMenu);
        menuChannel = (integer)(llFrand(-1000000000.0) - 1000000000.0);
        llDialog(ID, menuMessage, menuParts, menuChannel);
        listenHandleMenu = llListen( menuChannel, "", ID, "");
        menuExpireTime=llGetUnixTime() + 60;
    }
}

default
{
    state_entry()
    {
        llSetTimerEvent (10.0);
    }
    touch_start(integer total_number)
    {
        displayPartsMenu(llDetectedKey(0));
    }
    listen(integer channel, string name, key id, string message)
    {
        llListenRemove(listenHandleMenu);
        if (menuLevel=="main")
        {
            selectedPartName=message;
            displayColourMenu(id);
            return;
        }
        if (menuLevel=="colour")
        {
            colourPart(selectedPartName, message);
            return;
        }
            
    }
    



    timer()
    {
        if (llGetUnixTime() >= menuExpireTime) llListenRemove(listenHandleMenu);
    }
}