// when touched, present a dialog with four color choices

integer CHANNEL = 42;
list MENU_MAIN=["PLUM","TURQUOISE","BLUE","ORANGE","RED","WHITE","PURPLE","YELLOW","PINK","GREEN","MAGENTA","BLACK"];
list COLORS=[<0.53515,0.125,0.28125>,<0.68359,0.92687,0.92968>,<0.07031,0.41796,0.69921>,
    <0.65234,0.27343,0.22265>,<0.32941, 0.02353, 0.01176>,<0.86, 0.86, 0.86>,
    <0.34902, 0.12549, 0.76471>,<0.90234,0.73437,0.32421>,<1.00000, 0.39216, 0.69804>,
    <0.07421,0.33984,0.29687>,<0.78431, 0.00000, 0.78431>,<0.03922, 0.03922, 0.03922>];
list PRIMS=[20,16,18,21,19];
integer listen_handle;
vector Last_color=<0.86, 0.86, 0.86>;
integer i;



default {
    state_entry()
    {
    }
    touch_start(integer total_number)
    {
        llDialog(llDetectedKey(0), "What do you want to do?", MENU_MAIN, CHANNEL); // present dialog on click
        listen_handle = llListen(CHANNEL, "", NULL_KEY, ""); // listen for dialog answers (from multiple users)
    }
    timer()
    {
        llSay(0,"Menu Timed Out...");
        llListenRemove(listen_handle);

    }
    listen(integer channel, string name, key id, string message)
    {

        if (llListFindList(MENU_MAIN , [message]) != -1)  // verify dialog choice
        {
            integer colorindex=llListFindList(MENU_MAIN,[message]);
            Last_color=(vector)llList2String(COLORS,colorindex);
            integer length=llGetListLength(PRIMS);
            for (i=0;i<length;i++) {
                llSetLinkColor(llList2Integer(PRIMS,i),Last_color,ALL_SIDES);
            }

        }

        llListenRemove(listen_handle);

    }
}




