//OpenCollar - rlvtalk - 3.331
//Licensed under the GPLv2, with the additional requirement that these scripts remain "full perms" in Second Life.  See "OpenCollar License" for details.

string g_sParentMenu = "RLV";
string g_sSubMenu = "Talk";
string g_sDBToken = "rlvtalk";
string g_sExToken = "rlvtalkex";

list g_lSettings;//2-strided list in form of [sOption, sParam]
list g_lExceptions;//2-strided list in form of [sOption, uukID]
list g_lRemExptns;//2-strided list in form of [sOption, uukID], of exceptions that need to be removed.  cleared after being sent to main rlv script

list g_lRLVcmds = [
    "sendchat",
    "chatshout",
    "chatnormal",
    "sendim",
    "recvchat",
    "recvim",
    "emote",
    "recvemote"
        ];

list g_lPrettyCmds = [ //showing menu-friendly sCommand sNames for each item in g_lRLVcmds
    "Chat",
    "Shouting",
    "Normal",
    "IM",
    "RcvChat",
    "RcvIM",
    "Emote",
    "RcvEmote"
        ];

list g_lDescriptions = [ //showing g_lDescriptions for sCommands
    "Ability to Send Chat",
    "Ability to Shout Chat",
    "Disable = Forced whisper",
    "Ability to Send IM",
    "Ability to Receive Chat",
    "Ability to Receive IM",
    "Allowed Length of Emotes",
    "Ability to Receive Emote"
        ];

list g_lAutoExceptions = [//when these g_lRestrictions are enabled, an exception will
    "sendim",               //automatically be made for the person giving the sCommand
    "recvchat",
    "recvim",
    "recvemote"
        ];

string TURNON = "Allow";
string TURNOFF = "Forbid";

integer g_iReturnMenu = FALSE;

integer g_iRLVOn=FALSE;

key g_kWearer;
key g_kDialogID;

//MESSAGE MAP
integer COMMAND_NOAUTH = 0;
integer COMMAND_OWNER = 500;
integer COMMAND_SECOWNER = 501;
integer COMMAND_GROUP = 502;
integer COMMAND_WEARER = 503;
integer COMMAND_EVERYONE = 504;
//integer CHAT = 505;//deprecated
integer COMMAND_OBJECT = 506;
integer COMMAND_RLV_RELAY = 507;

//integer SEND_IM = 1000; deprecated.  each script should send its own IMs now.  This is to reduce even the tiny bt of lag caused by hkAving IM slkAve scripts
integer POPUP_HELP = 1001;

integer HTTPDB_SAVE = 2000;//scripts send messages on this channel to have settings saved to httpdb
//sStr must be in form of "sToken=sValue"
integer HTTPDB_REQUEST = 2001;//when startup, scripts send requests for settings on this channel
integer HTTPDB_RESPONSE = 2002;//the httpdb script will send responses on this channel
integer HTTPDB_DELETE = 2003;//delete sToken from DB
integer HTTPDB_EMPTY = 2004;//sent by httpdb script when a sToken has no sValue in the db

integer MENUNAME_REQUEST = 3000;
integer MENUNAME_RESPONSE = 3001;
integer SUBMENU = 3002;
integer MENUNAME_REMOVE = 3003;

integer RLV_CMD = 6000;
integer RLV_REFRESH = 6001;//RLV plugins should reinstate their g_lRestrictions upon receiving this message.
integer RLV_CLEAR = 6002;//RLV plugins should clear their resStriction lists upon receiving this message.

integer RLV_OFF = 6100; // send to inform plugins that RLV is disabled now, no sMessage or key needed
integer RLV_ON = 6101; // send to inform plugins that RLV is enabled now, no sMessage or key needed

integer ANIM_START = 7000;//send this with the sName of an sAnim in the string part of the sMessage to play the sAnim
integer ANIM_STOP = 7001;//send this with the sName of an sAnim in the string part of the sMessage to stop the sAnim

integer DIALOG = -9000;
integer DIALOG_RESPONSE = -9001;
integer DIALOG_TIMEOUT = -9002;

string UPMENU = "^";

Debug(string sMsg)
{
    //llOwnerSay(llGetScriptName() + ": " + sMsg);
    //llInstantMessage(llGetOwner(), llGetScriptName() + ": " + sMsg);
}

Notify(key kID, string sMsg, integer iAlsoNotifyWearer) {
    if (kID == g_kWearer) {
        llOwnerSay(sMsg);
    } else {
            llInstantMessage(kID,sMsg);
        if (iAlsoNotifyWearer) {
            llOwnerSay(sMsg);
        }
    }
}

key ShortKey()
{//just pick 8 random hex digits and pad the rest with 0.  Good enough for dialog uniqueness.
    string sChars = "0123456789abcdef";
    integer iLength = 16;
    string sOut;
    integer n;
    for (n = 0; n < 8; n++)
    {
        integer iIndex = (integer)llFrand(16);//yes this is correct; an integer cast rounds towards 0.  See the llFrand wiki entry.
        sOut += llGetSubString(sChars, iIndex, iIndex);
    }
     
    return (key)(sOut + "-0000-0000-0000-000000000000");
}

key Dialog(key kRCPT, string sPrompt, list lChoices, list lUtilityButtons, integer iPage)
{
    key kID = ShortKey();
    llMessageLinked(LINK_SET, DIALOG, (string)kRCPT + "|" + sPrompt + "|" + (string)iPage + "|" + llDumpList2String(lChoices, "`") + "|" + llDumpList2String(lUtilityButtons, "`"), kID);
    return kID;
} 

Menu(key kID)
{
    if (!g_iRLVOn)
    {
        Notify(kID, "RLV features are now disabled in this collar. You can enable those in RLV submenu. Opening it now.", FALSE);
        llMessageLinked(LINK_SET, SUBMENU, "RLV", kID);
        return;
    }

    //build sPrompt showing s_Current settings
    //make enable/disable lButtons
    string sPrompt = "Pick an option";
    sPrompt += "\nCurrent Settings: ";
    list lButtons;
    //Debug(llDumpList2String(g_lSettings, ","));
    integer n;
    integer iStop = llGetListLength(g_lRLVcmds);

    //Default to hide emote, chatnormal(forced whisper) and chatshsOut(ability to shsOut).
    //If they are allowed, they will be set to TRUE in the following block
    integer iShowChatNormal  = FALSE;
    integer iShowChatShout   = FALSE;
    integer iShowEmote       = FALSE;
    if (llList2String(g_lSettings, (llListFindList(g_lSettings, ["sendchat"])+1)) == "n"){
        //Debug("hide chatshout and chatnormal");
        iShowEmote = TRUE;
    }
    else {
        //Debug("show chatnormal");
        iShowChatNormal = TRUE;

        if (llList2String(g_lSettings, (llListFindList(g_lSettings, ["chatnormal"])+1)) == "n"){
            //Debug("hide chatshout");
        }
        else {
            //Debug("show chatshout");
            iShowChatShout   = TRUE;
        }
    }
    //

    for (n = 0; n < iStop; n++)
    {
        //Check if s_Current sValue should even be processed
        if (
             (llList2String(g_lRLVcmds, n) == "chatnormal" && !iShowChatNormal)
             ||
             (llList2String(g_lRLVcmds, n) == "chatshout" && !iShowChatShout)
             ||
             (llList2String(g_lRLVcmds, n) == "emote" && !iShowEmote)
           )
        {
            //Debug("skipping: "+llList2String(g_lRLVcmds, n));
        }
        else
        {
            //Process as usual....

            //see if there's a setting for this in the settings list
            string sCmd = llList2String(g_lRLVcmds, n);
            string sPretty = llList2String(g_lPrettyCmds, n);
            string sDesc = llList2String(g_lDescriptions, n);
            integer iIndex = llListFindList(g_lSettings, [sCmd]);

            if (iIndex == -1)
            {
                //if this sCmd not set, then give button to enable
                if (sPretty=="Emote"){
                    //When sendchat='n' then emote defaults to short mode (rem), so you allow long emotes(add)......
                    sPrompt += "\n" + sPretty + " = Short (" + sDesc + ")";
                    lButtons += [TURNON + " " + llList2String(g_lPrettyCmds, n)];
                }
                else
                {
                    sPrompt += "\n" + sPretty + " = Enabled (" + sDesc + ")";
                    lButtons += [TURNOFF + " " + llList2String(g_lPrettyCmds, n)];
                }
                
            }
            else
            {
                //else this sCmd is set, then show in sPrompt, and make button do opposite
                //get sValue of setting
                string sValue1 = llList2String(g_lSettings, iIndex + 1);

                //For some odd reason, the emote sCommand uses add (short;16 char iMax) and rem (no limit)
                if (sValue1 == "y" || (sPretty=="Emote" && sValue1 == "add"))
                {
                    {
                        if (sPretty=="Emote") {
                            sPrompt += "\n" + sPretty + " = Long (" + sDesc + ")";
                        }
                        else {
                            sPrompt += "\n" + sPretty + " = Enabled (" + sDesc + ")";
                        }
                        
                        lButtons += [TURNOFF + " " + llList2String(g_lPrettyCmds, n)];
                    }
                }
                else if (sValue1 == "n" || (sPretty=="Emote" && sValue1 == "rem"))
                {
                    {
                        if (sPretty=="Emote") {
                            sPrompt += "\n" + sPretty + " = Short (" + sDesc + ")";
                        }
                        else {
                            sPrompt += "\n" + sPretty + " = Disabled (" + sDesc + ")";
                        }
                        
                        lButtons += [TURNON + " " + llList2String(g_lPrettyCmds, n)];
                    }
                }
            }
            //end process as usual
        }
    }
    //give an Allow All button
    lButtons += [TURNON + " All"];
    lButtons += [TURNOFF + " All"];
    g_kDialogID = Dialog(kID, sPrompt, lButtons, [UPMENU], 0);
}

UpdateSettings()
{
    //build one big string from the settings list
    //llOwnerSay("TP g_lSettings: " + llDumpList2String(g_lSettings, ","));
    integer iSettingsLength = llGetListLength(g_lSettings);
    if (iSettingsLength > 0)
    {
        list lTempSettings;
        string sOut;
        integer n;
        list lNewList;
        for (n = 0; n < iSettingsLength; n = n + 2)
        {
            string sToken = llList2String(g_lSettings, n);
            string sValue = llList2String(g_lSettings, n + 1);

            if (sToken == "emote")
            {
                if (sValue == "y")
                {
                    sValue = "add";
                }
                else if (sValue == "n")
                {
                    sValue = "rem";
                }
            }

            lNewList += [sToken + "=" + sValue];
            if (sValue!="y")
            {
                lTempSettings+=[sToken,sValue];
            }
        }
        sOut = llDumpList2String(lNewList, ",");
        //sOutput that string to viewer
        llMessageLinked(LINK_THIS, RLV_CMD, sOut, NULL_KEY);
        g_lSettings=lTempSettings;
    }

    //Handle adding exceptions to RLV g_lRestrictions
    integer iExptnLength = llGetListLength(g_lExceptions);
    if (iExptnLength > 0)
    {
        list lExptnList;
        integer n;
        for (n = 0; n < iExptnLength; n = n + 2)
        {
            lExptnList += [llList2String(g_lExceptions, n) + ":" + llList2String(g_lExceptions, n + 1) + "=add"];
        }
        llMessageLinked(LINK_THIS, RLV_CMD, llDumpList2String(lExptnList, ","), NULL_KEY);
    }

    //Handle removing g_lExceptions to RLV g_lRestrictions
    integer iRemLength = llGetListLength(g_lRemExptns);
    if (iRemLength > 0)
    {
        list lRemList;
        integer n;
        for (n = 0; n < iRemLength; n = n + 2)
        {
            lRemList += [llList2String(g_lRemExptns, n) + ":" + llList2String(g_lRemExptns, n + 1) + "=rem"];
        }
        llMessageLinked(LINK_THIS, RLV_CMD, llDumpList2String(lRemList, ","), NULL_KEY);
        g_lRemExptns = [];
    }
}

SaveSettings()
{
    //save to DB
    if (llGetListLength(g_lSettings)>0)
        llMessageLinked(LINK_THIS, HTTPDB_SAVE, g_sDBToken + "=" + llDumpList2String(g_lSettings, ","), NULL_KEY);
    else
        llMessageLinked(LINK_THIS, HTTPDB_DELETE, g_sDBToken, NULL_KEY);
}

ClearSettings()
{
    //clear g_lSettings list
    g_lSettings = [];
    //remove tpsettings from DB
    llMessageLinked(LINK_THIS, HTTPDB_DELETE, g_sDBToken, NULL_KEY);
    //main RLV script will take care of sending @clear to viewer
}

list RestackMenu(list in)
{ //adds empty lButtons until the list iLength is multiple of 3, to iMax of 12
    while (llGetListLength(in) % 3 != 0 && llGetListLength(in) < 12)
    {
        in += [" "];
    }
    //look for ^ and > in the menu
    integer u = llListFindList(in, [UPMENU]);
    if (u != -1)
    {
        in = llDeleteSubList(in, u, u);
    }
    //re-orders a list so dialog lButtons start in the top row
    list sOut = llList2List(in, 9, 11);
    sOut += llList2List(in, 6, 8);
    sOut += llList2List(in, 3, 5);
    sOut += llList2List(in, 0, 2);
    //make sure we move ^ and > to position 1 and 2
    if (u != -1)
    {
        sOut = llListInsertList(sOut, [UPMENU], 1);
    }
    return sOut;
}

default
{
    state_entry()
    {
        g_kWearer = llGetOwner();

        //llSleep(1.0);
        //llMessageLinked(LINK_THIS, MENUNAME_RESPONSE, g_sParentMenu + "|" + g_sSubMenu, NULL_KEY);
        //llMessageLinked(LINK_THIS, HTTPDB_REQUEST, g_sDBToken, NULL_KEY);
    }

    link_message(integer iSender, integer iNum, string sStr, key kID)
    {
        if (iNum == MENUNAME_REQUEST && sStr == g_sParentMenu)
        {
            llMessageLinked(LINK_THIS, MENUNAME_RESPONSE, g_sParentMenu + "|" + g_sSubMenu, NULL_KEY);
        }
        else if (iNum == SUBMENU && sStr == g_sSubMenu)
        {
            Menu(kID);
        }
        /* //no more needed
            else if ((sStr == "reset" || sStr == "runaway") && (iNum == COMMAND_OWNER || iNum == COMMAND_WEARER))
            {
                //clear db, reset script
                llMessageLinked(LINK_THIS, HTTPDB_DELETE, g_sDBToken, NULL_KEY);
                llMessageLinked(LINK_THIS, HTTPDB_DELETE, g_sExToken, NULL_KEY);
                llResetScript();
            }
        */
            else if (iNum >= COMMAND_OWNER && iNum <= COMMAND_WEARER)
            {//added for short chat-menu sCommand
                if (llToLower(sStr) == "talk")
                {
                    Menu(kID);
                    return;
                }
                //do simple pass through for chat sCommands

                //since more than one RLV sCommand can come on the same g_iLine, loop through them
                list lItems = llParseString2List(sStr, [","], []);
                integer n;
                integer iStop = llGetListLength(lItems);
                integer iChange = FALSE;//set this to true if we see a setting that concerns us
                for (n = 0; n < iStop; n++)
                {
                    //split off the parameters (anything after a : or =)
                    //and see if the thing being set concerns us
                    string sThisItem = llList2String(lItems, n);
                    string sBehavior = llList2String(llParseString2List(sThisItem, ["=", ":"], []), 0);
                    if (llListFindList(g_lRLVcmds, [sBehavior]) != -1)
                    {
                        //this is a sBehavior that we handle.

                        //filter sCommands from g_kWearer
                        if (iNum == COMMAND_WEARER)
                        {
                            llOwnerSay("Sorry, but RLV commands may only be given by owner, secowner, or group (if set).");
                            return;
                        }

                        string sOption = llList2String(llParseString2List(sThisItem, ["="], []), 0);
                        string sParam = llList2String(llParseString2List(sThisItem, ["="], []), 1);
                        integer iIndex = llListFindList(g_lSettings, [sOption]);
                        if (iIndex == -1)
                        {
                            //we don't alread have this exact setting.  add it
                            g_lSettings += [sOption, sParam];
                        }
                        else
                        {
                            //we already have a setting for this sOption.  update it.
                            g_lSettings = llListReplaceList(g_lSettings, [sOption, sParam], iIndex, iIndex + 1);
                        }
                        iChange = TRUE;

                        //handle exceptions
                        if (llListFindList(g_lAutoExceptions, [sOption]) != -1)
                        {
                            //this is a setting for which we should automatically create an exception for the person sending the sCommand
                            list lExptn = [sOption, kID];
                            //only add exception if not already in list
                            if (llListFindList(g_lExceptions, lExptn) == -1)
                            {
                                g_lExceptions += lExptn;
                            }
                        }
                    }
                    else if (sBehavior == "clear")
                    {
                        ClearSettings();
                    }
                }

                if (iChange)
                {
                    UpdateSettings();
                    SaveSettings();
                    if (g_iReturnMenu)
                    {
                        Menu(kID);
                    }
                }
            }
        else if (iNum == HTTPDB_RESPONSE)
        {
            //this is tricky since our db sValue contains equals signs
            //split string on both comma and equals sign
            //first see if this is the token we care about
            list lParams = llParseString2List(sStr, ["="], []);
            if (llList2String(lParams, 0) == g_sDBToken)
            {
                //throw away first element
                //everything else is real settings (should be even number)
                g_lSettings = llParseString2List(llList2String(lParams, 1), [","], []);
                UpdateSettings();
            }
        }
        else if (iNum == RLV_REFRESH)
        {
            //rlvmain just started up.  Tell it about our current restrictions
            g_iRLVOn = TRUE;
            UpdateSettings();
        }
        else if (iNum == RLV_CLEAR)
        {
            //clear db and local settings list
            ClearSettings();
        }
        else if (iNum == RLV_OFF)// rlvoff -> we have to turn the menu off too
        {
            g_iRLVOn=FALSE;
        }
        else if (iNum == RLV_ON)// g_iRLVOn -> we have to turn the menu on again
        {
            g_iRLVOn=TRUE;                
        }
        else if (iNum == DIALOG_TIMEOUT)
        {
            if (kID == g_kDialogID)
            {
                g_iReturnMenu = FALSE;
            }
        }
        else if (iNum == DIALOG_RESPONSE)
        {
            if (kID == g_kDialogID)
            {
                list lMenuParams = llParseString2List(sStr, ["|"], []);
                key kAv = (key)llList2String(lMenuParams, 0);          
                string sMessage = llList2String(lMenuParams, 1);                                         
                integer iPage = (integer)llList2String(lMenuParams, 2);                
                if (sMessage == UPMENU)
                {
                    llMessageLinked(LINK_THIS, SUBMENU, g_sParentMenu, kAv);
                    g_iReturnMenu = FALSE;
                }
                else
                {
                    //we got a sCommand to enable or disable something, like "Enable LM"
                    //get the actual sCommand sName by looking up the sPretty sName from the message
                    list lParams = llParseString2List(sMessage, [" "], []);
                    string sSwitch = llList2String(lParams, 0);
                    string sCmd = llList2String(lParams, 1);
                    integer iIndex = llListFindList(g_lPrettyCmds, [sCmd]);
                    if (sCmd == "All")
                    {
                        //handle the "Allow All" and "Forbid All" sCommands
                        string ONOFF;
                        //deckIDe whether we need to sSwitch to "y" or "n"
                        if (sSwitch == TURNOFF)
                        {
                            //enable all functions (ie, remove all g_lRestrictions
                            ONOFF = "n";
                        }
                        else if (sSwitch == TURNON)
                        {
                            ONOFF = "y";
                        }
        
                        //loop through g_lRLVcmds to create list
                        string sOut;
                        integer n;
                        integer iStop = llGetListLength(g_lRLVcmds);
                        for (n = 0; n < iStop; n++)
                        {
                            //prefix all but the first sValue with a comma, so we have a comma-separated list
                            if (n)
                            {
                                sOut += ",";
                            }
                            sOut += llList2String(g_lRLVcmds, n) + "=" + ONOFF;
                        }
                        llMessageLinked(LINK_THIS, COMMAND_NOAUTH, sOut, kAv);
                        g_iReturnMenu = TRUE;
                    }
                    else if (iIndex != -1)
                    {
                        string sOut = llList2String(g_lRLVcmds, iIndex);
                        sOut += "=";
                        if (llList2String(lParams, 0) == TURNON)
                        {
                            sOut += "y";
                        }
                        else if (llList2String(lParams, 0) == TURNOFF)
                        {
                            sOut += "n";
                        }
                        //send rlv sCommand sOut through iNum system as though it were a chat sCommand, just to make sure person who sakID it has proper iNumority
                        llMessageLinked(LINK_THIS, COMMAND_NOAUTH, sOut, kAv);
                        g_iReturnMenu = TRUE;
                    }
                    else
                    {
                        //something went horribly wrong.  We got a sCommand that we can't find in the list
                    }
                }                       
            }     
        }
    }
}