//OpenCollar - rlvrelay - 3.336
//Licensed under the GPLv2, with the additional requirement that these scripts remain "full perms" in Second Life.  See "OpenCollar License" for details.

integer g_iRlvChan = -1812221819;
integer g_iRlvListener;

//MESSAGE MAP
integer COMMAND_NOAUTH = 0;
integer COMMAND_OWNER = 500;
integer COMMAND_SECOWNER = 501;
integer COMMAND_GROUP = 502;
integer COMMAND_WEARER = 503;
integer COMMAND_EVERYONE = 504;
//integer CHAT = 505;//deprecated
//integer COMMAND_OBJECT = 506;
integer COMMAND_RLV_RELAY = 507; // now will be used from rlvrelay to rlvmain, for ping only
integer COMMAND_SAFEWORD = 510;
integer COMMAND_RELAY_SAFEWORD = 511;

integer HTTPDB_SAVE = 2000;//scripts send messages on this channel to have settings saved to httpdb
                            //sStr must be in form of "sToken=sValue"
integer HTTPDB_REQUEST = 2001;//when startup, scripts send requests for settings on this channel
integer HTTPDB_RESPONSE = 2002;//the httpdb script will send responses on this channel

integer MENUNAME_REQUEST = 3000;
integer MENUNAME_RESPONSE = 3001;
integer SUBMENU = 3002;
integer MENUNAME_REMOVE = 3003;

integer RLVR_CMD = 6010; //let's do that for now (note this is not RLV_CMD)
integer RLV_REFRESH = 6001;//RLV plugins should reinstate their g_lRestrictions upon receiving this message.

integer RLV_OFF = 6100; // send to inform plugins that RLV is disabled now, no sMessage or key needed
integer RLV_ON = 6101; // send to inform plugins that RLV is enabled now, no sMessage or key needed

integer DIALOG = -9000;
integer DIALOG_RESPONSE = -9001;
integer DIALOG_TIMEOUT = -9002;

string g_sParentMenu = "RLV";
string g_sSubMenu = "Relay";
integer g_iRemenu = FALSE;
integer g_sMenuUseriNum;

string UPMENU = "^";

string ALL = "*All*";

key g_kWearer;

list chatsCommands=["auto","ask","restricted","off","safeword","safeword on","safeword off","playful on", "playful off","land on","land off","pending","access"];
list prettysCommands=["Auto","Ask","Restricted","Off","Safeword", "( )Safeword", "(*)Safeword","( )Playful","(*)Playful","( )Land","(*)Land","Pending","Access Lists"];
//list prettysCommands=["Auto","Ask","Restricted","Off","Safeword", "☐Safeword", "☒Safeword","☐Playful","☒Playful","☐Land","☒Land","Pending","Access Lists"];

integer RELAY_CHANNEL = -1812221819;
//integer MENU_CHANNEL;
//integer AUTH_MENU_CHANNEL;
//integer LIST_MENU_CHANNEL;
//integer LIST_CHANNEL;
//integer SIT_CHANNEL;

key kMenuID;
key g_kAuthMenuID;
key g_kListMenuID;
key g_kListID;

string PROTOCOL_VERSION = "1100"; //with some additions, but backward compatible, nonetheless
string IMPL_VERSION = "OpenCollar 3.3";
string ORG_VERSIONS = "ORG=0001/who=001";

//settings
integer g_iMode=0;
integer g_iMinMode=0;

integer g_iGarbageRate = 180; //garbage collection rate

list g_lSources=[];
//list users=[];
key g_kLastUser=NULL_KEY;
list g_lTempWhiteList=[];
list g_lTempBlackList=[];
list g_lTempUserWhiteList=[];
list g_lTempUserBlackList=[];
list g_lObjWhiteList=[];
list g_lObjBlackList=[];
list g_lAvWhiteList=[];
list g_lAvBlackList=[];
list g_lObjWhiteListNames=[];
list g_lObjBlackListNames=[];
list g_lAvWhiteListNames=[];
list g_lAvBlackListNames=[];

integer g_iRLV=FALSE;
list g_lQueue=[];
integer QSTRIDES=3;
integer g_iListener=0;
integer g_iAuthPending = FALSE;
string g_sTimerType="";
string g_sListType;
integer MAXLOAD=7;    //prevents stack-heap collisions due to malicious devices

//relay specific sMessage map
integer CMD_ADDSRC = 11;
integer CMD_REMSRC = 12;

string g_sDBToken="relay";

//collar owners, secowners and blacklist caching
string g_sOwnerssToken = "owner";
string g_sSecOwnerssToken = "secowners";
string g_sBlackListsToken = "blacklist";

list g_lCollarOwnersList;
list g_lCollarSecOwnersList;
list g_lCollarBlackList;

//querying g_iMode from g_iMode bitfield
integer ModeOff() {return (g_iMode & 7)==0;}
integer ModeRestricted() {return (g_iMode & 7)==1;}
integer ModeAsk() {return (g_iMode & 7)==2;}
integer ModeAuto() {return (g_iMode & 7)==3;}
integer ModeSafe() {return !(g_iMode & 8);} //notice the negation
integer ModeLand() {return (g_iMode & 16);}
integer ModePlayful() {return (g_iMode & 32);}
string Mode2String(integer g_iMode)
{
    string sOut;
    if ((g_iMode & 7)==0) sOut+="off";
    else if ((g_iMode & 7)==1) sOut+="restricted";
    else if ((g_iMode & 7)==2) sOut+="ask";
    else if ((g_iMode & 7)==3) sOut+="auto";
    if (g_iMode & 8) sOut+=", without safeword";
    else sOut+=", with safeword";
    if (g_iMode & 32) sOut+=", playful";
    else sOut+=", not playful";
    if (g_iMode & 16) sOut+=", landowner trusted.";
    else sOut+=", landowner not trusted.";
    return sOut;
}

integer MaxMode(integer iMode1, integer iMode2)
{
    integer iMainMode;
    if ((iMode1 & 7) < (iMode2 & 7)) iMainMode = iMode2; else iMainMode = iMode1; //come on, where is llMaxInteger()?
    return (iMainMode & 7) |(~7 & (iMode1|iMode2));
}

notify(key kID, string sMsg, integer iAlsoNotifyWearer) {
    if (kID == g_kWearer) {
        llOwnerSay(sMsg);
    } else {
        llInstantMessage(kID,sMsg);
        if (iAlsoNotifyWearer) {
            llOwnerSay(sMsg);
        }
    }    
}

SaveSettings()
{
    string sNewSettings=g_sDBToken+"=minmode:"+(string)g_iMode;
    sNewSettings+=",minmode:"+(string)g_iMinMode;
    if ( llGetListLength(g_lObjWhiteList) > 0 ) sNewSettings+=",objwhitelist:"+llDumpList2String(g_lObjWhiteList,"/");
    if ( llGetListLength(g_lObjBlackList) > 0 ) sNewSettings+=",objblacklist:"+llDumpList2String(g_lObjBlackList,"/");
    if ( llGetListLength(g_lAvWhiteList) > 0 ) sNewSettings+=",avwhitelist:"+llDumpList2String(g_lAvWhiteList,"/");
    if ( llGetListLength(g_lAvBlackList) > 0 ) sNewSettings+=",avblacklist:"+llDumpList2String(g_lAvBlackList,"/");
//    if (g_lObjWhiteListNames) settings+=",objwhitelistnames:"+llDumpList2String(g_lObjWhiteListNames,"/");
//    if (g_lObjBlackListNames) settings+=",objblacklistnames:"+llDumpList2String(g_lObjBlackListNames,"/");
//    if (g_lAvWhiteListNames) settings+=",avwhitelistnames:"+llDumpList2String(g_lAvWhiteListNames,"/");
//    if (g_lAvBlackListNames) settings+=",avblacklistnames:"+llDumpList2String(g_lAvBlackListNames,"/");    
    llMessageLinked(LINK_THIS, HTTPDB_SAVE, sNewSettings, NULL_KEY);
}

UpdateSettings(string sSettings)
{
    list lArgs = llParseString2List(sSettings,[","],[]);
    integer i;
    for (i=0;i<llGetListLength(lArgs);i++)
    {
        list setting=llParseString2List(llList2String(lArgs,i),[":"],[]);
        string var=llList2String(setting,0);
        list vals=llParseString2List(llList2String(setting,1),["/"],[]);
        if (var=="mode") SetMode(llList2Integer(setting,1),g_kWearer);
        if (var=="minmode") SetMinMode(llList2Integer(setting,1),g_kWearer);
//        else if (var=="objwhitelist") g_lObjWhiteList=vals;
//        else if (var=="objblacklist") g_lObjBlackList=vals;
        else if (var=="avwhitelist") g_lAvWhiteList=vals;
        else if (var=="avblacklist") g_lAvBlackList=vals;
//        else if (var=="objwhitelistnames") g_lObjWhiteListNames=vals;
//        else if (var=="objblacklistnames") g_lObjBlackListNames=vals;
        else if (var=="avwhitelistnames") g_lAvWhiteListNames=vals;
        else if (var=="avblacklistnames") g_lAvBlackListNames=vals;
    }
}

integer IsChannelCmd(string sCmd)
{
    return (llSubStringIndex(sCmd,"@version")==0)||(llSubStringIndex(sCmd,"@get")==0)||(llSubStringIndex(sCmd,"@findfolder")==0);
}


integer IsWho(string sCmd)
{
    return llGetSubString(sCmd,0,4)=="!who/"||llGetSubString(sCmd,0,6)=="!x-who/";
}

key GetWho(string sCmd)
{
    integer iIndex=llSubStringIndex(sCmd,"who/")+4;
    if (IsWho(sCmd)) return (key)llGetSubString(sCmd,iIndex,iIndex+35);
    else return NULL_KEY;
}

integer Auth(key object, key user)
{
    integer iAuth=1;
    //object iAuth
    integer iSource_iIndex=llListFindList(g_lSources,[object]);
    if (iSource_iIndex!=-1) {}
    else if (llListFindList(g_lTempBlackList+g_lObjBlackList,[object])!=-1) return -1;
    else if (llListFindList(g_lAvBlackList+g_lCollarBlackList,[llGetOwnerKey(object)])!=-1) return -1;
    else if (ModeAuto()) {}
    else if (ModeLand() && llGetOwnerKey(object)==llGetLandOwnerAt(llGetPos())) {}
    else if (llListFindList(g_lTempWhiteList+g_lObjWhiteList,[object])!=-1) {}
    else if (llListFindList(g_lAvWhiteList+g_lCollarOwnersList+g_lCollarSecOwnersList,[llGetOwnerKey(object)])!=-1) {}
    else if (ModeRestricted()) return -1;
    else iAuth=0;
    //user iAuth
    if (user==NULL_KEY) {}
//    else if (iSource_iIndex!=-1&&user==(key)llList2String(users,iSource_iIndex)) {}
    else if (user==g_kLastUser) {}
    else if (llListFindList(g_lAvBlackList+g_lCollarBlackList+g_lTempUserBlackList,[user])!=-1) return -1;
    else if (ModeAuto()) {}
    else if (llListFindList(g_lAvWhiteList+g_lCollarOwnersList+g_lCollarSecOwnersList+g_lTempUserWhiteList,[user])!=-1) {}
    else if (ModeRestricted()) return -1;
    else return 0;

    return iAuth;
}

//--- g_lQueue and sCommand handling functions section---//
string GetQident(integer i)
{
    return llList2String(g_lQueue,QSTRIDES*i);
}

key GetQObj(integer i)
{
    return (key)llList2String(g_lQueue,QSTRIDES*i+1);
}

string GetQCom(integer i)
{
    return llList2String(g_lQueue,QSTRIDES*i+2);
}

DeleteQItem(integer i)
{
    g_lQueue=llDeleteSubList(g_lQueue,i,i+QSTRIDES-1);
}

integer GetQLength()
{
    return llGetListLength(g_lQueue)/QSTRIDES;
}


Enqueue(string  sMsg, key kID)
{
    list lArgs=llParseString2List(sMsg,[","],[]);
    sMsg = "";  // free up memory in case of large messages
    if (llGetListLength(lArgs)!=3) return;
    if (llList2String(lArgs,1)!=(string)g_kWearer) return;
    string sIdent=llList2String(lArgs,0);
    string sCommand=llToLower(llList2String(lArgs,2));
    lArgs = [];  // free up memory in case of large messages
    integer iNum2=Auth(kID,GetWho(sCommand));
    if (iNum2==1) HandleCommand(sIdent,kID,sCommand,TRUE);
    else if (iNum2!=-1&&GetQLength()<MAXLOAD) //keeps margin for this event + next arriving chat message
    {
        g_lQueue+=[sIdent, kID, sCommand];
        if (!g_iAuthPending) Dequeue();
    }
    else
    {
        llShout(RELAY_CHANNEL,sIdent+","+(string)kID+","+sCommand+",ko");
        llOwnerSay("A device is trying to grab your relay but has been denied because your relay is in ask mode and already has too many pending authorization requests for the limited memory of this script.\nPlease answer the current requests first before looking for trouble again.\nIf no dialog is visible now, say \"<prefix>relay pending\" in chat to make it pop up again.");
    }
}

Dequeue()
{
    string sCommand = "";
    string sCurIdent;
    key kCurID;
    while (sCommand=="")
    {
        if (g_lQueue==[])
        {
            g_sTimerType="expire";
            llSetTimerEvent(5);
            return;
        }
        sCurIdent=GetQident(0);
        kCurID=GetQObj(0);
        sCommand=HandleCommand(sCurIdent,kCurID,GetQCom(0),FALSE);
        DeleteQItem(0);
    }
    g_lQueue=[sCurIdent,kCurID,sCommand]+g_lQueue;
//    llSetTimerEvent(menu_g_iTimeOut);
//    AUTH_MENU_CHANNEL=-9999 - llFloor(llFrand(9999999.0));
    list lButtons=["Yes","No","Trust Object","Ban Object","Trust Owner","Ban Owner"];
    string sOwner=llKey2Name(llGetOwnerKey(kCurID));
    if (sOwner!="") sOwner= ", owned by "+sOwner+",";
    string sPrompt=llKey2Name(kCurID)+sOwner+" wants to control your viewer.";
    if (IsWho(sCommand))
    {
        lButtons+=["Trust User","Ban User"];
        sPrompt+="\n"+llKey2Name(GetWho(sCommand))+" is currently using this device.";
    }
    sPrompt+="\nDo you want to allow this?";
    g_iAuthPending = TRUE;
    g_kAuthMenuID = Dialog(g_kWearer, sPrompt, lButtons, [], 0);
}


//cleans newly iNumed events, while preserving the order of arrival for every device
CleanQueue()
{
    list lOnHold=[];
    integer i=0;
    while (i<GetQLength())
    {
        string sIdent=GetQident(0);
        key kObj=GetQObj(0);
        string sCommand=GetQCom(0);
        key kUser=GetWho(sCommand);
        integer iNum2=Auth(kObj,kUser);
        if(llListFindList(lOnHold,[kObj])!=-1) i++;
        else if(iNum2==1)
        {
          DeleteQItem(i);
          HandleCommand(sIdent,kObj,sCommand,TRUE);
        }
        else if(iNum2==-1)
        {
          DeleteQItem(i);
          list lCommands = llParseString2List(sCommand,["|"],[]);
          integer j;
          for (j=0;j<llGetListLength(lCommands);j++)
          llShout(RELAY_CHANNEL,sIdent+","+(string)kObj+","+llList2String(lCommands,j)+",ko");
        }
        else
        {
            i++;
            lOnHold+=[kObj];
        }
    }
}

string HandleCommand(string sIdent, key kID, string sCom, integer iNum)
{
    list lCommands=llParseString2List(sCom,["|"],[]);
    sCom = llList2String(lCommands, 0);
    integer iIsWho = IsWho(sCom);
    key kWho = GetWho(sCom);
    integer i;
    for (i=0;i<llGetListLength(lCommands);i++)
    {
        sCom = llList2String(lCommands,i);
        list lSubArgs = llParseString2List(sCom,["="],[]);
        string sVal = llList2String(lSubArgs,1);
        string sAck = "ok";
        if (sCom == "!release" || sCom == "@clear") llMessageLinked(LINK_THIS,RLVR_CMD,"clear",kID);
        else if (sCom == "!version") sAck = PROTOCOL_VERSION;
        else if (sCom == "!implversion") sAck = IMPL_VERSION;
        else if (sCom == "!x-orgversions") sAck = ORG_VERSIONS;
        else if (iIsWho) g_kLastUser = kWho;
        else if (llGetSubString(sCom,0,0) == "!") sAck = "ko"; // ko unknown meta-commands
        else if (llGetSubString(sCom,0,0) != "@")
        {
            if (iIsWho) return llList2String(lCommands,0)+"|"+llDumpList2String(llList2List(lCommands,i,-1),"|");
            else return llDumpList2String(llList2List(lCommands,i,-1),"|");
        }//probably an ill-formed command, not answering
        else if (IsChannelCmd(sCom))
        {
            if ((integer)sVal>0) llMessageLinked(LINK_THIS,RLVR_CMD, llGetSubString(sCom,1,-1), kID);
            else sAck="ko";
        }
        else if (ModePlayful()&&llGetSubString(sCom,0,0)=="@"&&sVal!="n"&&sVal!="add")
            llMessageLinked(LINK_THIS,RLVR_CMD, llGetSubString(sCom,1,-1), kID);
        else if (!iNum)
        {
            if (iIsWho) return llList2String(lCommands,0)+"|"+llDumpList2String(llList2List(lCommands,i,-1),"|");
            else return llDumpList2String(llList2List(lCommands,i,-1),"|");
        }
        else if (llGetListLength(lSubArgs)==2)
        {
            string sBehav=llGetSubString(llList2String(lSubArgs,0),1,-1);
            if (sVal=="force"||sVal=="n"||sVal=="add"||sVal=="y"||sVal=="rem"||sBehav=="clear")
            {
                llMessageLinked(LINK_THIS,RLVR_CMD,sBehav+"="+sVal,kID);
            }
            else sAck="ko";
        }
        else
        {
            if (iIsWho) return llList2String(lCommands,0)+"|"+llDumpList2String(llList2List(lCommands,i,-1),"|");
            else return llDumpList2String(llList2List(lCommands,i,-1),"|");
        }//probably an ill-formed command, not answering
        llShout(RELAY_CHANNEL,sIdent+","+(string)kID+","+sCom+","+sAck);
    }
    return "";
}

Debug(string sMsg)
{
    llInstantMessage(g_kWearer,sMsg);
}

SafeWord()
{
    if (ModeSafe())
    {
        llMessageLinked(LINK_THIS, COMMAND_RELAY_SAFEWORD, "","");
        notify(g_kWearer, "You have safeworded",TRUE);
        g_lTempBlackList=[];
        g_lTempWhiteList=[];
        g_lTempUserBlackList=[];
        g_lTempUserWhiteList=[];
        integer i;
        for (i=0;i<llGetListLength(g_lSources);i++)
        {
            llShout(RELAY_CHANNEL,"release,"+llList2String(g_lSources,i)+",!release,ok");
        }
        g_lSources=[];
        g_sTimerType="safeword";
        refreshRlvListener();
        llSetTimerEvent(5.);
    }
    else
    {
        notify(g_kWearer, "Sorry, safewording is disabled now!", TRUE);
    }
}

//----Menu functions section---//
Menu(key kID)
{
//    g_sTimerType="menu";
//    llSetTimerEvent(menu_g_iTimeOut);
    string sPrompt="";        
    list lButtons=[];
    integer modebackup=g_iMode; //stupkID hack....
    if (kID==g_kWearer) sPrompt+="\nCurrent mode is: " + Mode2String(g_iMode);
    else
    {
        sPrompt+="\nCurrent minimal authorized mode is: " + Mode2String(g_iMinMode);
        g_iMode = g_iMinMode; //stupkID hack
    }
    if (!ModeAuto()) lButtons+=["Auto"];
    if (!ModeAsk()&&kID==g_kWearer) lButtons+=["Ask"];
    if (!ModeRestricted()) lButtons+=["Restricted"];
    if (g_lSources!=[])
    {
        sPrompt+="\nCurrently grabbed by "+(string)llGetListLength(g_lSources)+" object";
        if (llGetListLength(g_lSources)==1) sPrompt+=".";
        else sPrompt+="s.";
        lButtons+=["Grabbed by"];
        if (ModeSafe()) lButtons+=["Safeword"];
    }
    else
    {
        if (!ModeOff()) lButtons+=["Off"];
        if (ModeSafe()) lButtons+=["(*)Safeword"];
        else lButtons+=["( )Safeword"];
    }
    if (ModePlayful()) lButtons+=["(*)Playful"];
    else lButtons+=["( )Playful"];
    if (ModeLand()) lButtons+=["(*)Land"];
    else lButtons+=["( )Land"];
    if (g_lQueue!=[])
    {
        sPrompt+="\nYou have pending requests.";
        lButtons+=["Pending"];
    }
    lButtons+=["Access Lists"];
    lButtons+=["Help"];
//    lButtons+=[UPMENU];
//    lButtons = RestackMenu(buttons);
    sPrompt+="\n\nMake a choice:";
//    llDialog(kID,sPrompt,buttons,MENU_CHANNEL);
//    g_iListener=llListen(MENU_CHANNEL,"",kID,"");
    g_iMode=modebackup;//end of stupkID hack
    kMenuID = Dialog(kID, sPrompt, lButtons, [UPMENU], 0);
}

ListsMenu(key kID)
{
    string sPrompt="What list do you want to remove items from?";
    list lButtons=["Trusted Object","Banned Object","Trusted Avatar","Banned Avatar",UPMENU];
//    lButtons = RestackMenu(buttons);
    sPrompt+="\n\nMake a choice:";
//    llDialog(kID,sPrompt,buttons,LIST_MENU_CHANNEL);
//    g_iListener=llListen(LIST_MENU_CHANNEL,"",kID,"");   
    g_kListMenuID = Dialog(kID, sPrompt, lButtons, [], 0);
}

PListsMenu(key kID, string sMsg)
{
    list lOList;
    list lOListNames;
    string sPrompt;
    if (sMsg==UPMENU)
    {
        Menu(kID);
        return;
    }
    else if (sMsg=="Trusted Object")
    {
        lOList=g_lObjWhiteList;
        lOListNames=g_lObjWhiteListNames;
        sPrompt="What object do you want to stop trusting?";
        if (llGetListLength(lOListNames)==0) sPrompt+="\n\nNo object in list.";
        else  sPrompt+="\n\nObserve chat for the list.";
    }
    else if (sMsg=="Banned Object")
    {
        lOList=g_lObjBlackList;
        lOListNames=g_lObjBlackListNames;
        sPrompt="What object do you want not to ban anymore?";
        if (llGetListLength(lOListNames)==0) sPrompt+="\n\nNo object in list.";
        else sPrompt+="\n\nObserve chat for the list.";
    }
    else if (sMsg=="Trusted Avatar")
    {
        lOList=g_lAvWhiteList;
        lOListNames=g_lAvWhiteListNames;
        sPrompt="What avatar do you want to stop trusting?";
        if (llGetListLength(lOListNames)==0) sPrompt+="\n\nNo kAvatar in list.";
        else sPrompt+="\n\nObserve chat for the list.";
    }
    else if (sMsg=="Banned Avatar")
    {
        lOList=g_lAvBlackList;
        lOListNames=g_lAvBlackListNames;
        sPrompt="What avatar do you want not to ban anymore?";
        if (llGetListLength(lOListNames)==0) sPrompt+="\n\nNo avatar in list.";
        else sPrompt+="\n\nObserve chat for the list.";
    }
    else return;
    g_sListType=sMsg;

    list lButtons=[ALL];
//    lButtons+=[UPMENU];
    integer i;
    for (i=0;i<llGetListLength(lOList);i++)
    {
        lButtons+=(string)(i+1);
        llInstantMessage(kID, (string)(i+1)+": "+llList2String(lOListNames,i)+", "+llList2String(lOList,i));
    }
//    lButtons = RestackMenu(buttons);
    sPrompt+="\n\nMake a choice:";
//    g_iListener=llListen(LIST_CHANNEL,"",kID,"");    
//    llDialog(kID,sPrompt,buttons,LIST_CHANNEL);
    g_kListID = Dialog(kID, sPrompt, lButtons, [UPMENU], 0);
}

key ShortKey()
{//just pick 8 random hex digits and pad the rest with 0.  Good enough for dialog uniqueness.
    string sChars = "0123456789abcdef";
    integer iLength = 16;
    string sOut;
    integer n;
    for (n = 0; n < 8; n++)
    {
        integer iIndex = (integer)llFrand(16);//yes this is correct; an integer cast rounds towards 0.  See the llFrand wiki entry.
        sOut += llGetSubString(sChars, iIndex, iIndex);
    }
     
    return (key)(sOut + "-0000-0000-0000-000000000000");
}

key Dialog(key kRCPT, string sPrompt, list lChoices, list lUtilityButtons, integer iPage)
{
    key kID = ShortKey();
    llMessageLinked(LINK_SET, DIALOG, (string)kRCPT + "|" + sPrompt + "|" + (string)iPage + "|" + llDumpList2String(lChoices, "`") + "|" + llDumpList2String(lUtilityButtons, "`"), kID);
    return kID;
} 

RemListItem(string sMsg)
{
    
    integer i=((integer) sMsg) -1;
    if (g_sListType=="Banned Avatar")
    {
        if (sMsg==ALL) {g_lAvBlackList=[];g_lAvBlackListNames=[];return;}
        if  (i<llGetListLength(g_lAvBlackList))
        { 
            g_lAvBlackList=llDeleteSubList(g_lAvBlackList,i,i);
            g_lAvBlackListNames=llDeleteSubList(g_lAvBlackListNames,i,i);
        }
    }    
    else if (g_sListType=="Banned Object")
    {
        if (sMsg==ALL) {g_lObjBlackList=[];g_lObjBlackListNames=[];return;}
        if  (i<llGetListLength(g_lObjBlackList))
        {
            g_lObjBlackList=llDeleteSubList(g_lObjBlackList,i,i);
            g_lObjBlackListNames=llDeleteSubList(g_lObjBlackListNames,i,i);
        }
    }
    else if (g_sMenuUseriNum==COMMAND_WEARER && (g_iMinMode & 7) > 0)
    {
        notify(g_kWearer,"Sorry, your owner does not allow you do remove trusted sources.",TRUE);
    }
    else if (g_sListType=="Trusted Object")
    {
        if (sMsg==ALL) {g_lObjWhiteList=[];g_lObjWhiteListNames=[];return;}
        if  (i<llGetListLength(g_lObjWhiteList))
        {
            g_lObjWhiteList=llDeleteSubList(g_lObjWhiteList,i,i);
            g_lObjWhiteListNames=llDeleteSubList(g_lObjWhiteListNames,i,i);
        }
    }
    else if (g_sListType=="Trusted Avatar")
    {
        if (sMsg==ALL) {g_lAvWhiteList=[];g_lAvWhiteListNames=[];return;}
        if  (i<llGetListLength(g_lAvWhiteList)) 
        { 
            g_lAvWhiteList=llDeleteSubList(g_lAvWhiteList,i,i);
            g_lAvWhiteListNames=llDeleteSubList(g_lAvWhiteListNames,i,i);
        }
    }
}

integer SetMinMode(integer iNewMinMode, key kID)
{
    if (g_iMinMode == iNewMinMode) return FALSE;
    g_iMinMode = iNewMinMode;
    //do we really want that all the time??
    //notify(kID, "Relay minimal authorized mode is now: "+Mode2String(g_iMinMode),TRUE);
    integer iMaxMode2 = MaxMode(g_iMode,g_iMinMode);
    if (iMaxMode2 != g_iMode) SetMode(iMaxMode2, kID);
    return TRUE;
}

integer SetMode(integer iNewMode, key kID)
{
    if (g_lSources!=[] && (iNewMode & 8))
    {
        notify(kID, "Nice try. Unfortunately, it is too late to change that now!", TRUE);
        return FALSE ;
    }
    integer iMaxMode2=MaxMode(iNewMode, g_iMinMode);
//    llOwnerSay(Mode2String(g_iMinMode));
//    llOwnerSay(Mode2String(g_iMode));
//    llOwnerSay(Mode2String(iNewMode));
//    llOwnerSay(Mode2String(iMaxmode));
    if (iNewMode != iMaxMode2)
    {
        notify(kID, "Sorry, your owner forbids you to change this settings now.", TRUE);
        return FALSE;
    }
    if (g_iMode == iNewMode) return FALSE;
    g_iMode = iNewMode;
    refreshRlvListener();
    return TRUE;
}

refreshRlvListener()
{
    llListenRemove(g_iRlvListener);
    if (g_iRLV && !ModeOff() && g_sTimerType != "safeword")
        g_iRlvListener = llListen(g_iRlvChan, "", NULL_KEY, "");
}

default
{
    state_entry()
    {
        g_kWearer = llGetOwner();
        g_lSources=[];
        llSetTimerEvent(g_iGarbageRate); //start garbage collection timer
    }
    
    link_message(integer iSender_iNum, integer iNum, string sStr, key kID )
    {
        if (iNum == MENUNAME_REQUEST && sStr == g_sParentMenu)
        {
            llMessageLinked(LINK_THIS, MENUNAME_RESPONSE, g_sParentMenu + "|" + g_sSubMenu, NULL_KEY);
        }
        else if (iNum == SUBMENU && sStr == g_sSubMenu)
        {
            //give menu
            Menu(kID);
        }
        else if (iNum==CMD_ADDSRC)
        {
            g_lSources+=[kID];
//            kUsers+=[g_kLastUser];
        }
        else if (iNum==CMD_REMSRC)
        {
            integer i= llListFindList(g_lSources,[kID]);
            if (i!=-1)
            {
                g_lSources=llDeleteSubList(g_lSources,i,i);
//                kUsers=llDeleteSubList(kUsers,i,i);
            }
        }
// rlvoff -> we have to turn the relay off too
        else if (iNum>=COMMAND_OWNER && iNum<=COMMAND_WEARER && sStr=="rlvoff")
        {
            g_iRLV=FALSE;
            refreshRlvListener();
        }
// collar commands
        else if ((iNum>=COMMAND_OWNER&&iNum<=COMMAND_WEARER)&&llSubStringIndex(sStr,"relay")==0)
        {
            if (sStr=="relay") 
            {
                if (g_iRLV)
                {
                    g_sMenuUseriNum=iNum;
                    Menu(kID);
                    return;
                }
                else
                {
                    notify(kID, "RLV features are now disabled in this collar. You can enable those in RLV submenu. Opening it now.", FALSE);
                    llMessageLinked(LINK_SET, SUBMENU, "RLV", kID);
                    return;
                }
            }
            if (iNum==COMMAND_OWNER||kID==g_kWearer)
            {
                sStr=llGetSubString(sStr,6,-1);
                if (sStr=="safeword") SafeWord();
                else if (sStr=="pending")
                {
                    if (g_lQueue) Dequeue();
                    else llOwnerSay("No pending relay request for now.");
                }
                else if (sStr=="access")
                {
                    if(!g_iRLV)
                    {
                        notify(kID, "RLV features are now disabled in this collar. You can enable those in RLV submenu. Opening it now.", FALSE);
                        llMessageLinked(LINK_SET, SUBMENU, "RLV", kID);
                        return;
                    }
                    ListsMenu(kID);
                }
                else
                {
                    integer iNewMode;
                    if (kID==g_kWearer) iNewMode = g_iMode;
                    else iNewMode = g_iMinMode;
                    string modetype=llList2String(llParseString2List(sStr, [" "], []),0);
                    string modeiChange=llList2String(llParseString2List(sStr, [" "], []),1);
                    if (modetype=="off") iNewMode = iNewMode & ~7;
                    else if (modetype=="restricted") iNewMode = (iNewMode & ~7) | 1;
                    else if (modetype=="ask") iNewMode = (iNewMode & ~7) | (2 - (integer)(g_kWearer!=kID));
                    else if (modetype=="auto") iNewMode = (iNewMode & ~7) | 3;
                    else if (modetype=="safeword") iNewMode = (iNewMode & ~8) | 8*(integer)(modeiChange=="off");
                    else if (modetype=="land") iNewMode = (iNewMode & ~16) | 16*(integer)(modeiChange=="on");
                    else if (modetype=="playful") iNewMode = (iNewMode & ~32) | 32*(integer)(modeiChange=="on");
                    if (kID==g_kWearer)
                    {
                        if (iNum==COMMAND_OWNER) g_iMinMode=0;
                        if (SetMode(iNewMode, kID)) SaveSettings();
                    }
                    else if (SetMinMode(iNewMode,kID)) SaveSettings();
                }
            }
            else llInstantMessage(kID, "Sorry, only the wearer of the collar or their owner can change the relay options.");
            if (g_iRemenu) {g_iRemenu=FALSE; Menu(kID);}
        }
        else if (iNum == HTTPDB_RESPONSE)
        {   //this is tricky since our db sValue contains equals signs
            //split string on both comma and equals sign            
            //first see if this is the sToken we care absOut
            list lParams = llParseString2List(sStr, ["="], []);
            string iToken = llList2String(lParams, 0);
            if (iToken == g_sDBToken)
            {
                //throw away first element
                //everything else is real settings (should be even iNumber)
                UpdateSettings(llList2String(lParams, 1));
            }
            else if (iToken == g_sOwnerssToken)
            {
                g_lCollarOwnersList = llParseString2List(llList2String(lParams, 1), [","], []);
            }
            else if (iToken == g_sSecOwnerssToken)
            {
                g_lCollarSecOwnersList = llParseString2List(llList2String(lParams, 1), [","], []);
            }
            else if (iToken == g_sBlackListsToken)
            {
                g_lCollarBlackList = llParseString2List(llList2String(lParams, 1), [","], []);
            }            
        }
        else if (iNum == HTTPDB_SAVE)
        {   //this is tricky since our db sValue contains equals signs
            //split string on both comma and equals sign            
            //first see if this is the sToken we care absOut
            list lParams = llParseString2List(sStr, ["="], []);
            string iToken = llList2String(lParams, 0);
            if (iToken == g_sOwnerssToken)
            {
                g_lCollarOwnersList = llParseString2List(llList2String(lParams, 1), [","], []);
            }
            else if (iToken == g_sSecOwnerssToken)
            {
                g_lCollarSecOwnersList = llParseString2List(llList2String(lParams, 1), [","], []);
            }
            else if (iToken == g_sBlackListsToken)
            {
                g_lCollarBlackList = llParseString2List(llList2String(lParams, 1), [","], []);
            }            
        }
        // rlvoff -> we have to turn the menu off too
        else if (iNum == RLV_OFF)
        {
            g_iRLV=FALSE;
            refreshRlvListener();
        }
        // g_iRLVOn -> we have to turn the menu on again
        else if (iNum == RLV_ON)
        {
            g_iRLV=TRUE;
            refreshRlvListener();
        }
        else if (iNum==RLV_REFRESH)
        {
            g_iRLV=TRUE;
            refreshRlvListener();
        }
        else if (iNum == DIALOG_RESPONSE)
        {
            if (llListFindList([kMenuID, g_kListMenuID, g_kListID, g_kAuthMenuID], [kID]) != -1)
            {
                list lMenuParams = llParseString2List(sStr, ["|"], []);
                key kAv = (key)llList2String(lMenuParams, 0);          
                string sMsg = llList2String(lMenuParams, 1);                                         
                integer iPage = (integer)llList2String(lMenuParams, 2);   
                if (kID==kMenuID)
                {
                    llSetTimerEvent(g_iGarbageRate);
                    integer iIndex=llListFindList(prettysCommands,[sMsg]);
                    if (iIndex!=-1)
                    {
                        llMessageLinked(LINK_THIS,COMMAND_NOAUTH,"relay "+llList2String(chatsCommands,iIndex),kAv);
                        if (sMsg!="Access Lists") g_iRemenu=TRUE;
                    }
                    else if (sMsg=="Grabbed by")
                    {
                        llMessageLinked(LINK_THIS, COMMAND_NOAUTH,"showrestrictions",kAv);
                        g_iRemenu=TRUE;
                    }
                    else if (sMsg=="Help")
                    {
                        llGiveInventory(kAv,"OpenCollar - rlvrelay - Help");
                        Menu(kAv);
                    }
                    else if (sMsg==UPMENU)
                    {
                        llMessageLinked(LINK_THIS,SUBMENU,g_sParentMenu,kAv);
                    }
                }
                else if (kID==g_kListMenuID)
                {
                    llSetTimerEvent(g_iGarbageRate);
                    PListsMenu(kAv,sMsg);
                }
                else if (kID==g_kListID)
                {
                    llSetTimerEvent(g_iGarbageRate);
                    if (sMsg==UPMENU)
                    {
                        ListsMenu(kAv);
                    }
                    else 
                    {
                        RemListItem(sMsg);
                        ListsMenu(kAv);
                    }
                }
                else if (kID==g_kAuthMenuID)
                {
                    llSetTimerEvent(g_iGarbageRate);
                    g_iAuthPending = FALSE;
                    key kCurID=GetQObj(0);
                    key user=GetWho(GetQCom(0));
                    if (sMsg=="Yes")
                    {
                        g_lTempWhiteList+=[kCurID];
                        if (user) g_lTempUserWhiteList+=[user];
                    }
                    else if (sMsg=="No")
                    {
                        g_lTempBlackList+=[kCurID];
                        if (user) g_lTempUserBlackList+=[user];
                    }
                    else if (sMsg=="Trust Object")
                    {
                        g_lObjWhiteList+=[kCurID];
                        g_lObjWhiteListNames+=[llKey2Name(kCurID)];
                    }
                    else if (sMsg=="Ban Object")
                    {
                        g_lObjBlackList+=[kCurID];
                        g_lObjBlackListNames+=[llKey2Name(kCurID)];
                    }
                    else if (sMsg=="Trust Owner")
                    {
                        g_lAvWhiteList+=[llGetOwnerKey(kCurID)];
                        g_lAvWhiteListNames+=[llKey2Name(llGetOwnerKey(kCurID))];
                    }
                    else if (sMsg=="Ban Owner")
                    {
                        g_lAvBlackList+=[llGetOwnerKey(kCurID)];
                        g_lAvBlackListNames+=[llKey2Name(llGetOwnerKey(kCurID))];
                    }
                    else if (sMsg=="Trust User")
                    {
                        g_lAvWhiteList+=[user];
                        g_lAvWhiteListNames+=[llKey2Name(user)];
                    }
                    else if (sMsg=="Ban User")
                    {
                        g_lAvBlackList+=[user];
                        g_lAvBlackListNames+=[llKey2Name(user)];
                    }
                    CleanQueue();
                    Dequeue();
                }                             
            }
        }
        else if (iNum == DIALOG_TIMEOUT)
        {
            if (kID == g_kAuthMenuID)
            {
                g_iAuthPending = FALSE;
                llOwnerSay("Relay authorization dialog expired. You can make it appear again with command \"<prefix>relay pending\".");
            }
        }
    }    

    listen(integer iChan, string who, key kID, string sMsg)
    {
        if (llGetSubString(sMsg,-43,-1)==","+(string)g_kWearer+",!pong") //sloppy matching the protocol document is stricter, but some in-world devices do not respect it
        {
            llMessageLinked(LINK_THIS, COMMAND_RLV_RELAY, sMsg, kID);
            // send the ping to rlvmain to manage restrictions of this old source
        }
        else
        { //in other cases we analyze the command here
            Enqueue(sMsg,kID);
        }
    }

    on_rez(integer iNum)
    {
        llResetScript();
    }

    timer()
    {
        if (g_sTimerType=="safeword")
        {
            g_sTimerType="";
            refreshRlvListener();
        }
        //garbage collection
        vector vMyPos = llGetRootPosition();
        integer i;
        for (i=0;i<llGetListLength(g_lSources);i++)
        {
            key kID = (key) llList2String(g_lSources,i);
            list lTemp = llGetObjectDetails(kID, ([OBJECT_POS]));
            vector vObjPos = llList2Vector(lTemp,0);
            if (vObjPos == <0, 0, 0> || llVecDist(vObjPos, vMyPos) > 100) // 100: iMax shsOut distance
            llMessageLinked(LINK_THIS,RLVR_CMD,"clear",kID);
        }
        llSetTimerEvent(g_iGarbageRate);
        g_sTimerType="";
        g_lTempBlackList=[];
        g_lTempWhiteList=[];
        g_lTempUserBlackList=[];
        g_lTempUserWhiteList=[];
    }
}