// Francis was here

// Constants
integer linkChannel       = 598242;
string  linkStringRequest = "KISS_TARGET_=^..^=REQUEST";
string  linkStringStart   = "KISS_TARGET_=^..^=START";
string  linkStringAnim    = "KISS_TARGET_=^..^=ANIM";
string  linkStringReset   = "KISS_TARGET_=^..^=RESET";
string  animName          = "long-kiss-femanine";
integer animTime          = 15;

// Not Constants
vector   avPos = ZERO_VECTOR;
key      avKey = NULL_KEY;
rotation avRot = ZERO_ROTATION;

default
{
    state_entry() {
    }
    
    on_rez( integer startcode ) {
        llResetScript();
    }
    
    attach( key k ) {
        llResetScript();            
    }
    
    run_time_permissions(integer parm) {
        if( parm == PERMISSION_TRIGGER_ANIMATION ) {
            llMessageLinked( LINK_SET, linkChannel, linkStringStart, NULL_KEY );
        }
        else {
            string avName = llKey2Name( avKey );
            avName = llList2String( llParseString2List( avName, [" "], [] ), 0 );
            llInstantMessage( llGetOwner(), avName + " has declined your kiss." );
        }
    }

    link_message( integer sender, integer i, string s, key k ) {
        if ( i == linkChannel ) {
            if ( s == linkStringAnim ) {
                llStartAnimation( animName );
                llSleep(animTime);
                llStopAnimation( animName );
                llResetScript();
            }
            else if ( s == linkStringRequest ) {
                string owner;
                owner = llKey2Name( llGetOwner() );
                owner = llList2String( llParseString2List( owner, [" "], [] ), 0 );
                llRequestPermissions( k ,PERMISSION_TRIGGER_ANIMATION );
                llInstantMessage( k, owner + " would like give you a kiss. Say [Yes] to accept." );
                llSetTimerEvent( 60 );
                avKey = k;
            }
            else if ( s == linkStringReset ) {
                llResetScript();
            }
        }
    }

    timer() {
        llResetScript();
    }
} 