//OpenCollar - lock - 3.381
//Licensed under the GPLv2, with the additional requirement that these scripts remain "full perms" in Second Life.  See "OpenCollar License" for details.
list g_lOwners;

string g_sParentMenu = "Main";

string g_sRequestType; //may be "owner" or "secowner" or "rem secowner"
key g_kHTTPID;

integer g_iListenChan = 802930;//just something i randomly chose
integer g_iListener;

integer g_iLocked = FALSE;

string g_sLockPrimName="Lock"; // Description for lock elements to recognize them //EB
list g_lLockElements; //to store the locks prim to hide or show //EB

string LOCK = "*Lock*";
string UNLOCK = "*Unlock*";

//MESSAGE MAP
integer COMMAND_NOAUTH = 0;
integer COMMAND_OWNER = 500;
integer COMMAND_SECOWNER = 501;
integer COMMAND_GROUP = 502;
integer COMMAND_WEARER = 503;
integer COMMAND_EVERYONE = 504;
//integer CHAT = 505;//deprecated
integer COMMAND_OBJECT = 506;
integer COMMAND_RLV_RELAY = 507;
integer COMMAND_SAFEWORD = 510;  // new for g_sSafeWord

//integer SEND_IM = 1000; deprecated.  each script should send its own IMs now.  This is to reduce even the tiny bt of lag caused by hkAving IM slkAve scripts
integer POPUP_HELP = 1001;

integer HTTPDB_SAVE = 2000;//scripts send messages on this channel to have settings saved to httpdb
                            //sStr must be in form of "sToken=sValue"
integer HTTPDB_REQUEST = 2001;//when startup, scripts send requests for settings on this channel
integer HTTPDB_RESPONSE = 2002;//the httpdb script will send responses on this channel
integer HTTPDB_DELETE = 2003;//delete sToken from DB
integer HTTPDB_EMPTY = 2004;//sent by httpdb script when a sToken has no sValue in the db

integer LOCALSETTING_SAVE = 2500;
integer LOCALSETTING_REQUEST = 2501;
integer LOCALSETTING_RESPONSE = 2502;
integer LOCALSETTING_DELETE = 2503;
integer LOCALSETTING_EMPTY = 2504;

integer MENUNAME_REQUEST = 3000;
integer MENUNAME_RESPONSE = 3001;
integer SUBMENU = 3002;
integer MENUNAME_REMOVE = 3003;

integer RLV_CMD = 6000;
integer RLV_REFRESH = 6001;//RLV plugins should reinstate their g_lRestrictions upon receiving this message.
integer RLV_CLEAR = 6002;//RLV plugins should clear their resStriction lists upon receiving this message.

integer g_iRemenu=FALSE;

key g_kWearer;

Notify(key kID, string sMsg, integer iAlsoNotifyWearer) 
{
    if (kID == g_kWearer) 
    {
        llOwnerSay(sMsg);
    } 
    else 
    {
        llInstantMessage(kID,sMsg);
        if (iAlsoNotifyWearer) 
        {
            llOwnerSay(sMsg);
        }
    }    
}

NotifyOwners(string sMsg)
{
    integer n;
    integer stop = llGetListLength(g_lOwners);
    for (n = 0; n < stop; n += 2)
    {
        Notify((key)llList2String(g_lOwners, n), sMsg, FALSE);
    }
}

BuildLockElementList()//EB
{
    integer n;
    integer iLinkCount = llGetNumberOfPrims();
    list lParams;

    // clear list just in case
    g_lLockElements = [];

    //root prim is 1, so start at 2
    for (n = 2; n <= iLinkCount; n++)
    {
        // read description
        lParams=llParseString2List((string)llGetObjectDetails(llGetLinkKey(n), [OBJECT_DESC]), ["~"], []);
        // check inf name is lock name
        if (llList2String(lParams, 0)==g_sLockPrimName)
        {
            // if so store the number of the prim
            g_lLockElements += [n];
             //Debug("added " + (string)n + " to elements");
        }
    }
}

SetLockElementAlpha(float fAlpha) //EB
{
    //loop through stored links, setting alpha if element type is lock
    integer n;
    integer iLinkElements = llGetListLength(g_lLockElements);
    for (n = 0; n < iLinkElements; n++)
    {
        llSetLinkAlpha(llList2Integer(g_lLockElements,n), fAlpha, ALL_SIDES);
    }
}

Lock()
{
    g_iLocked = TRUE;
    llMessageLinked(LINK_SET, HTTPDB_SAVE, "locked=1", NULL_KEY);   
    llMessageLinked(LINK_THIS, RLV_CMD, "detach=n", NULL_KEY);                
    llMessageLinked(LINK_THIS, MENUNAME_RESPONSE, g_sParentMenu + "|" + UNLOCK, NULL_KEY);                
    llPlaySound("abdb1eaa-6160-b056-96d8-94f548a14dda", 1.0);
    llMessageLinked(LINK_THIS, MENUNAME_REMOVE, g_sParentMenu + "|" + LOCK, NULL_KEY);
    SetLockElementAlpha(1.0);//EB
}

Unlock()
{
    g_iLocked = FALSE;
    llMessageLinked(LINK_SET, HTTPDB_DELETE, "locked", NULL_KEY); 
    llMessageLinked(LINK_THIS, RLV_CMD, "detach=y", NULL_KEY);    
    llMessageLinked(LINK_THIS, MENUNAME_RESPONSE, g_sParentMenu + "|" + LOCK, NULL_KEY);                  
    llPlaySound("ee94315e-f69b-c753-629c-97bd865b7094", 1.0);
    llMessageLinked(LINK_THIS, MENUNAME_REMOVE, g_sParentMenu + "|" + UNLOCK, NULL_KEY);   
    SetLockElementAlpha(0.0); //EB  
}



default
{
    state_entry()
    {   //until set otherwise, g_kWearer is owner
        g_kWearer = llGetOwner();
//        g_lOwnersName = llKey2Name(llGetOwner());   //NEVER used
        g_iListenChan = -1 - llRound(llFrand(9999999.0));
        /* //no more needed
        llSleep(1.0);//giving time for others to reset before populating menu      
        llMessageLinked(LINK_THIS, MENUNAME_RESPONSE, g_sParentMenu + "|" + LOCK, NULL_KEY);
        */
        BuildLockElementList();//EB     
    }

    link_message(integer iSender, integer iNum, string sStr, key kID)
    {
        if (sStr == "settings" && iNum >= COMMAND_OWNER && iNum <=COMMAND_WEARER)
        {
            if (g_iLocked) Notify(kID, "Locked.", FALSE);                   
            else Notify(kID, "Unlocked.", FALSE);                                    
        }                                                      
        else if ((sStr == "lock" || sStr == "unlock") && iNum >= COMMAND_OWNER && iNum <=COMMAND_WEARER)
        { 
            if (sStr == "lock"){
                if (iNum == COMMAND_OWNER || kID == g_kWearer )
                {   //primary g_lOwners and g_kWearer can lock and unlock. no one else
                    Lock();
        //            owner = kID; //need to store the one who locked (who has to be also owner) here
                    Notify(kID, "Locked.", FALSE);                    
                    if (kID!=g_kWearer) llOwnerSay("Your collar has been locked.");  
                }
                else 
                {                    
                    Notify(kID, "Sorry, only primary owners and wearer can lock the collar.", FALSE);
                    
                }
            }
            else if (sStr == "unlock")
            { 
                if (iNum == COMMAND_OWNER)
                {  //primary g_lOwners can lock and unlock. no one else
                    Unlock();                             
                    Notify(kID, "Unlocked.", FALSE);                              
                    if (kID!=g_kWearer) llOwnerSay("Your collar has been unlocked.");  
                }
                else
                {
                    Notify(kID, "Sorry, only primary owners can unlock the collar.", FALSE);
                }                          
            }
            if (g_iRemenu) {g_iRemenu=FALSE; llMessageLinked(LINK_THIS, SUBMENU, g_sParentMenu, kID);}
        }

        else if (iNum == HTTPDB_RESPONSE)
        {
            list lParams = llParseString2List(sStr, ["="], []);
            string sToken = llList2String(lParams, 0);
            string sValue = llList2String(lParams, 1);
            if (sToken == "locked")
            {
                g_iLocked = (integer)sValue;
                if (g_iLocked)
                {
                    llMessageLinked(LINK_THIS, RLV_CMD, "detach=n", NULL_KEY);
                    llMessageLinked(LINK_THIS, MENUNAME_RESPONSE, g_sParentMenu + "|" + UNLOCK, NULL_KEY);                
                    llMessageLinked(LINK_THIS, MENUNAME_REMOVE, g_sParentMenu + "|" + LOCK, NULL_KEY);  
                }
                else
                {
                    llMessageLinked(LINK_THIS, RLV_CMD, "detach=y", NULL_KEY); 
                    llMessageLinked(LINK_THIS, MENUNAME_RESPONSE, g_sParentMenu + "|" + LOCK, NULL_KEY);                
                    llMessageLinked(LINK_THIS, MENUNAME_REMOVE, g_sParentMenu + "|" + UNLOCK, NULL_KEY);                     
                }
            }
            else if (sToken == "owner")
            {
                g_lOwners = llParseString2List(sValue, [","], []);
            }            
        }
        else if (iNum == HTTPDB_SAVE)
        {
            list lParams = llParseString2List(sStr, ["="], []);            
            string sToken = llList2String(lParams, 0);
            string sValue = llList2String(lParams, 1);            
            if (sToken == "owner")
            {
                g_lOwners = llParseString2List(sValue, [","], []);
            }            
        }        
        else if (iNum == MENUNAME_REQUEST && sStr == g_sParentMenu)
        {
            if (g_iLocked)
            {
                llMessageLinked(LINK_THIS, MENUNAME_RESPONSE, g_sParentMenu + "|" + UNLOCK, NULL_KEY);
            }
            else
            {
                llMessageLinked(LINK_THIS, MENUNAME_RESPONSE, g_sParentMenu + "|" + LOCK, NULL_KEY);                            
            }
        }
        else if (iNum == SUBMENU)
        {
            if (sStr == LOCK) 
            {
                g_iRemenu=TRUE;
                llMessageLinked(LINK_THIS, COMMAND_NOAUTH, "lock", kID);
            }
            else if (sStr == UNLOCK) 
            {
                g_iRemenu=TRUE;
                llMessageLinked(LINK_THIS, COMMAND_NOAUTH, "unlock", kID);
            }
        }        
        
        else if (iNum == RLV_REFRESH)
        {
            if (g_iLocked)
            {
                llMessageLinked(LINK_THIS, RLV_CMD, "detach=n", NULL_KEY);
            }
            else
            {
                llMessageLinked(LINK_THIS, RLV_CMD, "detach=y", NULL_KEY);
            }
        }
        else if (iNum == RLV_CLEAR)
        {
            if (g_iLocked)
            {
                llMessageLinked(LINK_THIS, RLV_CMD, "detach=n", NULL_KEY);
            }
            else
            {
                llMessageLinked(LINK_THIS, RLV_CMD, "detach=y", NULL_KEY);
            }
        }
                
    }
    attach(key kID)
    {
        if (g_iLocked && kID == NULL_KEY)
        {
            NotifyOwners(llKey2Name(g_kWearer) + " has detached me while locked!");
        }
    }

    changed(integer iChange)
    {
        if (iChange & CHANGED_OWNER)
        {
            llResetScript();
        }
    }
}