//{taraFAB} MMX - Please don't forget to set the script NOMOD after you're done.
string texture              = "829e7276-eb37-4037-9c33-2f3752f8d551";
integer pattern             = PSYS_SRC_PATTERN_DROP;
integer running             = FALSE;

integer glowEffect          = TRUE;
integer followVelocity      = TRUE;
integer followSource        = FALSE;
integer windEffect          = FALSE;
integer sizeInterpolation   = TRUE;
integer colorInterpolation  = TRUE;
integer bounceEffect        = FALSE;
integer effectFlags         = 0;
key target                  = "";
//Colour, shape and transparency
vector startSize            = <0.002, 0.007, 0.0>;
vector endSize              = <0.5, 0.8, 0.0>;
vector endColor             = <0.8, 0.8, 1.0>;
vector startColor           = <0.6, 0.6, 1.0>;
float startAlpha            = 0.3;
float endAlpha              = 0.0;
//Speeds and Angles
float minSpeed              = 0.01;
float maxSpeed              = 0.07;
float radius                = 0.0;
float beginAngle            = 0.0;
float endAngle              = 0.0;
vector omega                = <0.0, 0.0, 1.0>;
vector acceleration         = <0.00, 0.00, 0.1>;
//Timing
float SystemLife            = 0.0;
float particleLife          = 4.0;
float emissionRate          = 1.0;
integer partPerEmission     = 1;
// You don't need to change anything below.

setParticles()
{
    target="";

    if (colorInterpolation) effectFlags = effectFlags|PSYS_PART_INTERP_COLOR_MASK;
    if (sizeInterpolation)  effectFlags = effectFlags|PSYS_PART_INTERP_SCALE_MASK;
    if (windEffect)         effectFlags = effectFlags|PSYS_PART_WIND_MASK;
    if (bounceEffect)       effectFlags = effectFlags|PSYS_PART_BOUNCE_MASK;
    if (followSource)       effectFlags = effectFlags|PSYS_PART_FOLLOW_SRC_MASK;
    if (followVelocity)     effectFlags = effectFlags|PSYS_PART_FOLLOW_VELOCITY_MASK;
    if (target!="")         effectFlags = effectFlags|PSYS_PART_TARGET_POS_MASK;
    if (glowEffect)         effectFlags = effectFlags|PSYS_PART_EMISSIVE_MASK;

    llParticleSystem([
        PSYS_PART_FLAGS,            effectFlags,
        PSYS_SRC_PATTERN,           pattern,
        PSYS_PART_START_COLOR,      startColor,
        PSYS_PART_END_COLOR,        endColor,
        PSYS_PART_START_ALPHA,      startAlpha,
        PSYS_PART_END_ALPHA,        endAlpha,
        PSYS_PART_START_SCALE,      startSize,
        PSYS_PART_END_SCALE,        endSize,    
        PSYS_PART_MAX_AGE,          particleLife,
        PSYS_SRC_ACCEL,             acceleration,
        PSYS_SRC_TEXTURE,           texture,
        PSYS_SRC_BURST_RATE,        emissionRate,
        PSYS_SRC_ANGLE_BEGIN,       beginAngle,
        PSYS_SRC_ANGLE_END,         endAngle,
        PSYS_SRC_BURST_PART_COUNT,  partPerEmission,      
        PSYS_SRC_BURST_RADIUS,      radius,
        PSYS_SRC_BURST_SPEED_MIN,   minSpeed,
        PSYS_SRC_BURST_SPEED_MAX,   maxSpeed, 
        PSYS_SRC_MAX_AGE,           SystemLife,
        PSYS_SRC_TARGET_KEY,        target,
        PSYS_SRC_OMEGA,             omega   ]);
}

default
{
    state_entry()
    {
        running=TRUE;
        setParticles();
    }
    
    touch_start(integer num_detected)
    {
        if (running==TRUE)
        {
            running=FALSE;
            
            llParticleSystem([]);
        }
        else
        {
            running=TRUE;
            setParticles();
        }
    }

}
