//OpenCollar - timer - 3.339
list g_lTimes;
integer g_iTimesLength;
integer g_iCurrentTime;
integer g_iOnTime;
integer g_iLastTime;
integer g_iFirstOnTime;
integer g_iFirstRealTime;
integer g_iLastRez;
integer n;//for loops
string g_sMessage;
integer MAX_TIME=0x7FFFFFFF;

integer ATTACHMENT_COMMAND = 602;
integer ATTACHMENT_FORWARD = 610;
//these can iChange
integer TIMER_TOMESSAGE=609;
integer TIMER_FROMMESSAGE=610;
integer REAL_TIME=1;
integer REAL_TIME_EXACT=5;
integer ON_TIME=3;
integer ON_TIME_EXACT=7;

//key g_kWearer; why is this in here twice.
integer g_iInterfaceChannel;
// end time keeper


// Template for creating a OpenCOllar Plugin - OpenCollar Version 3.0xx

//Licensed under the GPLv2, with the additional requirement that these scripts remain "full perms" in Second Life.  See "OpenCollar License" for details.
//Collar Cuff Menu

string g_sSubMenu = "Timer"; // Name of the g_sSubMenu
string g_sParentMenu = "AddOns"; // msName of the menu, where the menu plugs in

key g_kMenuID;
key g_kOnMenuID;
key g_kRealMenuID;

key g_kWearer; // key of the s_Current g_kWearer to reset only on owner iChanges

list g_lLocalButtons = ["realtime","online"]; // any local, not changing lButtons which will be used in this plugin, lekAve emty or add lButtons as you like
list g_lTimeButtons = ["clear","+00:01","+00:05","+00:30","+03:00","+24:00","-00:01","-00:05","-00:30","-03:00","-24:00"];

integer g_iOnRunning;
integer g_iOnSetTime;
integer g_iOnTimeUpAt;
integer g_iLastOnTime;
integer g_iClockTimeAtLastOnTime;
integer g_iRealRunning;
integer g_iRealSetTime;
integer g_iRealTimeUpAt;
integer g_iLastRealTime;
integer g_iClockTimeAtLastRealTime;

integer g_iUnlockCollar;
integer g_iCollarLocked;
integer g_iClearRLVRestions;
integer g_iUnleash;
integer g_iBoth;
integer g_iWhoCanChangeTime;
integer g_iWhoCanChangeLeash;
integer g_iWhoCanOtherSettings;


integer g_iClockTime;
integer g_iTimeChange;
integer g_iOnUpdate;
integer g_iRealUpdated;

integer g_iWhichMenu;
key g_kMenuWho;

list lButtons;

//OpenCollae MESSAGE MAP
// messages for iNumenticating users
integer COMMAND_NOAUTH = 0;
integer COMMAND_OWNER = 500;
integer COMMAND_SECOWNER = 501;
integer COMMAND_GROUP = 502;
integer COMMAND_WEARER = 503;
integer COMMAND_EVERYONE = 504;
//integer CHAT = 505;//deprecated
integer COMMAND_OBJECT = 506;
integer COMMAND_RLV_RELAY = 507;
// added so when the sub is locked sOut they can use postions
integer COMMAND_WEARERLOCKEDOUT = 521;

//integer SEND_IM = 1000; deprecated.  each script should send its own IMs now.  This is to reduce even the tiny bt of lag caused by hkAving IM slkAve scripts
integer POPUP_HELP = 1001;

// messages for storing and retrieving sValues from http db
integer HTTPDB_SAVE = 2000;//scripts send messages on this channel to have settings saved to httpdb
//sStr must be in form of "sToken=sValue"
integer HTTPDB_REQUEST = 2001;//when startup, scripts send requests for settings on this channel
integer HTTPDB_RESPONSE = 2002;//the httpdb script will send responses on this channel
integer HTTPDB_DELETE = 2003;//delete sToken from DB
integer HTTPDB_EMPTY = 2004;//sent by httpdb script when a sToken has no sValue in the db

integer LOCALSETTING_SAVE = 2500;
integer LOCALSETTING_REQUEST = 2501;
integer LOCALSETTING_RESPONSE = 2502;
integer LOCALSETTING_DELETE = 2503;
integer LOCALSETTING_EMPTY = 2504;

// messages for creating OC menu sStructure
integer MENUNAME_REQUEST = 3000;
integer MENUNAME_RESPONSE = 3001;
integer SUBMENU = 3002;
integer MENUNAME_REMOVE = 3003;

// messages for RLV sCommands
integer RLV_CMD = 6000;
integer RLV_REFRESH = 6001;//RLV plugins should reinstate their g_lRestrictions upon receiving this message.
integer RLV_CLEAR = 6002;//RLV plugins should clear their resStriction lists upon receiving this message.
integer RLV_VERSION = 6003; //RLV Plugins can recieve the used rl viewer sVersion upon receiving this message..

// messages for poses and couple sAnims
integer ANIM_START = 7000;//send this with the sName of an sAnim in the string part of the sMessage to play the sAnim
integer ANIM_STOP = 7001;//send this with the sName of an sAnim in the string part of the sMessage to stop the sAnim
integer CPLANIM_PERMREQUEST = 7002;//kID should be kAv's key, sStr should be sCmd sName "hug", "kiss", etc
integer CPLANIM_PERMRESPONSE = 7003;//sStr should be "1" for got perms or "0" for not.  kID should be kAv's key
integer CPLANIM_START = 7004;//sStr should be valkID sAnim sName.  kID should be kAv
integer CPLANIM_STOP = 7005;//sStr should be valkID sAnim sName.  kID should be kAv

integer DIALOG = -9000;
integer DIALOG_RESPONSE = -9001;
integer DIALOG_TIMEOUT = -9002;

integer WEARERLOCKOUT=620;


// menu option to go one step back in menusStructure
string UPMENU = "^";
string MORE = ">";

Notify(key kID, string sMsg, integer iAlsoNotifyWearer)
{
    if (kID == g_kWearer)
    {
        llOwnerSay(sMsg);
    }
    else
    {
        llInstantMessage(kID,sMsg);
        if (iAlsoNotifyWearer)
        {
            llOwnerSay(sMsg);
        }
    }    
}

//===============================================================================
//= parameters   :    string    sMsg   sMessage string received
//=
//= return        :    none
//=
//= description  :    sOutput debug messages
//=
//===============================================================================


Debug(string sMsg)
{
    //llOwnerSay(llGetScriptName() + ": " + sMsg);
}

//===============================================================================
//= parameters   :    string    sMsg   sMessage string received
//=
//= return        :    integer TRUE/FALSE
//=
//= description  :    checks if a string begin with another sString
//=
//===============================================================================

integer StartsWith(string sHaystack, string sNeedle) // http://wiki.secondlife.com/wiki/llSubStringIndex
{
    return (llDeleteSubString(sHaystack, llStringLength(sNeedle), -1) == sNeedle);
}


key ShortKey()
{//just pick 8 random hex digits and pad the rest with 0.  Good enough for dialog uniqueness.
    string sChars = "0123456789abcdef";
    integer iLength = 16;
    string sOut;
    integer n;
    for (n = 0; n < 8; n++)
    {
        integer iIndex = (integer)llFrand(16);//yes this is correct; an integer cast rounds towards 0.  See the llFrand wiki entry.
        sOut += llGetSubString(sChars, iIndex, iIndex);
    }
     
    return (key)(sOut + "-0000-0000-0000-000000000000");
}

key Dialog(key kRCPT, string sPrompt, list lChoices, list lUtilityButtons, integer iPage)
{
    key kID = ShortKey();
    llMessageLinked(LINK_SET, DIALOG, (string)kRCPT + "|" + sPrompt + "|" + (string)iPage + "|" + llDumpList2String(lChoices, "`") + "|" + llDumpList2String(lUtilityButtons, "`"), kID);
    return kID;
} 

//===============================================================================
//= parameters   :    string    keyID   key of person requesting the menu
//=
//= return        :    none
//=
//= description  :    build menu and display to user
//=
//===============================================================================

DoMenu(key keyID)
{
    Debug("timeremaning:"+(string)(g_iOnTimeUpAt-g_iOnTime));
    string sPrompt = "Pick an option.";
    list lMyButtons = g_lLocalButtons + lButtons;

    //fill in your button list and additional sPrompt here
    sPrompt += "\n Online timer - "+Int2Time(g_iOnSetTime);
    if (g_iOnRunning==1)
    {
        sPrompt += "\n Online timer - "+Int2Time(g_iOnTimeUpAt-g_iOnTime)+" left";
        //lMyButtons += ["stop online"];
    }
    else
    {
        sPrompt += "\n Online timer - not running";
        //lMyButtons += ["start online"];
    }
    sPrompt += "\n Realtime timer - "+Int2Time(g_iRealSetTime);
    if (g_iRealRunning==1)
    {
        sPrompt += "\n Realtime timer - "+Int2Time(g_iRealTimeUpAt-g_iCurrentTime)+" left";
        //lMyButtons += ["stop realtime"];
    }
    else
    {
        sPrompt += "\n Realtime timer - not running";
        //lMyButtons += ["start realtime"];
    }
    if (g_iBoth)
    {
        sPrompt += "\n When BOTH the online and realtime timer go off:";
        lMyButtons += ["(*)bothtime"];
    }
    else
    {
        sPrompt += "\n When EITHER the online or realtime timer go off:";
        lMyButtons += ["()bothtime"];
    }
    if (g_iRealRunning || g_iOnRunning)
    {
        lMyButtons += ["stop"];
    }
    else if (g_iRealSetTime || g_iOnSetTime)
    {
        lMyButtons += ["start"];    
    }
    if (g_iUnlockCollar)
    {
        sPrompt += "\n\t the collar WILL be unlocked";
        lMyButtons += ["(*)unlock"];
    }
    else
    {
        sPrompt += "\n\t the collar will NOT be unlocked";
        lMyButtons += ["()unlock"];
    }
    if (g_iUnleash)
    {
        sPrompt += "\n\t the collar WILL be unleashed";
        lMyButtons += ["(*)unleash"];
    }
    else
    {
        sPrompt += "\n\t the collar will NOT be unleashed";
        lMyButtons += ["()unleash"];
    }
    if (g_iClearRLVRestions)
    {
        sPrompt += "\n\t the RLV restions WILL be cleared";
        lMyButtons += ["(*)clearRLV"];
    }
    else
    {
        sPrompt += "\n\t the RLV restions will NOT be cleared";
        lMyButtons += ["()clearRLV"];
    }

    llListSort(g_lLocalButtons, 1, TRUE); // resort menu lButtons alphabetical

    g_kMenuID = Dialog(keyID, sPrompt, lMyButtons, [UPMENU], 0);
}
DoOnMenu(key keyID)
{
    string sPrompt = "Pick an option.";
    sPrompt += "\n Online timer - "+Int2Time(g_iOnSetTime);
    if (g_iOnRunning)
    {
        sPrompt += "\n Online timer - "+Int2Time(g_iOnTimeUpAt-g_iOnTime)+" left";
    }
    else
    {
        sPrompt += "\n Online timer - not running";
    }
    g_kOnMenuID = Dialog(keyID, sPrompt, g_lTimeButtons, [UPMENU], 0);
}
DoRealMenu(key keyID)
{
    string sPrompt = "Pick an option.";
    //fill in your button list and additional sPrompt here
    sPrompt += "\n Realtime timer - " + Int2Time(g_iRealSetTime);
    if (g_iRealRunning)
    {
        sPrompt += "\n Realtime timer - "+Int2Time(g_iRealTimeUpAt-g_iCurrentTime)+" left";
    }
    else
    {
        sPrompt += "\n Realtime timer - not running";
    }
    g_kRealMenuID = Dialog(keyID, sPrompt, g_lTimeButtons, [UPMENU], 0);
}


//===============================================================================
//= parameters   :    none
//=
//= return        :   string     DB prefix from the description of the collar
//=
//= description  :    prefix from the description of the collar
//=
//===============================================================================

string GetDBPrefix()
{//get db prefix from list in object desc
    return llList2String(llParseString2List(llGetObjectDesc(), ["~"], []), 2);
}

string Int2Time(integer sTime)
{
    if (sTime<0) sTime=0;
    integer iSecs=sTime%60;
    sTime = (sTime-iSecs)/60;
    integer iMins=sTime%60;
    sTime = (sTime-iMins)/60;
    integer iHours=sTime%24;
    integer iDays = (sTime-iHours)/24;
    
    //this is the onley g_iLine that needs changing...
    return ( (string)iDays+" days "+
        llGetSubString("0"+(string)iHours,-2,-1) + ":"+
        llGetSubString("0"+(string)iMins,-2,-1) + ":"+
        llGetSubString("0"+(string)iSecs,-2,-1) );
    //return (string)iDays+":"+(string)iHours+":"+(string)iMins+":"+(string)iSecs;
}

TimerWhentOff()
{
    if(g_iBoth && (g_iOnRunning == 1 || g_iRealRunning == 1))
    {
        return;
    }
    llMessageLinked(LINK_THIS, WEARERLOCKOUT, "off", "");
    g_iOnSetTime=g_iRealSetTime=0;
    g_iOnRunning=g_iRealRunning=0;
    g_iOnTimeUpAt=g_iRealTimeUpAt=0;
    g_iWhoCanChangeTime=504;
    if(g_iUnlockCollar)
    {
        llMessageLinked(LINK_THIS, COMMAND_OWNER, "unlock", g_kWearer);
    }
    if(g_iClearRLVRestions)
    {
        llMessageLinked(LINK_THIS, COMMAND_OWNER, "clear", g_kWearer);
        if(!g_iUnlockCollar && g_iCollarLocked)
        {
            llSleep(2);
            llMessageLinked(LINK_THIS, COMMAND_OWNER, "lock", g_kWearer);
        }
    }
    if(g_iUnleash)
    {
        llMessageLinked(LINK_THIS, COMMAND_OWNER, "unleash", "");
    }
    g_iUnlockCollar=g_iClearRLVRestions=g_iUnleash=0;
    Notify(g_kWearer, "The timer has expired", TRUE);
}

default
{
    state_entry()
    {
        g_iLastTime=llGetUnixTime();
        llSetTimerEvent(1);
        g_kWearer = llGetOwner();
        g_iInterfaceChannel = (integer)("0x" + llGetSubString(g_kWearer,30,-1));
        if (g_iInterfaceChannel > 0)
        {
              g_iInterfaceChannel = -g_iInterfaceChannel;
        }
        g_iFirstOnTime=MAX_TIME;
        g_iFirstRealTime=MAX_TIME;
        llMessageLinked(LINK_THIS, TIMER_FROMMESSAGE, "timer|sendtimers", "");
        llWhisper(g_iInterfaceChannel, "timer|sendtimers");

        //end of timekeeper
        //g_kWearer=llGetOwner();

        // sleep a sceond to allow all scripts to be initialized
        llSleep(1.0);
        // send reequest to main menu and ask other menus if the wnt to register with us
        llMessageLinked(LINK_THIS, MENUNAME_REQUEST, g_sSubMenu, NULL_KEY);
        llMessageLinked(LINK_THIS, MENUNAME_RESPONSE, g_sParentMenu + "|" + g_sSubMenu, NULL_KEY);
        
        //set settings
        g_iUnlockCollar=0;
        g_iClearRLVRestions=0;
        g_iUnleash=0;
        g_iBoth=0;
        g_iWhoCanChangeTime=504;
        g_iWhoCanChangeLeash=504;
        g_iWhoCanOtherSettings=504;

    }
    on_rez(integer iParam)
    {
        g_iLastTime=g_iLastRez=llGetUnixTime();
        llMessageLinked(LINK_THIS, TIMER_FROMMESSAGE, "timer|sendtimers", "");
        llWhisper(g_iInterfaceChannel, "timer|sendtimers");
        if (g_iRealRunning == 1 || g_iOnRunning == 1)
        {
            llMessageLinked(LINK_THIS, WEARERLOCKOUT, "on", "");
            Debug("timer is running real:"+(string)g_iRealRunning+" on:"+(string)g_iOnRunning);
        }
    }

    // listen for likend messages fromOC scripts
    link_message(integer iSender, integer iNum, string sStr, key kID)
    {
        list info  = llParseString2List (sStr, ["|"], []);
        if((iNum==TIMER_TOMESSAGE || iNum==ATTACHMENT_FORWARD)&&llList2String(info, 0)=="timer")//request for us
        {
            Debug(sStr);
            string sCommand = llList2String(info, 1);
            integer type = llList2Integer(info, 2);
            if(sCommand=="settimer")
            {
                //should check sValues but I am not yet.
                if(type==REAL_TIME)
                {
                    integer newtime = llList2Integer(info, 3) +g_iCurrentTime;
                    g_lTimes=g_lTimes+[REAL_TIME,newtime];
                    if(g_iFirstRealTime>newtime)
                    {
                        g_iFirstRealTime=newtime;
                    }
                    g_sMessage="timer|timeis|"+(string)REAL_TIME+"|"+(string)g_iCurrentTime;
                }
                else if(type==REAL_TIME_EXACT)
                {
                    integer newtime = llList2Integer(info, 3);
                    g_lTimes=g_lTimes+[REAL_TIME,newtime];
                    if(g_iFirstRealTime>newtime)
                    {
                        g_iFirstRealTime=newtime;
                    }
                }
                else if(type==ON_TIME)
                {
                    integer newtime = llList2Integer(info, 3) +g_iOnTime;
                    g_lTimes=g_lTimes+[ON_TIME,newtime];
                    if(g_iFirstOnTime>newtime)
                    {
                        g_iFirstOnTime=newtime;
                    }
                    g_sMessage="timer|timeis|"+(string)ON_TIME+"|"+(string)g_iOnTime;
                }
                else if(type==ON_TIME_EXACT)
                {
                    integer newtime = llList2Integer(info, 3) +g_iOnTime;
                    g_lTimes=g_lTimes+[ON_TIME,newtime];
                    if(g_iFirstOnTime>newtime)
                    {
                        g_iFirstOnTime=newtime;
                    }
                }
            }
            else if(sCommand=="gettime")
            {
                if(type==REAL_TIME)
                {
                    g_sMessage="timer|timeis|"+(string)REAL_TIME+"|"+(string)g_iCurrentTime;
                }
                else if(type==ON_TIME)
                {
                    g_sMessage="timer|timeis|"+(string)ON_TIME+"|"+(string)g_iOnTime;
                }
            }
            else
            {
                return;
                //g_sMessage got sent to us or something went wrong
            }
            if(iNum==ATTACHMENT_FORWARD)
            {
                llWhisper(g_iInterfaceChannel, g_sMessage);//need to wispear
            }
            else if(iNum==TIMER_TOMESSAGE)
            {
                llMessageLinked(LINK_THIS, TIMER_FROMMESSAGE, g_sMessage, "");//inskIDe script
            }
        }
        else if(iNum == COMMAND_WEARERLOCKEDOUT && sStr == "menu")
        {
            Notify(kID , "You are locked out of the collar until the timer expires", FALSE);
        }
        else if (iNum == LOCALSETTING_DELETE )
        {
            if (sStr == "leashto")
            {
                g_iWhoCanChangeLeash=504;
            }
        }
        else if (iNum == HTTPDB_DELETE)
        {
            if (sStr == "locked")
            {
                g_iCollarLocked=0;
            }
        }
        else if (iNum == LOCALSETTING_SAVE)
        {
            if (llGetSubString(sStr, 0, 8) == "leashto")
            {
                integer temp = llList2Integer( llParseString2List( sStr , [","] , [] ) , -1 );
                if (temp < g_iWhoCanChangeLeash)
                {
                    g_iWhoCanChangeLeash=temp;
                    g_iUnleash=0;
                }
            }
        }
        else if (iNum == HTTPDB_SAVE)
        {
            if (sStr == "locked=1")
            {
                g_iCollarLocked=1;
            }
        }
        else if (iNum == HTTPDB_RESPONSE)
        {
            list lParams = llParseString2List(sStr, ["="], []);
            string sToken = llList2String(lParams, 0);
            string sValue = llList2String(lParams, 1);
            if (sToken == "locked")
            {
                g_iCollarLocked=(integer)sValue;
            }
        }
        else if (iNum == SUBMENU && sStr == g_sSubMenu)
        {
            //someone asked for our menu
            //give this plugin's menu to kID
            DoMenu(kID);
        }
        else if (iNum == MENUNAME_REQUEST && sStr == g_sParentMenu)
            // our parent menu requested to receive lButtons, so send ours
        {

            llMessageLinked(LINK_THIS, MENUNAME_RESPONSE, g_sParentMenu + "|" + g_sSubMenu, NULL_KEY);
        }
        else if (iNum == MENUNAME_RESPONSE)
            // a button is sned ot be added to a plugin
        {
            list lParts = llParseString2List(sStr, ["|"], []);
            if (llList2String(lParts, 0) == g_sSubMenu)
            {//someone wants to stick something in our menu
                string sButton = llList2String(lParts, 1);
                if (llListFindList(lButtons, [sButton]) == -1)
                    // if the button isnt in our benu yet, than we add it
                {
                    lButtons = llListSort(lButtons + [sButton], 1, TRUE);
                }
            }
        }
        else if (iNum >= COMMAND_OWNER && iNum <= COMMAND_WEARER)
            // a valkIDated sCommand from a owner, secowner, g_kGroupmember or the wear has been received
            // can also be used to listen to chat sCommands
        {
            if (llToLower(sStr) == "timer")
            {
                DoMenu(kID);
            }
            else if(llGetSubString(sStr, 0, 5) == "timer ")
            {
                string sMsg=llGetSubString(sStr, 6, -1);
                //we got a response for something we handle locally
                if (sMsg == "realtime")
                {
                    // do What has to be Done
                    Debug("realtime");
                    // and restart the menu if wantend/needed
                    DoRealMenu(kID);
                }
                else if (sMsg == "online")
                {
                    // do What has to be Done
                    Debug("online");
                    // and restart the meuu if wantend/needed
                    DoOnMenu(kID);
                }
                else if (sMsg == "start")
                {
                    // do What has to be Done
                    g_iWhoCanChangeTime = iNum;
                    if(g_iRealSetTime)
                    {
                        //llMessageLinked(LINK_THIS, TIMER_TOMESSAGE, "timer|settimer|"+(string)REAL_TIME+"|"+(string)(g_iRealSetTime), "");
                        g_iRealTimeUpAt=g_iCurrentTime+g_iRealSetTime;
                        llMessageLinked(LINK_THIS, WEARERLOCKOUT, "on", "");
                        
                        g_iRealRunning=1;
                    }
                    else
                    {
                        g_iRealRunning=3;
                    }
                    if(g_iOnSetTime)
                    {
                        //llMessageLinked(LINK_THIS, TIMER_TOMESSAGE, "timer|settimer|"+(string)ON_TIME+"|"+(string)(g_iOnSetTime), "");
                        g_iOnTimeUpAt=g_iOnTime+g_iOnSetTime;
                        llMessageLinked(LINK_THIS, WEARERLOCKOUT, "on", "");
                        
                        g_iOnRunning=1;
                    }
                    else
                    {
                        g_iOnRunning=3;
                    }
                    // and restart the meuu if wantend/needed
                    if(kID != g_kWearer)
                    {
                        DoMenu(kID);
                    }
                }
                else if (sMsg == "stop")
                {
                    // do What has to be Done
                    TimerWhentOff();
                    // and restart the meuu if wantend/needed
                    DoMenu(kID);
                }
                else if (sMsg == "(*)bothtime")
                {
                    // do What has to be Done
                    g_iBoth = FALSE;
                    // and restart the meuu if wantend/needed
                    DoMenu(kID);
                }
                else if (sMsg == "()bothtime")
                {
                    // do What has to be Done
                    g_iBoth = TRUE;
                    // and restart the meuu if wantend/needed
                    DoMenu(kID);
                }
                else if(sMsg=="(*)unlock")
                {
                    if(iNum == COMMAND_OWNER)
                    {
                        g_iUnlockCollar=0;
                        DoMenu(kID);
                    }
                    else
                    {
                        Notify(kID,"Only the owner can change if the collar unlocks when the timer runs out.",FALSE);
                    }
                }
                else if(sMsg=="()unlock")
                {
                    if(iNum == COMMAND_OWNER)
                    {
                        g_iUnlockCollar=1;
                        DoMenu(kID);
                    }
                    else
                    {
                        Notify(kID,"Only the owner can change if the collar unlocks when the timer runs out.",FALSE);
                    }
                }
                else if(sMsg=="(*)clearRLV")
                {
                    if(iNum == COMMAND_WEARER)
                    {
                        Notify(kID,"You cannot change if the RLV settings are cleared",FALSE);
                    }
                    else
                    {
                        g_iClearRLVRestions=0;
                        DoMenu(kID);
                    }
                }
                else if(sMsg=="()clearRLV")
                {
                    if(iNum == COMMAND_WEARER)
                    {
                        Notify(kID,"You cannot change if the RLV settings are cleared",FALSE);
                    }
                    else
                    {
                        g_iClearRLVRestions=1;
                        DoMenu(kID);
                    }
                }
                else if(sMsg=="(*)unleash")
                {
                    if(iNum <= g_iWhoCanChangeLeash)
                    {
                        g_iUnleash=0;
                        DoMenu(kID);
                    }
                    else
                    {
                        Notify(kID,"Only the someone who can leash the sub can change if the collar unleashes when the timer runs out.",FALSE);
                    }
                }
                else if(sMsg=="()unleash")
                {
                    if(iNum <= g_iWhoCanChangeLeash)
                    {
                        g_iUnleash=1;
                        DoMenu(kID);
                    }
                    else
                    {
                        Notify(kID,"Only the someone who can leash the sub can change if the collar unleashes when the timer runs out.",FALSE);
                    }
                }
            }
            if(llGetSubString(sStr, 0, 1) == "on")
            {
                string sMsg=llGetSubString(sStr, 2, -1);
                if (iNum <= g_iWhoCanChangeTime)
                {
                    list lTimes = llParseString2List(llGetSubString(sMsg, 1, -1), [":"], []);
                    if (sMsg == "clear")
                    {
                        g_iOnSetTime=g_iOnTimeUpAt=0;
                        if(g_iOnRunning == 1)
                        {
                            //unlock
                            g_iOnRunning=0;
                            TimerWhentOff();
                        }
                    }
                    else if (llGetSubString(sMsg, 0, 0) == "+")
                    {
                        g_iTimeChange=llList2Integer(lTimes,0)*60*60+llList2Integer(lTimes,1)*60;
                        g_iOnSetTime += g_iTimeChange;
                        if (g_iOnRunning==1)
                        {
                            g_iOnTimeUpAt += g_iTimeChange;
                            //llMessageLinked(LINK_THIS, TIMER_TOMESSAGE, "timer|settimer|"+(string)ON_TIME+"|"+(string)(g_iOnTimeUpAt-g_iLastOnTime), "");
                        }
                        else if(g_iOnRunning==3)
                        {
                            //llMessageLinked(LINK_THIS, TIMER_TOMESSAGE, "timer|settimer|"+(string)ON_TIME+"|"+(string)(g_iOnSetTime), "");
                            g_iOnTimeUpAt=g_iOnTime+g_iOnSetTime;
                            g_iOnRunning=1;
                        }
                    }
                    else if (llGetSubString(sMsg, 0, 0) == "-")
                    {
                        g_iTimeChange=-(llList2Integer(lTimes,0)*60*60+llList2Integer(lTimes,1)*60);
                        g_iOnSetTime += g_iTimeChange;
                        if (g_iOnSetTime<0)
                        {
                            g_iOnSetTime=0;
                        }
                        if (g_iOnRunning==1)
                        {
                            g_iOnTimeUpAt += g_iTimeChange;
                            if (g_iOnTimeUpAt<=g_iOnTime)
                            {
                                //unlock
                                g_iOnRunning=g_iOnSetTime=g_iOnTimeUpAt=0;
                                TimerWhentOff();
                            }
                            else
                            {
                                //llMessageLinked(LINK_THIS, TIMER_TOMESSAGE, "timer|settimer|"+(string)ON_TIME+"|"+(string)(g_iOnTimeUpAt-g_iLastOnTime), "");
                            }
                        }
                    }
                    else
                    {
                        return;
                    }
                }
                DoOnMenu(kID);
            }
            else if(llGetSubString(sStr, 0, 3) == "real")
            {
                string sMsg=llGetSubString(sStr, 4, -1);
                list lTimes = llParseString2List(llGetSubString(sMsg, 1, -1), [":"], []);
                if (iNum <= g_iWhoCanChangeTime)
                {
                    if (sMsg == "clear")
                    {
                        g_iRealSetTime=g_iRealTimeUpAt=0;
                        if(g_iRealRunning == 1)
                        {
                            //unlock
                            g_iRealRunning=0;
                            TimerWhentOff();
                        }
                    }
                    else if (llGetSubString(sMsg, 0, 0) == "+")
                    {
                        g_iTimeChange=llList2Integer(lTimes,0)*60*60+llList2Integer(lTimes,1)*60;
                        g_iRealSetTime += g_iTimeChange;
                        if (g_iRealRunning==1)
                        {
                            g_iRealTimeUpAt += g_iTimeChange;
                            //llMessageLinked(LINK_THIS, TIMER_TOMESSAGE, "timer|settimer|"+(string)ON_TIME+"|"+(string)(g_iOnTimeUpAt-g_iLastOnTime), "");
                        }
                        else if(g_iRealRunning==3)
                        {
                            //llMessageLinked(LINK_THIS, TIMER_TOMESSAGE, "timer|settimer|"+(string)ON_TIME+"|"+(string)(g_iOnSetTime), "");
                            g_iRealTimeUpAt=g_iCurrentTime+g_iRealSetTime;
                            g_iRealRunning=1;
                        }
                    }
                    else if (llGetSubString(sMsg, 0, 0) == "-")
                    {
                        g_iTimeChange=-(llList2Integer(lTimes,0)*60*60+llList2Integer(lTimes,1)*60);
                        g_iRealSetTime += g_iTimeChange;
                        if (g_iRealSetTime<0)
                        {
                            g_iRealSetTime=0;
                        }
                        if (g_iRealRunning==1)
                        {
                            g_iRealTimeUpAt += g_iTimeChange;
                            if (g_iRealTimeUpAt<=g_iCurrentTime)
                            {
                                //unlock
                                g_iRealRunning=g_iRealSetTime=g_iRealTimeUpAt=0;
                                TimerWhentOff();
                            }
                            else
                            {
                                //llMessageLinked(LINK_THIS, TIMER_TOMESSAGE, "timer|settimer|"+(string)ON_TIME+"|"+(string)(g_iOnTimeUpAt-g_iLastOnTime), "");
                            }
                        }
                    }
                    else
                    {
                        return;
                    }
                }
                DoRealMenu(kID);
            }
        }
        else if (iNum == DIALOG_RESPONSE)
        {
            if (llListFindList([g_kMenuID, g_kOnMenuID, g_kRealMenuID], [kID]) != -1)
            {//this is one of our menus
                list lMenuParams = llParseString2List(sStr, ["|"], []);
                key kAv = (key)llList2String(lMenuParams, 0);          
                string sMsg = llList2String(lMenuParams, 1);                                         
                integer iPage = (integer)llList2String(lMenuParams, 2);                 
                if (kID == g_kMenuID)
                {            
                    
                    // request to iChange to parrent menu
                    if (sMsg == UPMENU)
                    {
                        //give kAv the parent menu
                        llMessageLinked(LINK_THIS, SUBMENU, g_sParentMenu, kAv);
                    }
                    else if (llListFindList(lButtons, [sMsg]))
                    {
                        llMessageLinked(LINK_THIS, COMMAND_NOAUTH, "timer "+sMsg, kAv);
                    }
                    else if (~llListFindList(lButtons, [sMsg]))
                    {
                        //we got a sCommand which another sCommand pluged into our menu
                        llMessageLinked(LINK_THIS, SUBMENU, sMsg, kAv);
                    }
                }
                else if (kID == g_kOnMenuID)
                {
                    if (sMsg == UPMENU)
                    {
                        DoMenu(kAv);
                    }
                    else
                    {
                        llMessageLinked(LINK_THIS, COMMAND_NOAUTH, "on"+sMsg, kAv);
                    }
                }
                else if (kID == g_kRealMenuID)
                {
                    if (sMsg == UPMENU)
                    {
                        DoMenu(kAv);
                    }
                    else
                    {
                        llMessageLinked(LINK_THIS, COMMAND_NOAUTH, "real"+sMsg, kAv);
                    }
                }                  
            }          
        }
    }

    timer()
    {
        g_iCurrentTime=llGetUnixTime();
        if (g_iCurrentTime<(g_iLastRez+60))
        {
           return;
        }
        if ((g_iCurrentTime-g_iLastTime)<60)
        {
            g_iOnTime+=g_iCurrentTime-g_iLastTime;
        }
        if(g_iOnTime>=g_iFirstOnTime)
        {
            //could store which is need but if g_iBoth are trigered it will have to send g_iBoth anyway I prefer not to check for that.
            g_sMessage="timer|timeis|"+(string)ON_TIME+"|"+(string)g_iOnTime;
            llWhisper(g_iInterfaceChannel, g_sMessage);
            llMessageLinked(LINK_THIS, TIMER_FROMMESSAGE, g_sMessage, "");
            
            g_iFirstOnTime=MAX_TIME;
            g_iTimesLength=llGetListLength(g_lTimes);
            for(n = 0; n < g_iTimesLength; n = n + 2)// send notice and find the next time.
            {
                if(llList2Integer(g_lTimes, n)==ON_TIME)
                {
                    while(llList2Integer(g_lTimes, n+1)<=g_iOnTime&&llList2Integer(g_lTimes, n)==ON_TIME&&g_lTimes!=[])
                    {
                        g_lTimes=llDeleteSubList(g_lTimes, n, n+1);
                        g_iTimesLength=llGetListLength(g_lTimes);
                    }
                    if(llList2Integer(g_lTimes, n)==ON_TIME&&llList2Integer(g_lTimes, n+1)<g_iFirstOnTime)
                    {
                        g_iFirstOnTime=llList2Integer(g_lTimes, n+1);
                    }
                }
            }
        }
        if(g_iCurrentTime>=g_iFirstRealTime)
        {
            //could store which is need but if g_iBoth are trigered it will have to send g_iBoth anyway I prefer not to check for that.
            g_sMessage="timer|timeis|"+(string)REAL_TIME+"|"+(string)g_iCurrentTime;
            llWhisper(g_iInterfaceChannel, g_sMessage);
            llMessageLinked(LINK_THIS, TIMER_FROMMESSAGE, g_sMessage, "");
            
            g_iFirstRealTime=MAX_TIME;
            g_iTimesLength=llGetListLength(g_lTimes);
            for(n = 0; n < g_iTimesLength; n = n + 2)// send notice and find the next time.
            {
                if(llList2Integer(g_lTimes, n)==REAL_TIME)
                {
                    while(llList2Integer(g_lTimes, n+1)<=g_iCurrentTime&&llList2Integer(g_lTimes, n)==REAL_TIME)
                    {
                        g_lTimes=llDeleteSubList(g_lTimes, n, n+1);
                        g_iTimesLength=llGetListLength(g_lTimes);
                    }
                    if(llList2Integer(g_lTimes, n)==REAL_TIME&&llList2Integer(g_lTimes, n+1)<g_iFirstRealTime)
                    {
                        g_iFirstRealTime=llList2Integer(g_lTimes, n+1);
                    }
                }
            }
        }
        if(g_iOnRunning == 1 && g_iOnTimeUpAt<=g_iOnTime)
        {
            g_iOnRunning = 0;
            TimerWhentOff();
        }
        if(g_iRealRunning == 1 && g_iRealTimeUpAt<=g_iCurrentTime)
        {
            g_iRealRunning = 0;
            TimerWhentOff();
        }
        g_iLastTime=g_iCurrentTime;
    }

}