/////////////////////////////////////////////////////////////////////////
// Basic Lock and Colour change script 1.8
//
//
//
// Needs 3  prims in the object named as follows:
//
//    keyHolderPrim
//    keyHolderNamePrim
//    flagsPrim
//
//
// In addition any locks should have their description field set to "lock"
// and any keys should have a description field of "key".
//
// This will allow them to he hidden and displayed by the script.
//
//
////////////////////////////////////////////////////////////////////////// 
//
// Settings for debug/setup
//
integer rlvEnabled=TRUE;
integer debugMode=FALSE;
integer resetPrimData=FALSE;
string encryptionKey="1234balleft";
//
//////////////////////////////////////////////////////////////////////////
// Edit this line to set the name to be used in messages
//
string deviceName="BFE Ballet Boot L";
//
//////////////////////////////////////////////////////////////////////////
// Edit this line to set the RLV restrictions applied when the device is locked
//
//
// e.g. if going in the right lower leg of a pair of boots, you might want to make
//      the left lower leg no detach also to save putting a script in the other 
//      so use something like:
//
//      string rlvLockCommands="@detach=n,detach:l lower leg=n"
string rlvLockCommands="@detach=n";
//

//////////////////////////////////////////////////////////////////////////
// Edit the list below to match the names of the prims to be coloured
//
list menuParts=["Upper", "Sole", "Metal"];
//
//
////////////////////////////////////////////////////////////////////////////
//
// Settings under here should not need to be altered.
//
// 
//
//

string linkDescription;

key keyHolder = NULL_KEY;
string keyHolderName;
key wearer = NULL_KEY;
string wearerName;
key toucher = NULL_KEY;
string nameToucher;
string statusMessage;

integer keysOnStatus = TRUE;
integer lockStatus = FALSE;

vector blue=<0.0,0.0,1.0>;
vector darkblue=<0.0,0.0,0.545>;
vector lightblue=<0.678,0.847,0.902>;
vector green=<0.0,1.0,0.0>;
vector darkgreen=<0.0,0.392,0.0>;
vector lightgreen=<0.564,0.933,0.547>;
vector black=<0.0,0.0,0.0>;
vector darkblack=<0.0,0.0,0.0>;
vector lightblack=<0.501,0.501,0.501>;
vector pink=<0.933,0.416,0.655>;
vector darkpink=<1.0,0.078,0.576>;
vector lightpink=<1.0,0.714,0.757>;
vector red=<1.0,0.0,0.0>;
vector darkred=<0.545,0.0,0.0>;
vector lightred=<1.0,0.416,0.416>;
vector purple=<0.58,0.0,0.827>;
vector darkpurple=<0.5,0.0,0.5>;
vector lightpurple=<0.933,0.0,0.933>;
vector white=<1.0,1.0,1.0>;
vector darkwhite=<0.439,0.502,0.565>;
vector lightwhite=<0.752,0.752,0.752>;
vector yellow=<1.0,1.0,0.0>;
vector darkyellow=<1.0,0.843,0.0>;
vector lightyellow=<1.0,1.0,0.878>;
vector orange=<1.0,0.647,0.0>;
vector darkorange=<1.0,0.549,0.0>;
vector lightorange=<1.0,0.925,0.545>;

integer menuChannel;
vector vectColour;
string selectedPartName;
string selectedColourName;
list menuColour=[" - ", " - ", "back", "blue", "green", "black", "pink", "red", "purple", "white", "yellow", "orange"];
list menuShades=[" - ", " - ", "back", "light", "normal", "dark"];
list menuMain;
integer listenHandleMenu;
integer menuExpireTime;
string menuMessage;
string menuLevel;

list flags;
//string value1;
//string value2;
//string value3;
//string value4;
//string value5;
//string value6;
//string value7;
//string value8;
//string value9;
//string value10;
string retrievedData;
string retrievedMessage;
string data;


integer keyHolderPrim;
integer keyHolderNamePrim;
integer flagsPrim;
//integer valuePrim1;
//integer valuePrim2;
//integer valuePrim3;
//integer valuePrim4;
//integer valuePrim5;
//integer valuePrim6;
//integer valuePrim7;
//integer valuePrim8;
//integer valuePrim9;
//integer valuePrim10;

//Function to show or hide the locks and change indicator light colour.
showLocks(integer show)
{
    integer i=1;
    while (i <= llGetNumberOfPrims())
    {
        linkDescription=(string)llGetLinkPrimitiveParams(i,[PRIM_DESC]);
        float alpha=(float)show;
        if (linkDescription=="lock") llSetLinkAlpha(i,alpha,ALL_SIDES);
        if (linkDescription=="light")
        {
            if (show==TRUE) llSetLinkColor(i, <255,0,0>, ALL_SIDES);
            else llSetLinkColor(i, <0,255,0>, ALL_SIDES);
        }
        ++i;
    }
}

showKeys(integer show)
{
    integer i=1;
    while (i <= llGetNumberOfPrims())
    {
        linkDescription=(string)llGetLinkPrimitiveParams(i,[PRIM_DESC]);
        float alpha=(float)show;
        if (linkDescription=="key") llSetLinkAlpha(i,alpha,ALL_SIDES);
        ++i;
    }
}

///////////////////////////////////////////////////////////////////////
//
// Functions to store, retrieve and process data
//
getDataPrims()
{
    integer i=1;
    while (i <= llGetNumberOfPrims())
    {
        string linkDescription=(string)llGetLinkPrimitiveParams(i,[PRIM_NAME]);
        if (linkDescription=="keyHolderPrim") keyHolderPrim=i;
        else if (linkDescription=="keyHolderNamePrim") keyHolderNamePrim=i;
        else if (linkDescription=="flagsPrim") flagsPrim=i;
        //else if (linkDescription=="valuePrim1") valuePrim1=i;
        //else if (linkDescription=="valuePrim2") valuePrim2=i;
        //else if (linkDescription=="valuePrim3") valuePrim3=i;
        //else if (linkDescription=="valuePrim4") valuePrim4=i;
        //else if (linkDescription=="valuePrim5") valuePrim5=i;
        //else if (linkDescription=="valuePrim6") valuePrim6=i;
        //else if (linkDescription=="valuePrim7") valuePrim7=i;
        //else if (linkDescription=="valuePrim8") valuePrim8=i;
        //else if (linkDescription=="valuePrim9") valuePrim9=i;
        //else if (linkDescription=="valuePrim10") valuePrim10=i;
        ++i;
    }
    if (debugMode==TRUE)
    {
        llWhisper(0, "Data prims found:");
        llWhisper(0, "keyHolderPrim: " + (string)keyHolderPrim);
        llWhisper(0, "keyHolderNamePrim: " + (string)keyHolderNamePrim);
        llWhisper(0, "flagsPrim: " + (string)flagsPrim);
        //llWhisper(0, "valuePrim1: " + (string)valuePrim1);
        //llWhisper(0, "valuePrim2: " + (string)valuePrim2);
        //llWhisper(0, "valuePrim3: " + (string)valuePrim3);
        //llWhisper(0, "valuePrim4: " + (string)valuePrim4);
        //llWhisper(0, "valuePrim5: " + (string)valuePrim5);
        //llWhisper(0, "valuePrim6: " + (string)valuePrim6);
        //llWhisper(0, "valuePrim7: " + (string)valuePrim7);
        //llWhisper(0, "valuePrim8: " + (string)valuePrim8);
        //llWhisper(0, "valuePrim9: " + (string)valuePrim9);
        //llWhisper(0, "valuePrim10: " + (string)valuePrim10);
    }

}
getData()
{
    // Get key holder key
    retrievedData=llList2String(llGetLinkPrimitiveParams(keyHolderPrim, [PRIM_DESC]),0);
    retrievedMessage=llBase64ToString(llXorBase64StringsCorrect(retrievedData,llStringToBase64(encryptionKey)));
    keyHolder=(key)retrievedMessage;
    if (keyHolder==" ") keyHolder = NULL_KEY;
    if (debugMode==TRUE) llOwnerSay("Keyholder key: " +  (string)keyHolder);
    // Get key holder name
    retrievedData=llList2String(llGetLinkPrimitiveParams(keyHolderNamePrim, [PRIM_DESC]),0);
    retrievedMessage=llBase64ToString(llXorBase64StringsCorrect(retrievedData,llStringToBase64(encryptionKey)));
    keyHolderName=retrievedMessage;
    if (debugMode==TRUE) llOwnerSay("Keyholder name: " + keyHolderName);
    // Get flags
    retrievedData=llList2String(llGetLinkPrimitiveParams(flagsPrim, [PRIM_DESC]),0);
    retrievedMessage=llBase64ToString(llXorBase64StringsCorrect(retrievedData,llStringToBase64(encryptionKey)));
    flags = llParseString2List(retrievedMessage, ["|"], []);
    // Get values
    //retrievedData=llList2String(llGetLinkPrimitiveParams(valuePrim1, [PRIM_DESC]),0);
    //value1=llBase64ToString(llXorBase64StringsCorrect(retrievedData,llStringToBase64(encryptionKey)));
    //retrievedData=llList2String(llGetLinkPrimitiveParams(valuePrim2, [PRIM_DESC]),0);
    //value2=llBase64ToString(llXorBase64StringsCorrect(retrievedData,llStringToBase64(encryptionKey)));
    //retrievedData=llList2String(llGetLinkPrimitiveParams(valuePrim3, [PRIM_DESC]),0);
    //value3=llBase64ToString(llXorBase64StringsCorrect(retrievedData,llStringToBase64(encryptionKey)));
    //retrievedData=llList2String(llGetLinkPrimitiveParams(valuePrim4, [PRIM_DESC]),0);
    //value4=llBase64ToString(llXorBase64StringsCorrect(retrievedData,llStringToBase64(encryptionKey)));
    //retrievedData=llList2String(llGetLinkPrimitiveParams(valuePrim5, [PRIM_DESC]),0);
    //value5=llBase64ToString(llXorBase64StringsCorrect(retrievedData,llStringToBase64(encryptionKey)));
    //retrievedData=llList2String(llGetLinkPrimitiveParams(valuePrim6, [PRIM_DESC]),0);
    //value6=llBase64ToString(llXorBase64StringsCorrect(retrievedData,llStringToBase64(encryptionKey)));
    //retrievedData=llList2String(llGetLinkPrimitiveParams(valuePrim7, [PRIM_DESC]),0);
    //value7=llBase64ToString(llXorBase64StringsCorrect(retrievedData,llStringToBase64(encryptionKey)));
    //retrievedData=llList2String(llGetLinkPrimitiveParams(valuePrim8, [PRIM_DESC]),0);
    //value8=llBase64ToString(llXorBase64StringsCorrect(retrievedData,llStringToBase64(encryptionKey)));
    //retrievedData=llList2String(llGetLinkPrimitiveParams(valuePrim9, [PRIM_DESC]),0);
    //value9=llBase64ToString(llXorBase64StringsCorrect(retrievedData,llStringToBase64(encryptionKey)));
    //retrievedData=llList2String(llGetLinkPrimitiveParams(valuePrim10, [PRIM_DESC]),0);
    //value10=llBase64ToString(llXorBase64StringsCorrect(retrievedData,llStringToBase64(encryptionKey)));
}
saveData()
{
    // Write key holder key
    //
    data = llXorBase64StringsCorrect(llStringToBase64((string)keyHolder), llStringToBase64(encryptionKey));
    llSetLinkPrimitiveParamsFast(keyHolderPrim, [PRIM_DESC, data]);
    // Write key holder Name
    //
    data = llXorBase64StringsCorrect(llStringToBase64(keyHolderName), llStringToBase64(encryptionKey));
    llSetLinkPrimitiveParamsFast(keyHolderNamePrim, [PRIM_DESC, data]);
    // Write flags
    // We need to assemble the flagString here
    // This will need to be customised to suit the flags required by the device
    //
    // Suggest document flag usage here
    // 0 - lockStatus
    // 1 - keysOnStatus
    //
    string flagsString = (string)lockStatus + "|" + (string)keysOnStatus;
    //flagsString += "|" + (string)blockFarTouch + "|" + (string)blockInventory + "|" + (string)blockEdit
    data = llXorBase64StringsCorrect(llStringToBase64(flagsString), llStringToBase64(encryptionKey));
    llSetLinkPrimitiveParamsFast(flagsPrim, [PRIM_DESC, data]);
    //Write values
    //
    // value1 = some piece of data;
    // value2 = some piece of data;
    //
    //data = llXorBase64StringsCorrect(llStringToBase64(value1), llStringToBase64(encryptionKey));
    //llSetLinkPrimitiveParamsFast(valuePrim1, [PRIM_DESC, data]);
    //data = llXorBase64StringsCorrect(llStringToBase64(value2), llStringToBase64(encryptionKey));
    //llSetLinkPrimitiveParamsFast(valuePrim2, [PRIM_DESC, data]);
    //data = llXorBase64StringsCorrect(llStringToBase64(value3), llStringToBase64(encryptionKey));
    //llSetLinkPrimitiveParamsFast(valuePrim3, [PRIM_DESC, data]);
    //data = llXorBase64StringsCorrect(llStringToBase64(value4), llStringToBase64(encryptionKey));
    //llSetLinkPrimitiveParamsFast(valuePrim4, [PRIM_DESC, data]);
    //data = llXorBase64StringsCorrect(llStringToBase64(value5), llStringToBase64(encryptionKey));
    //llSetLinkPrimitiveParamsFast(valuePrim5, [PRIM_DESC, data]);
    //data = llXorBase64StringsCorrect(llStringToBase64(value6), llStringToBase64(encryptionKey));
    //llSetLinkPrimitiveParamsFast(valuePrim6, [PRIM_DESC, data]);
    //data = llXorBase64StringsCorrect(llStringToBase64(value7), llStringToBase64(encryptionKey));
    //llSetLinkPrimitiveParamsFast(valuePrim7, [PRIM_DESC, data]);
    //data = llXorBase64StringsCorrect(llStringToBase64(value8), llStringToBase64(encryptionKey));
    //llSetLinkPrimitiveParamsFast(valuePrim8, [PRIM_DESC, data]);
    //data = llXorBase64StringsCorrect(llStringToBase64(value9), llStringToBase64(encryptionKey));
    //llSetLinkPrimitiveParamsFast(valuePrim9, [PRIM_DESC, data]);
    //data = llXorBase64StringsCorrect(llStringToBase64(value10), llStringToBase64(encryptionKey));
    //llSetLinkPrimitiveParamsFast(valuePrim10, [PRIM_DESC, data]);
    if (debugMode==TRUE)
    {
        llOwnerSay("Data written");
        llOwnerSay("Flags: " + flagsString);
    }
}
processData()
{
    // This section is used to map the retrieved data (values and flags)
    // to the variables used in the script.
    //
    // Process flag data
    //
    // Suggest document flag usage here
    // 0 - lockStatus
    // 1 - keysOnStatus
    //
    lockStatus=llList2Integer(flags, 0);
    keysOnStatus=llList2Integer(flags, 1);
    //
    // Process values
    // some piece of data = value1;
    // some piece of data = value2;

    if (lockStatus==TRUE)
    {
        showKeys(FALSE);
        showLocks(TRUE);
        if (rlvEnabled==TRUE) llOwnerSay(rlvLockCommands);
    }
    else
    {
        showKeys(FALSE);
        showLocks(FALSE);
        if (rlvEnabled==TRUE) llOwnerSay("@clear");
    }
    if (keysOnStatus==TRUE)
    {
        showKeys(TRUE);
    }
    else
    {
        showKeys(FALSE);
    }
        


    //At the end check status of resetPrimData and if TRUE force the keys on and make keyholder NULL
    if (resetPrimData==TRUE)
    {
        keysOnStatus=TRUE;
        keyHolder=NULL_KEY;
        keyHolderName="";
        saveData();
        llWhisper(0, "Prim data reset.  Please remember to set 'resetPrimData' to FALSE to ensure correct operation.");
    }
}

//Function to generate status message for dialogues
generateStatusMessage()
{
    if (lockStatus==TRUE) statusMessage = "\n\n" + deviceName + " is locked, ";
    else statusMessage = deviceName + " is unlocked, ";
    statusMessage += "\n\nkeys are ";
    if (keysOnStatus==TRUE) statusMessage += "on.";
    else statusMessage += "taken by " + keyHolderName + ".";

}


//Function to change colour of parts
colourPart(string partName, string colour)
{
    integer i=1;
    if (colour=="blue") vectColour=blue;
    if (colour=="lightblue") vectColour=lightblue;
    if (colour=="darkblue") vectColour=darkblue;
    if (colour=="green") vectColour=green;
    if (colour=="lightgreen") vectColour=lightgreen;
    if (colour=="darkgreen") vectColour=darkgreen;
    if (colour=="black") vectColour=black;
    if (colour=="lightblack") vectColour=lightblack;
    if (colour=="darkblack") vectColour=darkblack;
    if (colour=="pink") vectColour=pink;
    if (colour=="lightpink") vectColour=lightpink;
    if (colour=="darkpink") vectColour=darkpink;
    if (colour=="red") vectColour=red;
    if (colour=="lightred") vectColour=lightred;
    if (colour=="darkred") vectColour=darkred;
    if (colour=="purple") vectColour=purple;
    if (colour=="lightpurple") vectColour=lightpurple;
    if (colour=="darkpurple") vectColour=darkpurple;
    if (colour=="white") vectColour=white;
    if (colour=="lightwhite") vectColour=lightwhite;
    if (colour=="darkwhite") vectColour=darkwhite;
    if (colour=="yellow") vectColour=yellow;
    if (colour=="lightyellow") vectColour=lightyellow;
    if (colour=="darkyellow") vectColour=darkyellow;
    if (colour=="orange") vectColour=orange;
    if (colour=="lightorange") vectColour=lightorange;
    if (colour=="darkorange") vectColour=darkorange;
     while (i <= llGetNumberOfPrims()) 
     {
        linkDescription=(string)llGetLinkPrimitiveParams(i,[PRIM_DESC]);
        if (linkDescription==partName)
        {
            llSetLinkColor(i,vectColour,ALL_SIDES);
        }
        ++i;
     }
    
}

//Function to display main Menu
displayMainMenu (key ID)
{
    generateStatusMessage();
    menuMessage=statusMessage;
    menuLevel="main";
    if (ID==keyHolder || keysOnStatus==TRUE || ID==wearer)
    {
        llListenRemove(listenHandleMenu);
        menuChannel = (integer)(llFrand(-1000000000.0) - 1000000000.0);
        menuMain=[];
        if (ID==keyHolder || keysOnStatus==TRUE)
        {
            if (keysOnStatus==TRUE) menuMain=["take keys"];
            else menuMain=["leave keys"];
            if (lockStatus==TRUE) menuMain += ["unlock"];
            else menuMain += ["lock"];
        }
        menuMain += ["colour", "reset"];
        llDialog(ID, menuMessage, menuMain, menuChannel);
        listenHandleMenu = llListen( menuChannel, "", ID, "");
        menuExpireTime=llGetUnixTime() + 60;
    }
}

//Function to display colour menu
displayColourMenu (key ID)
{
        menuLevel="colour";
        llListenRemove(listenHandleMenu);
        menuChannel = (integer)(llFrand(-1000000000.0) - 1000000000.0);
        llDialog(ID, menuMessage, menuColour, menuChannel);
        listenHandleMenu = llListen( menuChannel, "", ID, "");
        menuExpireTime=llGetUnixTime() + 60;
}
//Function to display colour shades menu
displayShadesMenu (key ID)
{
        menuLevel="shades";
        llListenRemove(listenHandleMenu);
        menuChannel = (integer)(llFrand(-1000000000.0) - 1000000000.0);
        llDialog(ID, menuMessage, menuShades, menuChannel);
        listenHandleMenu = llListen( menuChannel, "", ID, "");
        menuExpireTime=llGetUnixTime() + 60;
}
//Function to display belt parts menu for colouring
displayPartsMenu (key ID)
{
    if (ID==llGetOwner())
    {
        menuLevel="parts";
        llListenRemove(listenHandleMenu);
        menuChannel = (integer)(llFrand(-1000000000.0) - 1000000000.0);
        llDialog(ID, menuMessage, menuParts, menuChannel);
        listenHandleMenu = llListen( menuChannel, "", ID, "");
        menuExpireTime=llGetUnixTime() + 60;
    }
}

default
{
    state_entry()
    {
        wearer=llGetOwner();
        wearerName=llKey2Name(wearer);
        getDataPrims();
        getData();
        processData();
        llSetTimerEvent (10.0);
    }
    touch_start(integer total_number)
    {
        displayMainMenu(llDetectedKey(0));
    }
    listen(integer channel, string name, key id, string message)
    {
        llListenRemove(listenHandleMenu);
        if (menuLevel=="parts")
        {
            if (message != "back")
            {
                selectedPartName=message;
                displayColourMenu(id);
            }
            else displayMainMenu(id);
            return;
        }
        if (menuLevel=="colour")
        {
            if (message != "back")
            {
                selectedColourName=message;
                displayShadesMenu(id);
            }
            else displayPartsMenu(id);
            return;
        }
        if (menuLevel=="shades")
        {
            if (message != "back")
            {
                if (message != "normal") selectedColourName = message + selectedColourName;
                if (debugMode==TRUE) llWhisper (0, selectedPartName + " " + selectedColourName);
                colourPart(selectedPartName, selectedColourName);
                displayPartsMenu(id);
            }
            else displayColourMenu(id);
            return;
        }
        if (menuLevel=="main")
        {
            if (message=="colour")
            {
                displayPartsMenu(id);
                return;
            }
            if (message=="take keys")
            {
                keyHolder=id;
                keyHolderName=llKey2Name(id);
                keysOnStatus=FALSE;
                showKeys(FALSE);
                llWhisper(0, keyHolderName + " has taken the keys from " + wearerName + "'s " + deviceName + " ensuring only they have access.");
                saveData();
                displayMainMenu(id);
                return;
            }
             if (message=="leave keys")
            {
                llWhisper(0, keyHolderName + " has left the keys on " + wearerName + "'s " + deviceName + " allowing anyone access.");
                showKeys(TRUE);
                keyHolder=wearer;
                keyHolderName=llKey2Name(id);
                keysOnStatus=TRUE;
                saveData();
                displayMainMenu(id);
                return;
            }
            if (message=="lock")
            {
                llWhisper(0, keyHolderName + " has locked " + wearerName + "'s " + deviceName + " preventing it from being it removed.");
                showKeys(FALSE);
                showLocks(TRUE);
                keyHolder=id;
                keyHolderName=llKey2Name(id);
                keysOnStatus=FALSE;
                lockStatus=TRUE;
                if (rlvEnabled==TRUE) llOwnerSay(rlvLockCommands);
                saveData();
                displayMainMenu(id);
                return;
            }
             if (message=="unlock")
            {
                llWhisper(0, keyHolderName + " has unlocked " + wearerName + "'s " + deviceName + " allowing it to be removed.");
                showKeys(FALSE);
                showLocks(FALSE);
                keysOnStatus=FALSE;
                lockStatus=FALSE;
                if (rlvEnabled==TRUE) llOwnerSay("@clear");
                saveData();
                displayMainMenu(id);
                return;
            }
            if (message=="reset")
            {
                llResetScript();
            }
            
        }
            
    }
    



    timer()
    {
        if (llGetUnixTime() >= menuExpireTime) llListenRemove(listenHandleMenu);
    }
    on_rez (integer startParam)
    {
        llResetScript();
    }
    changed (integer iChange)
    {
        if (iChange & CHANGED_TELEPORT) llResetScript();
        if (iChange & CHANGED_REGION) llResetScript();
    }
}