string name;

goto(vector pos) {
    integer channel = llRound(llFrand(99999)) + 1000;
    llRezObject("Destination Orb", llGetPos() + <1,0,0>, ZERO_VECTOR, ZERO_ROTATION, channel);
    llSleep(.5);
    llSay(channel, (string)pos);
}

default {
    link_message(integer sender_num, integer num, string str, key id) {
        list command = llParseString2List(str, [" "], []);
        string Dest = llList2String(command, 1);
        if(llList2String(command, 0) == "!list") {
            llMessageLinked(LINK_SET, 1000, "goto <name> - create a rideable orb that will take you to somebody", "");
        } else if(Dest == "#atm") {
            goto(<113,135,57>);
        } else if(Dest == "#river") {
            goto(<181,196,29>);
        } else if(Dest == "#retail") {
            goto(<152,113,57>);
        } else if(Dest == "#fac") {
            goto(<134,192,57>);
        } else if(Dest == "#void") {
            goto(<69,243,496>);
        } else if(Dest == "#vegatower") {
            goto(<185,56,85>);
        } else if(Dest == "#house") {
            goto(<205,128,35>);
        } else if(Dest == "#office") {
            goto(<129,198,87>);
        } else if(Dest == "#park") {
            goto(<112, 63, 58>);
        } else if(num == 0 && llList2String(command, 0) == "!goto") {
            name = llToLower(Dest);
            llSensor("", NULL_KEY, AGENT, 96, PI);
        }
    }
    
    sensor(integer num) {
        integer x;
        for(x=0;x<num;x++) {
            string detectname = llToLower(llDetectedName(x));
            if(llSubStringIndex(detectname, name) == 0) {
                goto(llDetectedPos(x));
            }
        }
    }
}

 