//=========================================================================
// Garble Hearing script 1.3.6 
//
//Revision history:
//
// 1.31 Removed listener when exiting muffled state.
//      This was causing DEAF to fail becasue muffled sounds still heard
//
//
//
//
integer listen_handle_monitor;
key wearer;
float distance;
string msg_rec;

// ==================
// MUFFLE CHANNEL

// Send a gagged-speech version of a message to the open channel.
integer mumble(string mes, integer severity)
{
    // Iterate through the speech, mushing up the wearer's diction.
    integer i;
    string sub = "";
    string rep = "";
    for (i = 0; i < llStringLength(mes); i++)
    {
        sub = llGetSubString(mes, i, i);
        rep = "";

        if (severity == 0)
        {
            if (sub == "l")
                rep = "w";
            else
                if (sub == "L")
                    rep = "W";
            else
                if (sub == "s")
                    rep = "f";
            else
                if (sub == "S")
                    rep = "F";
            else
                if (sub == "t")
                    rep = "g";
            else
                if (sub == "T")
                    rep = "G";
        }
        else
            if (severity == 1)
            {
                if (sub == "r" || sub == "l" || sub == "q" || sub == "j" || sub == "d")
                    rep = "w";
                else
                    if (sub == "R" || sub == "L" || sub == "Q" || sub == "J" || sub == "D")
                        rep = "W";
                else
                    if (sub == "s")
                        rep = "f";
                else
                    if (sub == "S")
                        rep = "F";
                else
                    if (sub == "b" | sub == "t")
                        rep = "g";
                else
                    if (sub == "B" | sub == "T")
                        rep = "G";
            }
        else
            if (severity == 2)
            {
                if (sub == "r" || sub == "l" || sub == "q" || sub == "j" || sub == "d")
                    rep = "w";
                else
                    if (sub == "R" || sub == "L" || sub == "Q" || sub == "J" || sub == "D")
                        rep = "W";
                else
                    if (sub == "s")
                        rep = "f";
                else
                    if (sub == "S")
                        rep = "F";
                else
                    if (sub == "b" | sub == "t" | sub == "h" | sub == "d" | sub == "c" | sub == "k" | sub == "v")
                        rep = "g";
                else
                    if (sub == "B" | sub == "T" | sub == "H" | sub == "D" | sub == "C" | sub == "K" | sub == "V")
                        rep = "G";
            }
        else
        {
            llOwnerSay("Tried to use an unsupported muffle algorithm called '" + (string)severity + "'.");
        }

        // Replace character if necessary.
        if (rep != "")
        {
            mes = llDeleteSubString(mes, i, i);
            mes = llInsertString(mes, i, rep);
        }
    }

    // Broadcast the muffled speech on the chat channel.
    llInstantMessage (wearer, mes);

    return TRUE;
}

default
{
    state_entry()
    {
    }
    link_message(integer sender_num, integer num, string str, key id)
    {
        //llOwnerSay((string)num + " " + str);
        if (num==9988 && str=="MUFFLE")
        {
            state muffle_on;
        }
        else if (num=9988 && str=="NORM")
        {
            state muffle_off;
        }
        else if (num=9988 && str=="DEAF")
        {
            state deaf;
        }
        else if (num=9988 && str=="RESET")
        {
            llOwnerSay("Hearing script received reset message...");
            llResetScript();
        }
    }
    on_rez (integer startParam)
    {
        llResetScript();
    }
    attach (key attachKey)
    {
        if (attachKey != NULL_KEY)
        {
            llResetScript();
        }
    }
    changed (integer iChange)
    {
        if (iChange & CHANGED_TELEPORT)
        {
            llResetScript();
        }
        if (iChange & CHANGED_REGION)
        {
            llResetScript();
        }
    }
}


state muffle_off
{
    state_entry ()
    {
        wearer=llGetOwner();
        llOwnerSay("@recvchat_sec=y,recvemote_sec=y");
    }
    link_message(integer sender_num, integer num, string str, key id)
    {
        if (num==9988 && str=="MUFFLE")
        {
            state muffle_on;
        }
        else if (num=9988 && str=="NORM")
        {
            state muffle_off;
        }
        else if (num=9988 && str=="DEAF")
        {
            state deaf;
        }
        else if (num=9988 && str=="RESET")
        {
            llOwnerSay("Hearing script received reset message...");
            llResetScript();
        }
    }
    on_rez (integer startParam)
    {
        llResetScript();
    }
    attach (key attachKey)
    {
        if (attachKey != NULL_KEY)
        {
            llResetScript();
        }
    }
    changed (integer iChange)
    {
        if (iChange & CHANGED_TELEPORT)
        {
            llResetScript();
        }
        if (iChange & CHANGED_REGION)
        {
            llResetScript();
        }
    }

}



state muffle_on
{
    state_entry ()
    {
        wearer=llGetOwner();
        listen_handle_monitor=llListen(0,"", "", "");
        llOwnerSay("@recvchat_sec=n,recvemote_sec=n");
    }
    link_message(integer sender_num, integer num, string str, key id)
    {
        if (num==9988 && str=="MUFFLE")
        {
            state muffle_on;
        }
        else if (num=9988 && str=="NORM")
        {
            state muffle_off;
        }
        else if (num=9988 && str=="DEAF")
        {
            state deaf;
        }
        else if (num=9988 && str=="RESET")
        {
            llOwnerSay("Hearing script received reset message...");
            llResetScript();
        }
    }
    on_rez (integer startParam)
    {
        llResetScript();
    }
    attach (key attachKey)
    {
        if (attachKey != NULL_KEY)
        {
            llResetScript();
        }
    }
    changed (integer iChange)
    {
        if (iChange & CHANGED_TELEPORT)
        {
            llResetScript();
        }
        if (iChange & CHANGED_REGION)
        {
            llResetScript();
        }
    }
    state_exit ()
    {
        llListenRemove(listen_handle_monitor);
        llOwnerSay("@recvchat_sec=y");
    }
    listen(integer channel, string name, key id, string message)
    {
        msg_rec=message;
        llSensor("", id, AGENT, 20, PI);


    }
    sensor(integer total_number)
    {
        distance=llVecDist(llDetectedPos(0), llGetPos());
        if (distance < 5)         mumble ( msg_rec, 0);
        else if (distance <10)         mumble ( msg_rec, 1);
        else if (distance <20)         mumble ( msg_rec, 2);
    }

}

state deaf
{
    state_entry ()
    {
        wearer=llGetOwner();
        llOwnerSay("@recvchat_sec=n,recvemote_sec=n");
    }
    link_message(integer sender_num, integer num, string str, key id)
    {
        if (num==9988 && str=="MUFFLE")
        {
            state muffle_on;
        }
        else if (num=9988 && str=="NORM")
        {
            state muffle_off;
        }
        else if (num=9988 && str=="DEAF")
        {
            state deaf;
        }
        else if (num=9988 && str=="RESET")
        {
            llOwnerSay("Hearing script received reset message...");
            llResetScript();
        }
    }
    on_rez (integer startParam)
    {
        llResetScript();
    }
    attach (key attachKey)
    {
        if (attachKey != NULL_KEY)
        {
            llResetScript();
        }
    }
    changed (integer iChange)
    {
        if (iChange & CHANGED_TELEPORT)
        {
            llResetScript();
        }
        if (iChange & CHANGED_REGION)
        {
            llResetScript();
        }
    }
}
