//Jetpack Script made by qarl of qLab
//modified (barely) by Aaack Straaf

qUserError(string message)
{
  llOwnerSay(message);
}




__qError(string error, string file, integer line)
{
  llOwnerSay(error + ":" + 
          llGetScriptName() + ":" +
          file + "(" +
          (string)line + ")");
}


integer __qDebugLevel = 0;

qDebugSetLevel(integer level)
{
  __qDebugLevel = level;
}



__qDebug(string message, integer level, string file, integer line)
{
  if (level < __qDebugLevel)
    __qError("DEBUG: " + message, file, line);
}


key wearer;

float hoverEngine;
float thrustEngine;
float acceleration;

// logic

integer qJPIsWorn()
{
  if (wearer == NULL_KEY)
    return FALSE;
  else
    return TRUE;
}


integer qJPIsFlying()
{
  if (!qJPIsWorn())
    return FALSE;
  else
    return (llGetAgentInfo(wearer) & AGENT_FLYING);
}


qJPSetWearer(key user)
{
  wearer = user;

  if (qJPIsWorn())
    {
      llSetStatus(STATUS_PHYSICS, TRUE);
      llRequestPermissions(user, PERMISSION_TAKE_CONTROLS);
    }

  else
    {
      llSetStatus(STATUS_PHYSICS, FALSE);
      llReleaseControls();
    }
}


// actions



qJPEngineTimer()
{
  float speed = ((0.3 * hoverEngine) +
         (1.2 * thrustEngine) +
         (0.5)) * qJPIsFlying();
}



qJPHover(integer hover)
{
  __qDebug("hover=" + (string)hover,  20, "jetpack.lsl", 67);
  if (hover)
    {
      llSetForce(<0, 0, 9.8 * llGetMass()>, FALSE);
      hoverEngine = 1;
    }
  else
    {
      llSetForce(<0, 0, 0>, FALSE);
      hoverEngine = 0;
    }
}



qJPHoverTimer()
{
  integer shouldHover = FALSE;

  if (qJPIsFlying())
      {
    __qDebug("flying",  20, "jetpack.lsl", 88);
    vector position = llGetPos();
    float ground    = llGround(<0,0,0>);
    
    if ((position.z > 75) && (position.z > (ground + 35)))
      shouldHover = TRUE;
      }

  qJPHover(shouldHover);
}




// event handlers

qJPAttach(key user)
{
  qJPSetWearer(user);
}


qJPRunTimePermissions(integer permissions)
{
  if (llGetPermissions() & PERMISSION_TAKE_CONTROLS)

    llTakeControls(CONTROL_DOWN |
           CONTROL_UP |
           CONTROL_FWD |
           CONTROL_BACK,
           TRUE, TRUE);
}

qJPControl(key user, integer hold, integer change)
{
  if (user != wearer)
    return;  // commands from boss only, please

  if (!qJPIsFlying())
    return; // and only if we're flying

  vector thrust;

  if ((hold & CONTROL_UP) ||
      (hold & CONTROL_DOWN) ||
      (hold & CONTROL_FWD) ||
      (hold & CONTROL_BACK))
    acceleration += 0.1;
  else
    acceleration = 0;


  if (hold & CONTROL_UP)
    thrust += <0, 0, 2.0>;

  if (hold & CONTROL_DOWN)
    thrust += <0, 0, -0.5>;

  if (hold & CONTROL_FWD)
    thrust += <0.1, 0, 0>;

  if (hold & CONTROL_BACK)
    thrust += <-0.1, 0, 0>;

  
  llApplyImpulse(acceleration * thrust * llGetMass(), TRUE);
  thrustEngine = llVecMag(acceleration * thrust);

}


qJPStateEntry()
{
  llSetTimerEvent(1.0);
}


qJPTimer()
{
  qJPHoverTimer();
  qJPEngineTimer();
}



default
{
  state_entry()
    {
      qDebugSetLevel(0);
      qJPStateEntry();
    }

  timer()
    {
      qJPTimer();
    }

  attach(key user)
    {
      qJPAttach(user);
    }

  run_time_permissions(integer permissions)
    {
      qJPRunTimePermissions(permissions);
    }

  control(key user, integer hold, integer change)
    {
      qJPControl(user, hold, change);
    }
}