//NPC Chatterbot script using the Pandorabot by A.L.I.C.E. AI Foundation.
//Original script by Juicy Babii, fixed and polished by Adelle Fitzgerald with help from Roken Price by fixing up the str_replace :-)
//If you intend to use this script for anything other than a quick test then please register your own bot at www.pandorabots.com where you will be able to train it and manage it.

//This script is specifically for use with an NPC. When you create your NPC appearance make sure you are wearing this prim, so the NPC also wears it.

//!!!!!! Please also note that you Have to enable 'Allow_osNpcSay = true' in your opensim.ini. Do this at your own risk as it does open up the potential for other users to abuse your NPC's chat. !!!!!!!

key owner;
key requestId;
integer listening;
string custid;
string message;
string botId="fc8b11fdee349877"; //Your registered bot ID (see www.pandorabots.com)
string botURL="http://www.pandorabots.com/pandora/talk-xml";

string str_replace(string src, string from, string to)  //replaces all occurrences of 'from' with 'to' in 'src'.
{
    integer len = (~-(llStringLength(from)));
    if(~len)
    {
        string  buffer = src;
        integer b_pos = -1;
        integer to_len = (~-(llStringLength(to)));
        @loop;
        integer to_pos = ~llSubStringIndex(buffer, from);
        if(to_pos)
        {
            b_pos -= to_pos;
            src = llInsertString(llDeleteSubString(src, b_pos, b_pos + len), b_pos, to);
            b_pos += to_len;
            buffer = llGetSubString(src, (-~(b_pos)), 0x8000);
            jump loop;
        }
    }
    return src;
} 
   
default
{
   state_entry()
   {
       owner = llGetOwner();
        listening = llListen( 0, "", NULL_KEY, "" );
        custid = "";
   }

   touch_start(integer total_number)
   {
        llWhisper(0, "Talk to me in Local Chat.");
   }

   listen(integer channel, string name, key id, string msg)
   {
       if (id != owner) //We don't want the NPC to talk to itself!
       {
            custid=name;
            llListenRemove(listening);
            llSetTimerEvent(2.0); //Increase this timer if you experience errors.
            message = msg;
        }
   }
   

   
   timer()
   {
        requestId = llHTTPRequest(botURL,[HTTP_METHOD,"POST", HTTP_MIMETYPE, "application/x-www-form-urlencoded"], "input=" + message + "&botid=" + botId + "&custid=" + custid);
        llSetTimerEvent(0.0);
        listening=llListen( 0, "", NULL_KEY, "" );
    }

    http_response(key request_id, integer status, list metadata, string body)
    {
       if (request_id == requestId)
       {
           if(body == "error")
           {
                llWhisper(0, "An error occurred. Please try again later");
           }
           else
           {
                integer start = llSubStringIndex(body, "<that>");
                integer end   = llSubStringIndex(body, "</that>");
                list lines;
                if (start != -1 && end != -1)
                {
                    string msglines = llGetSubString(body, start+6, end-1);
                    msglines = str_replace(msglines, "&quot;","'");
                    msglines = str_replace(msglines, "&amp;lt;","<");
                    msglines = str_replace(msglines, "&amp;gt;",">");
                    msglines = str_replace(msglines, ", .",".");
                    lines = llParseString2List(msglines, ["&lt;br&gt; ", "&lt;br&gt;"],[""]);
                    integer i;
                    string output;
                    for (i = 0; i < llGetListLength(lines); i++)
                    {
                        output += llList2String(lines, i);
                        if (i < llGetListLength(lines) - 1) output = output + "\n";
                    }
                    osNpcSay(owner, output);
                }
            }
        }
        else
        {
            llWhisper(0, "An error occurred. Please try again later");
        }
    }
    
    on_rez(integer start_param)
    {
        llResetScript();
    }
}