integer wind = FALSE;
string texture;
key target = "";
vector startSize = <.1,.1,.1>;
vector startColor;
float startAlpha = 1;
integer show = FALSE;
float rate = .01;
float radius = .1;
vector push = <0,0,-0.01>;
integer pattern = PSYS_SRC_PATTERN_EXPLODE;
float outerAngle = 1.54;
key open = "912e09d1-dd27-4e19-b848-ac5419a30a98";
integer opaco = TRUE;
vector omega = <0,0,10>;
integer nieve = FALSE;
float minSpeed = 0;
float maxSpeed = 0.2;
float life = 0;
integer interpSize = TRUE;
integer interpColor = TRUE;
float innerAngle = 1.55;
integer glow = TRUE;
integer fono;
integer followVel = FALSE;
integer followSource = FALSE;
integer flags;
integer estado = FALSE;
vector endSize = <.1,.1,.1>;
vector endColor;
float endAlpha = 1;
integer count = 3;
key close = "9507a170-20f9-4bbf-a018-e5d5595e4ade";
integer briyo = FALSE;
integer bounce = FALSE;
float age = 10;




use_color( integer index )
{
    startColor = fetch_color (index);
    endColor = startColor;
    llSetLinkPrimitiveParams(LINK_SET, [ PRIM_COLOR, ALL_SIDES, startColor, 1 ]);
}


updateParticles()
{
    flags = 0;
    if (target == "owner")
    {
        target = llGetOwner();
    }
    if (target == "self")
    {
        target = llGetKey();
    }
    if (glow)
    {
        flags = flags | PSYS_PART_EMISSIVE_MASK;
    }
    if (bounce)
    {
        flags = flags | PSYS_PART_BOUNCE_MASK;
    }
    if (interpColor)
    {
        flags = flags | PSYS_PART_INTERP_COLOR_MASK;
    }
    if (interpSize)
    {
        flags = flags | PSYS_PART_INTERP_SCALE_MASK;
    }
    if (wind)
    {
        flags = flags | PSYS_PART_WIND_MASK;
    }
    if (followSource)
    {
        flags = flags | PSYS_PART_FOLLOW_SRC_MASK;
    }
    if (followVel)
    {
        flags = flags | PSYS_PART_FOLLOW_VELOCITY_MASK;
    }
    if (target != "")
    {
        flags = flags | PSYS_PART_TARGET_POS_MASK;
    }
    llParticleSystem
    ([
    PSYS_PART_MAX_AGE,age,
    PSYS_PART_FLAGS,flags,
    PSYS_PART_START_COLOR, startColor,
    PSYS_PART_END_COLOR, endColor,
    PSYS_PART_START_SCALE,startSize,
    PSYS_PART_END_SCALE,endSize,
    PSYS_SRC_PATTERN, pattern,
    PSYS_SRC_BURST_RATE,rate,
    PSYS_SRC_ACCEL, push,
    PSYS_SRC_BURST_PART_COUNT,count,
    PSYS_SRC_BURST_RADIUS,radius,
    PSYS_SRC_BURST_SPEED_MIN,minSpeed,
    PSYS_SRC_BURST_SPEED_MAX,maxSpeed,
    PSYS_SRC_TARGET_KEY,target,
    PSYS_SRC_INNERANGLE,innerAngle,
    PSYS_SRC_OUTERANGLE,outerAngle,
    PSYS_SRC_OMEGA, omega,
    PSYS_SRC_MAX_AGE, life,
    PSYS_SRC_TEXTURE, texture,
    PSYS_PART_START_ALPHA, startAlpha,
    PSYS_PART_END_ALPHA, endAlpha
    ]);
}


store_color( integer index, vector data )
{
    llSetLinkPrimitiveParamsFast( index + 2, [ PRIM_DESC, (string)data ]);
}


rot_volando()
{
    /*LV*/ llSetLinkPrimitiveParamsFast( (3), [ PRIM_ROT_LOCAL, ((<0.08574, 0.72812, 0.03664, 0.67908>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (5), [ PRIM_ROT_LOCAL, ((<0.10629, 0.68643, 0.17473, 0.69785>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (6), [ PRIM_ROT_LOCAL, ((<0.19914, 0.68953, 0.12996, 0.68411>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (9), [ PRIM_ROT_LOCAL, ((<0.12996, 0.68412, 0.19914, 0.68952>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (11), [ PRIM_ROT_LOCAL, ((<0.17472, 0.69785, 0.10628, 0.68643>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (16), [ PRIM_ROT_LOCAL, ((<0.15488, 0.70744, 0.08966, 0.68374>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (17), [ PRIM_ROT_LOCAL, ((<0.10201, 0.68094, 0.16678, 0.70576>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (19), [ PRIM_ROT_LOCAL, ((<0.18122, 0.68966, 0.11187, 0.69211>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (21), [ PRIM_ROT_LOCAL, ((<0.14184, 0.68355, 0.21122, 0.68413>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (22), [ PRIM_ROT_LOCAL, ((<0.20523, 0.68655, 0.13588, 0.68416>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (25), [ PRIM_ROT_LOCAL, ((<0.10582, 0.69186, 0.17523, 0.69241>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (26), [ PRIM_ROT_LOCAL, ((<0.14184, 0.68233, 0.21121, 0.68535>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (31), [ PRIM_ROT_LOCAL, ((<0.14488, 0.69638, 0.07553, 0.69883>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (32), [ PRIM_ROT_LOCAL, ((<0.11414, 0.70566, 0.04519, 0.69783>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (33), [ PRIM_ROT_LOCAL, ((<0.07618, 0.70411, 0.14534, 0.69087>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (34), [ PRIM_ROT_LOCAL, ((<0.04578, 0.70859, 0.11459, 0.69475>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (42), [ PRIM_ROT_LOCAL, ((<0.04675, 0.70674, -0.02264, 0.70556>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (43), [ PRIM_ROT_LOCAL, ((<0.07747, 0.70706, 0.00821, 0.70285>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (44), [ PRIM_ROT_LOCAL, ((<-0.02741, 0.71551, 0.04012, 0.69692>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (45), [ PRIM_ROT_LOCAL, ((<0.00276, 0.71190, 0.07141, 0.69863>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (54), [ PRIM_ROT_LOCAL, ((<0.01592, 0.70508, -0.05345, 0.70693>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (55), [ PRIM_ROT_LOCAL, ((<-0.02108, 0.70132, -0.09026, 0.70679>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (56), [ PRIM_ROT_LOCAL, ((<-0.06448, 0.71429, 0.00306, 0.69686>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (57), [ PRIM_ROT_LOCAL, ((<-0.09584, 0.70958, -0.02723, 0.69755>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (58), [ PRIM_ROT_LOCAL, ((<-0.05807, 0.69563, -0.12686, 0.70472>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (67), [ PRIM_ROT_LOCAL, ((<-0.08257, 0.69079, -0.15101, 0.70227>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (68), [ PRIM_ROT_LOCAL, ((<-0.12454, 0.71298, -0.05949, 0.68747>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (69), [ PRIM_ROT_LOCAL, ((<-0.16124, 0.70660, -0.09599, 0.68228>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (70), [ PRIM_ROT_LOCAL, ((<-0.18579, 0.70104, -0.12040, 0.67788>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (71), [ PRIM_ROT_LOCAL, ((<-0.11919, 0.68195, -0.18693, 0.69699>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (72), [ PRIM_ROT_LOCAL, ((<-0.15083, 0.66913, -0.21516, 0.69514>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (76), [ PRIM_ROT_LOCAL, ((<-0.25030, 0.69035, -0.20863, 0.64594>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (77), [ PRIM_ROT_LOCAL, ((<-0.22047, 0.69494, -0.15732, 0.66612>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (78), [ PRIM_ROT_LOCAL, ((<-0.18148, 0.65803, -0.24358, 0.68900>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (79), [ PRIM_ROT_LOCAL, ((<-0.31074, 0.66807, -0.25562, 0.62593>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (80), [ PRIM_ROT_LOCAL, ((<-0.22667, 0.64435, -0.29123, 0.66979>)) ]);
    /*LV*/ llSetLinkPrimitiveParamsFast( (81), [ PRIM_ROT_LOCAL, ((<-0.29582, 0.60584, -0.34826, 0.65128>)) ]);
}

rot_plegado()
{
    /*LP*/ llSetLinkPrimitiveParamsFast( (3), [ PRIM_ROT_LOCAL, ((<0.63619, -0.36438, 0.61032, -0.29999>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (5), [ PRIM_ROT_LOCAL, ((<0.71578, 0.13673, -0.68445, -0.02229>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (6), [ PRIM_ROT_LOCAL, ((<-0.65202, 0.20045, 0.72535, -0.09250>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (9), [ PRIM_ROT_LOCAL, ((<0.72828, -0.02143, -0.67323, 0.12615>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (11), [ PRIM_ROT_LOCAL, ((<-0.67747, 0.00145, 0.72052, 0.14792>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (16), [ PRIM_ROT_LOCAL, ((<-0.66971, -0.12377, 0.69184, 0.23985>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (17), [ PRIM_ROT_LOCAL, ((<0.69523, 0.22149, -0.67117, -0.13090>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (19), [ PRIM_ROT_LOCAL, ((<-0.66239, 0.20538, 0.71170, -0.11200>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (21), [ PRIM_ROT_LOCAL, ((<0.71734, -0.12212, -0.65010, 0.21883>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (22), [ PRIM_ROT_LOCAL, ((<-0.64529, 0.22325, 0.72109, -0.11742>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (25), [ PRIM_ROT_LOCAL, ((<0.71900, -0.08214, -0.66435, 0.18690>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (26), [ PRIM_ROT_LOCAL, ((<0.71236, -0.15397, -0.63885, 0.24639>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (31), [ PRIM_ROT_LOCAL, ((<-0.66375, 0.21950, 0.70233, -0.13415>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (32), [ PRIM_ROT_LOCAL, ((<-0.64084, 0.26935, 0.69632, -0.17868>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (33), [ PRIM_ROT_LOCAL, ((<0.69209, -0.14891, -0.66860, 0.22761>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (34), [ PRIM_ROT_LOCAL, ((<0.68526, -0.17938, -0.64847, 0.27879>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (42), [ PRIM_ROT_LOCAL, ((<-0.61781, 0.34024, 0.66520, -0.24508>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (43), [ PRIM_ROT_LOCAL, ((<-0.64570, 0.28383, 0.68348, -0.18805>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (44), [ PRIM_ROT_LOCAL, ((<0.65985, -0.22926, -0.62801, 0.34299>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (45), [ PRIM_ROT_LOCAL, ((<0.66046, -0.24247, -0.62889, 0.33090>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (54), [ PRIM_ROT_LOCAL, ((<-0.62471, 0.33657, 0.65910, -0.24909>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (55), [ PRIM_ROT_LOCAL, ((<-0.60661, 0.37559, 0.63390, -0.29855>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (56), [ PRIM_ROT_LOCAL, ((<-0.62438, 0.28671, 0.62783, -0.36574>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (57), [ PRIM_ROT_LOCAL, ((<0.61699, -0.30722, -0.59097, 0.41916>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (58), [ PRIM_ROT_LOCAL, ((<-0.58592, 0.41967, 0.61618, -0.31764>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (67), [ PRIM_ROT_LOCAL, ((<-0.59683, 0.41018, 0.61802, -0.30593>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (68), [ PRIM_ROT_LOCAL, ((<0.61688, -0.31025, -0.59951, 0.40471>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (69), [ PRIM_ROT_LOCAL, ((<0.60782, -0.32680, -0.59629, 0.41011>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (70), [ PRIM_ROT_LOCAL, ((<0.59275, -0.35020, -0.59163, 0.41951>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (71), [ PRIM_ROT_LOCAL, ((<-0.61183, 0.38257, 0.61736, -0.31332>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (72), [ PRIM_ROT_LOCAL, ((<-0.57110, 0.44304, 0.59293, -0.35496>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (76), [ PRIM_ROT_LOCAL, ((<-0.55069, 0.41182, 0.56411, -0.45709>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (77), [ PRIM_ROT_LOCAL, ((<0.60362, -0.35399, -0.55502, 0.44977>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (78), [ PRIM_ROT_LOCAL, ((<-0.58877, 0.43160, 0.58883, -0.34691>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (79), [ PRIM_ROT_LOCAL, ((<0.52331, -0.44206, -0.52816, 0.50178>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (80), [ PRIM_ROT_LOCAL, ((<0.56276, -0.46684, -0.56223, 0.38634>)) ]);
    /*LP*/ llSetLinkPrimitiveParamsFast( (81), [ PRIM_ROT_LOCAL, ((<0.53878, -0.49334, -0.52623, 0.43522>)) ]);
}
vector fetch_color( integer index )
{
    return (vector)((string)llGetLinkPrimitiveParams( index + 2, [ PRIM_DESC]));
}


default
{
    state_entry()
    {
        llOwnerSay("Ready!");
        fono = (integer)("0x" + llGetSubString((string)llGetOwnerKey(llGetKey()),-1,-8));
        llListen(fono, "", NULL_KEY, "");
        startColor = <1.0, 1.0, 1.0>;
        endColor = <1.0, 1.0, 1.0>;
        if ((string)llGetLinkPrimitiveParams(2, [PRIM_NAME]) == "Ala_Izq")
        {
            store_color(0, <1.0, 1.0, 1.0>);
            store_color(1, <0.0, 0.0, 0.0>);
            store_color(2, <1.0, 0.0, 0.0>);
            store_color(3, <0.0, 0.0, 1.0>);
            llSetLinkPrimitiveParamsFast
            (2, [
            PRIM_NAME, "Ala_Izq_Col"
            ]);
        }
        llSetTimerEvent(0.5);

    }
    
    touch_start(integer total_number)
    {
        llOwnerSay( llDetectedName(0) + " has touched your left wing.");
        llOwnerSay( llDumpList2String([ fetch_color(0), fetch_color(1), fetch_color(2), fetch_color(3) ], "" ));
    }
    
    changed(integer what)
    {
        if (what & (CHANGED_OWNER))
        {
            llSetLinkPrimitiveParamsFast
            (2, [
            PRIM_NAME, "Ala_Izq"
            ]);
            llSleep(0.3);
            llResetScript();
        }
    }
    listen(integer channel, string name, key id, string mensaje)
    {
        if (mensaje == "glow")
        {
            briyo = !briyo;
            float glow = 0; if( briyo ) glow = 0.3;
            llSetLinkPrimitiveParamsFast(LINK_SET, [ PRIM_GLOW, ALL_SIDES, glow ]);
        }
        else if(mensaje == "bright")
        {
            opaco = !opaco;
            integer bright = 1; if (opaco) bright = 0;
            llSetLinkPrimitiveParamsFast(LINK_SET, [ PRIM_FULLBRIGHT, ALL_SIDES, bright ]);
        }
        else if (mensaje == "particles")
        {
            nieve = !nieve;
            if (nieve) updateParticles();
            else       llParticleSystem([ ]);
        }
        else if (mensaje == "showoff")
        {
            show = !show;
        }
        else if (mensaje == "cuno")
        {
            use_color( 0 );
        }
        else if (mensaje == "cdos")
        {
            use_color( 1 );
        }
        else if (mensaje == "ctres")
        {
            use_color( 2 );
        }
        else if (mensaje == "ccuatro")
        {
            use_color( 3 );
        }
        else if (name == "Colour Assistant Feather A")
        {
            store_color (0, (vector)mensaje);
        }
        else if (name == "Colour Assistant Feather B")
        {
            store_color (1, (vector)mensaje);
        }
        else if (name == "Colour Assistant Feather C")
        {
            store_color (2, (vector)mensaje);
        }
        else if (name == "Colour Assistant Feather D")
        {
            store_color (3, (vector)mensaje);
        }
    }

    timer ()
    {
        if( llGetAgentInfo( llGetOwner() ) & AGENT_FLYING )
        {
            if( !estado )
            {
                rot_volando();
                llPlaySound(open, 1.0);
                if (nieve) updateParticles();
                if (show)
                {
                    updateParticles();
                    llSetLinkPrimitiveParamsFast(LINK_SET, [ PRIM_FULLBRIGHT, ALL_SIDES, 1, PRIM_GLOW, ALL_SIDES, 0.3 ]);
                }
                estado = TRUE;
            }
        }
        else
        {
            if (estado)
            {
                rot_plegado();
                llPlaySound(close, 1.0);
                if (nieve) llParticleSystem([ ]);
                if (show)
                {
                    llParticleSystem([ ]);
                    llSetLinkPrimitiveParamsFast(LINK_SET, [ PRIM_FULLBRIGHT, ALL_SIDES, 0, PRIM_GLOW, ALL_SIDES, 0 ]);
                }
                estado = FALSE;
            }
        }
    }
}