// Sim FPS meter, original written by Adelle Fitzgerald
//                rewritten by Auti Blanco (aka Auti Coba)

// Feel free to use as you wish, but please keep this notice at the
// top of this script, or attribute us if you use any parts of it.

// Thanks

float maxFPS = 55;
float simFPS;
float percentCurrFPS;
float size;
float red;
float green;
float zSize;

default {
    
    state_entry () {
        
        zSize = 400;            // get the max size of the prim
        llSetTimerEvent(0.1);      // set the timer
        
    }
    
    timer () {
        
        simFPS = llGetRegionFPS();                          // Get region FPS
        if (simFPS > maxFPS) simFPS = maxFPS;               // Cap region FPS in case of big wierd spikes
        simFPS = maxFPS - simFPS;
        percentCurrFPS = 100 / maxFPS * simFPS;             // convert region FPS to percent to reset prim
        size = 2 * zSize / 100 * percentCurrFPS / 100;      // Work out size of meter prim
        
        // do some math to make colour slowly fade from green to red as FPS lowers
        if (percentCurrFPS < 50) red = percentCurrFPS / 50;
        else red = 1.0;   
        if (percentCurrFPS < 50) green = 1.0;
        else green = percentCurrFPS / 50;
        
        // Set the size and colour of the meter prim
        llSetLinkPrimitiveParams(-4, [PRIM_SIZE, <size, 0.1, 0.2>, PRIM_COLOR, ALL_SIDES, <red, green, 0>, 1.0]);
        
           
    }
    
}