integer BALL_NUMBER = 0;

integer GLOBAL_MSG = -1000;

integer channel = 0;
integer listenHandle = 0;

key    avatarKey = NULL_KEY;

string animation = "";
string curAnimation = "";

vector refPos = ZERO_VECTOR;
vector curPos = ZERO_VECTOR;
vector zAdjPos = ZERO_VECTOR;
rotation curRot = ZERO_ROTATION;

setPosition()
{
    string p = (string)(curPos + refPos + zAdjPos);
    string r = (string)(curRot);

    llRegionSay(channel, "Position|"+p+"|"+r);
}

startAnimation()
{
    if(animation)
    {
        if(curAnimation)
        {
            llStopAnimation(curAnimation);
            llSleep(0.05);
        }
        llStartAnimation(animation);
        curAnimation = animation;

        llRegionSay(channel, "Live");
        llSetTimerEvent(60);
    }
}

default
{
    state_entry()
    {
        list nameParts = llParseString2List(llGetScriptName(), [" "], []);
        BALL_NUMBER = llList2Integer(nameParts, 1);

        channel = (integer)(llFrand(-1000000000.0) - 1000000000.0);

        listenHandle = 0;
        animation = "";
        curAnimation = "";

        avatarKey = NULL_KEY;
        refPos = ZERO_VECTOR;
        curPos = ZERO_VECTOR;
        zAdjPos = ZERO_VECTOR;
        curRot = ZERO_ROTATION;

        llMessageLinked(LINK_THIS, BALL_NUMBER,"Ready", NULL_KEY);
    }

    on_rez(integer start_param)
    {
        llResetScript();
    }

    changed(integer change)
    {
        if(change == CHANGED_REGION_START)
        {
            llResetScript();
        }
    }

    link_message(integer sender_num, integer ball_num, string message, key id)
    {
        if(ball_num == GLOBAL_MSG)
        {
            if(message == "Hello")
            {
                llMessageLinked(LINK_THIS, BALL_NUMBER, "Pose|Ready", NULL_KEY);
            }
        }
        else if (ball_num == BALL_NUMBER)
        {
            list msgData = llParseString2List(message,["|"], ["|"]);
            string msg = llList2String(msgData, 0);
            string option = llList2String(msgData, 1);

            if(msg == "Target")
            {
                refPos = (vector)option;

                llRezObject("~ball", llGetPos(), ZERO_VECTOR, ZERO_ROTATION, channel);
                llSleep(0.5);

                llRegionSay(channel, "Color|"+(string)((BALL_NUMBER % 2)+1));
                llRegionSay(channel, "Position|"+(string)refPos+"|"+(string)ZERO_ROTATION);

                state REZZED;
            }
        }
    }
}

state REZZED
{
    state_entry()
    {
        listenHandle = llListen(channel, "", NULL_KEY, "");
    }

    on_rez(integer start_param)
    {
        llResetScript();
    }

    changed(integer change)
    {
        if(change == CHANGED_REGION_START)
        {
            llResetScript();
        }
    }

    link_message(integer sender_num, integer ball_num, string message, key id)
    {
        if (ball_num == BALL_NUMBER)
        {
            list msgData = llParseString2List(message,["|"], ["|"]);
            string msg = llList2String(msgData, 0);
            string option = llList2String(msgData, 1);

            if (msg == "STOP")
            {
                llRegionSay(channel, "Die");
            }
            if(msg == "MoveTo")
            {
                refPos = (vector)option;
                llRegionSay(channel, "Position|"+(string)refPos+"|"+(string)ZERO_ROTATION);
            }
            else if(msg == "SetAnim")
            {
                string anim = llList2String(msgData, 1);
                curPos = llList2Vector(msgData, 2);
                curRot = llList2Rot(msgData, 3);
                zAdjPos = llList2Vector(msgData, 4);

                setPosition();

                animation = anim;
            }
        }
    }

    listen(integer chan, string name, key id, string message)
    {
        list msgParts = llParseString2List(message, ["|"], [""]);

        string msg = llList2String(msgParts, 0);
        if(msg == "Sitting")
        {
            avatarKey = llList2Key(msgParts,1);
            llRequestPermissions(avatarKey, PERMISSION_TRIGGER_ANIMATION | PERMISSION_TAKE_CONTROLS);
        }
        else if(msg == "Die")
        {
            llMessageLinked(LINK_THIS, BALL_NUMBER, "Pose|Die", avatarKey);

            state default;
        }
    }

    run_time_permissions(integer perm)
    {
        if ((avatarKey == llGetPermissionsKey()) && (perm & PERMISSION_TRIGGER_ANIMATION))
        {
            llMessageLinked(LINK_THIS, BALL_NUMBER, "Pose|Sitting", avatarKey);

            state ANIMATED;
        }
    }
}

state ANIMATED
{
    state_entry()
    {
        curAnimation = "sit";
        startAnimation();

        listenHandle = llListen(channel, "", NULL_KEY, "");

        integer desired_controls = CONTROL_UP | CONTROL_DOWN;
        llTakeControls(desired_controls, TRUE, FALSE);

        llSetTimerEvent(10.0);
    }

    on_rez(integer start_param)
    {
        llResetScript();
    }

    changed(integer change)
    {
        if(change == CHANGED_REGION_START)
        {
            llResetScript();
        }
    }

    control(key id, integer down, integer new)
    {
        integer pressed = down & new;
        integer held = down & ~new;
        integer released = ~down & new;

        if (pressed & CONTROL_UP)
        {
            zAdjPos.z += 0.05;
            setPosition();
        }
        if (pressed & CONTROL_DOWN)
        {
            zAdjPos.z -= 0.05;
            setPosition();
        }
    }

    link_message(integer sender_num, integer ball_num, string message, key id)
    {
        if (ball_num == BALL_NUMBER)
        {
            list msgData = llParseString2List(message,["|"], ["|"]);
            string msg = llList2String(msgData, 0);

            if(msg == "SetAnim")
            {
                string anim = llList2String(msgData, 1);
                curPos = llList2Vector(msgData, 2);
                curRot = llList2Rot(msgData, 3);
                zAdjPos = llList2Vector(msgData, 4);

                setPosition();
                
                animation = anim;
                startAnimation();
            }
            else if(msg == "STOP")
            {
                llRegionSay(channel, "Die");
            }
            else if(msg == "Adjust On")
            {
                llRegionSay(channel, "Adjust On");
            }
            else if(msg == "Adjust Off")
            {
                llRegionSay(channel, "Adjust Off");
            }
            else if(msg == "Save Pos")
            {
                llRegionSay(channel, "Save");
            }
            else if(msg == "Save AV Z")
            {
                llMessageLinked(LINK_THIS, BALL_NUMBER, "SaveAVZ|"+(string)zAdjPos, avatarKey);
            }
        }
    }

    listen(integer chan, string name, key id, string message)
    {
        list msgParts = llParseString2List(message, ["|"], [""]);
        string msg = llList2String(msgParts, 0);

        if(msg == "Standing")
        {
            llMessageLinked(LINK_THIS, BALL_NUMBER, "Pose|Standing", avatarKey);

            llStopAnimation(curAnimation);
            llSleep(0.5);
            llStartAnimation("stand");
            llRequestPermissions(avatarKey, FALSE);
            llReleaseControls();

            llSetTimerEvent(0.0);

            state REZZED;
        }
        else if(msg == "Die")
        {
            llMessageLinked(LINK_THIS, BALL_NUMBER, "Pose|Die", avatarKey);

            llStopAnimation(curAnimation);
            llSleep(0.5);
            llStartAnimation("stand");
            llRequestPermissions(avatarKey, FALSE);
            llReleaseControls();

            llSetTimerEvent(0.0);

            state default;
        }
        else if(msg == "Saving")
        {
            vector p = (llList2Vector(msgParts, 1) - refPos);
            rotation r = llList2Rot(msgParts, 2);

            llMessageLinked(LINK_THIS, BALL_NUMBER, "savePos|"+curAnimation+"|"+(string)p+"|"+(string)r, NULL_KEY);
        }
    }

    timer()
    {
        llSetTimerEvent(10);

        llRegionSay(channel, "Live");
    }
}