integer DEBUG = FALSE;

string version = "v0.6";

integer STARTUP = TRUE;
integer MENU_READY = FALSE;
integer POSITIONS_READY = FALSE;
integer POSES_REPORTED = FALSE;
integer POSITIONS_REPORTED = FALSE;
integer REGIONRESTART = FALSE;
integer AVZREADY = FALSE;
integer AVZ_REPORTED = FALSE;

integer regionRestartTimer = 0;

key  avatarKey = NULL_KEY; 
list ballOwners = [];
list ballSitters = [];
list curAnimations = [];
list syncTimeBalls = [];
list syncTimeTimes = [];
list poseScriptsReady = [];

integer ballPairNum = 0;
integer maxBallPairs = 10;
integer readyCnt = 0;
integer channel = 0;

integer GLOBAL_MSG = -1000;

integer LM_OPTIONDATA = 10002;
integer LM_MENULOADED = 10003;
integer LM_READSTRINGDATA = 10006;

resetMenu()
{
    llMessageLinked(llGetLinkNumber(),10004,"",NULL_KEY); // 10004: LM_RESETMENUSYSTEM
}

doMenu( key user, string menuname )
{
    llMessageLinked(llGetLinkNumber(),10001,menuname,user); // 10001: LM_DOMENU
}

readString( key user, string var, string prompt )
{
    llMessageLinked(llGetLinkNumber(),10005,var+" "+prompt,user); // 10005: READSTRING
}

customMenu( key user, string menuname, string message, list buttons )
{
    llMessageLinked(llGetLinkNumber(),10007,llDumpList2String([ menuname, message ] + buttons,"~|~"),user);
}

integer getNextBall()
{
    if(DEBUG) llOwnerSay("getNextball: ");

    integer iy = -1;
    if(llListFindList(ballSitters, [avatarKey]) < 0)
    {
        iy = llListFindList(ballOwners, [avatarKey]);
        if(iy < 0)
        {
            iy = llListFindList(ballOwners, [NULL_KEY]);
            if(iy >= 0)
            {
                ballOwners = llListReplaceList(ballOwners, [avatarKey], iy, iy);
            }
            else
            {
                llInstantMessage(avatarKey, "Sorry, there are no more dance balls available. Try again in a little while.");
            }
        }
        else
        {
            if(DEBUG) llOwnerSay("getNextBall: Move old balls");

            integer ballNum = iy*2;
            list params = llGetObjectDetails(avatarKey, [OBJECT_POS]);
            vector position = llList2Vector(params, 0);
            vector position2 = position;
            position.x -= 0.5;
            position.z += 0.3;
            position2.x += 0.5;
            position2.z += 0.3;

            llMessageLinked(LINK_THIS, ballNum, "MoveTo|"+(string)position, NULL_KEY);
            llMessageLinked(LINK_THIS, ballNum+1, "MoveTo|"+(string)position2, NULL_KEY);
        }
    }
    return iy*2;
}

doTouch()
{
    if(DEBUG) llOwnerSay("doTouch: ");
    if(STARTUP)
    {
        llOwnerSay( "Couples Dance Machine "+version+" is still starting, please wait...");
    }
    else if(REGIONRESTART)
    {
        llOwnerSay("Couples Dance Machine "+version+" is still recovering from a region restart, please wait...");
    }
    else
    {
        integer ballNum = getNextBall();
        if(ballNum >= 0)
        {
            list params = llGetObjectDetails(avatarKey, [OBJECT_POS]);
            vector position = llList2Vector(params, 0);
            vector position2 = position;
            position.x -= 0.5;
            position.z += 0.3;
            position2.x += 0.5;
            position2.z += 0.3;

            llMessageLinked(LINK_THIS, ballNum, "Target|"+(string)position, NULL_KEY);
            llMessageLinked(LINK_THIS, ballNum+1, "Target|"+(string)position2, NULL_KEY);
        }

        if(llListFindList(ballSitters, [avatarKey]) >= 0)
        {
            doMenu( avatarKey, "DEFAULT" );
        }
    }
}

doSync(integer ballNum)
{
    if(llList2String(ballSitters, ballNum) != (string)NULL_KEY &&
        llList2String(ballSitters, ballNum+1) != (string)NULL_KEY)
        {
            string animF = llList2String(curAnimations, ballNum);
            string animM = llList2String(curAnimations, ballNum+1);

            llMessageLinked(LINK_THIS, ballNum, "SetPos|"+animF, llList2Key(ballSitters, ballNum));
            llMessageLinked(LINK_THIS, ballNum+1, "SetPos|"+animM, llList2Key(ballSitters, ballNum+1));
        }
}

doAnimations(integer num)
{
    if(llList2String(ballSitters, num) != (string)NULL_KEY &&
        llList2String(ballSitters, num+1) != (string)NULL_KEY)
        {
            string animF = llList2String(curAnimations, num);
            string animM = llList2String(curAnimations, num+1);

            llMessageLinked(LINK_THIS, num, "SetPos|"+animF, llList2Key(ballSitters, num));
            llMessageLinked(LINK_THIS, num+1, "SetPos|"+animM, llList2Key(ballSitters, num+1));

            integer syncTime = llGetUnixTime() + 15;
            integer ix = llListFindList(syncTimeBalls, [num]);
            if(ix >= 0)
            {
                syncTimeTimes = llListReplaceList(syncTimeTimes, [syncTime], num, num);
            }
            else
            {
                syncTimeBalls += num;
                syncTimeTimes += syncTime;
            }

            llSetTimerEvent(1.0);
        }
    else
    {
        llMessageLinked(LINK_THIS, num, "SetPos|impatient", llList2Key(ballSitters, num));
        llMessageLinked(LINK_THIS, num+1, "SetPos|impatient", llList2Key(ballSitters, num+1));
    }
}

init()
{
    llSetText("Couples Dance Machine "+version+"\nby Frank", <1.0, 0.9, 0.0>, 1.0);

    llOwnerSay("One moment while the Couples Dance Machine "+version+" starts up...");

    channel = (integer)llGetObjectDesc();
    if(channel == 0)
    {
        llSay(0, "The CDM Remote channel must be set to a non-zero value in the objects description and must be the same value as the remotes associated with this FinTan unit.");
    }
    llListen(channel, "", NULL_KEY, "");

    ballOwners = [];
    integer ix = 0;
    for(ix = 0; ix < maxBallPairs; ix++)
    {
        ballOwners += NULL_KEY;
    }

    for(ix = 0; ix < (maxBallPairs*2); ix++)
    {
        ballSitters += NULL_KEY;
        curAnimations += "Stand";
        poseScriptsReady += 0;
    }
    POSITIONS_REPORTED = FALSE;
    POSES_REPORTED = FALSE;
    POSITIONS_READY = FALSE;
    MENU_READY = FALSE;
    STARTUP = TRUE;
    REGIONRESTART = FALSE;
    AVZREADY = FALSE;
    AVZ_REPORTED = FALSE;

    llSetTimerEvent(5.0);
    
    llSleep(5.0);
    
    resetMenu();
}

default
{
    state_entry()
    {
        readyCnt = 0;
        init();
    }

    on_rez(integer start_param)
    {
        llResetScript();
    }

    changed(integer change)
    {
        if(change == CHANGED_REGION_START)
        {
            REGIONRESTART = TRUE;
            regionRestartTimer = llGetUnixTime() + 600;

            llSetTimerEvent(5.0);
        }
    }

    link_message(integer sender_num, integer num, string str, key id)
    {
        if(num == LM_MENULOADED)
        {
            llOwnerSay("Menus Ready");
            MENU_READY = TRUE;
        }
        else if (num == LM_OPTIONDATA)
        {
            list menuData = llParseString2List(str,["|"], ["|"]);
            string menu = llList2String(menuData, 0);
            string option = llList2String(menuData, 1);
            string optionType = llList2String(menuData, 2);

            integer ballNum = llListFindList(ballSitters, [id]);
            ballNum = ballNum - (ballNum % 2);

            if(optionType == "DANCE")
            {
                string animF = llList2String(menuData, 3);
                string animM = llList2String(menuData, 4);

                if(ballNum >= 0)
                {
                    curAnimations = llListReplaceList(curAnimations, [animF, animM], ballNum, ballNum+1);

                    doAnimations(ballNum);
                }
            }
            else if(option == "SYNC")
            {
                doSync(ballNum);
            }
            else if (option == "STOP")
            {
                integer iy = llListFindList(ballSitters, [id]);
                if(iy >= 0)
                {
                    ballNum = iy - (iy % 2);
                    llMessageLinked(LINK_THIS, ballNum, option, id);
                    llMessageLinked(LINK_THIS, ballNum+1, option, id);
                }
            }
            else if(menu == "OPTIONS")
            {
                if(id != llGetOwner() && (option == "Adjust On" || option == "Adjust Off" || option == "Save Pos"))
                {
                    llInstantMessage(id, "Sorry, that option is enabled for the owner only.");
                }
                else
                {
                    llMessageLinked(LINK_THIS, ballNum, option, NULL_KEY);
                    llMessageLinked(LINK_THIS, ballNum+1, option, NULL_KEY);
                }
            }
        }
        else if (num >= 0)
        {
            list strData = llParseString2List(str,["|"], ["|"]);
            string msg = llList2String(strData, 0);
            string option = llList2String(strData, 1);

            if(msg == "Pose")
            {
                integer ownerNum = num / 2;
                if(option == "Die")
                {
                    ballOwners = llListReplaceList(ballOwners, [(string)NULL_KEY], ownerNum, ownerNum);
                    ballSitters = llListReplaceList(ballSitters, [(string)NULL_KEY], num, num);
                    curAnimations = llListReplaceList(curAnimations, ["impatient"], num, num);
                }
                else if(option == "Sitting")
                {
                    ballSitters = llListReplaceList(ballSitters, [(string)id], num, num);

                    num = num - (num % 2);

                    doAnimations(num);

                    doMenu( avatarKey, "DEFAULT" );
                }
                else if(option == "Standing")
                {
                    ballOwners = llListReplaceList(ballOwners, [(string)NULL_KEY], ownerNum, ownerNum);
                    ballSitters = llListReplaceList(ballSitters, [(string)NULL_KEY], num, num);

                    num = num - (num % 2);
                    llMessageLinked(LINK_THIS, num, "SetPos|stand", id);
                    llMessageLinked(LINK_THIS, num+1, "SetPos|stand", id);
                }
                else if(option == "Ready")
                {
                    poseScriptsReady = llListReplaceList(poseScriptsReady, [1], num, num);
                }
            }
            else if(msg == "position")
            {
                if(option == "Ready")
                {
                    POSITIONS_READY = TRUE;
                    if(! POSITIONS_REPORTED)
                    {
                        POSITIONS_REPORTED = TRUE;
                        llOwnerSay("Positions Ready");
                    }
                }
            }
            else if(msg =="AVZ")
            {
                if(option == "Ready")
                {
                    AVZREADY = TRUE;
                    if(! AVZ_REPORTED)
                    {
                        AVZ_REPORTED = TRUE;
                        llOwnerSay("AV Z Adjustments Ready");
                    }
                }
            }
        }
    }

    listen(integer channel, string name, key id, string message)
    {
        list msgParts = llParseString2List(message, ["|"], []);
        string msg = llList2String(msgParts, 0);
        avatarKey = llList2Key(msgParts, 1);

        doTouch();
    }

    touch_start(integer total_number)
    {
        avatarKey = llDetectedKey(0);
        doTouch();
    }

    timer()
    {
        if(REGIONRESTART)
        {
            if(llGetUnixTime() > regionRestartTimer)
            {
                llResetScript();
            }
        }
        else if(STARTUP)
        {
            if(llListFindList(poseScriptsReady, [0]) < 0)
            {
                if(!POSES_REPORTED)
                {
                    llOwnerSay("Poses Ready");
                    POSES_REPORTED = TRUE;
                }
                if(!POSITIONS_READY || !AVZREADY)
                {
                    llMessageLinked(LINK_THIS, GLOBAL_MSG, "Hello", NULL_KEY);
                    llSetTimerEvent(5.0);
                }
                if(MENU_READY && POSITIONS_READY && AVZREADY)
                {
                    llOwnerSay("Couples Dance Machine "+version+" is Ready to use");

                    STARTUP = FALSE;
                    llSetTimerEvent(0.0);
                }
            }
            else
            {
                llMessageLinked(LINK_THIS, GLOBAL_MSG, "Hello", NULL_KEY);
                llSetTimerEvent(5.0);
            }
        }
        else
        {
            integer ix = 0;
            integer n = llGetListLength(syncTimeBalls);
            if(n == 0)
            {
                llSetTimerEvent(0.0);
            }
            else
            {
                for(ix = 0; ix < n; ix++)
                {
                    if(llGetUnixTime() > llList2Integer(syncTimeTimes, ix))
                    {
                        integer num = llList2Integer(syncTimeBalls, ix);
                        doSync(num);

                        syncTimeBalls = llListReplaceList(syncTimeBalls, [], ix, ix);
                        syncTimeTimes = llListReplaceList(syncTimeTimes, [], ix, ix);
                        ix = n;
                    }
                }
            }
        }
    }
}