///////////////////////////////////////////////////
//
// MWS HoloScene 1.0.1 
// Woolich Ulich 
// March-October, 2007.
//
// -----------------
//
//  Slave Script.
//
// -----------------
//
// v1.0     First version. Start version.
// v1.0.1   Same version. Continued work from past.
//
///////////////////////////////////////////////////

    // General variables.
    // ------------------
    
integer     padnumber = 0;
integer     objchannel = -93793;            // Channel to talk to objects.
integer     objchannelid = 0;               // Objects channel identifier to remove listen event.

vector      myrelpos = <-9, -9, -9>;        // Stores relative position to the box.
rotation    myrelrot = <-9, -9, -9, -1>;    // Stores relative rotation to the box.

integer     stored = FALSE;                 // Flag to know if data was stored.

vector      firstpos = ZERO_VECTOR;         // To show first object.
rotation    firstrot = ZERO_ROTATION;       //

//******************************************************************************
//******************************************************************************
//******************************************************************************

    // **************************************
    // Send the object to a defined position.
    // **************************************
    
gotopos(rotation newrot, vector newpos)
{
        // Send slave to its final destination (rotate before move).
    llSetRot(newrot);
    
        // Move object to destination until it is reached, or within 10 hops, whichever comes first.

    integer cnt;
    
    for (cnt = 1; cnt < 10; cnt++) 
    {
        llSetPos(newpos);
        if (llGetPos() == newpos) return;
    }
}


//******************************************************************************
//******************************************************************************
//******************************************************************************
default
{
    ////////////////////////////////////////////////////////////////////////////////
    on_rez(integer parameter)
    {
        padnumber = parameter;
        
        if (parameter == 0) llSetPrimitiveParams([PRIM_TEMP_ON_REZ, FALSE]);
        
            // Open chat channel for objets.
            
        objchannelid = llListen(objchannel, "", NULL_KEY, "");
    }
        
    ////////////////////////////////////////////////////////////////////////////////
    state_entry()
    {
            // Open chat channel for objets.
            
        objchannelid = llListen(objchannel, "", NULL_KEY, "");
    }
    
    ////////////////////////////////////////////////////////////////////////////////
    listen(integer channel, string name, key id, string message)
    {
        list        items = llParseString2List(message,[":"],[]);
        
        string      identifier = llList2String(items, 0);
        key         myowner = (key)llList2String(items, 1);
        integer     thepad = (integer)llList2String(items, 2);
        string      command = llList2String(items, 3);

        vector      controlposition;
        rotation    controlrotation;
        
        vector      nposition;
        rotation    nrotation;
        
            // If data received from a box with the same owner.
            // ------------------------------------------------
        
        if ( (identifier == "holoscene101") && (myowner == llGetOwner()) && (thepad == padnumber) )
        {

                // Store position for every object. Takes data about box position,
                // calculate relative position and store it.
                // ---------------------------------------------------------------

            if (command == "recordpos")
            {
                    // Take position of the control from received list.
                    
                controlposition = (vector)llList2String(items, 4);
                controlrotation = (rotation)llList2String(items, 5);
                
                    // Calculate relative position and rotation and store it.
                    
                myrelpos = (llGetPos() - controlposition) / controlrotation;
                myrelrot = (llGetRot() / controlrotation);
                
                stored = TRUE;
                
                    // Notice to HUD data was stored and sends it position and rotation.
                    // Same data will be received by the box.
                
                llRegionSay(objchannel, "holoscene101:" + (string)myowner + ":stored:" + (string)llGetKey() + ":" +
                    (string)llGetPos() + ":" + (string)llGetRot() + ":" + (string)llGetObjectPrimCount(llGetKey()));

                return;
            }
            
                // The box has been moved. Takes data of box new position and move
                // object.
                // ---------------------------------------------------------------
            
            if ((command == "moved") && (stored))
            {
                    // Take position of the control from received list.
                    
                controlposition = (vector)llList2String(items, 4);
                controlrotation = (rotation)llList2String(items, 5);
                nposition = (myrelpos * controlrotation) + controlposition;
                nrotation = (myrelrot * controlrotation);    
                
                    // Move the object.
                    
                gotopos(nrotation, nposition);            
    
                return;
            }
            
                // Send number of prims in this object to the HUD.
                // -----------------------------------------------
                            
            if (command == "objcount")
            {
                llRegionSay(objchannel, "holoscene101:" + (string)myowner + ":tohudcount:" + (string)llGetNumberOfPrims());
                
                return;
            }
            
                // Send data about position of this object.
                // ----------------------------------------
                            
            if (command == "idpos")
            {
                llRegionSay(objchannel, "holoscene101:" + (string)myowner + ":objpos:" + (string)llGetKey() + ":" +
                    (string)llGetPos() + ":" + (string)llGetRot());

                return;
            }
            
                // Move up 10 meters.
                // ------------------
                            
            if (command == "firstup")
            {
                if ((key)llList2String(items, 4) == llGetKey())
                {
                    if (firstpos == ZERO_VECTOR)
                    {           
                        firstpos = llGetPos();
                        firstrot = llGetRot();
                        llSetPos(firstpos + <0.0, 0.0, 0.5>);
                        llSetTimerEvent(20.0);
                    }
                    else llSetPos(llGetPos() + <0.0, 0.0, 0.5>);
                }

                return;
            }
            
                // Restore position.
                // -----------------
                            
            if ((command == "restorefirst") && (firstpos != ZERO_VECTOR))
            {
                if ((key)llList2String(items, 4) == llGetKey())
                {
                    llSetTimerEvent(0.0);
                    gotopos(firstrot, firstpos);
                    firstpos = ZERO_VECTOR;
                }

                return;
            }
            
                // Set object as temporal.
                // -----------------------
                            
            if (command == "objstemp")
            {
                llSetPrimitiveParams([PRIM_TEMP_ON_REZ, TRUE]);
                llRegionSay(objchannel, "holoscene101:" + (string)myowner + ":yesastemp");
            }

                // Set object as not temporal.
                // -----------------------
                            
            if (command == "objsnotemp")
            {
                llSetPrimitiveParams([PRIM_TEMP_ON_REZ, FALSE]);
                llRegionSay(objchannel, "holoscene101:" + (string)myowner + ":noastemp");
            }
                        
                // Fix. Close Listening channel.
                // -----------------------------
                
            if (command == "fix") llListenRemove(objchannelid);
            
                // FinalPos. Set this as final position and delete 
                // this script.
                // -----------------------------------------------
                
            if (command == "delscripts") llRemoveInventory("MWS BuildRezz 1.0.1 (slave)");
            
                // Deletes this object.
                // --------------------
            if (command == "clean") 
            {
                if ((llGetObjectPermMask(MASK_BASE) & PERM_COPY)) llDie();
                    else llOwnerSay(llGetObjectDesc() + " not deleted because do not have COPY-PERMISSIONS.");
            }
            
                // Deletes object, don´t matter if it is no-copy.
                // ----------------------------------------------
                
            if (command == "NO.COPY.DEL") llDie();
        }
        
    }
    
    timer()
    {
        llSetTimerEvent(0.0);
        
        if (firstpos != ZERO_VECTOR)
        {
            gotopos(firstrot, firstpos);
            firstpos = ZERO_VECTOR;
        }
    }
    
}
