integer NotecardLine = 0;
key     DataRequest = NULL_KEY;
string  DataNotecard = "positions";

list    animations = [];
list    positions = [];
list    rotations = [];

integer READY = FALSE;
integer GLOBAL_MSG = -1000;

default
{
    state_entry()
    {
        READY = FALSE;

        if (llGetInventoryKey( DataNotecard ) != NULL_KEY)
        {
            NotecardLine = 0;
            DataRequest = llGetNotecardLine( DataNotecard, 0 );
        }
        else
        {
            READY = TRUE;
        }
    }

    on_rez(integer start_param)
    {
        llResetScript();
    }

    changed(integer change)
    {
        if(change == CHANGED_REGION_START)
        {
            llResetScript();
        }
    }

    dataserver( key id, string data )
    {
        if (id == DataRequest)
        {
            if (data != "")
            {
                data = llStringTrim( data, STRING_TRIM );
                if (data != "")
                {
                    list dataParts = llParseString2List(data, ["|"], [""]);

                    animations += llList2String(dataParts, 0);
                    positions += llList2Vector(dataParts, 1);
                    rotations += llList2Rot(dataParts, 2);

                    DataRequest = llGetNotecardLine( DataNotecard, ++NotecardLine );
                }
            }
            else
            {
                READY = TRUE;
            }
        }
    }

    link_message(integer sender_num, integer ball_num, string str, key id)
    {
        list msgData = llParseString2List(str,["|"], ["|"]);
        string msg = llList2String(msgData, 0);
        string animation = llList2String(msgData, 1);

        if(ball_num == GLOBAL_MSG)
        {
            if(str == "Hello")
            {
                if(READY)
                {
                    llMessageLinked(LINK_THIS, 0, "position|Ready", NULL_KEY);
                }
            }
        }
        else if(msg == "SetPos")
        {
            integer ix = llListFindList(animations, [animation]);
            if(ix < 0)
            {
                llMessageLinked(LINK_THIS, ball_num, "SetAVZ|"+animation+"|<0.0, 0.0, 0.0>|<0.0, 0.0, 0.0, 0.0>", id);
            }
            else
            {
                vector p = llList2Vector(positions, ix);
                rotation r = llList2Rot(rotations, ix);

                llMessageLinked(LINK_THIS, ball_num, "SetAVZ|"+animation+"|"+(string)p+"|"+(string)r, id);
            }
        }
        else if(msg == "savePos")
        {
            vector p = llList2Vector(msgData, 2);
            rotation r = llList2Rot(msgData, 3);

            integer IX = llListFindList( animations, [animation] );
            if( IX < 0 )
            {
                animations += animation;
                positions += p;
                rotations += r;
            }
            else
            {
                positions = llListReplaceList(positions, [p], IX, IX);
                rotations = llListReplaceList(rotations, [r], IX, IX);
            }

            list lines = [];
            integer ix = 0;
            for (ix = 0; ix < llGetListLength(animations); ix++)
            {
                lines += llList2String(animations, ix) + "|" + llList2String(positions, ix)+"|"+llList2String(rotations, ix);
            }

            if (llGetInventoryKey( DataNotecard ) != NULL_KEY)
                llRemoveInventory( DataNotecard );

            osMakeNotecard( DataNotecard, lines );
        }
    }
}

