// 29/09/2010
// based on Hiro Protagonist's Bookscript
// includes preloading of the next page by Dale Glass
// and pageback by Revolution Smythe
// modded for this use by Eryn Galen.


// Global Variables
vector opensize=<0.062,1.242,0.82>;
vector closedsize=<0.031,0.414,0.547>;
string book="closed";
integer pagesets=9;
// here enter the number of pages
list pageUUIDs=["0bfb48b6-dcef-4080-a110-a95690807161","4d66d1c3-bb50-461a-ab96-255cc8d066aa","65fd4154-bd0a-496a-b9dc-e4ba75ae70be","239b107f-5b5f-4d05-bc8f-59aba21e0c54","9ae4177c-c6f3-497f-bae5-d1572209fe61","cf5b205f-c309-40fa-a69d-80d99999edb3","fdb28173-3829-4750-ad63-07177653cefd","a1c8fe7d-b363-40fe-80ab-6806b12ba8d3","4c54ad04-2690-412b-bfe7-0fa5ea9ba777"];
// here enter all UUIDs of the pictures that make the double pages
integer pageset=0;
integer next_pageset=1;
float   timer_delay = 4.0;

// SCRIPT STARTS HERE !

settexture()
{
    string ID=llList2String(pageUUIDs,pageset);
    key textureID=(key) ID;
    llSetTexture("041d02c0-b2fa-4ddf-bafb-c438adf72fc4",0);
    // texture of upper face
    llSetTexture("810c68b6-93ab-4d9f-b697-c7f15bc2d096",1);
    // texture of right side face on open
    llSetTexture("e2b9287c-7a25-4b62-9d60-2a5e81426152",3);
    // texture of first side face on open
    llSetTexture("041d02c0-b2fa-4ddf-bafb-c438adf72fc4",4);
    // texture below face on open
    llSetTexture("63f5294b-6a33-4219-97cc-d3965b7106fb",2);
    // texture backside on open
    llSetTexture("041d02c0-b2fa-4ddf-bafb-c438adf72fc4",7);
    // texture below face on open
    llSetPrimitiveParams([PRIM_TEXTURE, 5, textureID, <0.5,1,0>, <0.25,0,0>, 0.0]);
    llSetPrimitiveParams([PRIM_TEXTURE, 6, textureID, <0.5,1,0>, <-0.25,0,0>, 0.0]);
// set texture for inner pages - book pages
}

closebook()
{
    llSetPrimitiveParams([PRIM_TYPE, PRIM_TYPE_BOX, 0, <0,1,0>, 0.0, <0,0,0>, <1,1,1>, <0,0,0>]);
    llSetPrimitiveParams([PRIM_SIZE, closedsize]);
    llSetTexture("041d02c0-b2fa-4ddf-bafb-c438adf72fc4",0);
    // texture above face
    llSetTexture("041d02c0-b2fa-4ddf-bafb-c438adf72fc4",1);
    // texture right side face
    llSetTexture("63f5294b-6a33-4219-97cc-d3965b7106fb",2);
    // texture back face
    llSetTexture("63f5294b-6a33-4219-97cc-d3965b7106fb",3);
    // texture left side face
    llSetTexture("25c746ea-6d05-45ed-bab2-124f8e817ef3",4);
    // texture cover face
    llSetTexture("041d02c0-b2fa-4ddf-bafb-c438adf72fc4",5);
    // texture below face
}

default
{    
    state_entry()
    {
        closebook();
        book="closed";
        pageset=0;
        next_pageset=1;
        llSetTimerEvent(timer_delay);
    }
    
    touch_start(integer num_times)
    {
        if(book=="closed")
        {
            book="open";
            llSetPrimitiveParams([PRIM_TYPE, PRIM_TYPE_BOX, 0, <0,0.725,0>, 0.0, <0,0,0>, <1,1,1>, <0,0,0>]);
            llSetPrimitiveParams([PRIM_SIZE, opensize]);
            settexture();
        } else if(book=="open")
        {
            if(llDetectedTouchFace(0) == 5)
            {
             pageset=pageset + 1;
             if(pageset>(pagesets-1))
             {
                closebook();
                book="closed";
                pageset=0;
                next_pageset=1;
             } 
             else 
             {
                settexture();
                next_pageset = pageset+1;
             }
             if ( next_pageset < llGetListLength(pageUUIDs) ) 
             {
                // preload next page after a delay
                llSetTimerEvent(timer_delay);
             } 
             else 
             {
                // nothing to preload, stop event if any
                llSetTimerEvent(0.0);
             }
         }
         else if(llDetectedTouchFace(0) == 6)
         {
            pageset=pageset - 1;
            if(pageset< 0)
            {
                closebook();
                book="closed";
                pageset=0;
                next_pageset=1;
            } 
            else 
            {
                settexture();
                next_pageset = pageset-1;
            }
            if ( next_pageset < llGetListLength(pageUUIDs) ) 
            {
                // preload next page after a delay
                llSetTimerEvent(timer_delay);
            } 
            else 
            {
                // nothing to preload, stop event if any
                llSetTimerEvent(0.0);
            }
         }
       }
    }

    timer() 
    {
        key textureID=llList2Key(pageUUIDs,next_pageset);
        llSetColor(<0,0,0>, 3);
        llSetTexture(textureID,3);
        llSetTimerEvent(0.0); // do this only once
    }
        
    changed( integer what )
    {
        if (what & 1024) llResetScript();
    }
}
