
string sittext="sit";
string floattext="";
vector floattextcolor=<0.5,0,0>;
vector sitpos=<0,-0.167,0.11>;
rotation sitrot=<0,0,-0.70711,0.70711>;
string sitanim="sit";
float alpha=0.0;

// Variables below are used for internal purposes

key sittingonme;

default
{
    state_entry()
    {
        llSetText(floattext,floattextcolor,1);
        llSetSitText(sittext);
        llSitTarget(sitpos,sitrot);
        llSetAlpha(alpha,ALL_SIDES);
        sittingonme=NULL_KEY;
    }
    
    changed(integer change) {
        if (change & CHANGED_LINK) {
            if (llAvatarOnSitTarget()!=NULL_KEY && sittingonme==NULL_KEY) {
                llRequestPermissions(llAvatarOnSitTarget(),PERMISSION_TRIGGER_ANIMATION);
            }
            else {
                if (llAvatarOnSitTarget()==NULL_KEY && sittingonme!=NULL_KEY) {
                    llUnSit(sittingonme);
                    llStopAnimation(sitanim);
                    sittingonme=NULL_KEY;
                    llResetScript();
                }
            }
        }
    }
    
    run_time_permissions(integer perm) {
        if (perm==PERMISSION_TRIGGER_ANIMATION) {
            sittingonme=llAvatarOnSitTarget();
            if (sitanim!="sit") {
                llStopAnimation("sit");
                llStartAnimation(sitanim);
            }
            llSetText("",<0,0,0>,0);
            llSetAlpha(0.,ALL_SIDES);
        }
    }
}
