//  Original Particle Script v3 by Ama Omega
// settings and customizations by Jopsy Pendragon

// Mask Flags - set to TRUE to enable
integer glow =TRUE;            // Make the particles glow
integer bounce = FALSE;          // Make particles bounce on Z plan of object
integer interpColor = TRUE;     // Go from start to end color
integer interpSize = TRUE;      // Go from start to end size
integer wind = FALSE;           // Particles effected by wind
integer followSource = TRUE;    // Particles follow the source
integer followVel = FALSE;       // Particles turn to velocity direction

// Choose a pattern from the following:
// PSYS_SRC_PATTERN_EXPLODE
// PSYS_SRC_PATTERN_DROP
// PSYS_SRC_PATTERN_ANGLE_CONE_EMPTY
// PSYS_SRC_PATTERN_ANGLE_CONE
// PSYS_SRC_PATTERN_ANGLE
integer pattern = PSYS_SRC_PATTERN_ANGLE;

// Select a target for particles to go towards
// "" for no target, "owner" will follow object owner 
//    and "self" will target this object
//    or put the key of an object for particles to go to
key target="";

// Particle paramaters
float age =2; //how long will particles live (in seconds)
float maxSpeed =.03; //maximum speed a particle should be moving
float minSpeed = .01; //minimum speed a particle should be movie
string texture=""; //texture applied to the particles
float startAlpha =.9; //alpha transparency at start
float endAlpha =.2; //alpha at end
vector startColor = <1,1,.5>; //particles start as this color
vector endColor = <1,.5,0>; //and end as thiscolor
vector startSize = <.2,.2,1>; //particles start at this size
vector endSize = <.04,.2,10>; //and end at this size
vector push = <0,0,.15>; //how far to push particles

// System paramaters
float rate = 0.05;      // How fast to emit particles
float radius = 0;       // Radius to emit particles for BURST pattern
integer count =2;   // How many particles to emit per BURST 
float outerAngle = 0.0;   // Outer angle for all ANGLE patterns
float innerAngle = 0.05;   // Inner angle for all ANGLE patterns
vector omega = <0,0,3>; // Rotation of ANGLE patterns around the source
float life = 0;



// Script variables
integer flags;

updateParticles()
{
    if (target == "owner") target = llGetOwner();
    if (target == "self") target = llGetKey();
    if (glow) flags = flags | PSYS_PART_EMISSIVE_MASK;
    if (bounce) flags = flags | PSYS_PART_BOUNCE_MASK;
    if (interpColor) flags = flags | PSYS_PART_INTERP_COLOR_MASK;
    if (interpSize) flags = flags | PSYS_PART_INTERP_SCALE_MASK;
    if (wind) flags = flags | PSYS_PART_WIND_MASK;
    if (followSource) flags = flags | PSYS_PART_FOLLOW_SRC_MASK;
    if (followVel) flags = flags | PSYS_PART_FOLLOW_VELOCITY_MASK;
    if (target != "") flags = flags | PSYS_PART_TARGET_POS_MASK;

    
    //llMakeSmoke( 500, 1, 1, 10, 1, "Alien FaceSucker.tga", <0,0,0>); 
    if (1) { llParticleSystem([  PSYS_PART_MAX_AGE,age,
                        PSYS_PART_FLAGS,flags,
                        PSYS_PART_START_COLOR, startColor,
                        PSYS_PART_END_COLOR, endColor,
                        PSYS_PART_START_SCALE,startSize,
                        PSYS_PART_END_SCALE,endSize, 
                        PSYS_SRC_PATTERN, pattern,
                        PSYS_SRC_BURST_RATE,rate,
                        PSYS_SRC_ACCEL, push,
                        PSYS_SRC_BURST_PART_COUNT,count,
                        PSYS_SRC_BURST_RADIUS,radius,
                        PSYS_SRC_BURST_SPEED_MIN,minSpeed,
                        PSYS_SRC_BURST_SPEED_MAX,maxSpeed,
                        PSYS_SRC_TARGET_KEY,target,
                        PSYS_SRC_INNERANGLE,innerAngle, 
                        PSYS_SRC_OUTERANGLE,outerAngle,
                        PSYS_SRC_OMEGA, omega,
                        PSYS_SRC_MAX_AGE, life,
                        PSYS_SRC_TEXTURE, texture,
                        PSYS_PART_START_ALPHA, startAlpha,
                        PSYS_PART_END_ALPHA, endAlpha
                            ]);
                        }
}
default
{
    state_entry()
    {
        updateParticles();
        llSetTimerEvent(360);
    }
    
    timer() { 
        vector pos = llGetSunDirection();
        if ( pos.z > 0 ) llParticleSystem( [ ] );
        else updateParticles();
    }
    
    
}
