integer flipped = 0;
rotation inverse;
float LastPos = -337.0;

CheckSun() {
    vector v = llGetSunDirection();
    float CurPos = v.z;
    if (LastPos < -300.0)
    {
        LastPos = CurPos;
        if (CurPos > -0.331) llSetRot( inverse );
        llSetTimerEvent( 0.0 );
        llSetTimerEvent( 15.0 );
        return;
    }
    if ((LastPos > -0.331) && (CurPos <= -0.331)) // sun has dipped below the horizon
        llSetRot( ZERO_ROTATION );
    else if ((LastPos < 0.105) && (CurPos >= 0.105)) // sun has risen above the horizon
        llSetRot( inverse );
    LastPos = CurPos;
    llSetTimerEvent( 0.0 );
    llSetTimerEvent( 60.0 );
}

default {
    state_entry() {
        flipped = 0;
        llSetRot( ZERO_ROTATION );
        inverse = llEuler2Rot( <PI,0.0,0.0> );
        llTargetOmega( <0.0,0.0,1.0>, 1.0, 10.0 );
        llSetTimerEvent( 60.0 );
        CheckSun();
    }
    
    timer() {
        CheckSun();
    }
    
    changed( integer whatChanged ) {
        if (whatChanged & 256) llResetScript();
    }
}