list daySounds = ["American Oriole", "Cardinal", "Red-tailed Hawk", "Robin", "Song Sparrow", "Tree Swallow", "Locust"];
list nightSounds = ["Great Horned Owl","wolf-howl", "cow-calf", "wildcat"];

list nightAmbient = ["Cricket", "Big wind 7"];

default {
    state_entry() {
        llStopSound();
        llSetTimerEvent(2.0);
    }

    timer() {
        vector time = llGetSunDirection();
        list myList;
        float density = 0.9;

        if (time.z > 0.0) {
            myList = llListRandomize(daySounds, 1);
        } else {
            myList = llListRandomize(nightSounds, 1);
            density = 0.98;
            
            // Ambient nighttime sound
            if (llFrand(1.0) > 0.85) {
                llStopSound();
            } else {
                llLoopSound(llList2String(nightAmbient, 0), 1.0);
            }
        }
        
        if (llFrand(1.0) > density) {
            llTriggerSound(llList2String(myList, 0), 1.0);
        }
    }
}


