// This script is free to distribute and modify.  It is NOT for resale purposes but may be
// used in your own builds as long as next owner is allowed full permissions for the script.
// February 3, 2010 - Alessandra Carlos

// Note:  Although doors can be linked, I recommend that you don't link them to a build.
// If set at an angle different from the cardinal directions, linked doors will sometimes
// open to odd angles when rotating.  This doesn't seem to happen with unlinked doors.

integer OpenTime = 10; //How long the door stays open before shutting again.  Minimum = 1
integer ClickOpen = TRUE; //If the door can be clicked to open.  TRUE or FALSE
integer BumpOpen = TRUE; //If bumping the door opens it. TRUE or FALSE
integer ProximityOpen = FALSE; //Should the door auto open if someone is close? TRUE or FALSE
integer ProximityDistance = 3;  //How close before the door opens?
integer CheckTime = 1; //Number of second to wait between proximity checks.

// Rotation Door Configuration
// Use negative numbers to open in the opposite direction
vector RotationOffset = <0,0,90>; //The axis a rotating door spins on and how many degrees

// Sliding Door Configuration
// Enabling a sliding door turns off rotation.  If linked the door is slid in
// relation to the position of the root prim.
integer SlideDoor = TRUE;//Is this a sliding door?  TRUE or FALSE
float NorthSouth = 0.0; //Sliding: How far to travel North/South. Negative = South
float EastWest = 0.0; //Sliding:  How far to travel East/West.  Negative = West
float UpDown = 6.0; //Sliding:  How for to travel Up/Down. Negative = Down

// Sound Configuration
// The door sounds may be either UUIDs or a sound name. If they are a sound name, the
// sound must also be in the prim with this script.  Change the strings to "" for no sound.
string OpenSound = "cb340647-9680-dd5e-49c0-86edfa01b3ac"; //Door opening sound. 
string CloseSound = "e7ff1054-003d-d134-66be-207573f2b535"; //Door closing sound.
float SoundVolume = 1.0;  //How loud is it?  0.0 to 1.0


// No modifications needed below this line
integer open;
vector  Pos;
vector  Offset;

default
{
    state_entry() {
        Offset = <EastWest, NorthSouth, UpDown>;
        if (OpenTime < 1 ) {
            OpenTime = 1;
        }
        if (ProximityOpen == TRUE) { 
        llSensorRepeat("","",AGENT,ProximityDistance,PI,CheckTime); 
        }
        open = FALSE;
    }
    sensor(integer num) {
        if ((open != TRUE) && (SlideDoor != TRUE)) { 
        llSetRot(llGetRot() * llEuler2Rot(RotationOffset * DEG_TO_RAD)); 
        open = TRUE; 
            if(OpenSound != "") {
                llTriggerSound(OpenSound, SoundVolume);
            }
        }
        if (open != TRUE) {
            Pos = llGetLocalPos();
        }
        if ((open != TRUE) && (ProximityOpen == TRUE) && (SlideDoor == TRUE)) {
            llSetPos(Pos + Offset);
            open = TRUE;
            if(OpenSound != "") {
                llTriggerSound(OpenSound, SoundVolume);
            }
        }
            
        llSetTimerEvent(OpenTime);
    }
    collision_start(integer num) {
        if (open != TRUE) {
            Pos = llGetLocalPos();
        }
        if ((open != TRUE) && (BumpOpen == TRUE) && (SlideDoor != TRUE)) { 
        llSetRot(llGetRot() * llEuler2Rot(RotationOffset * DEG_TO_RAD)); 
        open = TRUE; 
            if(OpenSound != "") {
                llTriggerSound(OpenSound, SoundVolume);
            }
        if ((open != TRUE) && (BumpOpen == TRUE) && (SlideDoor == TRUE)) {
            llSetPos(Pos + Offset);
            open = TRUE;
            if(OpenSound != "") {
                llTriggerSound(OpenSound, SoundVolume);
            }
        }
        }
        llSetTimerEvent(OpenTime);
    }        
    touch_start(integer total_number) {
        if (open != TRUE) {
            Pos = llGetLocalPos();
        }
        if ((open != TRUE) && (ClickOpen == TRUE) && (SlideDoor != TRUE)) { 
        llSetRot(llGetRot() * llEuler2Rot(RotationOffset * DEG_TO_RAD)); 
        open = TRUE; 
            if(OpenSound != "") {
                llTriggerSound(OpenSound, SoundVolume);
            }
        }
        if ((open != TRUE) && (ClickOpen == TRUE) && (SlideDoor == TRUE)) {
            llSetPos(Pos + Offset);
            open = TRUE;
            if(OpenSound != "") {
                llTriggerSound(OpenSound, SoundVolume);
            }
        }
        llSetTimerEvent(OpenTime);
    }
    timer() {
        if (SlideDoor != TRUE) {            
            llSetRot(llGetRot() * llEuler2Rot((RotationOffset * -1) * DEG_TO_RAD));
        }
        else {
            llSetPos(Pos);
        }
        if(CloseSound != "") {
            llTriggerSound(CloseSound, SoundVolume);
        }
        open = FALSE;
        llSetTimerEvent(0);
    }
}
