

string generate_index(integer i)
{
  if (i < 10)
    return "0" + (string)i;

  return (string)i;
}

default
{
  on_rez(integer start_param)
  {
    if (start_param == 0)
      return;

    string message = (string)start_param;
    integer message_size = llStringLength(message);
    string index;
    string the_scale;

    if (message_size == 9)
    {
      index = llGetSubString(message, 0, 1);
      the_scale = "0." + llGetSubString(message, 2, 8);
    }
    else if (message_size == 8)
    {
      index = "0" + llGetSubString(message, 0, 0);
      the_scale = "." + llGetSubString(message, 1, 7);
    }
    else
    {
      index = "00";
      the_scale = "." + llGetSubString(message, 0, 6);
    }

    index = generate_index(((integer)index) - 1);

    rotation the_rotation = llEuler2Rot(<90.0 * DEG_TO_RAD, .0, .0>);
    llSetRot(the_rotation);

    float the_scale_value = (float)the_scale * 2.0 * 10.0;
    llSetScale(<the_scale_value, the_scale_value, the_scale_value>);

    string geometry = "geometry_" + index;
    llSetPrimitiveParams([PRIM_TYPE, PRIM_TYPE_SCULPT, geometry, PRIM_SCULPT_TYPE_SPHERE]);

    string texture = "texture_" + index;
    if(llGetInventoryType(texture) != INVENTORY_NONE)
      llSetTexture(texture, ALL_SIDES);
  }
}
