// This script is free to distribute and modify.  It is NOT for resale purposes but may be
// used in your own builds as long as next owner is allowed full permissions for the script.
// February 3, 2010 - Alessandra Carlos

// Note:  Although doors can be linked, I recommend that you don't link them to a build.
// If set at an angle different from the cardinal directions, linked doors will sometimes
// open to odd angles when rotating.  This doesn't seem to happen with unlinked doors.

integer OpenTime = 10; //How long the door stays open before shutting again.  Minimum = 1
integer ClickOpen = TRUE; //If the door can be clicked to open.  TRUE or FALSE
integer BumpOpen = TRUE; //If bumping the door opens it. TRUE or FALSE
integer ProximityOpen = FALSE; //Should the door auto open if someone is close? TRUE or FALSE
integer ProximityDistance = 3;  //How close before the door opens?
integer CheckTime = 1; //Number of second to wait between proximity checks.

// Rotation Door Configuration
// Use negative numbers to open in the opposite direction
vector RotationOffset = <0,0,90>; //The axis a rotating door spins on and how many degrees

// Sliding Door Configuration
// Enabling a sliding door turns off rotation.  If linked the door is slid in
// relation to the position of the root prim.
integer SlideDoor = TRUE;//Is this a sliding door?  TRUE or FALSE
float NorthSouth = 0.0; //Sliding: How far to travel North/South. Negative = South
float EastWest = 0.0; //Sliding:  How far to travel East/West.  Negative = West
float UpDown = 6.0; //Sliding:  How for to travel Up/Down. Negative = Down


//Sound to play on open, either a UUID or a name in the door contents
//if a name, it must be exact. Leave at "" for no sound
string      OpenSound = "AirDoorSlide";

//Volume to play open sound, 0.0 is same as no sound, 1.0 is max
float       OpenVol = 1.0;

//Sound to play on close, either a UUID or a name in the door contents
//if a name, it must be exact. Leave at "" for no sound
string      CloseSound = "AirDoorSlide";

//Volume to play close sound, 0.0 is same as no sound, 1.0 is max
float       CloseVol = 0.4;


//misc variables
vector      Pos;
vector      Offset;
integer     Open;
integer     x;

default
{
    state_entry()
    {
        Offset = <EastWest, NorthSouth, UpDown>;
    }
    
    touch_start(integer num)
    {
        for(x = 0; x < num; x++)
        {
            Open = !Open;
            if(Open)
            {
                Pos = llGetLocalPos();
                if(OpenSound != "") llTriggerSound(OpenSound, OpenVol);
                llSetPos(Pos + Offset);
                llSetTimerEvent(0);
            }

            else
            {
                if(CloseSound != "") llTriggerSound(CloseSound, CloseVol);
                llSetPos(Pos);
                llSetTimerEvent(0);
            }
        }
    }
    
    on_rez(integer param)
    {
        llResetScript();
    }
    
    moving_end()
    {
        if(Open)
        {
            Open = 0;
            llSetTimerEvent(0.0);
        }
    }
    
    timer()
    {
        if(CloseSound != "") llTriggerSound(CloseSound, CloseVol);
        llSetPos(Pos);
        llSetTimerEvent(0);
        Open = 0;
    }
}