//Original 1 prim double sliding glass door was made by Seagel Neville as public domain, Nov 2006
//Modified by Kevin Carbonaro (SL: Kevin Ballinger) 8 March 2007
//
//Fixes:
//-FIX - Now resetting the script will not re-position, scale, and rotate the object to some pre-defined numbers.
//
//To Do:
//-Improve Smoothness of Door Opening and Closing Animation.
//-Use a Dialog to Code Lock the door.

integer pitch = 5; //Steps for the door to take to open and close. More Steps will make the door open and close more slowly.
float TimeInterval = 6.0; //Seconds to keep the door open.
integer TouchFlag;
integer Holding;
integer SecureFlag;

Open()
{
    TouchFlag = TRUE;
    llTriggerSound("de7ac1a3-f31b-e1a4-5a21-5b9907921bf1", 1.0);
    integer i;
    for(i = 0; i < pitch + .5; i++)
    {
        llSetPrimitiveParams([PRIM_TYPE, 0, 0, <0.000000, 1.000000, 0.000000>,
        0.949000, <0.000000, 0.000000, 0.000000>, <(float)i/pitch, 1.000000, 0.000000>,
        <0.000000, 0.000000, 0.000000>]);   
    }
    llSetTimerEvent(TimeInterval);
}

Close()
{
    llSetTimerEvent(0);
    TouchFlag = FALSE;
    llTriggerSound("44f32d82-8604-1f29-37c9-a35baec646ee", 1.0);
    integer i;
    for(i = pitch - 1; i >= 0 ; i--)
    {
        llSetPrimitiveParams([PRIM_TYPE, 0, 0, <0.000000, 1.000000, 0.000000>,
        0.949000, <0.000000, 0.000000, 0.000000>, <(float)i/pitch, 1.000000, 0.000000>,
        <0.000000, 0.000000, 0.000000>]);
    }
}

TouchOpen()
{
    if(TouchFlag == FALSE)
    {
        Open();
    }
    else
    {
        Close();
    }
}

CollideOpen()
{
    if(TouchFlag == FALSE)
    {
        Open();
    }
    else
    {
        llSetTimerEvent(TimeInterval);
    }
}

Init()
{
    llSetPrimitiveParams([PRIM_MATERIAL, PRIM_MATERIAL_GLASS, PRIM_SIZE, llGetScale(),
    PRIM_TYPE, 0, 0, <0.0, 1.0, 0.0>, 0.949, <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, <0.0, 0.0, 0.0>,
    PRIM_FULLBRIGHT, ALL_SIDES, TRUE, PRIM_ROTATION, llGetRot(),
    PRIM_COLOR, ALL_SIDES, <0.0, 0.5, 0.0>, 0.5, PRIM_POSITION, llGetPos() + (<0, 0, 0> * llGetRot()),
    PRIM_TEXTURE, ALL_SIDES, "5748decc-f629-461c-9a36-a35a221fe21f",
    <1.0, 1.0, 0.0>, <0.0, 0.0, 0.0>, 0.0]);
}

default
{
    state_entry()
    {
        Init();
    }
    changed(integer change)
    {
        if(change & CHANGED_OWNER)
        {
            llResetScript();
        }
    }
    touch(integer total_number)
    {
        if(llDetectedKey(0) == llGetOwner())
        {
            Holding++;
            if(Holding == 50)
            {
                if(SecureFlag == FALSE)
                {
                    llOwnerSay("Door Locked");
                    SecureFlag = TRUE;
                }
                else
                {
                    llOwnerSay("Door Unlocked");
                    SecureFlag = FALSE;
                }
            }
        }
    }
    touch_end(integer total_number)
    {
        Holding = 0;
        if(SecureFlag == FALSE)
        {
            TouchOpen();
        }
        else
        {
            if(llDetectedKey(0) == llGetOwner())
            {
                TouchOpen();
            }
            else
            {
                llWhisper(0, "Sorry, this door is locked.");
            }
        }
    }
    collision_start(integer num_detected)
    {
        if(SecureFlag == FALSE)
        {
            CollideOpen();
        }
        else
        {
            if(llDetectedKey(0) == llGetOwner())
            {
                CollideOpen();
            }
            else
            {
                llWhisper(0, "Sorry, this door is locked.");
                llSleep(5.0);
            }
        }
    }
    timer()
    {
        Close();
    }
}  