// This script is licensed under GPL license version 2
//
// In short: feel free to redistribute and modify it, as long as
// any copies of it can be redistributed and modified as well.
//
// The official text of the licence is available at
// http://www.gnu.org/licences/gpl.html
//
// (c) The owner of Avatar Whidou Bienstock, 2008, 2009, 2010
// Large portions of this script are by Catherine Pfeffer
vector offset;                                                  // Distance between avatar's bottom and center

startAnimation()
{
    string name = llGetInventoryName(INVENTORY_ANIMATION, 0);

    llStopAnimation("sit");                                 // Stop the default animation
    llStartAnimation(name);                                 // and start the new one
}

stopAnimation()
{
    string name = llGetInventoryName(INVENTORY_ANIMATION, 0);

    llStopAnimation(name);                                  // Stop the animation
}

setSitTarget(string message ) {

    list msg = llParseString2List(message, [ "|" ], []);        // Split the data
    vector avPos = (vector) llList2String(msg, 0);              // Avatar's position
    rotation avRot = (rotation) llList2String(msg, 1);          // Avatar's rotation
    llSitTarget(avPos, avRot);                                  // Sitpose the objet (the purpose of the whole thing)
    llSetClickAction(CLICK_ACTION_SIT);                         // Make it easy to sit for new residents

}


default
{
    state_entry()
    {
        llSitTarget(ZERO_VECTOR,ZERO_ROTATION);
        
        string message = llGetObjectDesc();
        if (llSubStringIndex(message, "|") > 0 ) {
            setSitTarget(message);
        }
    }

    
    changed(integer change)
    {
        if (change & CHANGED_LINK)
        {
            if (llGetInventoryNumber(INVENTORY_ANIMATION))  // If there is at least one animation in the inventory
            {
                key who = llAvatarOnSitTarget();
                integer perm = llGetPermissions();

                if (who)                                    // If someone sits down, animate the avatar
                {
                    if ( (perm & PERMISSION_TRIGGER_ANIMATION) &&
                         (who == llGetPermissionsKey())
                       ) startAnimation();
                    else
                        llRequestPermissions(who, PERMISSION_TRIGGER_ANIMATION);
                }
                else                                        // If the person stands up and was playing the animation, stop the animation
                {
                    if (perm & PERMISSION_TRIGGER_ANIMATION)
                        stopAnimation();
                }
            }
        }
    }
    
    run_time_permissions(integer perm)
    {
        if (perm & PERMISSION_TRIGGER_ANIMATION)            // If the permission is granted, start the animation
            startAnimation();
    }
}
