// PICK-YOUR-OWN PUBLIC DANCE BALL
// by Mata Hari/Aine Caoimhe January 2014
//
// NOTES:
// This public dance ball script was written specifically to replace the white dance ball at Close Encounter and
// does not have all thefeatures of a more traditional general use public dance ball (but could be adapted).
// It simply allows each person to click and select the dance they want to play (which can be any dance
// in inventory) or stop dancing.
// It is scripted to keep sim load to the absolute minimum when there are a potentially large
// number of users, so this wouldn't be the recommended method for other applications
// (for instance I wouldn't normally have a listen perminently registered, but this method is lower
// sim load for a dialog that expects to accomodate multiple simultaneous users rather than
// registering and later removing unique handles for each user during use since the greatest
// script load will coincide with greatest user load which we definitely don't want!)
//
// REQUIRES:
// - the two necessary OSSL functions: osAvatarStopAnimation() and osAvatarPlayAnimation()
// - a minimum of 1 dance animation in inventory but I recommend having at least 9
//
// USAGE:
// - Place some animations into the prim's inventory and add this script...it will take care of the rest. You could just delete all of the scripts from your existing dance ball and then drop this into the prim and it will work right away
// - You can add or remove animations at any time...even during use. It will detect the change and build a new dances list automatically.
// - If you need to, you can reset the script even while the dance ball is in use! Users will probably not even notice :)
// - If yuo don't have full perm (copy/mod/trans) on an animation that is in the ball's inventory there could be
//   some slightly unpredictable results when someone tries to play it...I think it should still work but I'm not 100% sure. They don't
//   have to be set that way for next user...it's only the perms that you (the script owner) have on them that matter.
//
// CUSTOMIZATION:
// Set the values below to whatever you like...
//
// these two are just the text that appears in the top of the dialog box
string diaName="Pick-Your-Own-Dance Ball";
string diaMessage="Please select a dance below, or click NEXT or PREV to see more, or click STOP to stop dancing";
// this controls if you want floaty text above the ball...
integer showText=FALSE;                              // set it to FALSE if you don't want any text at all or TRUE if you do
string floatyName="D&J Pick-Your-Own-Dance Ball";   // name to show above it when using floaty text (or set to ="" for no name shown)
vector floatyTextColour=<0.0,0.3,0.0>;              // the vector colour of the text if it's shown (I set it to a dark green for now)
float floatyTextAlpha=0.65;                         // alpha of the floaty text.....0.0 would be invisible (transparent), 1.0 is no transparency at all
integer showNumberOfDancesLoaded=TRUE;              // set to TRUE to have the floaty text include the number of differenet dances available or FALSE not to
integer showNumberOfDancers=TRUE;                   // set to TRUE to have the floaty text show how many poeple it thinks are using it, or FALSE not to

// ***************************************************************************************************
// **        Please don't change anything below this line unless you know what you're doing         **
// ***************************************************************************************************
integer myChannel;
integer handle;
list danceList;
list diaIndexList; // strided [UUID of avi, last index]
float cleanTimer=600;

showMenu(key toucher, integer diaIndex)
{
    string diaText=diaName+"\n"+diaMessage;
    list butDia;
    list butRow1;
    list butRow2;
    list butRow3;
    list butRow4=["< PREV","STOP","NEXT >"];
    integer wrap=llGetListLength(danceList);
    integer d;
    while (++d<10)
    {
        if (d<4) butRow1+=llList2String(danceList,diaIndex);
        else if (d<7) butRow2+=llList2String(danceList,diaIndex);
        else butRow3+=llList2String(danceList,diaIndex);
        diaIndex++;
        if (diaIndex>=wrap) diaIndex=0;
    }
    butDia=butRow4+butRow3+butRow2+butRow1;
    llDialog(toucher,diaText,butDia,myChannel);
}
updateText()
{
    if (showText)
    {
        string floatyText;
        floatyText+=floatyName+"\n";
        if (showNumberOfDancesLoaded) floatyText+=(string)llGetListLength(danceList)+" dances loaded\n";
        if (showNumberOfDancers)
        {
            integer dancerCount=(integer)(llGetListLength(diaIndexList)/2);
            if (dancerCount==0) floatyText+="Currently no dancers";
            else if (dancerCount==1) floatyText+="Currently 1 dancer";
            else floatyText+="Currently "+(string)dancerCount+" dancers";
        }
        llSetText(floatyText,floatyTextColour,floatyTextAlpha);
    }
    else llSetText("",ZERO_VECTOR,0);
}
buildDanceList()
{
    // builds a list of the animations in inventory (ignoring any animation with a name length that exceeds button string limit) and sorts then alphabetically
    danceList=[];
    diaIndexList=[];
    integer i=llGetInventoryNumber(INVENTORY_ANIMATION);
    while (--i>-1)
    {
        string danceName=llGetInventoryName(INVENTORY_ANIMATION,i);
        if (llStringLength(danceName)>24)
        {
            llOwnerSay("Error...you have an animation in the dance ball's inventory with a name that is too long.\n"
                    +"Animation name: "+danceName+"\n"
                    +"The maximum allowed name length is 24 (for a button) but I recommend using much shorter names so they'll fit");
        }
        else danceList+=[danceName];
    }
    danceList=llListSort(danceList,1,TRUE);
    integer danceCount=llGetListLength(danceList);
    if (danceCount<1) llOwnerSay("ERROR! Unable to detect any usable animations in the dance ball's inventory. Please add at least one");
    while (danceCount<9) // if less than 9 dances, fill up to that with blanks
    {
        danceList+=["-"];
        danceCount++;
    }
    updateText();
}
playDance(key dancer,string danceName)
{
    // stop any currently running animations and start playing the desired dance
    // if danceName is "controlDanceBallStopDancing" release animation controls instead
    list animToStop=llGetAnimationList(dancer);
    integer anim=llGetListLength(animToStop);
    if (danceName=="controlDanceBallStopDancing") osAvatarPlayAnimation(dancer,"Stand");
    else osAvatarPlayAnimation(dancer,danceName);
    key dontStop=llGetInventoryKey(danceName);
    while (--anim>-1)
    {
        if (llList2Key(animToStop,anim) != dontStop) osAvatarStopAnimation(dancer,llList2String(animToStop,anim));
    }
}
default
{
    on_rez(integer onRez)
    {
        llResetScript();
    }
    changed(integer change)
    {
        if (change & CHANGED_INVENTORY) buildDanceList();
        else if (change & CHANGED_OWNER) llResetScript();
        else if (change & CHANGED_REGION_START) llResetScript();
    }
    state_entry()
    {
        myChannel= 0x80000000 | (integer)("0x"+(string)llGetKey());
        handle=llListen(myChannel,"",NULL_KEY,"");
        buildDanceList();
        updateText();
        llSetTimerEvent(cleanTimer);

        
        
    }
    touch_start(integer num_detected)
    {
        while (--num_detected>-1)
        {
            integer diaIndex;
            key toucher=llDetectedKey(num_detected);
            integer found=llListFindList(diaIndexList,[toucher]);
            if (found>-1) diaIndex=llList2Integer(diaIndexList,found+1);
            else
            {
                diaIndexList+=[toucher,0];
                updateText();
            }
            showMenu(toucher,diaIndex);
        }
    }
    timer()
    {
        // load reduction: periodically check to ensure we're not storing unnecessary diaIndexes and purge any entries for avi not in region
        integer check=llGetListLength(diaIndexList);
        while (check>0)
        {
            check-=2;
            if (llGetAgentSize(llList2Key(diaIndexList,check))==ZERO_VECTOR) diaIndexList=llDeleteSubList(diaIndexList,check, check+1);
        }
        updateText();
    }
    listen(integer channel, string name, key id, string message)
    {
        integer found=llListFindList(diaIndexList,id); // should always return a result
        if (found==-1)
        {
            // just in case it somehow got purged add to list and set index to 0...could happen if script is reset while 
            // someone has a dialog open... their index will be lost but otherwise it won't interrupt their use
            diaIndexList+=[id,0];
            found=llListFindList(diaIndexList,id);
            updateText();
        }
        integer newIndex=llList2Integer(diaIndexList,found+1);
        // handle possible responses
        if (message=="-")
        {
            // reshow last dialog
            showMenu(id,newIndex);
            return;
        }
        if (message=="STOP")
        {
            // remove from diaIndexList and release animations
            if (found>-1) diaIndexList=llDeleteSubList(diaIndexList,found,found+1);
            playDance(id,"controlDanceBallStopDancing");
            updateText();
            return;
        }
        if (message=="< PREV")
        {
            // show previous page of dances (or wrap to end)
            newIndex-=9;
            if (newIndex<0) newIndex+=llGetListLength(danceList);
            diaIndexList=llListReplaceList(diaIndexList,[newIndex],found+1,found+1);
            showMenu(id,newIndex);
            return;
        }
        if (message=="NEXT >")
        {
            // show next page of dances (or wrap to start)
            newIndex+=9;
            if (newIndex>=llGetListLength(danceList)) newIndex=0;
            diaIndexList=llListReplaceList(diaIndexList,[newIndex],found+1,found+1);
            showMenu(id,newIndex);
            return;
        }
        // getting here means message was the name of a dance so play it (fall-through default)
        playDance(id,message);
    }
} 