//FreeView 1.2 WebGuide - By CrystalShard Foo
//Multifunctional Picture viewer and Video control script with webguide support
//This script is distributed for free and must stay that way. DO NOT SELL THIS SCRIPT UNDER ANY CIRCUMSTANCE.

//Help for using this script can be obtained at: http://www.slguide.com/help

//Feel free to modify this script and post your improvement. Leave the credits intact but feel free to add your name at its bottom.


//Constants
integer PICTURE_ROTATION_TIMER = 15;   //In whole seconds

integer DISPLAY_ON_SIDE = ALL_SIDES; //Change this to change where the image will be displayed

key BLANK = "b76da477-084b-219b-5430-399e4a2144fd"; //Blank texture - Used when there are no textures to display in Picture mode
integer PICTURE_MATERIAL = PRIM_MATERIAL_LIGHT;  //All this does is make the prim bright. No worries about light related lag.

integer REMOTE_CHANNEL = 9238742;

integer mode = 0;           //Freeview mode.
                            //Mode 0 - Power off
                            //Mode 1 - Picture viewer
                            //Mode 2 - Video

integer listenHandle = -1;      //Dialog menu listen handler
integer listenUrl = -1;         //listen handler for channel 1 for when a URL is being added
integer listenTimer = -1;       //Timer variable for removing all listeners after 2 minutes of listener inactivity
integer listenRemote = -1;      //listen handler for the remote during initial setup
integer encryption = 0;
integer numberofnotecardlines = 0;  //Stores the current number of detected notecard lines.
integer notecardline = 0;       //Current notecard line

integer loop_image = TRUE;     //Are we looping pictures with a timer? (picture mode)
integer current_texture = 0;    //Current texture number in inventory being displayed (picture mode)
integer chan;                   //llDialog listen channel

integer isGroup = TRUE;
key groupcheck = NULL_KEY;
key last_owner;
key XML_channel;

pictures()      //Change mode to Picture Viewer
{
    //Initilize variables
    
    //Change prim to Light material while coloring face 0 black to prevent light-lag generation.
    llSetPrimitiveParams([PRIM_BUMP_SHINY,DISPLAY_ON_SIDE,PRIM_SHINY_NONE,PRIM_BUMP_NONE,PRIM_COLOR,DISPLAY_ON_SIDE,<1,1,1>,1.0,PRIM_MATERIAL,PICTURE_MATERIAL]);
    llSetColor(<0,0,0>,0);

    integer check = llGetInventoryNumber(INVENTORY_TEXTURE);
     
    if(check == 0)
    {
        report("No pictures found.");
        llSetTexture(BLANK,DISPLAY_ON_SIDE);
        return;
    }
    else    
        if(current_texture > check)
            //Set to first texture if available
            current_texture = 0;
            
    display_texture(current_texture);
}

off()
{
    report("Click to power on.");
    llSetPrimitiveParams([PRIM_BUMP_SHINY,DISPLAY_ON_SIDE,PRIM_SHINY_LOW,PRIM_BUMP_NONE,PRIM_COLOR,DISPLAY_ON_SIDE,<0.1,0.1,0.1>,1.0,PRIM_MATERIAL,PRIM_MATERIAL_PLASTIC,PRIM_TEXTURE,DISPLAY_ON_SIDE,BLANK,llGetTextureScale(DISPLAY_ON_SIDE),llGetTextureOffset(DISPLAY_ON_SIDE),llGetTextureRot(DISPLAY_ON_SIDE)]);
}

string mediatype(string ext)    //Returns a string stating the filetype of a file based on file extension
{
    ext = llToLower(ext);
    if(ext == "jpg" || ext == "mpeg" || ext == "gif" || ext == "png" || ext == "pict" || ext == "tga" || ext == "tiff" || ext == "sgi" || ext == "bmp")
        return "Image";
    if(ext == "txt")
        return "Text";
    return "Unknown";
}

browse(key id)      //Image browser function for picture viewer mode
{
    integer check = llGetInventoryNumber(INVENTORY_TEXTURE);
    string header;
    if(check > 0)
        header = "("+(string)(current_texture+1)+"/"+(string)check+") "+llGetInventoryName(INVENTORY_TEXTURE,current_texture);
    else
        header = "No pictures found.";
    llDialog(id,"** Monitor Control **\n Picture Viewer mode\n- Image browser\n- "+header,["Back","Next","Menu"],chan);
    extendtimer();
}

report(string str)
{
    llSetObjectDesc(str);
}

extendtimer()       //Add another 2 minute to the Listen Removal timer (use when a Listen event is triggered)
{
    if(listenHandle == -1)
        listenHandle = llListen(chan,"","","");
    listenTimer = (integer)llGetTime() + 120;
    if(loop_image == FALSE)
        llSetTimerEvent(45);
}

menu(key id)        //Dialog menus for all 3 modes
{
    list buttons = [];
    string title = "** Monitor control **";
    
    extendtimer();

    if(mode != 0)
    {
        if(mode == 1)       //Pictures menu
        {
            title+="\n  Picture Viewer mode";
            buttons+=["Browse"];
            if(loop_image == FALSE)
                buttons+=["Loop"];
            else
                buttons+=["Unloop"];
            buttons+=["Power off","Help"];
        }
    }
    else
        buttons += ["Pictures","Help"];
    
    llDialog(id,title,buttons,chan);
}

display_texture(integer check)  //Display texture and set name in description (picture mode)
{                               //"Check" holds the number of textures in contents. The function uses "current_texture" to display.
    string name = llGetInventoryName(INVENTORY_TEXTURE,current_texture);
    llSetTexture(name,DISPLAY_ON_SIDE);
    report("Showing picture: "+name+" ("+(string)(current_texture+1)+"/"+(string)check+")");
}
    

next()  //Change to next texture (picture mode)
{       //This function is used twice - by the menu and timer. Therefor, it is a dedicated function.
    current_texture++;
    integer check = llGetInventoryNumber(INVENTORY_TEXTURE);
    if(check == 0)
    {
        llSetTexture(BLANK,DISPLAY_ON_SIDE);
        current_texture = 0;
        report("No pictures found.");
        return;
    }
    if(check == current_texture)
        current_texture = 0;
    
    display_texture(check);
    return;
}

default
{
    state_entry()
    {
        chan = (integer)llFrand(1000) + 1000;   //Pick a random listen channel for the listener
        if(PICTURE_ROTATION_TIMER <= 0)         //Ensure the value is no less or equal 0
            PICTURE_ROTATION_TIMER = 1;
        llListenRemove(listenHandle);
        listenHandle = -1;
        last_owner = llGetOwner();
        groupcheck = llRequestAgentData(llGetOwner(),DATA_NAME);
        mode = 1;
        pictures();
        llSetTimerEvent(PICTURE_ROTATION_TIMER);
    }
    
    on_rez(integer i)
    {
        llResetScript();
    }

    touch_start(integer total_number)
    {
        //-------------------------------------------------------------------------------
        //Listen only to owner or group member. Edit this code to change access controls.
        if(llDetectedKey(0) != llGetOwner() && llDetectedGroup(0) == FALSE)
            return;
        //-------------------------------------------------------------------------------

        if(llGetOwnerKey(llGetKey()) != last_owner)  //Sense if object has been deeded to group for Web Guide function
        {
            isGroup = TRUE;
            last_owner = llGetOwner();
            groupcheck = llRequestAgentData(llGetOwner(),DATA_NAME);
        }

        menu(llDetectedKey(0));
    }
    
    changed(integer change)
    {
        if(change == CHANGED_INVENTORY) //If inventory change
            if(mode == 1)   //If picture mode
            {
                integer check = llGetInventoryNumber(INVENTORY_TEXTURE);
                if(check != 0)
                {
                    current_texture = 0;
                    display_texture(check);
                }
                else
                {
                    llSetTexture(BLANK,DISPLAY_ON_SIDE);
                    report("No pictures found.");
                }
            }
    }
    
    listen(integer channel, string name, key id, string message)
    {
        if(message == "Pictures")
        {
            pictures();
            mode = 1;
            menu(id);
            return;
        }

        if(message == "Power off")
        {
//            if(mode == 2)
//                llParcelMediaCommandList([PARCEL_MEDIA_COMMAND_UNLOAD]);
            off();
            mode = 0;
            return;
        }
        if(message == "Help")
        {
            llSay(0,"Help documentation is available at: http://www.slguide.com/help");
        }
        if(mode == 1)
        {
            if(message == "Browse")
            {
                loop_image = FALSE;
                browse(id);
                return;
            }
            if(message == "Next")
            {
                extendtimer();
                next();
                browse(id);
            }
            if(message == "Back")
            {
                extendtimer();
                current_texture--;
                integer check = llGetInventoryNumber(INVENTORY_TEXTURE);
                if(check == 0)
                {
                    llSetTexture(BLANK,DISPLAY_ON_SIDE);
                    current_texture = 0;
                    report("No pictures found.");
                    return;
                }
                if(current_texture < 0)
                    current_texture = check - 1;
                
                display_texture(check);
                
                browse(id);
                return;
            }
            if(message == "Menu")
            {
                menu(id);
                return;
            }
            if(message == "Loop")
            {
                llSetTimerEvent(PICTURE_ROTATION_TIMER);
                loop_image = TRUE;
                llOwnerSay("Picture will change every "+(string)PICTURE_ROTATION_TIMER+" seconds.");
                return;
            }
            if(message == "Unloop")
            {
                loop_image = FALSE;
                llOwnerSay("Picture loop disabled.");
                return;
            }
        }
    }
    
    dataserver(key queryid, string data)
    {
        if(queryid == groupcheck)       //Test if object is deeded to group
        {
            groupcheck = NULL_KEY;
            isGroup = FALSE;
            return;
        }
    }
    
    timer()
    {
        if(loop_image == FALSE || mode != 1) //If we're not looping pictures or are in picture mode at all
                llSetTimerEvent(0.0);   //Remove timer

        if(loop_image == TRUE && mode == 1) //If we're looping pictures and and we're in picture mode...
            next(); //Next picture
    }
}
