
float fTimerInterval = 0.25; 

integer PRIMCHAN = -192589;  
                                    



vector vOffset;
rotation rRotation;
integer bNeedMove;
vector vDestPos;
rotation rDestRot;
integer bMovingSingle = FALSE;
integer bAbsolute = FALSE;
integer bRecorded = FALSE;


list record_mem = []; 
key g_quary_nc;  
integer nc_line;  
integer iStartValue;



float vDestPosXMIN = 0.0;
float vDestPosXMAX = 1024.0;
float vDestPosYMIN = 0.0;
float vDestPosYMAX = 1024.0;
float vDestPosZMAX = 10000.0;

start_move(string sText, key kID)
{
    
    if( !bRecorded ) return;

    
    
    if( llGetOwner() != llGetOwnerKey(kID) ) return;

    
    if(!bAbsolute) {
        
        
        sText = other_words(sText, " ");
        list lParams = llParseString2List(sText, [ "|" ], []);
        vector vBase = (vector)llList2String(lParams, 0);
        rotation rBase = (rotation)llList2String(lParams, 1);

        vDestPos = (vOffset * rBase) + vBase;
        rDestRot = rRotation * rBase;
    } else {
        
        vDestPos = vOffset;
        rDestRot = rRotation;
    }

    
    if(vDestPos.x < vDestPosXMIN) vDestPos.x = vDestPosXMIN;
    if(vDestPos.x > vDestPosXMAX) vDestPos.x = vDestPosXMAX;
    if(vDestPos.y < vDestPosYMIN) vDestPos.y = vDestPosYMIN;
    if(vDestPos.y > vDestPosYMAX) vDestPos.y = vDestPosYMAX;
    if(vDestPos.z > vDestPosZMAX) vDestPos.z = vDestPosZMAX;


    
    if( !bNeedMove )
    {
        llSetTimerEvent(fTimerInterval);
        bNeedMove = TRUE;
    }
    return;
}


string other_words(string In_String, string Token)
{
    
    
    
    if( Token == "" ) Token = " ";

    integer pos = llSubStringIndex(In_String, Token);

    
    if( pos >= 1 )
        return llGetSubString(In_String, pos + 1, llStringLength(In_String));
    else
        return "";
}



string first_word(string In_String, string Token)
{
    
    
    
    if(Token == "") Token = " ";
    integer pos = llSubStringIndex(In_String, Token);

    
    if( pos >= 1 )
        return llGetSubString(In_String, 0, pos - 1);
    else
        return In_String;
}


do_move()
{
    integer i = 0;
    vector vLastPos = ZERO_VECTOR;
    while( (i < 5) && (llGetPos() != vDestPos) )
    {
        list lParams = [];

        
        if( llGetPos() != vDestPos )
        {
            
            
            if( llGetPos() == vLastPos )
            {
                
                lParams = [ PRIM_POSITION, llGetPos() + <0, 0, 10.0> ];
                
            } else {
                
                vLastPos = llGetPos();
            }
        }

        
        
        
        integer iHops = llAbs(llCeil(llVecDist(llGetPos(), vDestPos) / 10.0));
        integer x;
        for( x = 0; x < iHops; x++ ) {
            lParams += [ PRIM_POSITION, vDestPos ];
        }
        llSetPrimitiveParams(lParams);
        
        i++;
    }

    
    llSetRot(rDestRot);
}




default
{
    
    state_entry()
    {
        
        llListen(PRIMCHAN, "", NULL_KEY, "");
        llRegionSay(PRIMCHAN, "READYTOPOS");
    }

    
    on_rez(integer iStart)
    {
        iStartValue = iStart;
        if(llGetInventoryType("Builders Buddy Memory") != -1)
        {
            nc_line = 0;
            g_quary_nc = llGetNotecardLine("Builders Buddy Memory", nc_line);
        }
        else
        {
            
            if( iStart != 0 )
            {
                PRIMCHAN = iStart;
                state reset_listeners;
            }
        }
    }

    
    listen(integer iChan, string sName, key kID, string sText)
    {
        string sCmd = llToUpper(first_word(sText, " "));

        if( sCmd == "SET_LIMITS" )
        {
            list lParams = llParseString2List(sText, [ " " ], []);
            
            vDestPosXMIN = llList2Float(lParams, 1);
            vDestPosXMAX = llList2Float(lParams, 2);
            vDestPosYMIN = llList2Float(lParams, 3);
            vDestPosYMAX = llList2Float(lParams, 4);
            vDestPosZMAX = llList2Float(lParams, 5);        
        
        }   
        else if( sCmd == "RECORD" )
        {
            record_mem = [];
            
            
            sText = other_words(sText, " ");
            list lParams = llParseString2List(sText, [ "|" ], []);
            vector vBase = (vector)llList2String(lParams, 0);
            rotation rBase = (rotation)llList2String(lParams, 1);

            vOffset = (llGetPos() - vBase) / rBase;
                record_mem += "vOffset|" +(string)vOffset ;
            rRotation = llGetRot() / rBase;
                record_mem += "rRotation|" +(string)rRotation ;
            bAbsolute = FALSE;
                record_mem += "bAbsolute|" +(string)bAbsolute ;
            bRecorded = TRUE;
                record_mem += "bRecorded|" +(string)bRecorded ;
            
            if(llGetInventoryType("Builders Buddy Memory") != -1)
            {
                llRemoveInventory("Builders Buddy Memory");
            }
            osMakeNotecard( "Builders Buddy Memory", record_mem );
            
            
            llOwnerSay("Recorded position.");
            return;
        }

        if( sCmd == "RECORDABS" )
        {
            record_mem = [];
            
            rRotation = llGetRot();
                record_mem += "rRotation|" +(string)rRotation ;
            vOffset = llGetPos();
                record_mem += "vOffset|" +(string)vOffset ;
            bAbsolute = TRUE;
                record_mem += "bAbsolute|" +(string)bAbsolute ;
            bRecorded = TRUE;
                record_mem += "bRecorded|" +(string)bRecorded ;
                
            if(llGetInventoryType("Builders Buddy Memory") != -1)
            {
                llRemoveInventory("Builders Buddy Memory");
            }
            osMakeNotecard( "Builders Buddy Memory", record_mem );                
            
            llOwnerSay("Recorded sim position.");
            return;
        }

        
        if( sCmd == "MOVE" )
        {
            start_move(sText, kID);
            return;
        }

        if( sCmd == "MOVESINGLE" )
        {
            
            if(!bMovingSingle) {
                
                bMovingSingle = TRUE;

                
                start_move(sText, kID);
                return;
            }
        }

        
        if( sCmd == "DONE" )
        {
            
            if(llGetInventoryType("Builders Buddy Memory") != -1)
            {
                llRemoveInventory("Builders Buddy Memory");
            }
            llRemoveInventory(llGetScriptName());
            return;
        }

        
        if( sCmd == "CLEAN" )
        {
            
            llDie();
            return;
        }

        
        if( sCmd == "RESET" )
        {
            llResetScript();
        }
    }

    
    timer()
    {
        
        llSetTimerEvent(0.0);

        
        if( bNeedMove )
        {
            
            do_move();

            
            if(bMovingSingle) {
                llRegionSay(PRIMCHAN, "ATDEST");
            }

            
            bNeedMove = FALSE;
        }
        return;
    }
    dataserver(key queryid, string data)
    {
        if ( queryid == g_quary_nc)
        {
            if (data != EOF)
            {
                list n = llParseString2List(data, ["|"], []);
                
                if(llList2String(n, 0) == "vOffset")
                {
                    vOffset = llList2Vector(n, 1);
                }
                else if(llList2String(n, 0) == "rRotation")
                {
                    rRotation = llList2Rot(n, 1);
                }
                else if(llList2String(n, 0) == "bAbsolute")
                {
                    bAbsolute = (integer)llList2String(n, 1);
                }
                else if(llList2String(n, 0) == "bRecorded")
                {
                    bRecorded = (integer)llList2String(n, 1);
                }
                nc_line++;
                g_quary_nc = llGetNotecardLine("Builders Buddy Memory", nc_line);
            }
            else
            {
                
                if( iStartValue != 0 )
                {
                    PRIMCHAN = iStartValue;
                    state reset_listeners;
                }
            }
        }
    }
}





state reset_listeners
{
    
    state_entry()
    {
        state default;
    }
}
 