// NPC creator 2017-06-16 by Shinobar
// FP Syncronaized Dance compatible
integer DEBUG = FALSE;
integer CHANNEL = 0;  //telling partner
string NEWNAME = ""; //full name, such as "Satomi model";
string LASTNAME = "clone";   //one word such as "clone"
key CLONEFROM = ""; //"57cb6a8d-89cf-4615-8b6c-3b1e5267416d";
string NOTEHEADER = "~~~NPC";  //top word of appearance notecards
integer OWNERONLY = FALSE;   //restrict users only the owner
float RANGE = 0.0;  //meters, detection scope
integer TIMEOUT = 60;   //seconds, dialog time out
vector CreatePos = <0.0, 0.0, 1.0>; // Relative Position where NPC will be rezzed at first 

integer AUTOPOP = FALSE;   // auto pop up partner dialog
string TouchText = "NPC";
string partnerMessage = "Right click and select 'NPC' on the other ball to call a robot partner.";
string helpMessage = "Touch me to create NPC.";
string createMessage = "Do you want to create new NPC?
新しくクローンを作成しますか？";
string removeMessage = "Do you want to remove your NPC? The NPC only you own are removed.
クローンを削除しますか？
";
string namingMessage = "Input new NPC name.
新しいNPCに名前を付けてください。英数字に限ります。";
string saveMessage = "You can save its appearance on a notecard,
容姿を保存することもできます。";
string sittingMessage = "A NPC is already sitting on. ";
string noteDetectedMessage = "Apperance notecard(s) found.";
string loadMessage = "You can load a saved one or create new NPC.
保存されたクローンを読み込むか、新しくクローンを作成できます。";
string removeButton = "Remove NPC";
string createButton = "*Create new";
string saveButton = "Save note";
string BACK = "Back <--";
string NEXT = "-->Next";
string BLANK = "......";
string CANCEL = "*Cancel*";

key npc = NULL_KEY;
key agent = NULL_KEY;
string notecard;
string detectedMessage;
list npcs = [];
integer channel;
integer handle = 0;
integer menu_channel;
integer menu_handle;
key partner = NULL_KEY;
key last_partner = NULL_KEY;
list notes = [];
list noteButtons = [];
integer total;
integer page = 0;
integer naming = FALSE;
string newname = "";
integer max_char = 24;

debug(string msg)
{
    if (DEBUG) llOwnerSay(msg);
}

help()
{
    if (OWNERONLY) llOwnerSay(helpMessage);
    else llSay(0, helpMessage);
}

search()
{
    notes = [];
    noteButtons = [];
    key id = llAvatarOnSitTarget();
    if (id != NULL_KEY)
    {
    //debug(llKey2Name(id) + " owned by " + llKey2Name(osNpcGetOwner(id)));
        if ( osIsNpc(id) && osNpcGetOwner(id) == llGetOwner() )
        {
            npc = id;
            npcs = [id];
            detectedMessage = sittingMessage;
            open_dialog(agent);
            return;
        }
    }
    if ( llFabs(RANGE) > 0.001 ) llSensor("", NULL_KEY, NPC|AGENT, RANGE, PI);
    else nonpc();
}

nonpc()
{
        npcs = [];
        debug("No NPC detected.");
        detectedMessage = "";
        if ( NOTEHEADER != "" ) find_notecards(NOTEHEADER);
        open_dialog(agent);
}

open_dialog(key agent)
{
    llSetTimerEvent(0.0);
    if (handle) llListenRemove(handle);
    if (naming)
    {
        menu_handle = llListen(menu_channel, "", agent, "");
        llTextBox(agent, namingMessage, menu_channel);
        llSetTimerEvent((float)TIMEOUT);
        return;
    }
    string msg = detectedMessage;
    list buttons = [];
    if ( llGetListLength(npcs) > 0 )
    {
        buttons += [ removeButton ];
        msg += removeMessage;
        if ( notecard == "" )
        {
            buttons += [ saveButton ];
            msg += saveMessage;
        }
        buttons += [CANCEL];
    }
    else
    {
        buttons = noteButtons;
        msg = createMessage;
        if (total > 1)
        {
            detectedMessage = noteDetectedMessage;
            msg = detectedMessage + loadMessage;
            if ( page == 0 )
            {
                buttons = [CANCEL] + buttons;
            }
            else
            {
                integer m = (total + 8)/9;
                msg = "Page " + (string)page +"/" + (string)m + "\n" + msg;
                if (page == 1 )
                {
                    buttons = [CANCEL, BLANK, NEXT];
                }
                else if (page == m)
                {
                    buttons = [CANCEL, BACK, BLANK];
                }
                else
                {
                    buttons = [CANCEL, BACK, NEXT];
                }
                buttons += llList2List(noteButtons, (page -1)*9, page*9 -1);
            }
        }
    }
    llInstantMessage(agent, detectedMessage + "A dailog will be pop up.");
    menu_handle = llListen(menu_channel, "", agent, "");
    llDialog(agent, msg, buttons, menu_channel);
    llSetTimerEvent((float)TIMEOUT);
}
close_dialog()
{
    llSetTimerEvent(0.0);
    if (menu_handle) llListenRemove(menu_handle);
    menu_handle = 0;
}

remove_npcs()
{
    integer i;
    for (i = 0; i < llGetListLength(npcs); ++i)
    {
        osNpcRemove(llList2Key(npcs, i));
    }
    npc = NULL_KEY;
    llOwnerSay("All NPC(s) removed.");
}

createNPC(string notecard)
{
    string firstname;
    string lastname;
    string cloneFrom = CLONEFROM;
    debug("notecard:" + notecard);
    if (newname == "" ) newname = NEWNAME;
    if ( notecard != "" )
    {
        cloneFrom = notecard;
        newname = llGetSubString(notecard, llStringLength(NOTEHEADER) + 1 ,-1);
    }
    else
    {
        if (cloneFrom == "" || cloneFrom == NULL_KEY ) cloneFrom = agent;
        else if (llKey2Name(cloneFrom) == "")
        {
            llInstantMessage(agent, "Original avatar is not online. Yourself is used instead.");
            cloneFrom = agent;
        }
         if ( newname == "" ) newname = key2firstname(cloneFrom);
    }
    list words;
    words = llParseString2List(newname, [" "], []);
    firstname = llList2String(words, 0);
    if (lastname == "" ) lastname = llList2String(words, 1);
    if (lastname == "") lastname = LASTNAME;
    vector position = llGetPos() + CreatePos;
    integer options = 0;
    npc = osNpcCreate(firstname, lastname, position, cloneFrom, options);
    llSay(0, "A NPC named '" + firstname + " " + lastname + "' created.");
    //if ( notecard != "" ) osNpcLoadAppearance(npc, notecard);
    llOwnerSay("Touch me again to remove the NPC.");
    unsit();
    osNpcSit(npc, llGetKey(), 0);
    debug("Sit");
}

integer find_notecards(string keyword)
{
    string name;
    list words;
    integer i;
    notes = [""];
    noteButtons = [createButton];
    integer keylength = llStringLength(keyword);
    for (i=0; i < llGetInventoryNumber(INVENTORY_NOTECARD); ++i)
    {
        name = llGetInventoryName(INVENTORY_NOTECARD, i);
        words = llParseString2List(name, [" "], []);
        if ( llSubStringIndex(llList2String(words, 0), keyword) >= 0 )
        {
            notes += [ name ];
            noteButtons += [ llGetSubString(name, keylength + 1, keylength + 64) ];
        }
    }
    total = llGetListLength(notes);
    page = 0;
    if (total > 12 ) page = 1;
    return llGetListLength(noteButtons);
}

string key2firstname(key id)
{
    string s = llKey2Name(id);
    if ( s == "" ) return "";
    list words = llParseString2List(s, [" "], []);
    return llList2String(words, 0);
}

unsit()
{
    key sitter = llAvatarOnSitTarget();
    if (sitter != NULL_KEY) llUnSit(sitter);
    llSleep(2.0);
}

command(string str, integer num, key id)
{
    if ( str == "sit" )
    {
        if ( id == partner ) return;
        partner = id;
        agent =  llAvatarOnSitTarget();
        if ( agent == NULL_KEY ) npc = NULL_KEY;
        if ( npc != NULL_KEY )
        {
            if ( partner == NULL_KEY ) llSetTimerEvent(TIMEOUT);
            else llSetTimerEvent(0);
            return;
        }
        //if ( npc == NULL_KEY )
        if ( partner != NULL_KEY && agent == NULL_KEY )
        {
                if ( osIsNpc(partner) ) return;
                if ( OWNERONLY && partner != llGetOwner() ) return;
                agent = partner;
                if ( llKey2Name(agent) != "" )
                {
                    if (AUTOPOP) search();
                    else llInstantMessage(partner, partnerMessage);
                }
        }
    } 
}

hotstart()
{
    llSetTouchText(TouchText);
    agent = llGetOwner();
    help();
    menu_channel = -1*llCeil(llFrand(990.0) + 10.0);
    if (channel) llListen(channel, "", NULL_KEY, "");
}

default
{
    state_entry()
    {
        channel = CHANNEL;
        hotstart();
    }

    on_rez(integer param)
    {
        if (param)channel = param;
        hotstart();
    }

    touch_start(integer num)
    {
        agent = llDetectedKey(0);
        if ( OWNERONLY && agent != llGetOwner() ) return;
        search();
     }

    sensor(integer num)
    {
        key id;
        integer i;
        npcs = [];
        noteButtons = [];
        for (i = 0; i < num; ++i)
        {
            id =  llDetectedKey(i);
            if (osIsNpc(id) && osNpcGetOwner(id) == llGetOwner() )  npcs += [ id ];
        }
        num = llGetListLength(npcs);
        if (num)
        {
            detectedMessage = (string)num + " NPC detected. ";
            open_dialog(llGetOwner());
        }
        else
        {
            detectedMessage = "";
            if ( NOTEHEADER != "" ) find_notecards(NOTEHEADER);
            open_dialog(agent);
        }
    }
    no_sensor()
    {
        nonpc();
    }
    
    listen(integer ch, string name, key talker, string msg)
    {
        debug("listen channel#" + (string)ch + ":" + msg);
        if ( ch == channel )
        {
            list dataList = llParseString2List(msg, [" "], [ ]);
            string cmd = llList2String(dataList, 0);
            integer num = llList2Integer(dataList, 1);
            key id = llList2Key(dataList, 2);
            command(cmd, num, id);
            return;
        }
        if ( ch != menu_channel ) return;
        close_dialog();
        if (naming)
        {
            notecard = "";
            newname = llGetSubString(msg, 0, max_char);
            createNPC("");
            naming = FALSE;
            return;            
        }
        else if (msg == removeButton)
        {
            notecard = "";
            remove_npcs();
            help();
        }
        else if (msg == createButton)
        {
            if (NEWNAME != "" )
            {
                notecard = "";
                newname = NEWNAME;
                createNPC("");
                return;
            }
            naming = TRUE;
            open_dialog(agent);
        }
        else if ( msg == saveButton )
        {
            npc = llList2Key(npcs, 0);
            //string firstname = key2firstname(npc);
            notecard = NOTEHEADER + " " + newname;
            osNpcSaveAppearance(npc, notecard);
            llInstantMessage(agent, "Appearance is saved on a notecard '" + notecard + "'.");
        }
        else if ( msg == BACK  && page > 1 )
        {
            --page;
            open_dialog(agent);
            return;
        }
        else if (msg == NEXT)
        {
            ++page;
            open_dialog(agent);
            return;
        }
        else
        {
            integer index = llListFindList(noteButtons, msg);
            debug((string)index);
            if ( index >= 0 )
            {
                notecard = llList2String(notes, index);
                createNPC(notecard);
                return;
            }
            llInstantMessage(agent, "Removing/Creating canceled.");
            help();
        }
    }

    link_message(integer sender, integer num, string str, key id)
    {
        //debug((string)sender + ":" + (string)num + ":" + str + " " + (string)id);
        // FP Syncronized Dance compatible
        if ( sender == llGetLinkNumber() ) return;
        if ( id == "BALL" )
        {
            if ( num == 0 ) id = NULL_KEY;
            command("sit", 0, id);
            return; 
        }
        command(str, num, id);
    }
    
    timer()
    {
        llSetTimerEvent(0);
        if ( npc != NULL_KEY )
        {
            npcs = [ npc ];
            remove_npcs();
            return;
        }
        llInstantMessage(agent, "Action canceled due to time out.");
        close_dialog();
        naming = FALSE;
        help();
        //if (createQueue) createNPC();
    }

} 