integer FARM_CHANNEL = -911201;
string PASSWORD="*";
string mode;

integer chan(key u)
{
    return -1 - (integer)("0x" + llGetSubString( (string) u, -6, -1) )-393;
}



integer listener=-1;
integer listenTs;

startListen()
{
    if (listener<0) 
    {
        listener = llListen(chan(llGetKey()), "", "", "");
        listenTs = llGetUnixTime();
    }
}

checkListen()
{
    if (listener > 0 && llGetUnixTime() - listenTs > 300)
    {
        llListenRemove(listener);
        listener = -1;
    }
}


float food=0.;
float water=100.;
integer lastFood=0;
integer lastWater=0;
integer lastTs;

string status;
list animals;


psys(key k)
{
 
     llParticleSystem(
                [
                    PSYS_SRC_PATTERN, PSYS_SRC_PATTERN_EXPLODE,
                    PSYS_SRC_BURST_RADIUS,1,
                    PSYS_SRC_ANGLE_BEGIN,0,
                    PSYS_SRC_ANGLE_END,0,
                    PSYS_SRC_TARGET_KEY, (key) k,
                    PSYS_PART_START_COLOR,<1.000000,1.00000,0.800000>,
                    PSYS_PART_END_COLOR,<1.000000,1.00000,0.800000>,
                        
                    PSYS_PART_START_ALPHA,.5,
                    PSYS_PART_END_ALPHA,0,
                    PSYS_PART_START_GLOW,0,
                    PSYS_PART_END_GLOW,0,
                    PSYS_PART_BLEND_FUNC_SOURCE,PSYS_PART_BF_SOURCE_ALPHA,
                    PSYS_PART_BLEND_FUNC_DEST,PSYS_PART_BF_ONE_MINUS_SOURCE_ALPHA,
                    
                    PSYS_PART_START_SCALE,<0.100000,0.100000,0.000000>,
                    PSYS_PART_END_SCALE,<1.000000,1.000000,0.000000>,
                    PSYS_SRC_TEXTURE,"",
                    PSYS_SRC_MAX_AGE,2,
                    PSYS_PART_MAX_AGE,5,
                    PSYS_SRC_BURST_RATE, 10,
                    PSYS_SRC_BURST_PART_COUNT, 30,
                    PSYS_SRC_ACCEL,<0.000000,0.000000,0.000000>,
                    PSYS_SRC_OMEGA,<0.000000,0.000000,0.000000>,
                    PSYS_SRC_BURST_SPEED_MIN, 0.1,
                    PSYS_SRC_BURST_SPEED_MAX, 1.,
                    PSYS_PART_FLAGS,
                        0 |
                        PSYS_PART_EMISSIVE_MASK |
                        PSYS_PART_TARGET_POS_MASK|
                        PSYS_PART_INTERP_COLOR_MASK |
                        PSYS_PART_INTERP_SCALE_MASK
                ]);
                
}

refresh()
{
   
    

   /* vector v ;
    v = llList2Vector(llGetLinkPrimitiveParams(5, [PRIM_POS_LOCAL]), 0);
    v.z = 0.142 + 2.5*water/100;
    llSetLinkPrimitiveParamsFast(5, [PRIM_POS_LOCAL, v]);

    v = llList2Vector(llGetLinkPrimitiveParams(2, [PRIM_POS_LOCAL]), 0);
    v.z = 6.493 + 2.5*water/100;
    llSetLinkPrimitiveParamsFast(2, [PRIM_POS_LOCAL, v]);

    water -= (llGetUnixTime()  - lastTs)/86400.;
    lastTs = llGetUnixTime();
    */
}


integer startOffset=0;

multiPageMenu(key id, string message, list opt)
{
    integer l = llGetListLength(opt);
    integer ch = chan(llGetKey());
    if (l < 12)
    {
        llDialog(id, message, ["CLOSE"]+opt, ch);
        return;
    }
    if (startOffset >= l) startOffset = 0;
    list its = llList2List(opt, startOffset, startOffset + 9);
    llDialog(id, message, ["CLOSE"]+its+[">>"], ch);
}


startUpgrading(string m)
{
    llSleep(1.);
    llSay(0, "UPGRADING all '"+m+"' in a 96m radius... ");
    senseFor=m;
    llSensor(m, "", SCRIPTED, 96, PI);
}

string senseFor;

default 
{ 

    listen(integer c, string nm, key id, string m)
    {
        if (m == "CLOSE")
        {
            mode = "";
        }
        else if (m ==">>")
        {
            startOffset += 10;
            multiPageMenu(id, "Rez an animal", animals);
        }
        else if  (m == "Upgrade...")
        {
            mode = "Upgrading";
            multiPageMenu(id, "Upgrade an animal. WARNING: All animals within 96m range will be upgraded!", ["ALL"]+animals);
        }
        else if (m == "Rez...")
        {
            mode = "Rezzing";
            multiPageMenu(id, "Rez an animal:", animals);
        }
        else if (m == "ALL" && mode == "Upgrading")
        {
            integer i;
            for (i=0; i < llGetListLength(animals); i++)
            {
                startUpgrading(llList2String(animals,i));
            }
        }
        else
        {
            if (mode == "Upgrading")
            {  
                startUpgrading(m);
            }
            else // Rezzing
            {
                llSay(0, "Rezzing "+m+". Please allow a few seconds for the animal to initialize...");
                llRezObject(m, llGetPos() + <1,0,-.25>*llGetRot(), ZERO_VECTOR, ZERO_ROTATION, 1);
            }
        }
    }

    
    timer()
    {
        checkListen();
    }

    touch_start(integer n)
    {

        if (llGetOwner() != llDetectedKey(0)) 
        {
            return;
        }
        animals = [];
        //if (!llSameGroup(llDetectedKey(0))) llWhisper(0, "We are not in the same group");

        integer i;
        for (i=0; i < llGetInventoryNumber(INVENTORY_OBJECT); i++)
        {
            animals += llGetInventoryName(INVENTORY_OBJECT, i);
        }
        mode = "";
        startListen();
        multiPageMenu(llDetectedKey(0), "Select", ["Rez...", "Upgrade..."]);
        llSetTimerEvent(1000);
    }
    

 
    state_entry()
    {
        PASSWORD = llStringTrim(osGetNotecard("sfp"), STRING_TRIM);
        llSetText("Rez An Animal", <1,1,1>,1.0);
    }   
    
    on_rez(integer n)
    {
        llResetScript();
    }
    
     
    object_rez(key id)
    {
        llSleep(2.);
        llGiveInventory(id, llKey2Name(id));
        llGiveInventory(id , "sfp");
        llRemoteLoadScriptPin(id, "animal", 999, TRUE, 1);
    }
    
    sensor(integer n)
    {
        if (mode == "Upgrading")
        {
            integer i;
            for (i=0; i < n; i++)
            {
                key u = llDetectedKey(i);
                list desc = llParseString2List(llList2String(llGetObjectDetails(u, [OBJECT_DESC]) , 0) , [";"], []);
                if (llList2String(desc, 0) == "A")
                {
                    llSay(0, "Trying '"+llList2String(desc, 10)+"'");
                    osMessageObject(u, "DO-UPDATE|"+PASSWORD+"|"+(string)llGetKey()+"|animal,setpin,animal 1");
                    llSleep(2);
                }
                else
                {
                    llSay(0, llKey2Name(u)+" with id "+(string)u+" cannot be upgraded.");
                }
            }
        }
    }
    
    no_sensor()
    {
        llSay(0,"No "+senseFor+" found");
    }
    
    dataserver(key id, string m)
    {
        list res = llParseString2List(m, ["|"], []);
        if (llList2String(res,1) != PASSWORD)
        {
            return;
        }
        
        string command = llList2String(res, 0);
        if (command == "DO-UPDATE-REPLY")
        {
            //osMessageObject(llList2Key(tk, 2), "DO-UPDATE-REPLY|"+PASSWORD+"|"+(string)llGetKey()+"|"+(string)pin+"|"+sRemoveItems);
            key kobject = llList2Key(res, 2);
            integer ipin = llList2Integer(res, 3);
            llOwnerSay("PIN="+(string)ipin+", sending animal..");
            llRemoteLoadScriptPin(kobject, "animal", ipin, TRUE, 0);
            list desc = llParseString2List(llList2String(llGetObjectDetails(kobject, [OBJECT_DESC]) , 0) , [";"], []);
            llSay(0, "Upgraded "+ llList2String(desc,10)+ " (" +llKey2Name(kobject)+")");
        }
    }
}
 