//Variables
//------------------------------------------------------
vector forward = <0.0, 0.0, -3.0>; // Forward distance in meters
vector backward = <-0.0, 0.0, 3.0>; // Backward distance in meters
integer channel = 51; // dialog channel number
float interval = 13.0; // trigger interval between rat movement
float wait = 4; // seconds before and after rotation
//-----------------------------------------------------
vector new_pos;

//Functions
my_rot()
{
    // a rotation of 180 degrees around the x-axis
        rotation x_0 = llEuler2Rot (<0, 0, 0 * DEG_TO_RAD>);
        rotation new_rot = llGetRot() * x_0; // compute rotation
        llSetRot(new_rot); // move the object accordingly 
}


default
{
    state_entry()
    //touch_start(integer total_number)
    {
       
       llListen(channel, "", NULL_KEY, "");
       llSetTimerEvent(0);
    }

listen( integer channel, string name, key id, string message)
{
    if (message == "start")
    {llSetTimerEvent(interval);
    llOwnerSay("started");
    }
    
    if (message == "stop")
    {llSetTimerEvent(0);
    llOwnerSay("Stopped");
    }
}

timer()
    {
        new_pos = llGetPos() + forward;
          
       
        while(llVecDist(llGetPos(), new_pos) != 0)
        {                 
            llSetPos(new_pos);
        }
       
       llSleep(wait);
       my_rot();
       llSleep(wait);
       
       new_pos = llGetPos() + backward;
          
       
        while(llVecDist(llGetPos(), new_pos) != 0)
        {                 
            llSetPos(new_pos);
        }
            
    }


} 