float SECS_PER_SIDE = 0.1;
integer CYCLE_PING_PONG = TRUE;
integer increment = 1;
integer numSides;
integer lastSide;
integer cycling;

cycle()
{    
    integer nextSide = lastSide + increment;    
    if (CYCLE_PING_PONG)    
        {        
        if (nextSide == numSides)        
        {            
            nextSide = numSides - 2;    
            increment = -1;
        }        
        else        
        if (nextSide == -1)        
            {            
                nextSide = 1;            
                increment = 1;        
            }    
        }    
        else        
            nextSide = nextSide % numSides;
            llSetAlpha(1.0, nextSide);    
            llSetAlpha(0.0, lastSide);    
            lastSide = nextSide;
        }
        
default
    {    
    state_entry()    
        {        
        numSides = llGetNumberOfSides();        
        if (numSides < 2)        
            {            
            string scriptName = llGetScriptName();            
            llSay(DEBUG_CHANNEL, scriptName + " disabled. Only works in multi-sided elements.");
            llSetScriptState(scriptName, FALSE);        
            }        
            llSetAlpha(0.0, ALL_SIDES);        
            llSetAlpha(1.0, lastSide);    
        }    
touch_start(integer total_number)    
    {        
    if(cycling = !cycling)        
        {            
            llSetTimerEvent(SECS_PER_SIDE);
            cycle();
        }
        else            
        llSetTimerEvent(0.0);
    }    
    
timer()    
    {  cycle();    }
} 