///////////////////////////////////////////////////////////////////////////////////
///////
///////
///////
///////             Avacon Presentation System
///////
///////             initially created by Anthony Bundy, i3D Inc.
///////             Creatively Modified by Jeroen Frans, The Vesuvius Group, LLC.
///////             Contac: Contact@TheVesuviusGroup.cpm
///////             
///////             Date Jan 12, 2008
///////             
///////             This script shows texture slides based on the alphabetical order
///////             they appear in inventory. It is meant that the current slide is 
///////             shown on a detached screen with a listener and the previous and
///////             next slides will be displayed locally.
///////             
///////             Copyright (C) <2008>  <i3D Inc.>
///////             Contact: team@i3dnow.com
///////             
///////                 This program is free software: you can redistribute it and/or modify
///////                 it under the terms of the GNU General Public License as published by
///////                 the Free Software Foundation, either version 3 of the License, or
///////                 (at your option) any later version.
///////             
///////                 This program is distributed in the hope that it will be useful,
///////                 but WITHOUT ANY WARRANTY; without even the implied warranty of
///////                 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
///////                 GNU General Public License for more details.
///////             
///////                 You should have received a copy of the GNU General Public License
///////                 along with this program.  If not, see <http://www.gnu.org/licenses/>.
///////                 
///////                 Contact: team@i3dnow.com
///////              
///////              
//////////////////////////////////////////////////////////////////////////////////////    

// Inputs

// Output

// Chat Channels used
    integer debugChannel = DEBUG_CHANNEL;

    integer chatOffset = -2014101600;        // chat channel the display should listen to.
    integer chat2Display;

// Link Channels used
    integer link2All = -4873920;

// Global declarations
    integer debug = 0;                // for debugging
    list myMessage;
    integer currentChannel = 0;
    integer powerState;
    integer videoState;
    
    integer currentSlide;               // current slide index
    integer currDisplayLinkNum;         // link number that displays the current texture slide
    integer nextDisplayLinkNum;         // link number that displays the next texture slide
    integer urlButtonLinkNum;
    integer resizeButtonLinkNum;
    
    key noSlide = "d52bd13f-5706-4414-b027-5667f44998ee"; // texture key for an X indicating there is no slide for that spot
    key URLTexture = "4a8a23b1-95c8-416d-9baa-734b1dbb3eb2";
    integer displayFace = 2;            // display face 2 for some linked objects
    //integer face5 = 5;            // display face 5 for some linked objects

    list slides;
    integer URLQuestion = FALSE;
    integer URLChange = FALSE;
    integer ListenHandle;
    integer changeHandle;
// Global functions
              

//This function updates all the displays that can show the various textures
updateDisplays()
{
    if (debug > 0) llSay(DEBUG_CHANNEL, "currentSlide = " + (string)currentSlide + " : "+
        llGetInventoryName(INVENTORY_TEXTURE, currentSlide) + 
        " key= " + (string)llGetInventoryKey( llGetInventoryName(INVENTORY_TEXTURE, currentSlide) )); 
    
    if (llGetInventoryNumber(INVENTORY_TEXTURE) > 0) 
    {
        // there are slides and urls in a list
        // set main display to current slide/url and the provide the 2 previous and 2 coming slides.
        
        integer tTotalSlides = llGetListLength(slides);
        integer tPreview1 = currentSlide - 2;
        if(tPreview1 < 0) tPreview1 = 0;
        
        integer tPreview2 = currentSlide - 1;
        if(tPreview2 < 0) tPreview2 = 0;
        
        integer tPreview3 = currentSlide + 1;
        if(tPreview3 >= tTotalSlides) tPreview3 = tTotalSlides - 1;
        
        integer tPreview4 = currentSlide + 2;
        if(tPreview4 >= tTotalSlides) tPreview4 = tTotalSlides - 1;
        

        llSay( chat2Display, "SETTEXTURE::"+ llList2String(slides, tPreview1) + ","
                                        + llList2String(slides, tPreview2) + ","
                                        + llList2String(slides, currentSlide) + ","
                                        + llList2String(slides, tPreview3) + ","
                                        + llList2String(slides, tPreview4) );
        
        
        //Check if it is a UUID(texture) and if not, handle as if a URL   
        if(osIsUUID(llList2Key(slides,currentSlide))){    
            llSetLinkTexture(currDisplayLinkNum, 
                llList2String(slides, currentSlide), 
                displayFace);
        }else{
            llOwnerSay("Screen set to: " + llList2String(slides, currentSlide)); 
            llSetLinkTexture(currDisplayLinkNum, 
                URLTexture, 
                displayFace);
        }
        
        // set next display
        if (currentSlide < tTotalSlides - 1) 
        {
            //We are not at the end
            //Set the next display to the next texture
            //Check if it is a UUID(texture) and if not, handle as if a URL   
            if(osIsUUID(llList2Key(slides,currentSlide + 1))){    
                llSetLinkTexture(nextDisplayLinkNum, 
                    llList2String(slides, currentSlide +1), 
                    displayFace);
            
            }else{
                //llOwnerSay("Screen set to: " + llList2String(slides, currentSlide + 1)); 
                llSetLinkTexture(nextDisplayLinkNum, 
                    URLTexture, 
                    displayFace);
            }                        
        }else
        {
            // We are at the end
            llSetLinkTexture(nextDisplayLinkNum, noSlide, displayFace);
        }
    }

}

//This Function rotates the URL prim, to ask a to remove a URL or to revert back to the add url side
SetURLQuestion(integer on){
    if(on){
        llSetLinkPrimitiveParamsFast(urlButtonLinkNum, [PRIM_ROT_LOCAL,  <0.000000,0.000000,-1.000000,0.000000>]);
        URLQuestion = TRUE;
    }else{
        llSetLinkPrimitiveParamsFast(urlButtonLinkNum, [PRIM_ROT_LOCAL,  <0.000000,0.000000,0.000000,1.000000>]);
        URLQuestion = FALSE;
    }    
}

//This function updates the slides list with Textures from Inventory. Respecting URLs that have already been added.
UpdateSlidesList(){
    integer tNum = llGetInventoryNumber(INVENTORY_TEXTURE);
    integer i = 0;
    integer slidecounter = 0;
    integer tListLength = llGetListLength(slides);
            
    //Iterating through all textures in inventory
    for(i;i<tNum;i++){
        string tName = llGetInventoryName(INVENTORY_TEXTURE, i);
        key tInventoryKey = llGetInventoryKey(tName);
        integer check = TRUE;                
                
        //This while loop is used so I can loop past URLS in the slides list and then check the texture UUID after it.
        while(check){
            string tListString = llList2String(slides,slidecounter);

            //Check if the changed slide count is still lower then the total amount of slides in lists
            if(slidecounter<tListLength){                        
                
                //check if the slide in the current slide list is a key or a URL
                if(osIsUUID(tListString)){
                            
                    //Check if the current slide is NOT the same as the one in inventory
                    if(tInventoryKey != tListString){
                        slides = llListReplaceList(slides, [tInventoryKey],slidecounter, slidecounter);
                        check = FALSE;
                    }else{
                        //same UUID we can move on the next inventory Texture
                        check = FALSE;                        
                    }
                }else{
                    //llOwnerSay("slidecount:" + (string)slidecounter + " is URL");
                    //The current slide in the slide list is a URL, check the next slide
                            
                    slidecounter++;
                    URLChange = TRUE;
                    //slides = llListInsertList(slides, [tTextureKey],slidecounter,slidecounter);
                }
            }else{
                //the changed slide count is higher then the old total amount of slides, all remaining new slides can be added at the end of the list
                slides = llListInsertList(slides, [tInventoryKey],slidecounter); 
                check = FALSE;                   
            }
        }
        slidecounter++;
    }
            
    tListLength = llGetListLength(slides);
    //Remove any remaining old slides at the end
    if(slidecounter<tListLength){
        slides = llDeleteSubList(slides, slidecounter, tListLength -1);
    }

    //if a new texture was added directly after a URL, warn the USER.            
    if(URLChange){
        llOwnerSay("New Texture(s) have been added directly after URL slides, make sure the URLs are still in the location you intended. You can remove and re-add URLs using the HUD URL button.");
    }
}

init()
{
    // All the initialization items
    
    chat2Display = chatOffset+currentChannel;
    
    currentSlide = 0;
    
    currDisplayLinkNum = 0;
    nextDisplayLinkNum = 0;
    urlButtonLinkNum = 0;
    resizeButtonLinkNum = 0;
    
    integer totalLinked = llGetNumberOfPrims();
    integer idx;
    if (totalLinked > 1) 
    {
        
        // Find the link numbers of the HUD buttons and screen
        for (idx=1; idx <= totalLinked; ++idx)
        {
            if (llToLower( llGetLinkName(idx) ) == "currdisplay") 
            {
                currDisplayLinkNum = idx;
            }else
            if (llToLower( llGetLinkName(idx) ) == "nextdisplay") 
            {
                nextDisplayLinkNum = idx;
            }else
            if (llToLower( llGetLinkName(idx) ) == "url")
            {
                urlButtonLinkNum = idx;
            }else
            if (llToLower( llGetLinkName(idx) ) == "resize")
            {
                resizeButtonLinkNum = idx;
            }
        }
    }
    
    // check if we found all the displays
    if (currDisplayLinkNum < 1 || nextDisplayLinkNum < 1 || urlButtonLinkNum < 1 || resizeButtonLinkNum < 1)  
    {
        llOwnerSay("problem, control panel not linked properly");
        llOwnerSay((string)currDisplayLinkNum + (string)nextDisplayLinkNum + (string)urlButtonLinkNum + (string)resizeButtonLinkNum);
    }else

    //check if there are texture in inventory
    if (llGetInventoryNumber(INVENTORY_TEXTURE) < 1) 
    {
        llSay(0,"No slides detected, please place slides in the object contents.");
    }else{
        UpdateSlidesList();
        updateDisplays();
    } 
}

///////////////////////////////////////////////////////////////////////////////////////
//                          DEFAULT STATE                                            //
///////////////////////////////////////////////////////////////////////////////////////
default 
{
    // When we enter this state do this stuff
    state_entry() 
    {
            init();
    }
    
    touch_start(integer total_number)
    {
        // **** user permissions, change the following check based on your desired permissions requirements
        if ( llDetectedGroup(0) ) // agent is in same active group as this object
        {
            integer tTotalSlides = llGetListLength(slides);
            // next button pressed
            if (llGetLinkName( llDetectedLinkNumber(0) ) == "next") 
            {
                SetURLQuestion(FALSE);
                if (currentSlide < tTotalSlides - 1) 
                {
                    ++currentSlide;                    
                    updateDisplays();
                }    
                // else we are at the end, don't do anything
                
            }else
            // previous button pressed
            if (llGetLinkName( llDetectedLinkNumber(0) ) == "prev") 
            {    
                SetURLQuestion(FALSE);
                if (currentSlide > 0) 
                {
                    --currentSlide;                                   
                    updateDisplays();
                }    
                // else we are at the beggining, don't do anything            
                
            }else
            // begin button pressed
            if (llGetLinkName( llDetectedLinkNumber(0) ) == "begin") 
            {   
                SetURLQuestion(FALSE);
                currentSlide = 0;
                updateDisplays();            
                
            }else
            // end button pressed
            if (llGetLinkName( llDetectedLinkNumber(0) ) == "end") 
            {
                SetURLQuestion(FALSE);
                llOwnerSay("pressed end");                
                // go to end
                currentSlide = llGetInventoryNumber(INVENTORY_TEXTURE) - 1;
                updateDisplays();
            }else
            // resize button pressed
            if (llGetLinkName( llDetectedLinkNumber(0) ) == "resize") 
            {
                SetURLQuestion(FALSE);
                //send resize msg to screen
                llSay( chat2Display, "RESIZE");
            }else
            // URL button pressed
            if (llGetLinkName( llDetectedLinkNumber(0) ) == "url") 
            {                 
                //Check if the current slide is a texture or URL
                if(osIsUUID(llList2Key(slides,currentSlide))){
                    //If texture ask for the URL to add after this slide
                    llOwnerSay("Paste a URL in local chat, within the next 30 seconds.");
                    llSetTimerEvent(30);
                    llListenRemove(ListenHandle);
                    ListenHandle = llListen(0, "", llGetOwner(), "");
                }else
                //The current slide is not a texture so should be a URL
                if(!URLQuestion){
                    //SHow the url Question
                    //do want to remove the current URL?
                    //switch cube around
                    SetURLQuestion(TRUE);
                    llOwnerSay("Do you want to remove the current URL? Click on Yes or No on your HUD. Also click No if you want to add a texture");
                }else
                //Add this point the URL Question should be shown and the users should have clicked on yes or no.
                if(URLQuestion){
                    //Retrieve the location of prim where the User clicked
                    vector tPos = llDetectedTouchST(0);
                    //left side
                    if((tPos.x < 0.50) && (tPos.y < 0.67)){
                        //Pressed Yes
                        llOwnerSay("You pressed YES and we removed the following URL: " + llList2String(slides, currentSlide));
                        //Removing URL from List
                        slides = llDeleteSubList(slides, currentSlide, currentSlide);
                        
                        //Question done, set cube back to just URL
                        SetURLQuestion(FALSE);
                        updateDisplays();
                    //right side
                    }else if((tPos.x > 0.50) && (tPos.y < 0.67)){
                        //Pressed NO, Ask for the url to be said in chat
                        llOwnerSay("You pressed NO.");
                        llOwnerSay("Paste a URL in local chat, within the next 30 seconds.");
                        llSetTimerEvent(30);
                        llListenRemove(ListenHandle);
                        ListenHandle = llListen(0, "", llGetOwner(), "");
                        //Question done, set cube back to just URL
                        SetURLQuestion(FALSE);
                    //top
                    }else{
                        llOwnerSay("You clicked on the question, please click on either Yes or No");
                    }
                }
            }
        }
    }

    listen(integer channel, string name, key id, string msg){
        llListenRemove(ListenHandle);
        ListenHandle = FALSE;
        llSetTimerEvent(0);
        //check if url starts with "https://" or "http://"
        if( !(llGetSubString(msg, 0, 6) == "http://") &&  !(llGetSubString(msg, 0, 7) == "https://")){
            //no http:// or https;// add http://
             msg = "http://" + msg;             
        }
        slides = llListInsertList(slides, [msg], currentSlide + 1);
        updateDisplays();
        llOwnerSay("The following URL was added to your presentation: " + msg);
        llOwnerSay("If this is incorrect, please click the URL button again");    
    }

    timer(){
        //Close listen
        if(ListenHandle){
            llListenRemove(ListenHandle);
            ListenHandle = FALSE;
            llOwnerSay("Stopped listening for your URL, press the URL button again to add a URL.");
            llSetTimerEvent(0);
        }else
        //Start adding new texture to list.
        if(changeHandle){
            llSetTimerEvent(0);
            llOwnerSay("Inventory has changed, looking for new or removed Textures.");
            changeHandle = FALSE;
            UpdateSlidesList();
            updateDisplays();         
        }
    }
    
    changed(integer change){
        if(debug)llOwnerSay("change event");
        if (change & CHANGED_INVENTORY){
            llSetTimerEvent(3);
            changeHandle = TRUE;
            ListenHandle = FALSE;
             
        }else if(change & CHANGED_OWNER){
           // llOwnerSay("I changed owners, removing textures from inventory and clearing the slides from memory");
           // llResetScript();
        }
    }   
}