///////////////////////////////////////////////////////////////////////////////////
///////
///////
///////
///////            screen display
///////            initially created by Anthony Bundy, i3D Inc.
///////             
///////             Date Jan 12, 2008
///////             
///////             This script listens on a certain channel for a message
///////             SETTEXTURE::(key) where (key) is the texture key to show on its display face
///////             
///////             Copyright (C) <2008>  <i3D Inc.>
///////             Contact: team@i3dnow.com
///////             
///////                 This program is free software: you can redistribute it and/or modify
///////                 it under the terms of the GNU General Public License as published by
///////                 the Free Software Foundation, either version 3 of the License, or
///////                 (at your option) any later version.
///////             
///////                 This program is distributed in the hope that it will be useful,
///////                 but WITHOUT ANY WARRANTY; without even the implied warranty of
///////                 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
///////                 GNU General Public License for more details.
///////             
///////                 You should have received a copy of the GNU General Public License
///////                 along with this program.  If not, see <http://www.gnu.org/licenses/>.
///////                 
///////                 Contact: team@i3dnow.com
///////                 
///////              
//////////////////////////////////////////////////////////////////////////////////////    

// Inputs

// Output

// Chat Channels used
    integer debugChannel = DEBUG_CHANNEL;
                         
    integer chatOffset = -2014101600;        // chat channel the display should listen to.
    integer chat2Display;

// Link Channels used
    integer link2All = -4873920;

// Global declarations
    integer debug = FALSE;                // for debugging
    integer myListener;
    list myMessage;
    integer currentChannel = 0;
    integer channelButtonLinkNum;
    key channelButtonTexture = "9dd39437-37a7-4b95-aa71-cd7f5a24c022";
    string URLPreviewTexture = "URL";
    string ClickToPlayMediaTexture = "Click to play Media";

    key slide; // texture key for an X indicating there is no slide for that spot

    integer displayFace = 2;
    // integer displayFace = 2;
    
    list displayPrims = ["preview 1",0, "preview 2",0, "preview 3",0, "preview 4",0];
    list screenRatios = [1.7777777777777777777777777777777, 1.3333333333333333333333333333333, 1];
    integer currentRatio = 0;
    integer MEDIA = FALSE;
    
     list users = ["100d8615-a6da-49f7-a4e9-4b04459f7f91", "Andrew Stricker", 1,
"8e29f275-43b4-4ed7-a8f0-86282ed8bafb", "Anh Nguyen", 1,
"c14354a8-fde9-4543-a53f-215063fd02aa", "Barbara Truman", 1,
"b5a66e0e-4832-4f0c-83c6-9bff5880daea", "Bernard Rulof", 1,
"ff83deac-2bcb-444d-8c8b-24e90e341f3f", "Beth Reischl", 1,
"4b9c8ab4-b1c7-4814-9fe2-e83763a49132", "Cynthia Calongne", 1,
"079d2540-68ca-459d-a383-b737c6babbce", "David Metcalf", 1,
"383331bd-6c1b-42ea-a7ae-14c9fd1db864", "Douglas Maxwell", 1,
"505e933c-849d-4bc3-941c-9d3747426228", "Elise Augustine", 1,
"27c59068-dde7-4059-be4e-b412048937fb", "Eric Hackathorn", 1,
"150ad02a-39be-47f4-9807-584428b7f951", "Eric Ortiz", 1,
"578dfb6e-5425-45a3-93ba-50f96c4785a8", "Gwenette Sinclair", 1,
"b64993ef-2d6e-485d-9a54-59f44c13bbcd", "Jennifer Winner", 1,
"fbefe708-f5f4-4a48-a7f5-abfa974cd395", "Joe Rigby", 1,
"64795842-e722-4f7d-8cbe-cd17c43e3e53", "Justin Clark-Casey", 1,
"070df57f-7d61-4925-813f-481183b7698e", "Kay McLennan", 1,
"954b990a-ba44-483a-bfb7-c04f7ecff722", "Larysa Nadolny", 1,
"7577dd02-0108-4a46-838b-d24729db656d", "LuAnn Phillips", 1,
"f54b1fb4-5521-401e-983e-035382187250", "Mark Sturgell", 1,
"f901f302-cd92-40a0-90ca-dabf7b6abf8e", "Michael Heilmann", 1,
"06cdae14-4b42-45ac-b996-e1c1b6ed0801", "Michael Macedonia", 1,
"bf9d00eb-cf16-4b8d-bea9-f3ae27b9fd79", "Michael Young", 1,
"8d6ecbe4-0af5-40b8-afde-c4abfde0f442", "Pam Broviak", 1,
"def506f3-f922-49db-95bc-3bd556d7cd75", "Rachel Umoren", 1,
"fce59274-f237-4858-b836-aab41151937b", "Renne Brock-Richmond", 1,
"036b5877-130c-4063-9c45-f15327c35d09", "Rick Anderson", 1,
"7d3b91c5-f7e9-42ab-8edc-d3cc5d01c5f9", "Robert Daniel", 1, 
"34b63537-838b-47fc-9ef3-8e8334266aad", "Stephanie Lackey", 1,   
"077afdc4-64ef-44e4-8750-77a5db585cee", "Tonietta Walters", 1,               
"c07c31ca-c145-4470-a81f-05010112d7d3", "Joyce Bettencourt", 1,
"4ff9f389-c2b3-44d2-a061-836bf30f8ed4", "Michael Cerquoni", 1,
"8d132eeb-1b2f-4629-abf7-6181afb63f69", "Kurt Lesemann", 1,
"def506f3-f922-49db-95bc-3bd556d7cd75", "Chris Collins", 1
];


sendList(key id){
    string tUsers = llList2CSV(users);
    string sendUsers = tUsers + ",DONE";
    integer usersListLength = llGetListLength(users); 
                
    //Send the string if smaller or equal then 1023 characters  
    if(llStringLength(sendUsers) <= 1023){
        llRegionSayTo(id, chatOffset, sendUsers); 
                    
    //Divide up the list if string bigger then 1023 characters
    }else if(llStringLength(sendUsers) > 1023){
        integer batch = 30; //default we send 10 users a time, each users as 3 variables, makes 30.
        integer listCount = 0; //we use this to keep count where we are in the list.
        integer DONE = FALSE;
        while(!DONE){
            integer start = listCount;
            integer end =  listCount+batch-1;
            sendUsers = llList2CSV(llList2List(users,start,end));
            
            //check if these where the last or if we need to send more users.                                    
            if(end > usersListLength){
                sendUsers += ",DONE";
                DONE = TRUE;
            }else{
                sendUsers += ",MORE";
            }
            
            //Check if the smaller batch is not to long as well.
            if(llStringLength(sendUsers) > 1023){
                DONE = FALSE;
                batch--; //make batch size smaller if string to long
            }else{
                listCount = end + 1;
                llRegionSayTo(id, chatOffset, sendUsers);                                           
                llSleep(0.1);
            }                        
        }                          
    }
}



//DEFAULT STATE//
default 
{
    state_entry() 
    {
        chat2Display = chatOffset+currentChannel;
        llListenRemove(myListener);
        myListener = llListen(chat2Display, "", NULL_KEY, "");
        integer tPrims = llGetNumberOfPrims();
        
        //Find the preload prims and save their link numbers
        if(tPrims > 1){
            integer i = 1;
            for(i;i<=tPrims;i++){
                integer tFound = llListFindList(displayPrims, [llGetLinkName(i)]); 
                if(tFound > -1){
                   
                    displayPrims = llListReplaceList(displayPrims,[i],tFound +1, tFound +1);
                }
            }
        }        
    }
    
    listen(integer channel, string name, key id, string message) 
    {

        //Moderator HUD Commands
        if(llSubStringIndex(name, "Avacon Presenter Mod Hud") != -1){

            //Retrieving the list with of presenters and their activity status on this presentation board
            if(llSubStringIndex(message, "GIVE LIST") > -1){
                sendList(id);
                                
            //Adding a new Presenter    
            }else if(llSubStringIndex(message, "ADD NEW::") > -1){
                list tList = llCSV2List(llDeleteSubString(message, 0, llStringLength("ADD NEW::") - 1));
                users = users + tList;
                sendList(id);
             
            //Change Status of presenter   
            }else if(llSubStringIndex(message, "CHANGE STATUS::") > -1){
                list tList = llCSV2List(llDeleteSubString(message, 0, llStringLength("CHANGE STATUS::") - 1));
                integer tFound = llListFindList(users, [llList2String(tList,0)]);
                if(tFound != -1){
                    users = llListReplaceList(users, tList, tFound, tFound +2);
                    llSleep(0.1);
                    sendList(id);
                
                }else{
                    llRegionSayTo(llGetOwnerKey(id), 0, "The User you are trying to change is not listed on this board, your screen will be reloaded");
                    sendList(id);
                }        
            
            //Remove a presenter
            }else if(llSubStringIndex(message, "REMOVE::") > -1){
                list tList = llCSV2List(llDeleteSubString(message, 0, llStringLength("REMOVE::") - 1));
                integer tFound = llListFindList(users, tList);
                if(tFound != -1){
                    users = llDeleteSubList(users, tFound, tFound + 2);
                }                 
                sendList(id);
    
            }
        
        //Presenter Commands
        }else{ 
            
            //Check if the presenter is in the permitted list
            integer tFound = llListFindList(users, llGetOwnerKey(id));
            if(tFound != -1){
                tFound = llList2Integer(users, tFound + 2);
                if(tFound){

                    if (llSubStringIndex(message, "SETTEXTURE::") > -1) 
                    {
                        // message is to set the texture key, -1 is for 0 based indexing on the characters
                        list tList = llCSV2List(llDeleteSubString(message, 0, llStringLength("SETTEXTURE::") - 1));
            
            
                        if(debug) llOwnerSay("slide: " + llList2CSV(tList));
                        if (llGetListLength(tList) > 0) 
                        {
                
                            ////PREVIEW 1 & 2
                            if(debug)llOwnerSay((string)osIsUUID(llList2Key(tList,0)));
                            if(osIsUUID(llList2Key(tList,0))){
                    
                                llSetLinkTexture(llList2Integer(displayPrims,1),llList2Key(tList,0), ALL_SIDES);
                            }else{
                    
                                llSetLinkTexture(llList2Integer(displayPrims,1), URLPreviewTexture, ALL_SIDES);                   
                            }
                 
                            if(osIsUUID(llList2Key(tList,1))){
                                llSetLinkTexture(llList2Integer(displayPrims,3),llList2Key(tList,1), ALL_SIDES);
                            }else{
                                llSetLinkTexture(llList2Integer(displayPrims,3), URLPreviewTexture, ALL_SIDES);                   
                            }   
                
                            /////////MAIN DISPLAY////////////
                            if(osIsUUID(llList2Key(tList,2))){
                    
                                llSetTexture(llList2Key(tList,2), displayFace);
                                if(MEDIA){
                                    MEDIA = FALSE;
                                    llClearPrimMedia(displayFace);
                                }
                            }else{
                                llSetTexture(ClickToPlayMediaTexture, displayFace);
                    

                                integer tReturn = llSetPrimMediaParams(2, [PRIM_MEDIA_CONTROLS, PRIM_MEDIA_CONTROLS_MINI, 
                                            PRIM_MEDIA_CURRENT_URL, llList2String(tList, 2),
                                            PRIM_MEDIA_HOME_URL, llList2String(tList, 2),
                                            PRIM_MEDIA_AUTO_LOOP, FALSE,
                                            PRIM_MEDIA_AUTO_PLAY , TRUE,
                                            PRIM_MEDIA_AUTO_SCALE, TRUE,
                                            PRIM_MEDIA_AUTO_ZOOM, TRUE,
                                            PRIM_MEDIA_PERMS_INTERACT,PRIM_MEDIA_PERM_ANYONE,
                                            PRIM_MEDIA_PERMS_CONTROL, PRIM_MEDIA_PERM_GROUP]);
                    
                                MEDIA = TRUE;
                                if(debug) llOwnerSay("media flag " + (string)tReturn);
                
                            }
                
                            ////PREVIEW 3 & 4
                            if(osIsUUID(llList2Key(tList,3))){
                                llSetLinkTexture(llList2Integer(displayPrims,5),llList2Key(tList,3), ALL_SIDES);
                            }else{
                                llSetLinkTexture(llList2Integer(displayPrims,5), URLPreviewTexture, ALL_SIDES);                   
                            }
                 
                            if(osIsUUID(llList2Key(tList,4))){
                                llSetLinkTexture(llList2Integer(displayPrims,7),llList2Key(tList,4), ALL_SIDES);
                            }else{
                                llSetLinkTexture(llList2Integer(displayPrims,7), URLPreviewTexture, ALL_SIDES);                   
                            }   
                
                        }
                    }else if(llSubStringIndex(message, "RESIZE") > -1){
                        currentRatio++;
                        if(currentRatio >= llGetListLength(screenRatios)){
                            currentRatio = 0;
                        }
                        vector tSize = llGetScale();
            
                        float newY = tSize.z * llList2Float(screenRatios, currentRatio);
            
                        llSetScale(<tSize.x, newY, tSize.z>);
                        //llOwnerSay((string)llGetScale());
                        //llOwnerSay((string)(newY/tSize.z));         
            
                    }
                }else{
                    llRegionSayTo(llGetOwnerKey(id), 0, "You are not activated to use the Presentation screen, talk to a moderator.");
                }
            }else{
                llRegionSayTo(llGetOwnerKey(id), 0, "You are not activated to use the Presentation screen, talk to a moderator.");
            }
        }
    }
}