
// Prim animation compiler //
// Ferd Frederix - http://www.free-lsl-scripts.com
integer playbackchannel = 1; // The default llMessageLinked number
rotation calcChildRot(rotation rdeltaRot){
    if (llGetAttached())
        return rdeltaRot/llGetLocalRot();
    else
        return rdeltaRot/llGetRootRotation();
}
vector originalScale = <3.249817,3.423462,0.500000>;
down(){
    vector currentSize = llGetScale();
    float scaleby = currentSize.x/originalScale.x;

    llSetLinkPrimitiveParamsFast(2, [PRIM_POSITION, <-4.467590,-1.207855,-1.794250>*scaleby, PRIM_ROTATION,calcChildRot(<-0.017372,0.001673,0.995245,-0.095825>), PRIM_SIZE, <6.978278,1.568961,1.524720>*scaleby]);
    llSetLinkPrimitiveParamsFast(3, [PRIM_POSITION, <-4.772247,-0.197525,-2.223816>*scaleby, PRIM_ROTATION,calcChildRot(<-0.017372,0.001673,0.995245,-0.095825>), PRIM_SIZE, <7.220575,2.148749,1.317100>*scaleby]);
    llSetLinkPrimitiveParamsFast(4, [PRIM_POSITION, <-4.705597,-0.803680,-0.992920>*scaleby, PRIM_ROTATION,calcChildRot(<-0.017372,0.001673,0.995245,-0.095825>), PRIM_SIZE, <7.289554,5.100008,3.068331>*scaleby]);
    llSetLinkPrimitiveParamsFast(5, [PRIM_POSITION, <-4.585663,-1.199387,-1.671814>*scaleby, PRIM_ROTATION,calcChildRot(<-0.017372,0.001673,0.995245,-0.095825>), PRIM_SIZE, <7.163534,4.153318,1.793778>*scaleby]);
    llSetLinkPrimitiveParamsFast(6, [PRIM_POSITION, <-4.640533,-0.792419,-2.156616>*scaleby, PRIM_ROTATION,calcChildRot(<-0.017372,0.001673,0.995245,-0.095825>), PRIM_SIZE, <7.482280,1.976092,1.407157>*scaleby]);

}
up(){
    vector currentSize = llGetScale();
    float scaleby = currentSize.x/originalScale.x;

    llSetLinkPrimitiveParamsFast(2, [PRIM_POSITION, <-1.332794,-1.207855,3.290039>*scaleby, PRIM_ROTATION,calcChildRot(<0.592957,-0.057092,0.799510,-0.076979>), PRIM_SIZE, <6.978278,1.568961,1.524720>*scaleby]);
    llSetLinkPrimitiveParamsFast(3, [PRIM_POSITION, <-1.826202,-0.197525,3.474243>*scaleby, PRIM_ROTATION,calcChildRot(<0.592957,-0.057092,0.799510,-0.076979>), PRIM_SIZE, <7.220575,2.148749,1.317100>*scaleby]);
    llSetLinkPrimitiveParamsFast(4, [PRIM_POSITION, <-0.619446,-0.803680,3.725830>*scaleby, PRIM_ROTATION,calcChildRot(<0.592957,-0.057092,0.799510,-0.076979>), PRIM_SIZE, <7.289554,5.100008,3.068331>*scaleby]);
    llSetLinkPrimitiveParamsFast(5, [PRIM_POSITION, <-1.244781,-1.199387,3.435608>*scaleby, PRIM_ROTATION,calcChildRot(<0.592957,-0.057092,0.799510,-0.076979>), PRIM_SIZE, <7.163534,4.153318,1.793778>*scaleby]);
    llSetLinkPrimitiveParamsFast(6, [PRIM_POSITION, <-1.727417,-0.792419,3.364197>*scaleby, PRIM_ROTATION,calcChildRot(<0.592957,-0.057092,0.799510,-0.076979>), PRIM_SIZE, <7.482280,1.976092,1.407157>*scaleby]);
}
 



default{

    state_entry(){
        llSetMemoryLimit(llGetUsedMemory() + 512);
        llVolumeDetect(TRUE);
        up();
    }

    collision_start(integer sender_num){
        down();
        llVolumeDetect(FALSE);
        llSetTimerEvent(15);
    }
        
    timer()
    {
            up();
            llVolumeDetect(TRUE);
            llSetTimerEvent(0);
    }
    
    changed(integer what) {
        
        if (what & CHANGED_REGION_START)
        {
            llResetScript();
            
        }
    }
    
}

