// :CREATED: 9-8-2014
// :REV: 1.0
// :DESCRIPTION: 
// Vehicle code for the Tiger Rider.   

// :CODE:


integer debug = FALSE;         // set to TRUE or FALSE for debug chat on various actions
 
// OpenSim & ODE
 
// avatar control animations
string AvatarSit = "Ride_Tiger";
string AvatarWalk = "Ride_Tiger";

// NOPC animations

string NPCSit = "Tiger Sitting on ground";
string NPCStand = "Stand";
string NPCWalk = "Tiger Walk Fast";
string NPCRun = "TigerGallop";

string whatsplaying = "";      // the currentply playing NPC automation

integer Private = 0;    // Change to 1 to prevent others riding.
float  gallop= 1.0;
vector Sitpos = <0,0,0.55>;
vector SitrotV = <0,0,01>;
rotation Sitrot; 
integer animation_allowed = FALSE;
key Agent;

float forward_power = 6; //Power used to go forward (1 to 30)
float reverse_power = -6; //Power ued to go reverse (-1 to -30)
float turning_ratio = 3; //How sharply the vehicle turns. Less is more sharply. (.1 to 10)

integer turncount;

float Speed;
integer NPCisRunning;
string last_animation; // the last animation played on the owner
string sit_message = "Ride"; //Sit message


DEBUG(string str)
{
    if (debug)
        llOwnerSay(llGetScriptName()+":" +  str);                    // Send the owner debug info so you can chase NPCS
}


SetMaterial()
{
    llSetPrimitiveParams([PRIM_MATERIAL, PRIM_MATERIAL_GLASS]);
    llMessageLinked(LINK_ALL_OTHERS, 0, "SetMat", NULL_KEY);    // Tell daughter pims on ground to be glass
}

// pipeline for animations for the owner
AvatarAnimate(string animation)
{
    if (animation != last_animation) {
        llStartAnimation(animation);
        llStopAnimation(last_animation);
        last_animation = animation;
    }
}

// and for the NPC
NPCPlay(string what, float howlong)
{
    if (whatsplaying != what) {
        DEBUG("Playing NPC animation " + what + ", stopping " + whatsplaying);
        
        osNpcStopAnimation(NPCKey, whatsplaying);
        osNpcPlayAnimation(NPCKey, what);
        
        llSleep(howlong);
        whatsplaying = what;
    }       
}

// Make the mouth move and play a sound
Growl()
{
    DEBUG("Growl");
    llTriggerSound("Tiger growl 1",1.0);
    NPCPlay("Tiger_Growl",1);   
}




setVehicle()
{
    //car
    llSetVehicleType(VEHICLE_TYPE_CAR);
    llSetVehicleFloatParam(VEHICLE_ANGULAR_DEFLECTION_EFFICIENCY, 0.2);
    llSetVehicleFloatParam(VEHICLE_LINEAR_DEFLECTION_EFFICIENCY, 0.80);
    llSetVehicleFloatParam(VEHICLE_ANGULAR_DEFLECTION_TIMESCALE, 0.50);
    llSetVehicleFloatParam(VEHICLE_LINEAR_DEFLECTION_TIMESCALE, 0.10);
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_TIMESCALE, 1.0);
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_DECAY_TIMESCALE, 0.1);
    llSetVehicleFloatParam(VEHICLE_ANGULAR_MOTOR_TIMESCALE, 0.1);
    llSetVehicleFloatParam(VEHICLE_ANGULAR_MOTOR_DECAY_TIMESCALE, 0.1);
    llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <10.0, 2.0, 1000.0>);
    llSetVehicleVectorParam(VEHICLE_ANGULAR_FRICTION_TIMESCALE, <0.1, 0.1, 0.1>);
    llSetVehicleFloatParam(VEHICLE_VERTICAL_ATTRACTION_EFFICIENCY, 0.1);
    llSetVehicleFloatParam(VEHICLE_VERTICAL_ATTRACTION_TIMESCALE, 5.0);
}

    
Init()
{
    
    llSetStatus(STATUS_PHYSICS, FALSE);

    vector rotv = llRot2Euler(llGetRot());
    rotation rot = llEuler2Rot(<0,0,rotv.z>);

    llSetRot(rot);
    
    llSetVehicleType(VEHICLE_TYPE_NONE);
    NPCisRunning = FALSE;
}

string KeyValueGet(string var) {
    list dVars = llParseString2List(llGetObjectDesc(), ["&"], []);
    do {
        list data = llParseString2List(llList2String(dVars, 0), ["="], []);
        string k = llList2String(data, 0);
        if(k != var) jump continue;
        //DEBUG("got " + var + " = " +  llList2String(data, 1));
        return llList2String(data, 1);
        @continue;
        dVars = llDeleteSubList(dVars, 0, 0);
    } while(llGetListLength(dVars));
    return "";
}


KeyValueSet(string var, string val) {

    //DEBUG("set " + var + " = " + val);
    list dVars = llParseString2List(llGetObjectDesc(), ["&"], []);
    if(llGetListLength(dVars) == 0)
    {
        llSetObjectDesc(var + "=" + val);
        return;
    }
    list result = [];
    do {
        list data = llParseString2List(llList2String(dVars, 0), ["="], []);
        string k = llList2String(data, 0);
        if(k == "") jump continue;
        if(k == var && val == "") jump continue;
        if(k == var) {
            result += k + "=" + val;
            val = "";
            jump continue;
        }
        string v = llList2String(data, 1);
        if(v == "") jump continue;
        result += k + "=" + v;
        @continue;
        dVars = llDeleteSubList(dVars, 0, 0);
    } while(llGetListLength(dVars));
    if(val != "") result += var + "=" + val;
    llSetObjectDesc(llDumpList2String(result, "&"));
}


key NPCKey;

StartNPC() {
    NPCKey = osNpcCreate("Moo", "Cao", llGetPos(), "Appearance", OS_NPC_SENSE_AS_AGENT);    // no OS_NPC_SENSE_AS_AGENT allowed due to llSensor Use

    KeyValueSet("key",  NPCKey);       
        
    osNpcLoadAppearance(NPCKey, "Appearance");
        
    osNpcSit(NPCKey,llGetKey(), OS_NPC_SIT_NOW);     
}

init_followCam(){
    
    llSetCameraParams([
                       CAMERA_ACTIVE, 1,                     // 0=INACTIVE  1=ACTIVE
                       CAMERA_BEHINDNESS_ANGLE, 45.0,         // (0 to 180) DEGREES
                       CAMERA_BEHINDNESS_LAG, 1.0,           // (0 to 3) SECONDS
                       CAMERA_DISTANCE, 4.0,                 // ( 0.5 to 10) METERS
                       CAMERA_PITCH, 10.0,                    // (-45 to 80) DEGREES
                       CAMERA_POSITION_LOCKED, FALSE,        // (TRUE or FALSE)
                       CAMERA_POSITION_LAG, 0.01,             // (0 to 3) SECONDS
                       CAMERA_POSITION_THRESHOLD, 2.0,       // (0 to 4) METERS
                       CAMERA_FOCUS_LOCKED, FALSE,           // (TRUE or FALSE)
                       CAMERA_FOCUS_LAG, 0.01 ,               // (0 to 3) SECONDS
                       CAMERA_FOCUS_THRESHOLD, 0.01,          // (0 to 4) METERS
                       CAMERA_FOCUS_OFFSET, <2.0,0.0,0.0>   // <-10,-10,-10> to <10,10,10> METERS
                      ]);
}

default
{
    state_entry()
    {
        Init();
        SetMaterial();
        llSetSitText(sit_message);
        llSitTarget(Sitpos, Sitrot); 
        osNpcRemove(KeyValueGet("key"));

        NPCisRunning = FALSE;
    }
    
    on_rez(integer rn)
    {
        llResetScript();
    }

    link_message(integer sender_number, integer number, string message, key id)
    {
        DEBUG(" Main script heard:" + message + " with key " + (string) id);
        if (message == "Seated")
        {
            last_animation = "sit";
            llWhisper(0,"Use arrow keys to ride.  PG Up to gallpp, Pg Down to walk");
            AvatarAnimate(AvatarSit);
            Agent = id; 
            setVehicle();
            if (! NPCisRunning)
                StartNPC();
            
            
            llSleep(0.1);
            llSetStatus(STATUS_PHYSICS, TRUE);
            llSleep(.1);
            NPCisRunning = TRUE;
            
            DEBUG("Starting platform");
            llRequestPermissions(Agent, PERMISSION_TRIGGER_ANIMATION | PERMISSION_CONTROL_CAMERA| PERMISSION_TAKE_CONTROLS);
            
        } else if (message == "Unseated")    {
            if (NPCisRunning) {
                DEBUG("Remove tiger");
                osNpcRemove(KeyValueGet("key"));
                NPCisRunning = FALSE;
            }
            
        }

    }
    
    changed(integer change)
    {
        if (change & CHANGED_LINK)
        {
            key  tiger = llAvatarOnSitTarget();
            if (tiger  != NULL_KEY)
            {                
                if( (tiger != llGetOwner())  )
                {
                    DEBUG("Tiger Seated");
                    whatsplaying = "sit";
                    NPCPlay(NPCStand,0); 
                }
                else
                {
                    DEBUG("Owner Seated");          
                }
            }
            else
            {
                Init(); // shut down physics
                llReleaseControls();
                Growl();
                
                animation_allowed = FALSE;
                NPCisRunning = FALSE;            
                NPCPlay(NPCStand,0.1); 
                llSetTimerEvent(0.0);
            }
        }
    }
    
    run_time_permissions(integer perm)
    {
        if (perm)
        {
            //llOwnerSay("Perms check");
            if (perm & PERMISSION_CONTROL_CAMERA)
            {
                init_followCam();
            }

            if (perm & PERMISSION_TAKE_CONTROLS)
            {
                llMessageLinked(LINK_SET,0,"PoseOff","");    // show pose ball
                
                llSetTimerEvent(0.3);
                Growl();
                NPCPlay(NPCStand,0);
                
                llTakeControls(CONTROL_FWD | CONTROL_BACK | CONTROL_DOWN | CONTROL_UP | CONTROL_RIGHT |
                    CONTROL_LEFT | CONTROL_ROT_RIGHT | CONTROL_ROT_LEFT, TRUE, FALSE);
            }

            if (perm & PERMISSION_TRIGGER_ANIMATION)
            {
                animation_allowed = TRUE;
                AvatarAnimate(AvatarSit);
            }
            
        }
    }
    
    
    control(key id, integer level, integer edge)
    {
        integer reverse=1;
        vector angular_motor;
        
        //get current speed
        vector vel = llGetVel();
        Speed = llVecMag(vel);
        //DEBUG((string)Speed);

        //car controls
        if(level & CONTROL_FWD)
        {
            llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <10.0, 2.0, 1000.0>);
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <forward_power * gallop,0,0>);
            reverse=1;
        }
        if(level & CONTROL_BACK)
        {
            llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <10.0, 2.0, 1000.0>);
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <reverse_power,0,0>);
            reverse = -1;
        }

        if(level & (CONTROL_RIGHT|CONTROL_ROT_RIGHT))
        {
            angular_motor.z -= Speed / turning_ratio * reverse;
            turncount = 10;
        }
        
        if(level & (CONTROL_LEFT|CONTROL_ROT_LEFT))
        {
            angular_motor.z += Speed / turning_ratio * reverse;
            
            turncount = 10;
        }
        
        if(level & (CONTROL_UP))
        {
            if (gallop == 1.0)
                Growl();
                ;
            gallop = 2.0;
            
        }
        
        if(level & (CONTROL_DOWN))
        {
             if (gallop == 2.0)
                Growl();
           
            gallop = 1.0;
        }
        
        
 
        llSetVehicleVectorParam(VEHICLE_ANGULAR_MOTOR_DIRECTION, angular_motor);
        if(turncount > 0)
        {
            turncount--;
        } 
          
        
    } //end control        

    timer(){
        if(NPCisRunning){
            vector vel = llGetVel();

            Speed = llVecMag(vel);
            //DEBUG("vecMag Speed " + (string)Speed);            

            if(Speed > 0.1)
            {
                if (gallop == 1.0)
                    NPCPlay(NPCWalk,0);
                else 
                    NPCPlay(NPCRun,0); 
                    
                llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <1.0, 2.0, 1000.0>);
                llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <0,0,0>);
            }
            else {
                
                NPCPlay(NPCStand,0);
            }
            
            llSetTimerEvent(0.3);          // If restarted timer() appears to keep working  
        }else{
            llSetTimerEvent(0.0);
        }
    }
    
} //end default