// nut collider && scorekeeper

//Rev 1  7-4-2014 initial LSL editor 


integer scoreBits = 1;
string SOUND = "life_pickup";


integer debug = FALSE;
DEBUG(string msg)
{
    if (debug)
        llSay(0,msg); 
}


key http_request_id;
integer TIMER;
integer visible = TRUE;

poof(integer tnum)
{
    llPlaySound(SOUND, 0.5);
    llSetAlpha(0.0,ALL_SIDES);
    llSetTimerEvent(TIMER);
    visible = FALSE;
    integer i;
    for (i = 0; i < tnum; i++)
    {
        key id = llDetectedKey(i);
        string aviName = llDetectedName((i));

        string url = "http://www.outworldz.com/cgi/llGameMagic.plx?"
            + "PassFail=" + (string) scoreBits
            + "&Language=" + llGetAgentLanguage(id)
            + "&AvatarName=" + llEscapeURL(aviName)
            + "&AvatarKey=" + llEscapeURL(id)
            ;

        DEBUG(url);
        http_request_id = llHTTPRequest(url, [], "");
    }
}

default
{
     touch_start(integer total_number)
    {
        float dist = llVecDist(llDetectedPos(0), llGetPos());
        if (dist > 2 && visible)
        {
            llSay(0,"Please Stand a little closer");
        } else {
            poof(total_number);
        }
               
    }


    state_entry()
    {

        if (debug)
            TIMER = 10;
        else
            TIMER =120;
        llCollisionSound("",0);
        llSetAlpha(1.0,ALL_SIDES);
        llVolumeDetect(FALSE);
        llSetStatus(STATUS_PHANTOM,FALSE);
        llSleep(0.1);
        llVolumeDetect(TRUE);
    }
    
    collision_start(integer tnum)
    {
        if (! osIsNpc(llDetectedKey(0)) && visible) {
           poof(tnum);
        }           
    }
     
    timer()
    {
        llSetAlpha(1.0,ALL_SIDES);
        llSetTimerEvent(0.0);   
        visible = TRUE;
        
        llVolumeDetect(FALSE);
        llSetStatus(STATUS_PHANTOM,FALSE);
        llSleep(0.1);
        llVolumeDetect(TRUE);
        
        
    }
    
    http_response(key request_id, integer status, list metadata, string body)
    {
        if (request_id == http_request_id)
        {
            list stuff = llParseString2List(body,["|"],[]);
            if (llList2String(stuff,0) == "ACK")
            {
                llWhisper(0,llList2String(stuff,2));
            }
        }
    } 

           
    on_rez(integer p)
    {
        llResetScript();
    }
     changed(integer change) // something changed, take action
    {
        if (change & CHANGED_REGION_START) // that bit is set during a region restart
        {
            llResetScript();
        }
    }     


}


