//XEngine;lsl

// original script by Tiffany Sicling @ OSGrid / Hypergrid Project team
// Revised extensively by WhiteStar Magic @ HyperGrid-Supply-Centre OSGrid 
// =======================================================================
// The SHENGATE sysem is a single Point to Point mechanism and therefore much simpler than any other mechanism
// it uses osTeleportAgent to accomplish this TP process
// this must be enabled in your OpenSim.ini file
//
//
// =======================================================================
// MODFIFY following Fields
string HoverTitle = ""; // for Hovertext over Portal
//n/357/253/611
integer DEFAULTstate = TRUE;            // TRUE = ON & Ready at Startup. FALSE = OFF @ Startup

vector LandingPoint =<58.00533, 273.47293, 25.00799>;     // Where you want the Avatar to arrive at
vector LookAt       = <0.0,0.0,-1.0>;           // which way you want them facing. Avoid True North at ALL times (BUG THERE IN OS CODE)
// 
string TargetAddress;                               // In-Grid Teleport (Region Name as defined in region.xml OR region.ini)
//string TargetAddress = "9996,9974";                                      // In-Grid Teleport (Grid Map Locations XXXX,YYYYY)
//string TargetAddress = "first-star.dyndns.org:9000:FirstStar_Station";    //HyperGrid Example (using DNSname:Port:RegionName)
//string TargetAddress = "IPaddress:Port:RegionName";                       // Hypergrid TP are also valid (IPaddress:Port:RegionName)




list LastFewAgents;
//
PerformTeleport( key AgentToTP )
{
    integer CurrentTime = llGetUnixTime();
    integer AgentIndex = llListFindList( LastFewAgents, [ AgentToTP ] );           // Is the agent we're teleporting already in the list?
    if (AgentIndex != -1)                                                          // If yes, check to make sure it's been > 5 seconds
    {
        integer PreviousTime = llList2Integer( LastFewAgents, AgentIndex+1 );      // Get the last time they were teleported
        if (PreviousTime >= (CurrentTime - 5)) return;                             // Less than five seconds ago? Exit without teleporting
        LastFewAgents = llDeleteSubList( LastFewAgents, AgentIndex, AgentIndex+1); // Delete the agent from the list
    }
    LastFewAgents += [ AgentToTP, CurrentTime ];                                   // Add the agent and current time to the list
    osTeleportAgent( AgentToTP, TargetAddress, LandingPoint, LookAt );             // Teleport agent to their target
    llSleep(1.0);
    
}


default
{
    on_rez(integer int)
    {
        llResetScript();
    }
    
    state_entry()
    {
        TargetAddress = llGetRegionName();
         
    }

    link_message(integer sender_number, integer number, string message, key id)
    {
        if (number == 99) {
            PerformTeleport( id );
        }
    }

}

