// nut collider && scorekeeper

//Rev 1  7-4-2014 initial LSL editor 


integer scoreBits = 5;
string SOUND = "life_pickup";


integer debug = FALSE;
DEBUG(string msg)
{
    if (debug)
        llSay(0,msg);
}


key http_request_id;
integer TIMER;
integer visible = TRUE;

default
{
    
    state_entry()
    {

        if (debug)
            TIMER = 10;
        else
            TIMER =120;
        
        llSetAlpha(1.0,ALL_SIDES);
        llVolumeDetect(TRUE);
    }
    
    collision(integer tnum)
    {
        if (llDetectedType(0) & AGENT && visible) {
            llPlaySound(SOUND, 0.5);
            llSetAlpha(0.0,ALL_SIDES);
            llSetTimerEvent(TIMER);
            visible = FALSE;
            integer i;
            for (i = 0; i < tnum; i++)
            {
                key id = llDetectedKey(i);
                string aviName = llDetectedName((i));

                string url = "http://www.outworldz.com/cgi/llGameMagic.plx?"
                    + "PassFail=" + (string) scoreBits
                    + "&Language=" + llGetAgentLanguage(id)
                    + "&AvatarName=" + llEscapeURL(aviName)
                    + "&AvatarKey=" + llEscapeURL(id)
                    ;

                DEBUG(url);
                http_request_id = llHTTPRequest(url, [], "");
            }
        }           
    }
     
    timer()
    {
        llSetAlpha(1.0,ALL_SIDES);
        llSetTimerEvent(0.0);   
        visible = TRUE;
    }
    
    http_response(key request_id, integer status, list metadata, string body)
    {
        if (request_id == http_request_id)
        {
            list stuff = llParseString2List(body,["|"],[]);
            if (llList2String(stuff,0) == "ACK")
            {
                llWhisper(0,llList2String(stuff,2));
            }
        }
    } 

            


}


