//:DESCRIPTION: Vistor Counter
//:AUTHOR: Ferd Frederix
//:License: CC-BY-NC-SA
//:REV: 2.4
//:CODE:
//: Opensim Only
// Last Revised 16/11/2017

string WebKey = "";
list exclude = [];
// OR add name on your grid or full grid name for foreign visitors, including the space
//list exclude = ["Ferd Frederix","Nyira.Machabelli @hg.osgrid.org"];

 
// tunables
integer debug = FALSE;
integer hovertext = TRUE;

//vars
key owner_name_query ;
key http_request_id;
string owner_name;
integer Scan;
list ToDoURL;
integer timeGoneBy = -1;
integer ToDo = 0;

DEBUG(string msg)
{
    if (debug ) llOwnerSay(msg);
}


default
{
    on_rez(integer p)
    {
        llResetScript();
    }
    
    state_entry()
    {
        llSetText("", <1,1,1>, 1);
        owner_name = osKey2Name(llGetOwner());
        llSetTimerEvent(1); // StartUp
    }
    
    timer() 
    {
        if (timeGoneBy++ %60 == 0 )
        {
            Scan = TRUE;
        } else {
            Scan = FALSE;
        }
        
        
        if (Scan)
        {
            DEBUG("Scanning");
            ToDoURL = [];
            list keys = llGetAgentList(AGENT_LIST_REGION,[]);
            integer count = 0;
            integer i;
            for (i=0; i < llGetListLength(keys); ++i)
            {
                key UUID = llList2Key(keys,i);
                if (!osIsNpc(UUID)) {
                    string name = llKey2Name(UUID);    // name
                    
                    if (llListFindList(exclude,[name]) == -1)
                    {
                        DEBUG("Checking " + name);
                        list details = llGetObjectDetails(UUID, [OBJECT_POS]) ; // pos
                        vector pos = llList2Vector(details,0);
                        string x = (string) pos.x;
                        string y = (string) pos.y;
                        string z = (string) pos.z;

                        // parcel
                        details = llGetParcelDetails(pos,[PARCEL_DETAILS_NAME]);
                        string parcel = llList2String(details,0); 
 
                        string url = "http://www.outworldz.com:5000/stat"
                            + "?Name=" + llEscapeURL(name)
                            + "&UUID=" + llEscapeURL(UUID)
                            + "&Owner=" + llEscapeURL(owner_name)
                            + "&Region=" + llEscapeURL(llGetRegionName())
                            + "&RegionSize=" + llEscapeURL((string)osGetRegionSize())
                            + "&X=" + x
                            + "&Y=" + y
                            + "&Z=" + z
                            + "&Parcel=" + llEscapeURL(parcel)
                            + "&HomeUri=" + llEscapeURL( osGetGridHomeURI() )
                            + "&GridName=" + llEscapeURL( osGetGridName() )
                            + "&MapTextureUUID=" + osGetMapTexture()
                            + "&Gatekeeper=" +llEscapeURL( osGetGridGatekeeperURI())   
                            + "&LoginUri=" +llEscapeURL( osGetGridLoginURI()) ;

                        ToDoURL += url;
                        count++;
                    }
                }
            }
            if (count)
                ToDo = 1;   // send them
        }
        
        if (ToDo == 1)
        {
            if (llGetListLength(ToDoURL) == 0)
            {
                ToDo = 2;
                DEBUG("Fin");
                return;
            }
             DEBUG(llList2String(ToDoURL,0));
            http_request_id = llHTTPRequest(llList2String(ToDoURL,0), [], "");
            ToDoURL  = llDeleteSubList(ToDoURL,0,0);
        }
 
        if (ToDo == 2) {
            string url = "http://www.outworldz.com:5000/count?" 
                    + "Region=" + llEscapeURL(llGetRegionName())
                    + "&GridName=" + llEscapeURL(osGetGridName());
                    
            DEBUG(url);

            http_request_id = llHTTPRequest(url, [], "");
            ToDo = 0;  
        }            
    }
     
    touch_start(integer p)
    {
        if (llDetectedKey(0) == llGetOwner() || llSameGroup(llDetectedKey(0)))
        {
            llLoadURL(llDetectedKey(0), "Click to view vistors", "http://www.outworldz.com/stats/?q=" + llEscapeURL(llGetRegionName()) + "&WebKey=" + WebKey + "&GridName=" + llEscapeURL( osGetGridName() ));
        } 
    }

     http_response(key request_id, integer status, list metadata, string body)
    {
        if (request_id == http_request_id)
        {
            body = llUnescapeURL(body);
            DEBUG(body);
            list response = llParseString2List(body,["|"],[]);
            string message = llList2String(response,0);
            if (hovertext) 
                llSetText(message, <1,1,1>, 1);
            string mykey = llList2String(response,1);
            if (llStringLength(mykey)) {
                DEBUG("Key set to " + mykey)  ;
                WebKey = mykey;  
            }
        } 
    } 
    
    changed(integer what)
    {
        if (what & CHANGED_REGION_START)
            llResetScript();   
    }
}
  